"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManagerMetricsPublisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const SecretsManagerSecretMetricFactory_1 = require("./SecretsManagerSecretMetricFactory");
class SecretsManagerMetricsPublisher extends constructs_1.Construct {
    constructor(scope) {
        super(scope, "SecretsManagerMetricsPublisher");
        this.lambda = new aws_lambda_1.Function(this, "Lambda", {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, "..", "..", "..", "assets", "SecretsManagerMetricsPublisher")),
            description: "Custom metrics publisher for SecretsManager Secrets (MonitoringCDKConstructs)",
            handler: "index.handler",
            memorySize: 128,
            runtime: aws_lambda_1.Runtime.NODEJS_14_X,
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
            logRetention: aws_logs_1.RetentionDays.ONE_DAY,
        });
        this.lambda.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ["secretsmanager:DescribeSecret"],
            resources: ["*"],
        }));
        this.lambda.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ["cloudwatch:PutMetricData"],
            resources: ["*"],
            conditions: {
                StringEquals: {
                    "cloudwatch:namespace": SecretsManagerSecretMetricFactory_1.SecretsManagerSecretMetricFactory.Namespace,
                },
            },
        }));
    }
    static getInstance(scope) {
        const key = aws_cdk_lib_1.Names.nodeUniqueId(scope.node);
        let instance = SecretsManagerMetricsPublisher.instances[key];
        if (!instance) {
            instance = new SecretsManagerMetricsPublisher(scope);
            SecretsManagerMetricsPublisher.instances[key] = instance;
        }
        return instance;
    }
    addSecret(secret) {
        // run 1/hr so alarms can recover automatically
        const rule = new aws_events_1.Rule(this, `RuleFor${aws_cdk_lib_1.Names.nodeUniqueId(secret.node)}`, {
            schedule: aws_events_1.Schedule.cron({
                minute: "0",
            }),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(this.lambda, {
            event: aws_events_1.RuleTargetInput.fromObject({
                secretId: secret.secretArn,
            }),
        }));
    }
}
exports.SecretsManagerMetricsPublisher = SecretsManagerMetricsPublisher;
_a = JSII_RTTI_SYMBOL_1;
SecretsManagerMetricsPublisher[_a] = { fqn: "cdk-monitoring-constructs.SecretsManagerMetricsPublisher", version: "1.6.2" };
SecretsManagerMetricsPublisher.instances = {};
//# sourceMappingURL=data:application/json;base64,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