"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManagerSecretMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
class SecretsManagerSecretMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.secret = props.secret;
        this.dimensionsMap = {
            SecretName: props.secret.secretName,
        };
    }
    metricDaysSinceLastChange() {
        return this.metricFactory.createMetric(SecretsManagerSecretMetricFactory.MetricNameDaysSinceLastChange, common_1.MetricStatistic.MAX, "Days", this.dimensionsMap, undefined, SecretsManagerSecretMetricFactory.Namespace);
    }
    metricDaysSinceLastRotation() {
        return this.metricFactory.createMetric(SecretsManagerSecretMetricFactory.MetricNameDaysSinceLastRotation, common_1.MetricStatistic.MAX, "Days", this.dimensionsMap, undefined, SecretsManagerSecretMetricFactory.Namespace);
    }
}
exports.SecretsManagerSecretMetricFactory = SecretsManagerSecretMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
SecretsManagerSecretMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.SecretsManagerSecretMetricFactory", version: "1.6.2" };
SecretsManagerSecretMetricFactory.Namespace = "SecretsManager";
SecretsManagerSecretMetricFactory.MetricNameDaysSinceLastChange = "DaysSinceLastChange";
SecretsManagerSecretMetricFactory.MetricNameDaysSinceLastRotation = "DaysSinceLastRotation";
//# sourceMappingURL=data:application/json;base64,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