import { IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, DaysSinceUpdateThreshold, Monitoring, MonitoringScope } from "../../common";
import { SecretsManagerSecretMetricFactoryProps } from "./SecretsManagerSecretMetricFactory";
export interface SecretsManagerSecretMonitoringOptions extends BaseMonitoringProps {
    readonly addDaysSinceLastChangeAlarm?: Record<string, DaysSinceUpdateThreshold>;
    readonly addDaysSinceLastRotationAlarm?: Record<string, DaysSinceUpdateThreshold>;
    /**
     * @default true, if `addDaysSinceLastRotationAlarm` is set, otherwise `false`.
     */
    readonly showLastRotationWidget?: boolean;
}
/**
 * Monitoring props for Secrets Manager secrets.
 */
export interface SecretsManagerSecretMonitoringProps extends SecretsManagerSecretMetricFactoryProps, SecretsManagerSecretMonitoringOptions {
}
export declare class SecretsManagerSecretMonitoring extends Monitoring {
    protected readonly title: string;
    private readonly showLastRotationWidget;
    private readonly alarmFactory;
    private readonly daysSinceLastChangeMetric;
    private readonly daysSinceLastChangeAnnotations;
    private readonly daysSinceLastRotationMetric;
    private readonly daysSinceLastRotationAnnotations;
    constructor(scope: MonitoringScope, props: SecretsManagerSecretMonitoringProps);
    private getDaysSinceLastChangeWidget;
    private getDaysSinceLastRotationWidget;
    private getTitleWidget;
    widgets(): IWidget[];
    summaryWidgets(): IWidget[];
}
