"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManagerSecretMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SecretsManagerMetricsPublisher_1 = require("./SecretsManagerMetricsPublisher");
const SecretsManagerSecretMetricFactory_1 = require("./SecretsManagerSecretMetricFactory");
class SecretsManagerSecretMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope);
        const publisher = SecretsManagerMetricsPublisher_1.SecretsManagerMetricsPublisher.getInstance(scope);
        publisher.addSecret(props.secret);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.secret,
            fallbackConstructName: props.secret.secretName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.showLastRotationWidget = !!(props.showLastRotationWidget || props.addDaysSinceLastRotationAlarm);
        const metricFactory = new SecretsManagerSecretMetricFactory_1.SecretsManagerSecretMetricFactory(scope.createMetricFactory(), props);
        this.daysSinceLastChangeMetric = metricFactory.metricDaysSinceLastChange();
        this.daysSinceLastRotationMetric =
            metricFactory.metricDaysSinceLastRotation();
        this.alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        const ageAlarmFactory = new common_1.AgeAlarmFactory(this.alarmFactory);
        this.daysSinceLastChangeAnnotations = [];
        this.daysSinceLastRotationAnnotations = [];
        for (const disambiguator in props.addDaysSinceLastChangeAlarm) {
            const alarmProps = props.addDaysSinceLastChangeAlarm[disambiguator];
            const createdAlarm = ageAlarmFactory.addDaysSinceUpdateAlarm(this.daysSinceLastChangeMetric, alarmProps, disambiguator);
            this.daysSinceLastChangeAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDaysSinceLastRotationAlarm) {
            const alarmProps = props.addDaysSinceLastRotationAlarm[disambiguator];
            const createdAlarm = ageAlarmFactory.addDaysSinceUpdateAlarm(this.daysSinceLastRotationMetric, alarmProps, disambiguator);
            this.daysSinceLastRotationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    getDaysSinceLastChangeWidget() {
        return new aws_cloudwatch_1.GraphWidget({
            width: common_1.HalfWidth,
            height: common_1.DefaultGraphWidgetHeight,
            title: "Days since last change",
            left: [this.daysSinceLastChangeMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.daysSinceLastChangeAnnotations,
        });
    }
    getDaysSinceLastRotationWidget() {
        return new aws_cloudwatch_1.GraphWidget({
            width: common_1.HalfWidth,
            height: common_1.DefaultGraphWidgetHeight,
            title: "Days since last rotation",
            left: [this.daysSinceLastRotationMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.daysSinceLastRotationAnnotations,
        });
    }
    getTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Secret",
            title: this.title,
        });
    }
    widgets() {
        const widgets = [
            this.getTitleWidget(),
            this.getDaysSinceLastChangeWidget(),
        ];
        if (this.showLastRotationWidget) {
            widgets.push(this.getDaysSinceLastRotationWidget());
        }
        return widgets;
    }
    summaryWidgets() {
        // TODO verify dimensions, mainly height
        return this.widgets();
    }
}
exports.SecretsManagerSecretMonitoring = SecretsManagerSecretMonitoring;
_a = JSII_RTTI_SYMBOL_1;
SecretsManagerSecretMonitoring[_a] = { fqn: "cdk-monitoring-constructs.SecretsManagerSecretMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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