import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, HighMessagesPublishedThreshold, LowMessagesPublishedThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope, NotificationsFailedThreshold, TopicAlarmFactory } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { SnsTopicMetricFactoryProps } from "./SnsTopicMetricFactory";
export interface SnsTopicMonitoringOptions extends BaseMonitoringProps {
    readonly addMessageNotificationsFailedAlarm?: Record<string, NotificationsFailedThreshold>;
    readonly addMinNumberOfMessagesPublishedAlarm?: Record<string, LowMessagesPublishedThreshold>;
    readonly addMaxNumberOfMessagesPublishedAlarm?: Record<string, HighMessagesPublishedThreshold>;
}
export interface SnsTopicMonitoringProps extends SnsTopicMetricFactoryProps, SnsTopicMonitoringOptions {
}
export declare class SnsTopicMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly topicUrl?: string;
    protected readonly topicAlarmFactory: TopicAlarmFactory;
    protected readonly failedDeliveryAnnotations: HorizontalAnnotation[];
    protected readonly incomingMessagesAnnotations: HorizontalAnnotation[];
    protected readonly incomingMessagesMetric: MetricWithAlarmSupport;
    protected readonly outgoingMessagesMetric: MetricWithAlarmSupport;
    protected readonly messageSizeMetric: MetricWithAlarmSupport;
    protected readonly messagesFailedMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: SnsTopicMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createMessageCountWidget(width: number, height: number): GraphWidget;
    protected createMessageSizeWidget(width: number, height: number): GraphWidget;
    protected createMessageFailedWidget(width: number, height: number): GraphWidget;
    private resolveTopicName;
}
