"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopicMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SnsTopicMetricFactory_1 = require("./SnsTopicMetricFactory");
class SnsTopicMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.topic,
            fallbackConstructName: this.resolveTopicName(props.topic),
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.topicUrl = scope
            .createAwsConsoleUrlFactory()
            .getSnsTopicUrl(props.topic.topicArn);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.topicAlarmFactory = new common_1.TopicAlarmFactory(alarmFactory);
        this.failedDeliveryAnnotations = [];
        this.incomingMessagesAnnotations = [];
        const metricFactory = new SnsTopicMetricFactory_1.SnsTopicMetricFactory(scope.createMetricFactory(), props);
        this.incomingMessagesMetric = metricFactory.metricIncomingMessageCount();
        this.outgoingMessagesMetric = metricFactory.metricOutgoingMessageCount();
        this.messageSizeMetric = metricFactory.metricAverageMessageSizeInBytes();
        this.messagesFailedMetric =
            metricFactory.metricNumberOfNotificationsFailed();
        for (const disambiguator in props.addMessageNotificationsFailedAlarm) {
            const alarmProps = props.addMessageNotificationsFailedAlarm[disambiguator];
            const createdAlarm = this.topicAlarmFactory.addMessageNotificationsFailedAlarm(this.messagesFailedMetric, alarmProps, disambiguator);
            this.failedDeliveryAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinNumberOfMessagesPublishedAlarm) {
            const alarmProps = props.addMinNumberOfMessagesPublishedAlarm[disambiguator];
            const createdAlarm = this.topicAlarmFactory.addMinMessagesPublishedAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.incomingMessagesAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxNumberOfMessagesPublishedAlarm) {
            const alarmProps = props.addMaxNumberOfMessagesPublishedAlarm[disambiguator];
            const createdAlarm = this.topicAlarmFactory.addMaxMessagesPublishedAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.incomingMessagesAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createMessageCountWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createMessageFailedWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createMessageCountWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createMessageSizeWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createMessageFailedWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "SNS Topic",
            title: this.title,
            goToLinkUrl: this.topicUrl,
        });
    }
    createMessageCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Count",
            left: [this.incomingMessagesMetric, this.outgoingMessagesMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.incomingMessagesAnnotations,
        });
    }
    createMessageSizeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Size",
            left: [this.messageSizeMetric],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createMessageFailedWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Delivery Failed",
            left: [this.messagesFailedMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.failedDeliveryAnnotations,
        });
    }
    resolveTopicName(snsTopic) {
        var _b;
        // try to take the name (if specified) instead of token
        return (_b = snsTopic.node.defaultChild) === null || _b === void 0 ? void 0 : _b.topicName;
    }
}
exports.SnsTopicMonitoring = SnsTopicMonitoring;
_a = JSII_RTTI_SYMBOL_1;
SnsTopicMonitoring[_a] = { fqn: "cdk-monitoring-constructs.SnsTopicMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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