import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { IQueue } from "aws-cdk-lib/aws-sqs";
import { BaseMonitoringProps, MaxIncomingMessagesCountThreshold, MaxMessageAgeThreshold, MaxMessageCountThreshold, MaxTimeToDrainThreshold, MetricWithAlarmSupport, MinIncomingMessagesCountThreshold, MinMessageCountThreshold, Monitoring, MonitoringScope, QueueAlarmFactory } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { SqsQueueMetricFactoryProps } from "./SqsQueueMetricFactory";
export interface BaseSqsQueueAlarms {
    readonly addQueueMinSizeAlarm?: Record<string, MinMessageCountThreshold>;
    readonly addQueueMaxSizeAlarm?: Record<string, MaxMessageCountThreshold>;
    readonly addQueueMaxMessageAgeAlarm?: Record<string, MaxMessageAgeThreshold>;
    readonly addQueueMaxTimeToDrainMessagesAlarm?: Record<string, MaxTimeToDrainThreshold>;
    readonly addQueueMinIncomingMessagesAlarm?: Record<string, MinIncomingMessagesCountThreshold>;
    readonly addQueueMaxIncomingMessagesAlarm?: Record<string, MaxIncomingMessagesCountThreshold>;
}
export interface SqsQueueMonitoringOptions extends BaseSqsQueueAlarms, BaseMonitoringProps {
}
export interface SqsQueueMonitoringProps extends SqsQueueMetricFactoryProps, SqsQueueMonitoringOptions {
}
export declare class SqsQueueMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly queueUrl?: string;
    protected readonly queueAlarmFactory: QueueAlarmFactory;
    protected readonly countAnnotations: HorizontalAnnotation[];
    protected readonly ageAnnotations: HorizontalAnnotation[];
    protected readonly timeToDrainAnnotations: HorizontalAnnotation[];
    protected readonly visibleMessagesMetric: MetricWithAlarmSupport;
    protected readonly incomingMessagesMetric: MetricWithAlarmSupport;
    protected readonly deletedMessagesMetric: MetricWithAlarmSupport;
    protected readonly oldestMessageAgeMetric: MetricWithAlarmSupport;
    protected readonly messageSizeMetric: MetricWithAlarmSupport;
    protected readonly productionRateMetric: MetricWithAlarmSupport;
    protected readonly consumptionRateMetric: MetricWithAlarmSupport;
    protected readonly timeToDrainMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: SqsQueueMonitoringProps, invokedFromSuper?: boolean);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createMessageCountWidget(width: number, height: number): GraphWidget;
    protected createMessageAgeWidget(width: number, height: number): GraphWidget;
    protected createMessageSizeWidget(width: number, height: number): GraphWidget;
    protected createProducerAndConsumerRateWidget(width: number, height: number): GraphWidget;
    protected createTimeToDrainWidget(width: number, height: number): GraphWidget;
    protected resolveQueueName(queue: IQueue): string | undefined;
}
