"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueueMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SqsQueueMetricFactory_1 = require("./SqsQueueMetricFactory");
class SqsQueueMonitoring extends common_1.Monitoring {
    constructor(scope, props, invokedFromSuper) {
        var _b;
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.queue,
            fallbackConstructName: this.resolveQueueName(props.queue),
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.queueUrl = scope
            .createAwsConsoleUrlFactory()
            .getSqsQueueUrl(props.queue.queueUrl);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.queueAlarmFactory = new common_1.QueueAlarmFactory(alarmFactory);
        this.countAnnotations = [];
        this.ageAnnotations = [];
        this.timeToDrainAnnotations = [];
        const metricFactory = new SqsQueueMetricFactory_1.SqsQueueMetricFactory(scope.createMetricFactory(), props);
        this.visibleMessagesMetric =
            metricFactory.metricApproximateVisibleMessageCount();
        this.incomingMessagesMetric = metricFactory.metricIncomingMessageCount();
        this.deletedMessagesMetric = metricFactory.metricDeletedMessageCount();
        this.oldestMessageAgeMetric =
            metricFactory.metricApproximateAgeOfOldestMessageInSeconds();
        this.messageSizeMetric = metricFactory.metricAverageMessageSizeInBytes();
        this.productionRateMetric = metricFactory.metricProductionRate();
        this.consumptionRateMetric = metricFactory.metricConsumptionRate();
        this.timeToDrainMetric = metricFactory.metricTimeToDrain();
        for (const disambiguator in props.addQueueMinSizeAlarm) {
            const alarmProps = props.addQueueMinSizeAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMinQueueMessageCountAlarm(this.visibleMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxSizeAlarm) {
            const alarmProps = props.addQueueMaxSizeAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueMessageCountAlarm(this.visibleMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxMessageAgeAlarm) {
            const alarmProps = props.addQueueMaxMessageAgeAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueMessageAgeAlarm(this.oldestMessageAgeMetric, alarmProps, disambiguator);
            this.ageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxTimeToDrainMessagesAlarm) {
            const alarmProps = props.addQueueMaxTimeToDrainMessagesAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueTimeToDrainMessagesAlarm(this.timeToDrainMetric, alarmProps, disambiguator);
            this.timeToDrainAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMinIncomingMessagesAlarm) {
            const alarmProps = props.addQueueMinIncomingMessagesAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMinQueueIncomingMessagesCountAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxIncomingMessagesAlarm) {
            const alarmProps = props.addQueueMaxIncomingMessagesAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueIncomingMessagesCountAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        if (!(invokedFromSuper !== null && invokedFromSuper !== void 0 ? invokedFromSuper : false)) {
            // invoke only when not called from super class, so it is not called twice
            // TODO: find a more elegant solution for this
            (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
        }
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createProducerAndConsumerRateWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight), this.createTimeToDrainWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight)),
            new aws_cloudwatch_1.Row(this.createMessageCountWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight), this.createMessageAgeWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight)),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createMessageCountWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createMessageAgeWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createMessageSizeWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight)),
            new aws_cloudwatch_1.Row(this.createProducerAndConsumerRateWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight), this.createTimeToDrainWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight)),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "SQS Queue",
            title: this.title,
            goToLinkUrl: this.queueUrl,
        });
    }
    createMessageCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Count",
            left: [this.visibleMessagesMetric, this.incomingMessagesMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.countAnnotations,
        });
    }
    createMessageAgeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Oldest Message Age",
            left: [this.oldestMessageAgeMetric],
            leftYAxis: common_1.TimeAxisSecondsFromZero,
            leftAnnotations: this.ageAnnotations,
        });
    }
    createMessageSizeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Size",
            left: [this.messageSizeMetric],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createProducerAndConsumerRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Producer vs Consumer (rate)",
            left: [this.productionRateMetric, this.consumptionRateMetric],
            leftYAxis: common_1.RateAxisFromZero,
        });
    }
    createTimeToDrainWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Time to drain",
            left: [this.timeToDrainMetric],
            leftYAxis: common_1.TimeAxisSecondsFromZero,
        });
    }
    resolveQueueName(queue) {
        var _b;
        // try to take the name (if specified) instead of token
        return (_b = queue.node.defaultChild) === null || _b === void 0 ? void 0 : _b.queueName;
    }
}
exports.SqsQueueMonitoring = SqsQueueMonitoring;
_a = JSII_RTTI_SYMBOL_1;
SqsQueueMonitoring[_a] = { fqn: "cdk-monitoring-constructs.SqsQueueMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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