"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueueMonitoringWithDlq = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SqsQueueMetricFactory_1 = require("./SqsQueueMetricFactory");
const SqsQueueMonitoring_1 = require("./SqsQueueMonitoring");
class SqsQueueMonitoringWithDlq extends SqsQueueMonitoring_1.SqsQueueMonitoring {
    constructor(scope, props) {
        var _b, _c;
        super(scope, props, true);
        const deadLetterMetricFactory = new SqsQueueMetricFactory_1.SqsQueueMetricFactory(scope.createMetricFactory(), {
            ...props,
            queue: props.deadLetterQueue,
        });
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.deadLetterQueue,
            fallbackConstructName: this.resolveQueueName(props.deadLetterQueue),
        });
        this.deadLetterTitle = namingStrategy.resolveHumanReadableName();
        this.deadLetterUrl = scope
            .createAwsConsoleUrlFactory()
            .getSqsQueueUrl(props.deadLetterQueue.queueUrl);
        this.addDeadLetterQueueToSummaryDashboard = (_b = props.addDeadLetterQueueToSummaryDashboard) !== null && _b !== void 0 ? _b : false;
        const deadLetterAlarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName() + "-DLQ");
        this.deadLetterCountAnnotations = [];
        this.deadLetterAgeAnnotations = [];
        this.deadLetterQueueAlarmFactory = new common_1.QueueAlarmFactory(deadLetterAlarmFactory);
        this.deadLetterQueueVisibleMessagesMetric =
            deadLetterMetricFactory.metricApproximateVisibleMessageCount();
        this.deadLetterQueueIncomingMessagesMetric =
            deadLetterMetricFactory.metricIncomingMessageCount();
        this.deadLetterQueueOldestMessageAgeMetric =
            deadLetterMetricFactory.metricApproximateAgeOfOldestMessageInSeconds();
        for (const disambiguator in props.addDeadLetterQueueMaxSizeAlarm) {
            const alarmProps = props.addDeadLetterQueueMaxSizeAlarm[disambiguator];
            const createdAlarm = this.deadLetterQueueAlarmFactory.addMaxQueueMessageCountAlarm(this.deadLetterQueueVisibleMessagesMetric, alarmProps, disambiguator);
            this.deadLetterCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDeadLetterQueueMaxMessageAgeAlarm) {
            const alarmProps = props.addDeadLetterQueueMaxMessageAgeAlarm[disambiguator];
            const createdAlarm = this.deadLetterQueueAlarmFactory.addMaxQueueMessageAgeAlarm(this.deadLetterQueueOldestMessageAgeMetric, alarmProps, disambiguator);
            this.deadLetterAgeAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDeadLetterQueueMaxIncomingMessagesAlarm) {
            const alarmProps = props.addDeadLetterQueueMaxIncomingMessagesAlarm[disambiguator];
            const createdAlarm = this.deadLetterQueueAlarmFactory.addMaxQueueIncomingMessagesCountAlarm(this.deadLetterQueueIncomingMessagesMetric, alarmProps, disambiguator);
            this.addAlarm(createdAlarm);
        }
        (_c = props.useCreatedAlarms) === null || _c === void 0 ? void 0 : _c.consume(this.createdAlarms());
    }
    summaryWidgets() {
        var _b;
        const addToSummary = (_b = this.addDeadLetterQueueToSummaryDashboard) !== null && _b !== void 0 ? _b : true;
        if (!addToSummary) {
            // do not show the DLQ widgets at all
            return super.summaryWidgets();
        }
        return [
            ...super.summaryWidgets(),
            this.createDeadLetterMessageCountWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createDeadLetterMessageAgeWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            ...super.widgets(),
            this.createDeadLetterTitleWidget(),
            this.createDeadLetterMessageCountWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
            this.createDeadLetterMessageAgeWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createDeadLetterTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "SQS Dead-Letter Queue",
            title: this.deadLetterTitle,
            goToLinkUrl: this.deadLetterUrl,
        });
    }
    createDeadLetterMessageCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "DLQ: Message Count",
            left: [
                this.deadLetterQueueVisibleMessagesMetric,
                this.deadLetterQueueIncomingMessagesMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.deadLetterCountAnnotations,
        });
    }
    createDeadLetterMessageAgeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "DLQ: Oldest Message Age",
            left: [this.deadLetterQueueOldestMessageAgeMetric],
            leftYAxis: common_1.TimeAxisSecondsFromZero,
            leftAnnotations: this.deadLetterAgeAnnotations,
        });
    }
}
exports.SqsQueueMonitoringWithDlq = SqsQueueMonitoringWithDlq;
_a = JSII_RTTI_SYMBOL_1;
SqsQueueMonitoringWithDlq[_a] = { fqn: "cdk-monitoring-constructs.SqsQueueMonitoringWithDlq", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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