"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionActivityMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/States";
class StepFunctionActivityMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.rateComputationMethod = common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            ActivityArn: props.activity.activityArn,
        };
    }
    metricActivityRunTimeP99InMillis() {
        return this.metricFactory.createMetric("ActivityRunTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityRunTimeP90InMillis() {
        return this.metricFactory.createMetric("ActivityRunTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityRunTimeP50InMillis() {
        return this.metricFactory.createMetric("ActivityRunTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityScheduleTimeP99InMillis() {
        return this.metricFactory.createMetric("ActivityScheduleTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityScheduleTimeP90InMillis() {
        return this.metricFactory.createMetric("ActivityScheduleTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityScheduleTimeP50InMillis() {
        return this.metricFactory.createMetric("ActivityScheduleTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityTimeP99InMillis() {
        return this.metricFactory.createMetric("ActivityTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityTimeP90InMillis() {
        return this.metricFactory.createMetric("ActivityTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityTimeP50InMillis() {
        return this.metricFactory.createMetric("ActivityTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesFailed() {
        return this.metricFactory.createMetric("ActivitiesFailed", common_1.MetricStatistic.SUM, "Failed", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesFailedRate() {
        const metric = this.metricActivitiesFailed();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricActivitiesHeartbeatTimedOut() {
        return this.metricFactory.createMetric("ActivitiesHeartbeatTimedOut", common_1.MetricStatistic.SUM, "HeartbeatTimedOut", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesScheduled() {
        return this.metricFactory.createMetric("ActivitiesScheduled", common_1.MetricStatistic.SUM, "Scheduled", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesStarted() {
        return this.metricFactory.createMetric("ActivitiesStarted", common_1.MetricStatistic.SUM, "Started", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesSucceeded() {
        return this.metricFactory.createMetric("ActivitiesSucceeded", common_1.MetricStatistic.SUM, "Succeeded", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesTimedOut() {
        return this.metricFactory.createMetric("ActivitiesTimedOut", common_1.MetricStatistic.SUM, "Timeout", this.dimensionsMap, undefined, Namespace);
    }
}
exports.StepFunctionActivityMetricFactory = StepFunctionActivityMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionActivityMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.StepFunctionActivityMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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