import { HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, DurationThreshold, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, LatencyAlarmFactory, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { StepFunctionActivityMetricFactoryProps } from "./StepFunctionActivityMetricFactory";
export interface StepFunctionActivityMonitoringProps extends StepFunctionActivityMetricFactoryProps, BaseMonitoringProps {
    readonly addDurationP50Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP90Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP99Alarm?: Record<string, DurationThreshold>;
    readonly addFailedActivitiesCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFailedActivitiesRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addTimedOutActivitiesCountAlarm?: Record<string, ErrorCountThreshold>;
}
export declare class StepFunctionActivityMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly durationAlarmFactory: LatencyAlarmFactory;
    protected readonly durationAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly p50DurationMetric: MetricWithAlarmSupport;
    protected readonly p90DurationMetric: MetricWithAlarmSupport;
    protected readonly p99DurationMetric: MetricWithAlarmSupport;
    protected readonly scheduledActivitiesMetric: MetricWithAlarmSupport;
    protected readonly startedActivitiesMetric: MetricWithAlarmSupport;
    protected readonly succeededActivitiesMetric: MetricWithAlarmSupport;
    protected readonly failedActivitiesMetric: MetricWithAlarmSupport;
    protected readonly failedActivitiesRateMetric: MetricWithAlarmSupport;
    protected readonly heartbeatTimedOutActivitiesMetrics: MetricWithAlarmSupport;
    protected readonly timedOutActivitiesMetrics: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: StepFunctionActivityMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
}
