"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionLambdaIntegrationMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/States";
class StepFunctionLambdaIntegrationMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.rateComputationMethod = common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            LambdaFunctionArn: props.lambdaFunction.functionArn,
        };
    }
    metricFunctionRunTimeP99InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionRunTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionRunTimeP90InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionRunTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionRunTimeP50InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionRunTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionScheduleTimeP99InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionScheduleTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionScheduleTimeP90InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionScheduleTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionScheduleTimeP50InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionScheduleTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionTimeP99InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionTimeP90InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionTimeP50InMillis() {
        return this.metricFactory.createMetric("LambdaFunctionTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionsFailed() {
        return this.metricFactory.createMetric("LambdaFunctionsFailed", common_1.MetricStatistic.SUM, "Failed", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionsFailedRate() {
        const metric = this.metricFunctionsFailed();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricFunctionsScheduled() {
        return this.metricFactory.createMetric("LambdaFunctionsScheduled", common_1.MetricStatistic.SUM, "Scheduled", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionsStarted() {
        return this.metricFactory.createMetric("LambdaFunctionsStarted", common_1.MetricStatistic.SUM, "Started", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionsSucceeded() {
        return this.metricFactory.createMetric("LambdaFunctionsSucceeded", common_1.MetricStatistic.SUM, "Succeeded", this.dimensionsMap, undefined, Namespace);
    }
    metricFunctionsTimedOut() {
        return this.metricFactory.createMetric("LambdaFunctionsTimedOut", common_1.MetricStatistic.SUM, "Timeout", this.dimensionsMap, undefined, Namespace);
    }
}
exports.StepFunctionLambdaIntegrationMetricFactory = StepFunctionLambdaIntegrationMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionLambdaIntegrationMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.StepFunctionLambdaIntegrationMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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