import { HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, DurationThreshold, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, LatencyAlarmFactory, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { StepFunctionLambdaIntegrationMetricFactoryProps } from "./StepFunctionLambdaIntegrationMetricFactory";
export interface StepFunctionLambdaIntegrationMonitoringProps extends StepFunctionLambdaIntegrationMetricFactoryProps, BaseMonitoringProps {
    readonly addDurationP50Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP90Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP99Alarm?: Record<string, DurationThreshold>;
    readonly addFailedFunctionsCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFailedFunctionsRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addTimedOutFunctionsCountAlarm?: Record<string, ErrorCountThreshold>;
}
export declare class StepFunctionLambdaIntegrationMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly functionUrl?: string;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly durationAlarmFactory: LatencyAlarmFactory;
    protected readonly durationAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly p50DurationMetric: MetricWithAlarmSupport;
    protected readonly p90DurationMetric: MetricWithAlarmSupport;
    protected readonly p99DurationMetric: MetricWithAlarmSupport;
    protected readonly scheduledFunctionsMetric: MetricWithAlarmSupport;
    protected readonly startedFunctionsMetric: MetricWithAlarmSupport;
    protected readonly succeededFunctionsMetric: MetricWithAlarmSupport;
    protected readonly failedFunctionsMetric: MetricWithAlarmSupport;
    protected readonly failedFunctionRateMetric: MetricWithAlarmSupport;
    protected readonly timedOutFunctionsMetrics: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: StepFunctionLambdaIntegrationMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
}
