"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionLambdaIntegrationMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const StepFunctionLambdaIntegrationMetricFactory_1 = require("./StepFunctionLambdaIntegrationMetricFactory");
class StepFunctionLambdaIntegrationMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        const fallbackConstructName = props.lambdaFunction.functionName;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.functionUrl = scope
            .createAwsConsoleUrlFactory()
            .getLambdaFunctionUrl(props.lambdaFunction.functionName);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.errorAlarmFactory = new common_1.ErrorAlarmFactory(alarmFactory);
        this.durationAlarmFactory = new common_1.LatencyAlarmFactory(alarmFactory);
        this.durationAnnotations = [];
        this.errorCountAnnotations = [];
        this.errorRateAnnotations = [];
        const metricFactory = new StepFunctionLambdaIntegrationMetricFactory_1.StepFunctionLambdaIntegrationMetricFactory(scope.createMetricFactory(), props);
        this.p50DurationMetric = metricFactory.metricFunctionRunTimeP50InMillis();
        this.p90DurationMetric = metricFactory.metricFunctionRunTimeP90InMillis();
        this.p99DurationMetric = metricFactory.metricFunctionRunTimeP99InMillis();
        this.scheduledFunctionsMetric = metricFactory.metricFunctionsScheduled();
        this.startedFunctionsMetric = metricFactory.metricFunctionsStarted();
        this.succeededFunctionsMetric = metricFactory.metricFunctionsSucceeded();
        this.failedFunctionsMetric = metricFactory.metricFunctionsFailed();
        this.failedFunctionRateMetric = metricFactory.metricFunctionsFailedRate();
        this.timedOutFunctionsMetrics = metricFactory.metricFunctionsTimedOut();
        for (const disambiguator in props.addDurationP50Alarm) {
            const alarmProps = props.addDurationP50Alarm[disambiguator];
            const createdAlarm = this.durationAlarmFactory.addDurationAlarm(this.p50DurationMetric, common_1.LatencyType.P50, alarmProps, disambiguator);
            this.durationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDurationP90Alarm) {
            const alarmProps = props.addDurationP90Alarm[disambiguator];
            const createdAlarm = this.durationAlarmFactory.addDurationAlarm(this.p90DurationMetric, common_1.LatencyType.P90, alarmProps, disambiguator);
            this.durationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDurationP99Alarm) {
            const alarmProps = props.addDurationP99Alarm[disambiguator];
            const createdAlarm = this.durationAlarmFactory.addDurationAlarm(this.p99DurationMetric, common_1.LatencyType.P99, alarmProps, disambiguator);
            this.durationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFailedFunctionsCountAlarm) {
            const alarmProps = props.addFailedFunctionsCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.failedFunctionsMetric, common_1.ErrorType.FAILURE, alarmProps, disambiguator);
            this.errorCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFailedFunctionsRateAlarm) {
            const alarmProps = props.addFailedFunctionsRateAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.failedFunctionRateMetric, common_1.ErrorType.FAILURE, alarmProps, disambiguator);
            this.errorRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addTimedOutFunctionsCountAlarm) {
            const alarmProps = props.addTimedOutFunctionsCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.timedOutFunctionsMetrics, common_1.ErrorType.TIMED_OUT, alarmProps, disambiguator);
            this.errorCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            // Title
            new dashboard_1.MonitoringHeaderWidget({
                family: "States Lambda Integration",
                title: this.title,
                goToLinkUrl: this.functionUrl,
            }),
            // Duration
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.HalfWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "Duration",
                left: [
                    this.p50DurationMetric,
                    this.p90DurationMetric,
                    this.p99DurationMetric,
                ],
                leftYAxis: common_1.TimeAxisMillisFromZero,
                leftAnnotations: this.durationAnnotations,
            }),
            // Statuses
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.HalfWidth,
                height: common_1.DefaultSummaryWidgetHeight,
                title: "Executions",
                left: [
                    this.scheduledFunctionsMetric,
                    this.startedFunctionsMetric,
                    this.succeededFunctionsMetric,
                    this.failedFunctionsMetric,
                    this.timedOutFunctionsMetrics,
                ],
                leftYAxis: common_1.CountAxisFromZero,
                leftAnnotations: this.errorCountAnnotations,
            }),
        ];
    }
    widgets() {
        return [
            // Title
            new dashboard_1.MonitoringHeaderWidget({
                family: "States Lambda Integration",
                title: this.title,
                goToLinkUrl: this.functionUrl,
            }),
            // Duration
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Duration",
                left: [
                    this.p50DurationMetric,
                    this.p90DurationMetric,
                    this.p99DurationMetric,
                ],
                leftYAxis: common_1.TimeAxisMillisFromZero,
                leftAnnotations: this.durationAnnotations,
            }),
            // Statuses
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.HalfWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Executions",
                left: [
                    this.scheduledFunctionsMetric,
                    this.startedFunctionsMetric,
                    this.succeededFunctionsMetric,
                    this.failedFunctionsMetric,
                    this.timedOutFunctionsMetrics,
                ],
                leftYAxis: common_1.CountAxisFromZero,
                leftAnnotations: this.errorCountAnnotations,
            }),
            // Fault Rate
            new aws_cloudwatch_1.GraphWidget({
                width: common_1.QuarterWidth,
                height: common_1.DefaultGraphWidgetHeight,
                title: "Errors (rate)",
                left: [this.failedFunctionRateMetric],
                leftAnnotations: this.errorRateAnnotations,
            }),
        ];
    }
}
exports.StepFunctionLambdaIntegrationMonitoring = StepFunctionLambdaIntegrationMonitoring;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionLambdaIntegrationMonitoring[_a] = { fqn: "cdk-monitoring-constructs.StepFunctionLambdaIntegrationMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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