"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/States";
class StepFunctionMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.rateComputationMethod = common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            StateMachineArn: props.stateMachine.stateMachineArn,
        };
    }
    metricExecutionTimeP99InMillis() {
        return this.metricFactory.createMetric("ExecutionTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionTimeP90InMillis() {
        return this.metricFactory.createMetric("ExecutionTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionTimeP50InMillis() {
        return this.metricFactory.createMetric("ExecutionTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsFailed() {
        return this.metricFactory.createMetric("ExecutionsFailed", common_1.MetricStatistic.SUM, "Failed", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsFailedRate() {
        const metric = this.metricExecutionsFailed();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricExecutionsTimedOut() {
        return this.metricFactory.createMetric("ExecutionsTimedOut", common_1.MetricStatistic.SUM, "Timeout", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionThrottled() {
        return this.metricFactory.createMetric("ExecutionThrottled", common_1.MetricStatistic.SUM, "Throttled", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsAborted() {
        return this.metricFactory.createMetric("ExecutionsAborted", common_1.MetricStatistic.SUM, "Aborted", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsStarted() {
        return this.metricFactory.createMetric("ExecutionsStarted", common_1.MetricStatistic.SUM, "Started", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsSucceeded() {
        return this.metricFactory.createMetric("ExecutionsSucceeded", common_1.MetricStatistic.SUM, "Succeeded", this.dimensionsMap, undefined, Namespace);
    }
}
exports.StepFunctionMetricFactory = StepFunctionMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.StepFunctionMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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