import { HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, DurationThreshold, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, LatencyAlarmFactory, MetricWithAlarmSupport, MinRunningTaskCountThreshold, Monitoring, MonitoringScope, TaskHealthAlarmFactory } from "../../common";
import { StepFunctionMetricFactoryProps } from "./StepFunctionMetricFactory";
export interface StepFunctionMonitoringOptions extends BaseMonitoringProps {
    readonly addDurationP50Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP90Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP99Alarm?: Record<string, DurationThreshold>;
    readonly addFailedExecutionCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFailedExecutionRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addAbortedExecutionCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addThrottledExecutionCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addTimedOutExecutionCountAlarm?: Record<string, ErrorCountThreshold>;
    /**
     * Add minimum started execution count alarm for the stepfunctions.
     */
    readonly addMinStartedExecutionCountAlarm?: Record<string, MinRunningTaskCountThreshold>;
}
export interface StepFunctionMonitoringProps extends StepFunctionMetricFactoryProps, StepFunctionMonitoringOptions {
}
export declare class StepFunctionMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly stateMachineUrl?: string;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly durationAlarmFactory: LatencyAlarmFactory;
    protected readonly taskHealthAlarmFactory: TaskHealthAlarmFactory;
    protected readonly durationAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly p50DurationMetric: MetricWithAlarmSupport;
    protected readonly p90DurationMetric: MetricWithAlarmSupport;
    protected readonly p99DurationMetric: MetricWithAlarmSupport;
    protected readonly startedExecutionsMetric: MetricWithAlarmSupport;
    protected readonly succeededExecutionsMetric: MetricWithAlarmSupport;
    protected readonly failedExecutionsMetric: MetricWithAlarmSupport;
    protected readonly failedExecutionRateMetric: MetricWithAlarmSupport;
    protected readonly abortedExecutionsMetric: MetricWithAlarmSupport;
    protected readonly throttledExecutionsMetric: MetricWithAlarmSupport;
    protected readonly timedOutExecutionsMetrics: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: StepFunctionMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
}
