import { HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, DurationThreshold, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, LatencyAlarmFactory, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { StepFunctionServiceIntegrationMetricFactoryProps } from "./StepFunctionServiceIntegrationMetricFactory";
export interface StepFunctionServiceIntegrationMonitoringProps extends StepFunctionServiceIntegrationMetricFactoryProps, BaseMonitoringProps {
    readonly addDurationP50Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP90Alarm?: Record<string, DurationThreshold>;
    readonly addDurationP99Alarm?: Record<string, DurationThreshold>;
    readonly addFailedServiceIntegrationsCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFailedServiceIntegrationsRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addTimedOutServiceIntegrationsCountAlarm?: Record<string, ErrorCountThreshold>;
}
export declare class StepFunctionServiceIntegrationMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly durationAlarmFactory: LatencyAlarmFactory;
    protected readonly durationAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly p50DurationMetric: MetricWithAlarmSupport;
    protected readonly p90DurationMetric: MetricWithAlarmSupport;
    protected readonly p99DurationMetric: MetricWithAlarmSupport;
    protected readonly scheduledServiceIntegrationsMetric: MetricWithAlarmSupport;
    protected readonly startedServiceIntegrationsMetric: MetricWithAlarmSupport;
    protected readonly succeededServiceIntegrationsMetric: MetricWithAlarmSupport;
    protected readonly failedServiceIntegrationsMetric: MetricWithAlarmSupport;
    protected readonly failedServiceIntegrationRateMetric: MetricWithAlarmSupport;
    protected readonly timedOutServiceIntegrationsMetrics: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: StepFunctionServiceIntegrationMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
}
