"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyntheticsCanaryMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const index_1 = require("../../common/index");
const MetricNamespace = "CloudWatchSynthetics";
class SyntheticsCanaryMetricFactory {
    constructor(metricFactory, props) {
        var _b;
        this.canary = props.canary;
        this.metricFactory = metricFactory;
        this.rateComputationMethod = (_b = props.rateComputationMethod) !== null && _b !== void 0 ? _b : index_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            CanaryName: props.canary.canaryName,
        };
    }
    metricLatencyAverageInMillis() {
        return this.metricFactory.adaptMetric(this.canary.metricDuration({
            label: "Average",
            statistic: index_1.MetricStatistic.AVERAGE,
        }));
    }
    metricSuccessInPercent() {
        return this.metricFactory.adaptMetric(this.canary.metricSuccessPercent({
            label: "Success Rate",
            statistic: index_1.MetricStatistic.AVERAGE,
        }));
    }
    metric4xxErrorCount() {
        return this.metricFactory.createMetric("4xx", index_1.MetricStatistic.SUM, "4xx", this.dimensionsMap, undefined, MetricNamespace);
    }
    metric4xxErrorRate() {
        const metric = this.metric4xxErrorCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "errors");
    }
    metric5xxFaultCount() {
        return this.metricFactory.createMetric("5xx", index_1.MetricStatistic.SUM, "5xx", this.dimensionsMap, undefined, MetricNamespace);
    }
    metric5xxFaultRate() {
        const metric = this.metric5xxFaultCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
}
exports.SyntheticsCanaryMetricFactory = SyntheticsCanaryMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
SyntheticsCanaryMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.SyntheticsCanaryMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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