import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, LatencyAlarmFactory, LatencyThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common/index";
import { MonitoringHeaderWidget } from "../../dashboard/index";
import { SyntheticsCanaryMetricFactoryProps } from "./SyntheticsCanaryMetricFactory";
export interface SyntheticsCanaryMonitoringOptions extends BaseMonitoringProps {
    readonly addAverageLatencyAlarm?: Record<string, LatencyThreshold>;
    readonly add4xxErrorCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly add4xxErrorRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly add5xxFaultCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly add5xxFaultRateAlarm?: Record<string, ErrorRateThreshold>;
}
export interface SyntheticsCanaryMonitoringProps extends SyntheticsCanaryMetricFactoryProps, SyntheticsCanaryMonitoringOptions {
}
/**
 * Monitoring for CloudWatch Synthetics Canaries.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries.html
 */
export declare class SyntheticsCanaryMonitoring extends Monitoring {
    protected readonly humanReadableName: string;
    protected readonly latencyAlarmFactory: LatencyAlarmFactory;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly latencyAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly averageLatencyMetric: MetricWithAlarmSupport;
    protected readonly errorCountMetric: MetricWithAlarmSupport;
    protected readonly errorRateMetric: MetricWithAlarmSupport;
    protected readonly faultCountMetric: MetricWithAlarmSupport;
    protected readonly faultRateMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: SyntheticsCanaryMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createLatencyWidget(width: number, height: number): GraphWidget;
    protected createErrorCountWidget(width: number, height: number): GraphWidget;
    protected createErrorRateWidget(width: number, height: number): GraphWidget;
}
