import { GraphWidget, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { WafV2MetricFactoryProps } from "./WafV2MetricFactory";
export interface WafV2MonitoringOptions extends BaseMonitoringProps {
}
export interface WafV2MonitoringProps extends WafV2MetricFactoryProps, WafV2MonitoringOptions {
}
/**
 * Monitoring for AWS Web Application Firewall.
 *
 * @see https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html
 */
export declare class WafV2Monitoring extends Monitoring {
    protected readonly humanReadableName: string;
    protected readonly allowedRequestsMetric: MetricWithAlarmSupport;
    protected readonly blockedRequestsMetric: MetricWithAlarmSupport;
    protected readonly blockedRequestsRateMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: WafV2MonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createAllowedRequestsWidget(width: number, height: number): GraphWidget;
    protected createBlockedRequestsWidget(width: number, height: number): GraphWidget;
    protected createBlockedRequestsRateWidget(width: number, height: number): GraphWidget;
}
