"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafV2Monitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const WafV2MetricFactory_1 = require("./WafV2MetricFactory");
/**
 * Monitoring for AWS Web Application Firewall.
 *
 * @see https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html
 */
class WafV2Monitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.acl,
        });
        this.humanReadableName = namingStrategy.resolveHumanReadableName();
        const metricFactory = new WafV2MetricFactory_1.WafV2MetricFactory(scope.createMetricFactory(), props);
        this.allowedRequestsMetric = metricFactory.metricAllowedRequests();
        this.blockedRequestsMetric = metricFactory.metricBlockedRequests();
        this.blockedRequestsRateMetric = metricFactory.metricBlockedRequestsRate();
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createAllowedRequestsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createBlockedRequestsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createBlockedRequestsRateWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createAllowedRequestsWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createBlockedRequestsWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createBlockedRequestsRateWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Web Application Firewall",
            title: this.humanReadableName,
        });
    }
    createAllowedRequestsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Allowed Requests",
            left: [this.allowedRequestsMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createBlockedRequestsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Blocked Requests",
            left: [this.blockedRequestsMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createBlockedRequestsRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Blocked Requests (rate)",
            left: [this.blockedRequestsRateMetric],
            leftYAxis: common_1.RateAxisFromZero,
        });
    }
}
exports.WafV2Monitoring = WafV2Monitoring;
_a = JSII_RTTI_SYMBOL_1;
WafV2Monitoring[_a] = { fqn: "cdk-monitoring-constructs.WafV2Monitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiV2FmVjJNb25pdG9yaW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiV2FmVjJNb25pdG9yaW5nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0RBQWtFO0FBQ2xFLHlDQVVzQjtBQUN0QiwrQ0FHeUI7QUFDekIsNkRBRzhCO0FBUTlCOzs7O0dBSUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsbUJBQVU7SUFPN0MsWUFBWSxLQUFzQixFQUFFLEtBQTJCO1FBQzdELEtBQUssQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFcEIsTUFBTSxjQUFjLEdBQUcsSUFBSSxvQ0FBd0IsQ0FBQztZQUNsRCxHQUFHLEtBQUs7WUFDUixjQUFjLEVBQUUsS0FBSyxDQUFDLEdBQUc7U0FDMUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGlCQUFpQixHQUFHLGNBQWMsQ0FBQyx3QkFBd0IsRUFBRSxDQUFDO1FBRW5FLE1BQU0sYUFBYSxHQUFHLElBQUksdUNBQWtCLENBQzFDLEtBQUssQ0FBQyxtQkFBbUIsRUFBRSxFQUMzQixLQUFLLENBQ04sQ0FBQztRQUVGLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxhQUFhLENBQUMscUJBQXFCLEVBQUUsQ0FBQztRQUNuRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsYUFBYSxDQUFDLHFCQUFxQixFQUFFLENBQUM7UUFDbkUsSUFBSSxDQUFDLHlCQUF5QixHQUFHLGFBQWEsQ0FBQyx5QkFBeUIsRUFBRSxDQUFDO0lBQzdFLENBQUM7SUFFRCxjQUFjO1FBQ1osT0FBTztZQUNMLElBQUksQ0FBQyxpQkFBaUIsRUFBRTtZQUN4QixJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxtQ0FBMEIsQ0FBQztZQUN4RSxJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxtQ0FBMEIsQ0FBQztZQUN4RSxJQUFJLENBQUMsK0JBQStCLENBQ2xDLG1CQUFVLEVBQ1YsbUNBQTBCLENBQzNCO1NBQ0YsQ0FBQztJQUNKLENBQUM7SUFFRCxPQUFPO1FBQ0wsT0FBTztZQUNMLElBQUksQ0FBQyxpQkFBaUIsRUFBRTtZQUN4QixJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxpQ0FBd0IsQ0FBQztZQUN0RSxJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxpQ0FBd0IsQ0FBQztZQUN0RSxJQUFJLENBQUMsK0JBQStCLENBQ2xDLG1CQUFVLEVBQ1YsaUNBQXdCLENBQ3pCO1NBQ0YsQ0FBQztJQUNKLENBQUM7SUFFUyxpQkFBaUI7UUFDekIsT0FBTyxJQUFJLGtDQUFzQixDQUFDO1lBQ2hDLE1BQU0sRUFBRSwwQkFBMEI7WUFDbEMsS0FBSyxFQUFFLElBQUksQ0FBQyxpQkFBaUI7U0FDOUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVTLDJCQUEyQixDQUFDLEtBQWEsRUFBRSxNQUFjO1FBQ2pFLE9BQU8sSUFBSSw0QkFBVyxDQUFDO1lBQ3JCLEtBQUs7WUFDTCxNQUFNO1lBQ04sS0FBSyxFQUFFLGtCQUFrQjtZQUN6QixJQUFJLEVBQUUsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7WUFDbEMsU0FBUyxFQUFFLDBCQUFpQjtTQUM3QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRVMsMkJBQTJCLENBQUMsS0FBYSxFQUFFLE1BQWM7UUFDakUsT0FBTyxJQUFJLDRCQUFXLENBQUM7WUFDckIsS0FBSztZQUNMLE1BQU07WUFDTixLQUFLLEVBQUUsa0JBQWtCO1lBQ3pCLElBQUksRUFBRSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztZQUNsQyxTQUFTLEVBQUUsMEJBQWlCO1NBQzdCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFUywrQkFBK0IsQ0FBQyxLQUFhLEVBQUUsTUFBYztRQUNyRSxPQUFPLElBQUksNEJBQVcsQ0FBQztZQUNyQixLQUFLO1lBQ0wsTUFBTTtZQUNOLEtBQUssRUFBRSx5QkFBeUI7WUFDaEMsSUFBSSxFQUFFLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDO1lBQ3RDLFNBQVMsRUFBRSx5QkFBZ0I7U0FDNUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFyRkgsMENBc0ZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgR3JhcGhXaWRnZXQsIElXaWRnZXQgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2hcIjtcbmltcG9ydCB7XG4gIEJhc2VNb25pdG9yaW5nUHJvcHMsXG4gIENvdW50QXhpc0Zyb21aZXJvLFxuICBEZWZhdWx0R3JhcGhXaWRnZXRIZWlnaHQsXG4gIERlZmF1bHRTdW1tYXJ5V2lkZ2V0SGVpZ2h0LFxuICBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0LFxuICBNb25pdG9yaW5nLFxuICBNb25pdG9yaW5nU2NvcGUsXG4gIFJhdGVBeGlzRnJvbVplcm8sXG4gIFRoaXJkV2lkdGgsXG59IGZyb20gXCIuLi8uLi9jb21tb25cIjtcbmltcG9ydCB7XG4gIE1vbml0b3JpbmdIZWFkZXJXaWRnZXQsXG4gIE1vbml0b3JpbmdOYW1pbmdTdHJhdGVneSxcbn0gZnJvbSBcIi4uLy4uL2Rhc2hib2FyZFwiO1xuaW1wb3J0IHtcbiAgV2FmVjJNZXRyaWNGYWN0b3J5LFxuICBXYWZWMk1ldHJpY0ZhY3RvcnlQcm9wcyxcbn0gZnJvbSBcIi4vV2FmVjJNZXRyaWNGYWN0b3J5XCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgV2FmVjJNb25pdG9yaW5nT3B0aW9ucyBleHRlbmRzIEJhc2VNb25pdG9yaW5nUHJvcHMge31cblxuZXhwb3J0IGludGVyZmFjZSBXYWZWMk1vbml0b3JpbmdQcm9wc1xuICBleHRlbmRzIFdhZlYyTWV0cmljRmFjdG9yeVByb3BzLFxuICAgIFdhZlYyTW9uaXRvcmluZ09wdGlvbnMge31cblxuLyoqXG4gKiBNb25pdG9yaW5nIGZvciBBV1MgV2ViIEFwcGxpY2F0aW9uIEZpcmV3YWxsLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dhZi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbW9uaXRvcmluZy1jbG91ZHdhdGNoLmh0bWxcbiAqL1xuZXhwb3J0IGNsYXNzIFdhZlYyTW9uaXRvcmluZyBleHRlbmRzIE1vbml0b3Jpbmcge1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgaHVtYW5SZWFkYWJsZU5hbWU6IHN0cmluZztcblxuICBwcm90ZWN0ZWQgcmVhZG9ubHkgYWxsb3dlZFJlcXVlc3RzTWV0cmljOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgYmxvY2tlZFJlcXVlc3RzTWV0cmljOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgYmxvY2tlZFJlcXVlc3RzUmF0ZU1ldHJpYzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydDtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogTW9uaXRvcmluZ1Njb3BlLCBwcm9wczogV2FmVjJNb25pdG9yaW5nUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgcHJvcHMpO1xuXG4gICAgY29uc3QgbmFtaW5nU3RyYXRlZ3kgPSBuZXcgTW9uaXRvcmluZ05hbWluZ1N0cmF0ZWd5KHtcbiAgICAgIC4uLnByb3BzLFxuICAgICAgbmFtZWRDb25zdHJ1Y3Q6IHByb3BzLmFjbCxcbiAgICB9KTtcbiAgICB0aGlzLmh1bWFuUmVhZGFibGVOYW1lID0gbmFtaW5nU3RyYXRlZ3kucmVzb2x2ZUh1bWFuUmVhZGFibGVOYW1lKCk7XG5cbiAgICBjb25zdCBtZXRyaWNGYWN0b3J5ID0gbmV3IFdhZlYyTWV0cmljRmFjdG9yeShcbiAgICAgIHNjb3BlLmNyZWF0ZU1ldHJpY0ZhY3RvcnkoKSxcbiAgICAgIHByb3BzXG4gICAgKTtcblxuICAgIHRoaXMuYWxsb3dlZFJlcXVlc3RzTWV0cmljID0gbWV0cmljRmFjdG9yeS5tZXRyaWNBbGxvd2VkUmVxdWVzdHMoKTtcbiAgICB0aGlzLmJsb2NrZWRSZXF1ZXN0c01ldHJpYyA9IG1ldHJpY0ZhY3RvcnkubWV0cmljQmxvY2tlZFJlcXVlc3RzKCk7XG4gICAgdGhpcy5ibG9ja2VkUmVxdWVzdHNSYXRlTWV0cmljID0gbWV0cmljRmFjdG9yeS5tZXRyaWNCbG9ja2VkUmVxdWVzdHNSYXRlKCk7XG4gIH1cblxuICBzdW1tYXJ5V2lkZ2V0cygpOiBJV2lkZ2V0W10ge1xuICAgIHJldHVybiBbXG4gICAgICB0aGlzLmNyZWF0ZVRpdGxlV2lkZ2V0KCksXG4gICAgICB0aGlzLmNyZWF0ZUFsbG93ZWRSZXF1ZXN0c1dpZGdldChUaGlyZFdpZHRoLCBEZWZhdWx0U3VtbWFyeVdpZGdldEhlaWdodCksXG4gICAgICB0aGlzLmNyZWF0ZUJsb2NrZWRSZXF1ZXN0c1dpZGdldChUaGlyZFdpZHRoLCBEZWZhdWx0U3VtbWFyeVdpZGdldEhlaWdodCksXG4gICAgICB0aGlzLmNyZWF0ZUJsb2NrZWRSZXF1ZXN0c1JhdGVXaWRnZXQoXG4gICAgICAgIFRoaXJkV2lkdGgsXG4gICAgICAgIERlZmF1bHRTdW1tYXJ5V2lkZ2V0SGVpZ2h0XG4gICAgICApLFxuICAgIF07XG4gIH1cblxuICB3aWRnZXRzKCk6IElXaWRnZXRbXSB7XG4gICAgcmV0dXJuIFtcbiAgICAgIHRoaXMuY3JlYXRlVGl0bGVXaWRnZXQoKSxcbiAgICAgIHRoaXMuY3JlYXRlQWxsb3dlZFJlcXVlc3RzV2lkZ2V0KFRoaXJkV2lkdGgsIERlZmF1bHRHcmFwaFdpZGdldEhlaWdodCksXG4gICAgICB0aGlzLmNyZWF0ZUJsb2NrZWRSZXF1ZXN0c1dpZGdldChUaGlyZFdpZHRoLCBEZWZhdWx0R3JhcGhXaWRnZXRIZWlnaHQpLFxuICAgICAgdGhpcy5jcmVhdGVCbG9ja2VkUmVxdWVzdHNSYXRlV2lkZ2V0KFxuICAgICAgICBUaGlyZFdpZHRoLFxuICAgICAgICBEZWZhdWx0R3JhcGhXaWRnZXRIZWlnaHRcbiAgICAgICksXG4gICAgXTtcbiAgfVxuXG4gIHByb3RlY3RlZCBjcmVhdGVUaXRsZVdpZGdldCgpIHtcbiAgICByZXR1cm4gbmV3IE1vbml0b3JpbmdIZWFkZXJXaWRnZXQoe1xuICAgICAgZmFtaWx5OiBcIldlYiBBcHBsaWNhdGlvbiBGaXJld2FsbFwiLFxuICAgICAgdGl0bGU6IHRoaXMuaHVtYW5SZWFkYWJsZU5hbWUsXG4gICAgfSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlQWxsb3dlZFJlcXVlc3RzV2lkZ2V0KHdpZHRoOiBudW1iZXIsIGhlaWdodDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBHcmFwaFdpZGdldCh7XG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodCxcbiAgICAgIHRpdGxlOiBcIkFsbG93ZWQgUmVxdWVzdHNcIixcbiAgICAgIGxlZnQ6IFt0aGlzLmFsbG93ZWRSZXF1ZXN0c01ldHJpY10sXG4gICAgICBsZWZ0WUF4aXM6IENvdW50QXhpc0Zyb21aZXJvLFxuICAgIH0pO1xuICB9XG5cbiAgcHJvdGVjdGVkIGNyZWF0ZUJsb2NrZWRSZXF1ZXN0c1dpZGdldCh3aWR0aDogbnVtYmVyLCBoZWlnaHQ6IG51bWJlcikge1xuICAgIHJldHVybiBuZXcgR3JhcGhXaWRnZXQoe1xuICAgICAgd2lkdGgsXG4gICAgICBoZWlnaHQsXG4gICAgICB0aXRsZTogXCJCbG9ja2VkIFJlcXVlc3RzXCIsXG4gICAgICBsZWZ0OiBbdGhpcy5ibG9ja2VkUmVxdWVzdHNNZXRyaWNdLFxuICAgICAgbGVmdFlBeGlzOiBDb3VudEF4aXNGcm9tWmVybyxcbiAgICB9KTtcbiAgfVxuXG4gIHByb3RlY3RlZCBjcmVhdGVCbG9ja2VkUmVxdWVzdHNSYXRlV2lkZ2V0KHdpZHRoOiBudW1iZXIsIGhlaWdodDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBHcmFwaFdpZGdldCh7XG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodCxcbiAgICAgIHRpdGxlOiBcIkJsb2NrZWQgUmVxdWVzdHMgKHJhdGUpXCIsXG4gICAgICBsZWZ0OiBbdGhpcy5ibG9ja2VkUmVxdWVzdHNSYXRlTWV0cmljXSxcbiAgICAgIGxlZnRZQXhpczogUmF0ZUF4aXNGcm9tWmVybyxcbiAgICB9KTtcbiAgfVxufVxuIl19