'''
# CDK Monitoring Constructs

[![Gitpod Ready-to-Code](https://img.shields.io/badge/Gitpod-ready--to--code-blue?logo=gitpod)](https://gitpod.io/#https://github.com/cdklabs/cdk-monitoring-constructs)
[![NPM version](https://badge.fury.io/js/cdk-monitoring-constructs.svg)](https://badge.fury.io/js/cdk-monitoring-constructs)
[![PyPI version](https://badge.fury.io/py/cdk-monitoring-constructs.svg)](https://badge.fury.io/py/cdk-monitoring-constructs)
[![NuGet version](https://badge.fury.io/nu/Cdklabs.CdkMonitoringConstructs.svg)](https://badge.fury.io/nu/Cdklabs.CdkMonitoringConstructs)
[![Maven Central](https://maven-badges.herokuapp.com/maven-central/io.github.cdklabs/cdkmonitoringconstructs/badge.svg)](https://maven-badges.herokuapp.com/maven-central/io.github.cdklabs/cdkmonitoringconstructs)
[![Mergify](https://img.shields.io/endpoint.svg?url=https://gh.mergify.io/badges/cdklabs/cdk-monitoring-constructs&style=flat)](https://mergify.io)

Easy-to-use CDK constructs for monitoring your AWS infrastructure.

* Easily add commonly-used alarms using predefined properties
* Generate concise Cloudwatch dashboards that indicate your alarms
* Extend the library with your own extensions or custom metrics
* Consume the library in multiple languages (see below)

## Installation

<details><summary><strong>TypeScript</strong></summary>

> https://www.npmjs.com/package/cdk-monitoring-constructs

In your `package.json`:

```json
{
  "dependencies": {
    "cdk-monitoring-constructs": "^1.0.0",

    // peer dependencies
    "@aws-cdk/aws-apigatewayv2-alpha": "^2.18.0-alpha.0",
    "@aws-cdk/aws-appsync-alpha": "^2.18.0-alpha.0",
    "@aws-cdk/aws-redshift-alpha": "^2.18.0-alpha.0",
    "@aws-cdk/aws-synthetics-alpha": "^2.18.0-alpha.0",
    "aws-cdk-lib": "^2.18.0",
    "constructs": "^10.0.5"

    // (your other dependencies)
  }
}
```

</details><details><summary><strong>Java</strong></summary>

See https://mvnrepository.com/artifact/io.github.cdklabs/cdkmonitoringconstructs

</details><details><summary><strong>Python</strong></summary>

See https://pypi.org/project/cdk-monitoring-constructs/

</details><details><summary><strong>C#</strong></summary>

See https://www.nuget.org/packages/Cdklabs.CdkMonitoringConstructs/

</details>

## Features

See [API](API.md) for complete auto-generated documentation.

You can also browse the documentation at https://constructs.dev/packages/cdk-monitoring-constructs/

| Item | Monitoring | Alarms | Notes |
| ---- | ---------- | ------ | ----- |
| AWS API Gateway (REST API) (`.monitorApiGateway()`) | TPS, latency, errors | Latency, error count/rate |  To see metrics, you have to enable Advanced Monitoring |
| AWS API Gateway V2 (HTTP API) (`.monitorApiGatewayV2HttpApi()`) | TPS, latency, errors | Latency, error count/rate | To see route level metrics, you have to enable Advanced Monitoring|
| AWS AppSync (GraphQL API) (`.monitorAppSyncApi()`) | TPS, latency, errors | Latency, error count/rate, low/high TPS | |
| AWS Billing (`.monitorBilling()`) | AWS account cost | | [Requires enabling](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/gs_monitor_estimated_charges_with_cloudwatch.html#gs_turning_on_billing_metrics) the **Receive Billing Alerts** option in AWS Console / Billing Preferences |
| AWS Certificate Manager (`.monitorCertificate()`) | Certificate expiration | Days until expiration | |
| AWS CloudFront (`.monitorCloudFrontDistribution()`) | TPS, traffic, latency, errors | Error rate, low/high TPS | |
| AWS CloudWatch Synthetics Canary (`.monitorSyntheticsCanary()`) | Latency, error count/rate | Error count/rate, latency | |
| AWS CodeBuild (`.monitorCodeBuildProject()`) | Build counts (total, successful, failed), failed rate, duration | Failed build count/rate, duration | |
| AWS DynamoDB (`.monitorDynamoTable()`) | Read and write capacity provisioned / used | Consumed capacity, throttling, latency, errors | |
| AWS DynamoDB Global Secondary Index (`.monitorDynamoTableGlobalSecondaryIndex()`) | Read and write capacity, indexing progress, throttled events | | |
| AWS EC2 (`.monitorEC2Instances()`) | CPU, disk operations, network | | |
| AWS EC2 Auto Scaling Groups (`.monitorAutoScalingGroup()`) | Group size, instance status | | |
| AWS ECS (`.monitorFargateService()`, `.monitorEc2Service()`, `.monitorSimpleFargateService()`, `monitorSimpleEc2Service()`, `.monitorQueueProcessingFargateService()`, `.monitorQueueProcessingEc2Service()`) | System resources and task health | Unhealthy task count, running tasks count, CPU/memory usage, and bytes processed by load balancer (if any) | Use for ecs-patterns load balanced ec2/fargate constructs (NetworkLoadBalancedEc2Service, NetworkLoadBalancedFargateService, ApplicationLoadBalancedEc2Service, ApplicationLoadBalancedFargateService) |
| AWS ElastiCache (`.monitorElastiCacheCluster()`) | CPU/memory usage, evictions and connections | | |
| AWS Glue (`.monitorGlueJob()`) | Traffic, job status, memory/CPU usage | | |
| AWS Kinesis Data Analytics (`.monitorKinesisDataAnalytics`) | Up/Downtime, CPU/memory usage, KPU usage, checkpoint metrics, and garbage collection metrics | Downtime | |
| AWS Kinesis Data Stream (`.monitorKinesisDataStream()`) | Put/Get/Incoming Record/s and Throttling | Throttling, iterator max age | |
| AWS Kinesis Firehose (`.monitorKinesisFirehose()`) | Number of records, requests, latency, throttling | | |
| AWS Lambda (`.monitorLambdaFunction()`) | Latency, errors, iterator max age | Latency, errors, throttles, iterator max age | Optional Lambda Insights metrics (opt-in) support |
| AWS Load Balancing (`.monitorNetworkLoadBalancer()`, `.monitorFargateApplicationLoadBalancer()`, `.monitorFargateNetworkLoadBalancer()`, `.monitorEc2ApplicationLoadBalancer()`, `.monitorEc2NetworkLoadBalancer()`) | System resources and task health | Unhealthy task count, running tasks count, (for Fargate/Ec2 apps) CPU/memory usage | Use for FargateService or Ec2Service backed by a NetworkLoadBalancer or ApplicationLoadBalancer |
| AWS OpenSearch/Elasticsearch (`.monitorOpenSearchCluster()`, `.monitorElasticsearchCluster()`) | Indexing and search latency, disk/memory/CPU usage | Indexing and search latency, disk/memory/CPU usage, cluster status | |
| AWS RDS (`.monitorRdsCluster()`) | Query duration, connections, latency, disk/CPU usage | Disk and CPU usage | |
| AWS Redshift (`.monitorRedshiftCluster()`) | Query duration, connections, latency, disk/CPU usage | Disk and CPU usage | |
| AWS S3 Bucket (`.monitorS3Bucket()`) | Bucket size and number of objects | | |
| AWS SecretsManager (`.monitorSecretsManagerSecret()`) | Days since last rotation | Days since last rotation | |
| AWS SNS Topic (`.monitorSnsTopic()`) | Message count, size, failed notifications | Failed notifications | |
| AWS SQS Queue (`.monitorSqsQueue()`, `.monitorSqsQueueWithDlq()`) | Message count, age, size | Message count, age, DLQ incoming messages | |
| AWS Step Functions (`.monitorStepFunction()`, `.monitorStepFunctionActivity()`, `monitorStepFunctionLambdaIntegration()`, `.monitorStepFunctionServiceIntegration()`) | Execution count and breakdown per state | Duration, failed, failed rate, aborted, throttled, timed out executions | |
| AWS Web Application Firewall (`.monitorWebApplicationFirewallAcl()`) | Allowed/blocked requests | | |
| CloudWatch Logs (`.monitorLog()`) | Patterns present in the log group | | |
| Custom metrics (`.monitorCustom()`) | Addition of custom metrics into the dashboard (each group is a widget) | | Supports anomaly detection |

## Getting started

### Create monitoring stack and facade

*Important note*: **Please, do NOT import anything from the `/dist/lib` package.** This is unsupported and might break any time.

Create an instance of `MonitoringFacade`, which is the main entry point:

```python
export interface MonitoringStackProps extends DeploymentStackProps {
  // ...
}

export class MonitoringStack extends DeploymentStack {
  constructor(parent: App, name: string, props: MonitoringStackProps) {
    super(parent, name, props);

    const monitoring = new MonitoringFacade(this, "Monitoring", {
      // Define all necessary props
    });

    // Setup your monitoring
    monitoring
      .addLargeHeader("Storage")
      .monitorDynamoTable({ /* table1 */ })
      .monitorDynamoTable({ /* table2 */ })
      .monitorDynamoTable({ /* table3 */ })
      // ...and more
  }
}
```

### Set up your monitoring

Once the facade is created, you can use it to call methods like `.monitorLambdaFunction()` and chain them together to define your monitors.

You can also use facade methods to add your own widgets, headers of various sizes, and more.

### Customize actions

Alarms should have an action setup, otherwise they are not very useful. Currently, we support notifying an SNS queue.

```python
const onAlarmTopic = new Topic(this, "AlarmTopic");

const monitoring = new MonitoringFacade(this, "Monitoring", {
  // ...other props
  alarmFactoryDefaults: {
    // ....other props
    action: new SnsAlarmActionStrategy({ onAlarmTopic }),
  },
});
```

You can override the default topic for any alarm like this:

```python
monitoring
  .monitorSomething(something, {
    addSomeAlarm: {
      Warning: {
        // ...other props
        threshold: 42,
        actionOverride: new SnsAlarmActionStrategy({ onAlarmTopic }),
      }
    }
  });
```

### Custom metrics

For simply adding some custom metrics, you can use `.monitorCustom()` and specify your own title and metric groups.
Each metric group will be rendered as a single graph widget, and all widgets will be placed next to each other.
All the widgets will have the same size, which is chosen based on the number of groups to maximize dashboard space usage.

Custom metric monitoring can be created for simple metrics, simple metrics with anomaly detection and search metrics.
The first two also support alarming.

### Custom monitoring

If you want even more flexibility, you can create your own Dashboard Segment.

This is a general procedure on how to do it:

1. Extend the `Monitoring` ckass
2. Override the `widgets()` method (and/or similar ones)
3. Leverage the metric factor and alarm factory, provided by the base class (you can create additional factories, if you will)
4. Add all alarms to `.addAlarm()` so they are visible to the user and being placed on the alarm summary dashboard

Both of these monitoring base classes are dashboard segments, so you can add them to your monitoring by calling `.addSegment()`.

### Monitoring Scopes

With CDK Monitoring Constructs, you can monitor complete CDK construct scopes. It will automatically discover all monitorable resources within the scope (recursively)) and add them to your dashboard.

```python
monitoring.monitorScope(stack);
```

You can also specify default alarms for any specific resource and disable automatic monitoring for it as well.

```python
monitoring.monitorScope(stack, {
  lambda: {
    props: {
      addLatencyP50Alarm: {
        Critical: { maxLatency: Duration.seconds(10) },
      },
    },
  },
  billing: { enabled: false },
});
```

## Contributing/Security

See [CONTRIBUTING](CONTRIBUTING.md) for more information.

## License

This project is licensed under the Apache-2.0 License.
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from ._jsii import *

import aws_cdk
import aws_cdk.aws_apigateway
import aws_cdk.aws_apigatewayv2_alpha
import aws_cdk.aws_appsync_alpha
import aws_cdk.aws_autoscaling
import aws_cdk.aws_certificatemanager
import aws_cdk.aws_cloudfront
import aws_cdk.aws_cloudwatch
import aws_cdk.aws_codebuild
import aws_cdk.aws_dynamodb
import aws_cdk.aws_ecs
import aws_cdk.aws_ecs_patterns
import aws_cdk.aws_elasticloadbalancingv2
import aws_cdk.aws_elasticsearch
import aws_cdk.aws_lambda
import aws_cdk.aws_opensearchservice
import aws_cdk.aws_s3
import aws_cdk.aws_secretsmanager
import aws_cdk.aws_sns
import aws_cdk.aws_sqs
import aws_cdk.aws_stepfunctions
import aws_cdk.aws_synthetics_alpha
import aws_cdk.aws_wafv2
import constructs


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AddAlarmProps",
    jsii_struct_bases=[],
    name_mapping={
        "alarm_description": "alarmDescription",
        "alarm_name_suffix": "alarmNameSuffix",
        "comparison_operator": "comparisonOperator",
        "threshold": "threshold",
        "treat_missing_data": "treatMissingData",
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_dedupe_string_suffix": "alarmDedupeStringSuffix",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "disambiguator": "disambiguator",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
    },
)
class AddAlarmProps:
    def __init__(
        self,
        *,
        alarm_description: builtins.str,
        alarm_name_suffix: builtins.str,
        comparison_operator: aws_cdk.aws_cloudwatch.ComparisonOperator,
        threshold: jsii.Number,
        treat_missing_data: aws_cdk.aws_cloudwatch.TreatMissingData,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Properties necessary to create a single alarm and configure it.

        :param alarm_description: (experimental) Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible.
        :param alarm_name_suffix: (experimental) Suffix added to base alarm name. Alarm names need to be unique.
        :param comparison_operator: (experimental) Comparison operator used to compare actual value against the threshold.
        :param threshold: (experimental) Threshold to alarm on.
        :param treat_missing_data: (experimental) Behaviour in case the metric data is missing.
        :param action_override: (experimental) Allows to override the default action strategy. Default: default action will be used
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_dedupe_string_suffix: (experimental) If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix. This allows you to specify the same dedupe string for a family of alarms. Cannot be defined at the same time as alarmDedupeStringOverride. Default: undefined (no suffix)
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state.
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Default: undefined (no override)
        :param disambiguator: (experimental) Disambiguator is a string that differentiates this alarm from other similar ones. Default: undefined (no disambiguator)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: {number} Same as datapointsToAlarm.
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alarm_description": alarm_description,
            "alarm_name_suffix": alarm_name_suffix,
            "comparison_operator": comparison_operator,
            "threshold": threshold,
            "treat_missing_data": treat_missing_data,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_dedupe_string_suffix is not None:
            self._values["alarm_dedupe_string_suffix"] = alarm_dedupe_string_suffix
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if disambiguator is not None:
            self._values["disambiguator"] = disambiguator
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link

    @builtins.property
    def alarm_description(self) -> builtins.str:
        '''(experimental) Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible.

        :stability: experimental
        '''
        result = self._values.get("alarm_description")
        assert result is not None, "Required property 'alarm_description' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alarm_name_suffix(self) -> builtins.str:
        '''(experimental) Suffix added to base alarm name.

        Alarm names need to be unique.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_suffix")
        assert result is not None, "Required property 'alarm_name_suffix' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def comparison_operator(self) -> aws_cdk.aws_cloudwatch.ComparisonOperator:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :stability: experimental
        '''
        result = self._values.get("comparison_operator")
        assert result is not None, "Required property 'comparison_operator' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.ComparisonOperator, result)

    @builtins.property
    def threshold(self) -> jsii.Number:
        '''(experimental) Threshold to alarm on.

        :stability: experimental
        '''
        result = self._values.get("threshold")
        assert result is not None, "Required property 'threshold' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def treat_missing_data(self) -> aws_cdk.aws_cloudwatch.TreatMissingData:
        '''(experimental) Behaviour in case the metric data is missing.

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data")
        assert result is not None, "Required property 'treat_missing_data' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.TreatMissingData, result)

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default action strategy.

        :default: default action will be used

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_dedupe_string_suffix(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix.

        This allows you to specify the same dedupe string for a family of alarms.
        Cannot be defined at the same time as alarmDedupeStringOverride.

        :default: undefined (no suffix)

        :stability: experimental
        '''
        result = self._values.get("alarm_dedupe_string_suffix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def disambiguator(self) -> typing.Optional[builtins.str]:
        '''(experimental) Disambiguator is a string that differentiates this alarm from other similar ones.

        :default: undefined (no disambiguator)

        :stability: experimental
        '''
        result = self._values.get("disambiguator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: {number} Same as datapointsToAlarm.

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddAlarmProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AddCompositeAlarmProps",
    jsii_struct_bases=[],
    name_mapping={
        "disambiguator": "disambiguator",
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_dedupe_string_suffix": "alarmDedupeStringSuffix",
        "alarm_description": "alarmDescription",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "alarm_name_suffix": "alarmNameSuffix",
        "composite_operator": "compositeOperator",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "fill_alarm_range": "fillAlarmRange",
        "runbook_link": "runbookLink",
    },
)
class AddCompositeAlarmProps:
    def __init__(
        self,
        *,
        disambiguator: builtins.str,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_description: typing.Optional[builtins.str] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        alarm_name_suffix: typing.Optional[builtins.str] = None,
        composite_operator: typing.Optional["CompositeAlarmOperator"] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        runbook_link: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Properties necessary to create a composite alarm and configure it.

        :param disambiguator: (experimental) Disambiguator is a string that differentiates this alarm from other similar ones.
        :param action_override: (experimental) Allows to override the default action strategy. Default: default action will be used
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_dedupe_string_suffix: (experimental) If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix. This allows you to specify the same dedupe string for a family of alarms. Cannot be defined at the same time as alarmDedupeStringOverride. Default: undefined (no suffix)
        :param alarm_description: (experimental) Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible. Default: no description
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param alarm_name_suffix: (experimental) Suffix added to base alarm name. Alarm names need to be unique. Default: no suffix
        :param composite_operator: (experimental) Logical operator used to aggregate the status individual alarms. Default: OR
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "disambiguator": disambiguator,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_dedupe_string_suffix is not None:
            self._values["alarm_dedupe_string_suffix"] = alarm_dedupe_string_suffix
        if alarm_description is not None:
            self._values["alarm_description"] = alarm_description
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if alarm_name_suffix is not None:
            self._values["alarm_name_suffix"] = alarm_name_suffix
        if composite_operator is not None:
            self._values["composite_operator"] = composite_operator
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link

    @builtins.property
    def disambiguator(self) -> builtins.str:
        '''(experimental) Disambiguator is a string that differentiates this alarm from other similar ones.

        :stability: experimental
        '''
        result = self._values.get("disambiguator")
        assert result is not None, "Required property 'disambiguator' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default action strategy.

        :default: default action will be used

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_dedupe_string_suffix(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix.

        This allows you to specify the same dedupe string for a family of alarms.
        Cannot be defined at the same time as alarmDedupeStringOverride.

        :default: undefined (no suffix)

        :stability: experimental
        '''
        result = self._values.get("alarm_dedupe_string_suffix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_description(self) -> typing.Optional[builtins.str]:
        '''(experimental) Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible.

        :default: no description

        :stability: experimental
        '''
        result = self._values.get("alarm_description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_suffix(self) -> typing.Optional[builtins.str]:
        '''(experimental) Suffix added to base alarm name.

        Alarm names need to be unique.

        :default: no suffix

        :stability: experimental
        '''
        result = self._values.get("alarm_name_suffix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def composite_operator(self) -> typing.Optional["CompositeAlarmOperator"]:
        '''(experimental) Logical operator used to aggregate the status individual alarms.

        :default: OR

        :stability: experimental
        '''
        result = self._values.get("composite_operator")
        return typing.cast(typing.Optional["CompositeAlarmOperator"], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AddCompositeAlarmProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AgeAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AgeAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: "AlarmFactory") -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addDaysSinceUpdateAlarm")
    def add_days_since_update_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "DaysSinceUpdateThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> "AlarmWithAnnotation":
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast("AlarmWithAnnotation", jsii.invoke(self, "addDaysSinceUpdateAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addDaysToExpiryAlarm")
    def add_days_to_expiry_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "DaysToExpiryThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> "AlarmWithAnnotation":
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast("AlarmWithAnnotation", jsii.invoke(self, "addDaysToExpiryAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addIteratorMaxAgeAlarm")
    def add_iterator_max_age_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "MaxAgeThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> "AlarmWithAnnotation":
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast("AlarmWithAnnotation", jsii.invoke(self, "addIteratorMaxAgeAlarm", [metric, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> "AlarmFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("AlarmFactory", jsii.get(self, "alarmFactory"))


class AlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        alarm_scope: constructs.Construct,
        *,
        global_alarm_defaults: "AlarmFactoryDefaults",
        global_metric_defaults: "MetricFactoryDefaults",
        local_alarm_name_prefix: builtins.str,
    ) -> None:
        '''
        :param alarm_scope: -
        :param global_alarm_defaults: 
        :param global_metric_defaults: 
        :param local_alarm_name_prefix: 

        :stability: experimental
        '''
        props = AlarmFactoryProps(
            global_alarm_defaults=global_alarm_defaults,
            global_metric_defaults=global_metric_defaults,
            local_alarm_name_prefix=local_alarm_name_prefix,
        )

        jsii.create(self.__class__, self, [alarm_scope, props])

    @jsii.member(jsii_name="addAlarm")
    def add_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        *,
        alarm_description: builtins.str,
        alarm_name_suffix: builtins.str,
        comparison_operator: aws_cdk.aws_cloudwatch.ComparisonOperator,
        threshold: jsii.Number,
        treat_missing_data: aws_cdk.aws_cloudwatch.TreatMissingData,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
    ) -> "AlarmWithAnnotation":
        '''
        :param metric: -
        :param alarm_description: (experimental) Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible.
        :param alarm_name_suffix: (experimental) Suffix added to base alarm name. Alarm names need to be unique.
        :param comparison_operator: (experimental) Comparison operator used to compare actual value against the threshold.
        :param threshold: (experimental) Threshold to alarm on.
        :param treat_missing_data: (experimental) Behaviour in case the metric data is missing.
        :param action_override: (experimental) Allows to override the default action strategy. Default: default action will be used
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_dedupe_string_suffix: (experimental) If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix. This allows you to specify the same dedupe string for a family of alarms. Cannot be defined at the same time as alarmDedupeStringOverride. Default: undefined (no suffix)
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state.
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Default: undefined (no override)
        :param disambiguator: (experimental) Disambiguator is a string that differentiates this alarm from other similar ones. Default: undefined (no disambiguator)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: {number} Same as datapointsToAlarm.
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added

        :stability: experimental
        '''
        props = AddAlarmProps(
            alarm_description=alarm_description,
            alarm_name_suffix=alarm_name_suffix,
            comparison_operator=comparison_operator,
            threshold=threshold,
            treat_missing_data=treat_missing_data,
            action_override=action_override,
            actions_enabled=actions_enabled,
            alarm_dedupe_string_suffix=alarm_dedupe_string_suffix,
            alarm_description_override=alarm_description_override,
            alarm_name_override=alarm_name_override,
            custom_params=custom_params,
            custom_tags=custom_tags,
            datapoints_to_alarm=datapoints_to_alarm,
            dedupe_string_override=dedupe_string_override,
            disambiguator=disambiguator,
            documentation_link=documentation_link,
            evaluate_low_sample_count_percentile=evaluate_low_sample_count_percentile,
            evaluation_periods=evaluation_periods,
            fill_alarm_range=fill_alarm_range,
            period=period,
            runbook_link=runbook_link,
        )

        return typing.cast("AlarmWithAnnotation", jsii.invoke(self, "addAlarm", [metric, props]))

    @jsii.member(jsii_name="addCompositeAlarm")
    def add_composite_alarm(
        self,
        alarms: typing.Sequence["AlarmWithAnnotation"],
        *,
        disambiguator: builtins.str,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_description: typing.Optional[builtins.str] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        alarm_name_suffix: typing.Optional[builtins.str] = None,
        composite_operator: typing.Optional["CompositeAlarmOperator"] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        runbook_link: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.CompositeAlarm:
        '''
        :param alarms: -
        :param disambiguator: (experimental) Disambiguator is a string that differentiates this alarm from other similar ones.
        :param action_override: (experimental) Allows to override the default action strategy. Default: default action will be used
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_dedupe_string_suffix: (experimental) If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix. This allows you to specify the same dedupe string for a family of alarms. Cannot be defined at the same time as alarmDedupeStringOverride. Default: undefined (no suffix)
        :param alarm_description: (experimental) Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible. Default: no description
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param alarm_name_suffix: (experimental) Suffix added to base alarm name. Alarm names need to be unique. Default: no suffix
        :param composite_operator: (experimental) Logical operator used to aggregate the status individual alarms. Default: OR
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added

        :stability: experimental
        '''
        props = AddCompositeAlarmProps(
            disambiguator=disambiguator,
            action_override=action_override,
            actions_enabled=actions_enabled,
            alarm_dedupe_string_suffix=alarm_dedupe_string_suffix,
            alarm_description=alarm_description,
            alarm_description_override=alarm_description_override,
            alarm_name_override=alarm_name_override,
            alarm_name_suffix=alarm_name_suffix,
            composite_operator=composite_operator,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string_override=dedupe_string_override,
            documentation_link=documentation_link,
            fill_alarm_range=fill_alarm_range,
            runbook_link=runbook_link,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.CompositeAlarm, jsii.invoke(self, "addCompositeAlarm", [alarms, props]))

    @jsii.member(jsii_name="createAnnotation")
    def _create_annotation(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.Alarm,
        comparison_operator: aws_cdk.aws_cloudwatch.ComparisonOperator,
        datapoints_to_alarm: jsii.Number,
        evaluation_periods: jsii.Number,
        fill_alarm_range: builtins.bool,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        threshold: jsii.Number,
        action: "IAlarmActionStrategy",
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.HorizontalAnnotation:
        '''
        :param alarm: 
        :param comparison_operator: 
        :param datapoints_to_alarm: 
        :param evaluation_periods: 
        :param fill_alarm_range: 
        :param metric: 
        :param threshold: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        props = AlarmAnnotationStrategyProps(
            alarm=alarm,
            comparison_operator=comparison_operator,
            datapoints_to_alarm=datapoints_to_alarm,
            evaluation_periods=evaluation_periods,
            fill_alarm_range=fill_alarm_range,
            metric=metric,
            threshold=threshold,
            action=action,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string=dedupe_string,
            disambiguator=disambiguator,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.HorizontalAnnotation, jsii.invoke(self, "createAnnotation", [props]))

    @jsii.member(jsii_name="determineActionsEnabled")
    def _determine_actions_enabled(
        self,
        actions_enabled: typing.Optional[builtins.bool] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> builtins.bool:
        '''
        :param actions_enabled: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.invoke(self, "determineActionsEnabled", [actions_enabled, disambiguator]))

    @jsii.member(jsii_name="determineCompositeAlarmRule")
    def _determine_composite_alarm_rule(
        self,
        alarms: typing.Sequence["AlarmWithAnnotation"],
        *,
        disambiguator: builtins.str,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_description: typing.Optional[builtins.str] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        alarm_name_suffix: typing.Optional[builtins.str] = None,
        composite_operator: typing.Optional["CompositeAlarmOperator"] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        runbook_link: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.IAlarmRule:
        '''
        :param alarms: -
        :param disambiguator: (experimental) Disambiguator is a string that differentiates this alarm from other similar ones.
        :param action_override: (experimental) Allows to override the default action strategy. Default: default action will be used
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_dedupe_string_suffix: (experimental) If this is defined, the default resource-specific alarm dedupe string will be set and this will be added as a suffix. This allows you to specify the same dedupe string for a family of alarms. Cannot be defined at the same time as alarmDedupeStringOverride. Default: undefined (no suffix)
        :param alarm_description: (experimental) Alarm description is included in the ticket and therefore should describe what happened, with as much context as possible. Default: no description
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param alarm_name_suffix: (experimental) Suffix added to base alarm name. Alarm names need to be unique. Default: no suffix
        :param composite_operator: (experimental) Logical operator used to aggregate the status individual alarms. Default: OR
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added

        :stability: experimental
        '''
        props = AddCompositeAlarmProps(
            disambiguator=disambiguator,
            action_override=action_override,
            actions_enabled=actions_enabled,
            alarm_dedupe_string_suffix=alarm_dedupe_string_suffix,
            alarm_description=alarm_description,
            alarm_description_override=alarm_description_override,
            alarm_name_override=alarm_name_override,
            alarm_name_suffix=alarm_name_suffix,
            composite_operator=composite_operator,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string_override=dedupe_string_override,
            documentation_link=documentation_link,
            fill_alarm_range=fill_alarm_range,
            runbook_link=runbook_link,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.IAlarmRule, jsii.invoke(self, "determineCompositeAlarmRule", [alarms, props]))

    @jsii.member(jsii_name="generateDescription")
    def _generate_description(
        self,
        alarm_description: builtins.str,
        alarm_description_override: typing.Optional[builtins.str] = None,
        runbook_link_override: typing.Optional[builtins.str] = None,
        documentation_link_override: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        '''
        :param alarm_description: -
        :param alarm_description_override: -
        :param runbook_link_override: -
        :param documentation_link_override: -

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "generateDescription", [alarm_description, alarm_description_override, runbook_link_override, documentation_link_override]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmNamingStrategy")
    def _alarm_naming_strategy(self) -> "AlarmNamingStrategy":
        '''
        :stability: experimental
        '''
        return typing.cast("AlarmNamingStrategy", jsii.get(self, "alarmNamingStrategy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmScope")
    def _alarm_scope(self) -> constructs.Construct:
        '''
        :stability: experimental
        '''
        return typing.cast(constructs.Construct, jsii.get(self, "alarmScope"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="globalAlarmDefaults")
    def _global_alarm_defaults(self) -> "AlarmFactoryDefaults":
        '''
        :stability: experimental
        '''
        return typing.cast("AlarmFactoryDefaults", jsii.get(self, "globalAlarmDefaults"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="globalMetricDefaults")
    def _global_metric_defaults(self) -> "MetricFactoryDefaults":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactoryDefaults", jsii.get(self, "globalMetricDefaults"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldUseDefaultDedupeForError")
    def should_use_default_dedupe_for_error(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "shouldUseDefaultDedupeForError"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="shouldUseDefaultDedupeForLatency")
    def should_use_default_dedupe_for_latency(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "shouldUseDefaultDedupeForLatency"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmFactoryDefaults",
    jsii_struct_bases=[],
    name_mapping={
        "actions_enabled": "actionsEnabled",
        "alarm_name_prefix": "alarmNamePrefix",
        "action": "action",
        "annotation_strategy": "annotationStrategy",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_processor": "dedupeStringProcessor",
        "documentation_link": "documentationLink",
        "evaluation_periods": "evaluationPeriods",
        "runbook_link": "runbookLink",
        "use_default_dedupe_for_error": "useDefaultDedupeForError",
        "use_default_dedupe_for_latency": "useDefaultDedupeForLatency",
    },
)
class AlarmFactoryDefaults:
    def __init__(
        self,
        *,
        actions_enabled: typing.Union[builtins.bool, typing.Mapping[builtins.str, builtins.bool]],
        alarm_name_prefix: builtins.str,
        action: typing.Optional["IAlarmActionStrategy"] = None,
        annotation_strategy: typing.Optional["IAlarmAnnotationStrategy"] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_processor: typing.Optional["IAlarmDedupeStringProcessor"] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        use_default_dedupe_for_error: typing.Optional[builtins.bool] = None,
        use_default_dedupe_for_latency: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions for either all severities, or per severity.
        :param alarm_name_prefix: (experimental) Global prefix for all alarm names. This should be something unique to avoid collisions with other CTIs. This is ignored if an alarm's dedupeStringOverride is declared.
        :param action: (experimental) Default alarm action used for each alarm, unless it is overridden. Default: no action.
        :param annotation_strategy: (experimental) Custom strategy to create annotations for alarms. Default: default annotations
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: 3
        :param dedupe_string_processor: (experimental) Custom strategy to process dedupe strings of the alarms. Default: default behaviour (no change)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body.
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: {number} Same as datapointsToAlarm.
        :param runbook_link: (experimental) An optional link included in the generated ticket description body.
        :param use_default_dedupe_for_error: (experimental) If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string. This essentially stops the dedupe of different errors together. Default: undefined (true)
        :param use_default_dedupe_for_latency: (experimental) If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string. This essentially stops the dedupe of different latency issues together. Default: undefined (true)

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "actions_enabled": actions_enabled,
            "alarm_name_prefix": alarm_name_prefix,
        }
        if action is not None:
            self._values["action"] = action
        if annotation_strategy is not None:
            self._values["annotation_strategy"] = annotation_strategy
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_processor is not None:
            self._values["dedupe_string_processor"] = dedupe_string_processor
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if use_default_dedupe_for_error is not None:
            self._values["use_default_dedupe_for_error"] = use_default_dedupe_for_error
        if use_default_dedupe_for_latency is not None:
            self._values["use_default_dedupe_for_latency"] = use_default_dedupe_for_latency

    @builtins.property
    def actions_enabled(
        self,
    ) -> typing.Union[builtins.bool, typing.Mapping[builtins.str, builtins.bool]]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions for either all severities, or per severity.

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        assert result is not None, "Required property 'actions_enabled' is missing"
        return typing.cast(typing.Union[builtins.bool, typing.Mapping[builtins.str, builtins.bool]], result)

    @builtins.property
    def alarm_name_prefix(self) -> builtins.str:
        '''(experimental) Global prefix for all alarm names.

        This should be something unique to avoid collisions with other CTIs.
        This is ignored if an alarm's dedupeStringOverride is declared.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_prefix")
        assert result is not None, "Required property 'alarm_name_prefix' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def action(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Default alarm action used for each alarm, unless it is overridden.

        :default: no action.

        :stability: experimental
        '''
        result = self._values.get("action")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def annotation_strategy(self) -> typing.Optional["IAlarmAnnotationStrategy"]:
        '''(experimental) Custom strategy to create annotations for alarms.

        :default: default annotations

        :stability: experimental
        '''
        result = self._values.get("annotation_strategy")
        return typing.cast(typing.Optional["IAlarmAnnotationStrategy"], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: 3

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_processor(self) -> typing.Optional["IAlarmDedupeStringProcessor"]:
        '''(experimental) Custom strategy to process dedupe strings of the alarms.

        :default: default behaviour (no change)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_processor")
        return typing.cast(typing.Optional["IAlarmDedupeStringProcessor"], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: {number} Same as datapointsToAlarm.

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def use_default_dedupe_for_error(self) -> typing.Optional[builtins.bool]:
        '''(experimental) If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string.

        This essentially stops the dedupe of different errors together.

        :default: undefined (true)

        :stability: experimental
        '''
        result = self._values.get("use_default_dedupe_for_error")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def use_default_dedupe_for_latency(self) -> typing.Optional[builtins.bool]:
        '''(experimental) If this is defined as false and dedupeStringOverride is undefined, the alarm prefix will be part of the dedupe string.

        This essentially stops the dedupe of different latency issues together.

        :default: undefined (true)

        :stability: experimental
        '''
        result = self._values.get("use_default_dedupe_for_latency")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmFactoryDefaults(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "global_alarm_defaults": "globalAlarmDefaults",
        "global_metric_defaults": "globalMetricDefaults",
        "local_alarm_name_prefix": "localAlarmNamePrefix",
    },
)
class AlarmFactoryProps:
    def __init__(
        self,
        *,
        global_alarm_defaults: AlarmFactoryDefaults,
        global_metric_defaults: "MetricFactoryDefaults",
        local_alarm_name_prefix: builtins.str,
    ) -> None:
        '''
        :param global_alarm_defaults: 
        :param global_metric_defaults: 
        :param local_alarm_name_prefix: 

        :stability: experimental
        '''
        if isinstance(global_alarm_defaults, dict):
            global_alarm_defaults = AlarmFactoryDefaults(**global_alarm_defaults)
        if isinstance(global_metric_defaults, dict):
            global_metric_defaults = MetricFactoryDefaults(**global_metric_defaults)
        self._values: typing.Dict[str, typing.Any] = {
            "global_alarm_defaults": global_alarm_defaults,
            "global_metric_defaults": global_metric_defaults,
            "local_alarm_name_prefix": local_alarm_name_prefix,
        }

    @builtins.property
    def global_alarm_defaults(self) -> AlarmFactoryDefaults:
        '''
        :stability: experimental
        '''
        result = self._values.get("global_alarm_defaults")
        assert result is not None, "Required property 'global_alarm_defaults' is missing"
        return typing.cast(AlarmFactoryDefaults, result)

    @builtins.property
    def global_metric_defaults(self) -> "MetricFactoryDefaults":
        '''
        :stability: experimental
        '''
        result = self._values.get("global_metric_defaults")
        assert result is not None, "Required property 'global_metric_defaults' is missing"
        return typing.cast("MetricFactoryDefaults", result)

    @builtins.property
    def local_alarm_name_prefix(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("local_alarm_name_prefix")
        assert result is not None, "Required property 'local_alarm_name_prefix' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AlarmMatrixWidget(
    aws_cdk.aws_cloudwatch.AlarmStatusWidget,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AlarmMatrixWidget",
):
    '''(experimental) Wrapper of Alarm Status Widget which auto-calcultes height based on the number of alarms.

    Always takes the maximum width.

    :stability: experimental
    '''

    def __init__(
        self,
        *,
        alarms: typing.Sequence[aws_cdk.aws_cloudwatch.IAlarm],
        height: typing.Optional[jsii.Number] = None,
        title: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarms: (experimental) list of alarms to show.
        :param height: (experimental) desired height. Default: auto calculated based on alarm number (3 to 8)
        :param title: (experimental) widget title. Default: no title

        :stability: experimental
        '''
        props = AlarmMatrixWidgetProps(alarms=alarms, height=height, title=title)

        jsii.create(self.__class__, self, [props])


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmMatrixWidgetProps",
    jsii_struct_bases=[],
    name_mapping={"alarms": "alarms", "height": "height", "title": "title"},
)
class AlarmMatrixWidgetProps:
    def __init__(
        self,
        *,
        alarms: typing.Sequence[aws_cdk.aws_cloudwatch.IAlarm],
        height: typing.Optional[jsii.Number] = None,
        title: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarms: (experimental) list of alarms to show.
        :param height: (experimental) desired height. Default: auto calculated based on alarm number (3 to 8)
        :param title: (experimental) widget title. Default: no title

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alarms": alarms,
        }
        if height is not None:
            self._values["height"] = height
        if title is not None:
            self._values["title"] = title

    @builtins.property
    def alarms(self) -> typing.List[aws_cdk.aws_cloudwatch.IAlarm]:
        '''(experimental) list of alarms to show.

        :stability: experimental
        '''
        result = self._values.get("alarms")
        assert result is not None, "Required property 'alarms' is missing"
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IAlarm], result)

    @builtins.property
    def height(self) -> typing.Optional[jsii.Number]:
        '''(experimental) desired height.

        :default: auto calculated based on alarm number (3 to 8)

        :stability: experimental
        '''
        result = self._values.get("height")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''(experimental) widget title.

        :default: no title

        :stability: experimental
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmMatrixWidgetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmMetadata",
    jsii_struct_bases=[],
    name_mapping={
        "action": "action",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "dedupe_string": "dedupeString",
        "disambiguator": "disambiguator",
    },
)
class AlarmMetadata:
    def __init__(
        self,
        *,
        action: "IAlarmActionStrategy",
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Metadata of an alarm.

        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "action": action,
        }
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if dedupe_string is not None:
            self._values["dedupe_string"] = dedupe_string
        if disambiguator is not None:
            self._values["disambiguator"] = disambiguator

    @builtins.property
    def action(self) -> "IAlarmActionStrategy":
        '''
        :stability: experimental
        '''
        result = self._values.get("action")
        assert result is not None, "Required property 'action' is missing"
        return typing.cast("IAlarmActionStrategy", result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def dedupe_string(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("dedupe_string")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def disambiguator(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("disambiguator")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmMetadata(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmNamingInput",
    jsii_struct_bases=[],
    name_mapping={
        "alarm_name_suffix": "alarmNameSuffix",
        "alarm_dedupe_string_suffix": "alarmDedupeStringSuffix",
        "alarm_name_override": "alarmNameOverride",
        "dedupe_string_override": "dedupeStringOverride",
        "disambiguator": "disambiguator",
    },
)
class AlarmNamingInput:
    def __init__(
        self,
        *,
        alarm_name_suffix: builtins.str,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarm_name_suffix: 
        :param alarm_dedupe_string_suffix: 
        :param alarm_name_override: 
        :param dedupe_string_override: 
        :param disambiguator: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alarm_name_suffix": alarm_name_suffix,
        }
        if alarm_dedupe_string_suffix is not None:
            self._values["alarm_dedupe_string_suffix"] = alarm_dedupe_string_suffix
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if disambiguator is not None:
            self._values["disambiguator"] = disambiguator

    @builtins.property
    def alarm_name_suffix(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_name_suffix")
        assert result is not None, "Required property 'alarm_name_suffix' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alarm_dedupe_string_suffix(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_dedupe_string_suffix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def disambiguator(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("disambiguator")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmNamingInput(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AlarmNamingStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AlarmNamingStrategy",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        global_prefix: builtins.str,
        local_prefix: builtins.str,
        dedupe_string_strategy: typing.Optional["IAlarmDedupeStringProcessor"] = None,
    ) -> None:
        '''
        :param global_prefix: -
        :param local_prefix: -
        :param dedupe_string_strategy: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [global_prefix, local_prefix, dedupe_string_strategy])

    @jsii.member(jsii_name="getDedupeString")
    def get_dedupe_string(
        self,
        *,
        alarm_name_suffix: builtins.str,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> typing.Optional[builtins.str]:
        '''(experimental) Dedupe string resolved like this: - If "dedupeStringOverride" is defined for an alarm, it will be used as a dedupe string.

        - If "alarmDedupeStringSuffix" from the alarm factory is defined, "GlobalPrefix-LocalPrefix-AlarmDedupeStringSuffix" will be used as a dedupe string.
        - Otherwise, the alarm dedupe string will not be set.
          If a dedupe string strategy is set, it will be used to process the final string.

        :param alarm_name_suffix: 
        :param alarm_dedupe_string_suffix: 
        :param alarm_name_override: 
        :param dedupe_string_override: 
        :param disambiguator: 

        :stability: experimental
        '''
        props = AlarmNamingInput(
            alarm_name_suffix=alarm_name_suffix,
            alarm_dedupe_string_suffix=alarm_dedupe_string_suffix,
            alarm_name_override=alarm_name_override,
            dedupe_string_override=dedupe_string_override,
            disambiguator=disambiguator,
        )

        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getDedupeString", [props]))

    @jsii.member(jsii_name="getName")
    def get_name(
        self,
        *,
        alarm_name_suffix: builtins.str,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        '''(experimental) Alarm name is resolved like this: - If "alarmNameOverride" is defined for an alarm, it will be used as alarm name.

        - Otherwise, the alarm name will be generated by joining: global prefix, local prefix, alarm name suffix, disambiguator.

        :param alarm_name_suffix: 
        :param alarm_dedupe_string_suffix: 
        :param alarm_name_override: 
        :param dedupe_string_override: 
        :param disambiguator: 

        :stability: experimental
        '''
        props = AlarmNamingInput(
            alarm_name_suffix=alarm_name_suffix,
            alarm_dedupe_string_suffix=alarm_dedupe_string_suffix,
            alarm_name_override=alarm_name_override,
            dedupe_string_override=dedupe_string_override,
            disambiguator=disambiguator,
        )

        return typing.cast(builtins.str, jsii.invoke(self, "getName", [props]))

    @jsii.member(jsii_name="getWidgetLabel")
    def get_widget_label(
        self,
        *,
        alarm_name_suffix: builtins.str,
        alarm_dedupe_string_suffix: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        '''
        :param alarm_name_suffix: 
        :param alarm_dedupe_string_suffix: 
        :param alarm_name_override: 
        :param dedupe_string_override: 
        :param disambiguator: 

        :stability: experimental
        '''
        props = AlarmNamingInput(
            alarm_name_suffix=alarm_name_suffix,
            alarm_dedupe_string_suffix=alarm_dedupe_string_suffix,
            alarm_name_override=alarm_name_override,
            dedupe_string_override=dedupe_string_override,
            disambiguator=disambiguator,
        )

        return typing.cast(builtins.str, jsii.invoke(self, "getWidgetLabel", [props]))

    @jsii.member(jsii_name="joinDistinct")
    def _join_distinct(
        self,
        parts: typing.Sequence[builtins.str],
        separator: builtins.str,
    ) -> builtins.str:
        '''
        :param parts: -
        :param separator: -

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "joinDistinct", [parts, separator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dedupeStringStrategy")
    def _dedupe_string_strategy(self) -> "IAlarmDedupeStringProcessor":
        '''
        :stability: experimental
        '''
        return typing.cast("IAlarmDedupeStringProcessor", jsii.get(self, "dedupeStringStrategy"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="globalPrefix")
    def _global_prefix(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "globalPrefix"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="localPrefix")
    def _local_prefix(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "localPrefix"))


class AlarmSummaryMatrixWidget(
    aws_cdk.aws_cloudwatch.ConcreteWidget,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AlarmSummaryMatrixWidget",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        *,
        alarm_arns: typing.Sequence[builtins.str],
        height: typing.Optional[jsii.Number] = None,
        region: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        width: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param alarm_arns: 
        :param height: Height of the widget. Default: - 6 for Alarm and Graph widgets. 3 for single value widgets where most recent value of a metric is displayed.
        :param region: The region the metrics of this graph should be taken from. Default: - Current region
        :param title: Title for the graph. Default: - None
        :param width: Width of the widget, in a grid of 24 units wide. Default: 6

        :stability: experimental
        '''
        props = AlarmSummaryMatrixWidgetProps(
            alarm_arns=alarm_arns,
            height=height,
            region=region,
            title=title,
            width=width,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.List[typing.Any]:
        '''(experimental) Return the widget JSON for use in the dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[typing.Any], jsii.invoke(self, "toJson", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="props")
    def _props(self) -> "AlarmSummaryMatrixWidgetProps":
        '''
        :stability: experimental
        '''
        return typing.cast("AlarmSummaryMatrixWidgetProps", jsii.get(self, "props"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetPropertiesJson",
    jsii_struct_bases=[],
    name_mapping={"alarms": "alarms", "title": "title"},
)
class AlarmSummaryMatrixWidgetPropertiesJson:
    def __init__(
        self,
        *,
        alarms: typing.Sequence[builtins.str],
        title: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarms: 
        :param title: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alarms": alarms,
        }
        if title is not None:
            self._values["title"] = title

    @builtins.property
    def alarms(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarms")
        assert result is not None, "Required property 'alarms' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmSummaryMatrixWidgetPropertiesJson(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmSummaryMatrixWidgetProps",
    jsii_struct_bases=[aws_cdk.aws_cloudwatch.MetricWidgetProps],
    name_mapping={
        "height": "height",
        "region": "region",
        "title": "title",
        "width": "width",
        "alarm_arns": "alarmArns",
    },
)
class AlarmSummaryMatrixWidgetProps(aws_cdk.aws_cloudwatch.MetricWidgetProps):
    def __init__(
        self,
        *,
        height: typing.Optional[jsii.Number] = None,
        region: typing.Optional[builtins.str] = None,
        title: typing.Optional[builtins.str] = None,
        width: typing.Optional[jsii.Number] = None,
        alarm_arns: typing.Sequence[builtins.str],
    ) -> None:
        '''
        :param height: Height of the widget. Default: - 6 for Alarm and Graph widgets. 3 for single value widgets where most recent value of a metric is displayed.
        :param region: The region the metrics of this graph should be taken from. Default: - Current region
        :param title: Title for the graph. Default: - None
        :param width: Width of the widget, in a grid of 24 units wide. Default: 6
        :param alarm_arns: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alarm_arns": alarm_arns,
        }
        if height is not None:
            self._values["height"] = height
        if region is not None:
            self._values["region"] = region
        if title is not None:
            self._values["title"] = title
        if width is not None:
            self._values["width"] = width

    @builtins.property
    def height(self) -> typing.Optional[jsii.Number]:
        '''Height of the widget.

        :default:

        - 6 for Alarm and Graph widgets.
        3 for single value widgets where most recent value of a metric is displayed.
        '''
        result = self._values.get("height")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''The region the metrics of this graph should be taken from.

        :default: - Current region
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''Title for the graph.

        :default: - None
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def width(self) -> typing.Optional[jsii.Number]:
        '''Width of the widget, in a grid of 24 units wide.

        :default: 6
        '''
        result = self._values.get("width")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def alarm_arns(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_arns")
        assert result is not None, "Required property 'alarm_arns' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmSummaryMatrixWidgetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AlarmWithAnnotation",
    jsii_struct_bases=[AlarmMetadata],
    name_mapping={
        "action": "action",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "dedupe_string": "dedupeString",
        "disambiguator": "disambiguator",
        "alarm": "alarm",
        "alarm_description": "alarmDescription",
        "alarm_label": "alarmLabel",
        "alarm_name": "alarmName",
        "alarm_name_suffix": "alarmNameSuffix",
        "alarm_rule_when_alarming": "alarmRuleWhenAlarming",
        "alarm_rule_when_insufficient_data": "alarmRuleWhenInsufficientData",
        "alarm_rule_when_ok": "alarmRuleWhenOk",
        "annotation": "annotation",
    },
)
class AlarmWithAnnotation(AlarmMetadata):
    def __init__(
        self,
        *,
        action: "IAlarmActionStrategy",
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
        alarm: aws_cdk.aws_cloudwatch.Alarm,
        alarm_description: builtins.str,
        alarm_label: builtins.str,
        alarm_name: builtins.str,
        alarm_name_suffix: builtins.str,
        alarm_rule_when_alarming: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_insufficient_data: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_ok: aws_cdk.aws_cloudwatch.IAlarmRule,
        annotation: aws_cdk.aws_cloudwatch.HorizontalAnnotation,
    ) -> None:
        '''(experimental) Representation of an alarm with additional information.

        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 
        :param alarm: 
        :param alarm_description: 
        :param alarm_label: 
        :param alarm_name: 
        :param alarm_name_suffix: 
        :param alarm_rule_when_alarming: 
        :param alarm_rule_when_insufficient_data: 
        :param alarm_rule_when_ok: 
        :param annotation: 

        :stability: experimental
        '''
        if isinstance(annotation, dict):
            annotation = aws_cdk.aws_cloudwatch.HorizontalAnnotation(**annotation)
        self._values: typing.Dict[str, typing.Any] = {
            "action": action,
            "alarm": alarm,
            "alarm_description": alarm_description,
            "alarm_label": alarm_label,
            "alarm_name": alarm_name,
            "alarm_name_suffix": alarm_name_suffix,
            "alarm_rule_when_alarming": alarm_rule_when_alarming,
            "alarm_rule_when_insufficient_data": alarm_rule_when_insufficient_data,
            "alarm_rule_when_ok": alarm_rule_when_ok,
            "annotation": annotation,
        }
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if dedupe_string is not None:
            self._values["dedupe_string"] = dedupe_string
        if disambiguator is not None:
            self._values["disambiguator"] = disambiguator

    @builtins.property
    def action(self) -> "IAlarmActionStrategy":
        '''
        :stability: experimental
        '''
        result = self._values.get("action")
        assert result is not None, "Required property 'action' is missing"
        return typing.cast("IAlarmActionStrategy", result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def dedupe_string(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("dedupe_string")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def disambiguator(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("disambiguator")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm(self) -> aws_cdk.aws_cloudwatch.Alarm:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm")
        assert result is not None, "Required property 'alarm' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.Alarm, result)

    @builtins.property
    def alarm_description(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_description")
        assert result is not None, "Required property 'alarm_description' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alarm_label(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_label")
        assert result is not None, "Required property 'alarm_label' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alarm_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_name")
        assert result is not None, "Required property 'alarm_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alarm_name_suffix(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_name_suffix")
        assert result is not None, "Required property 'alarm_name_suffix' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def alarm_rule_when_alarming(self) -> aws_cdk.aws_cloudwatch.IAlarmRule:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_rule_when_alarming")
        assert result is not None, "Required property 'alarm_rule_when_alarming' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.IAlarmRule, result)

    @builtins.property
    def alarm_rule_when_insufficient_data(self) -> aws_cdk.aws_cloudwatch.IAlarmRule:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_rule_when_insufficient_data")
        assert result is not None, "Required property 'alarm_rule_when_insufficient_data' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.IAlarmRule, result)

    @builtins.property
    def alarm_rule_when_ok(self) -> aws_cdk.aws_cloudwatch.IAlarmRule:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_rule_when_ok")
        assert result is not None, "Required property 'alarm_rule_when_ok' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.IAlarmRule, result)

    @builtins.property
    def annotation(self) -> aws_cdk.aws_cloudwatch.HorizontalAnnotation:
        '''
        :stability: experimental
        '''
        result = self._values.get("annotation")
        assert result is not None, "Required property 'annotation' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.HorizontalAnnotation, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlarmWithAnnotation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AnomalyDetectingAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AnomalyDetectingAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addAlarmWhenOutOfBand")
    def add_alarm_when_out_of_band(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        alarm_name_suffix: builtins.str,
        disambiguator: builtins.str,
        *,
        alarm_when_above_the_band: builtins.bool,
        alarm_when_below_the_band: builtins.bool,
        standard_deviation_for_alarm: jsii.Number,
        additional_description: typing.Optional[builtins.str] = None,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param alarm_name_suffix: -
        :param disambiguator: -
        :param alarm_when_above_the_band: 
        :param alarm_when_below_the_band: 
        :param standard_deviation_for_alarm: 
        :param additional_description: 
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default

        :stability: experimental
        '''
        props = AnomalyDetectionThreshold(
            alarm_when_above_the_band=alarm_when_above_the_band,
            alarm_when_below_the_band=alarm_when_below_the_band,
            standard_deviation_for_alarm=standard_deviation_for_alarm,
            additional_description=additional_description,
            action_override=action_override,
            actions_enabled=actions_enabled,
            alarm_description_override=alarm_description_override,
            alarm_name_override=alarm_name_override,
            comparison_operator_override=comparison_operator_override,
            custom_params=custom_params,
            custom_tags=custom_tags,
            datapoints_to_alarm=datapoints_to_alarm,
            dedupe_string_override=dedupe_string_override,
            documentation_link=documentation_link,
            evaluate_low_sample_count_percentile=evaluate_low_sample_count_percentile,
            evaluation_periods=evaluation_periods,
            fill_alarm_range=fill_alarm_range,
            period=period,
            runbook_link=runbook_link,
            treat_missing_data_override=treat_missing_data_override,
        )

        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addAlarmWhenOutOfBand", [metric, alarm_name_suffix, disambiguator, props]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


class AnomalyDetectionMathExpression(
    aws_cdk.aws_cloudwatch.MathExpression,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AnomalyDetectionMathExpression",
):
    '''(experimental) Captures specific MathExpression for anomaly detection, for which alarm generation is different.

    Added to overcome certain CDK limitations at the time of writing.

    :see: https://github.com/aws/aws-cdk/issues/10540
    :stability: experimental
    '''

    def __init__(
        self,
        *,
        expression: builtins.str,
        using_metrics: typing.Optional[typing.Mapping[builtins.str, aws_cdk.aws_cloudwatch.IMetric]] = None,
        color: typing.Optional[builtins.str] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        search_account: typing.Optional[builtins.str] = None,
        search_region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param expression: The expression defining the metric. When an expression contains a SEARCH function, it cannot be used within an Alarm.
        :param using_metrics: The metrics used in the expression, in a map. The key is the identifier that represents the given metric in the expression, and the value is the actual Metric object. Default: - Empty map.
        :param color: Color for this metric when added to a Graph in a Dashboard. Default: - Automatic color
        :param label: Label for this metric when added to a Graph in a Dashboard. Default: - Expression value is used as label
        :param period: The period over which the expression's statistics are applied. This period overrides all periods in the metrics used in this math expression. Default: Duration.minutes(5)
        :param search_account: Account to evaluate search expressions within. Specifying a searchAccount has no effect to the account used for metrics within the expression (passed via usingMetrics). Default: - Deployment account.
        :param search_region: Region to evaluate search expressions within. Specifying a searchRegion has no effect to the region used for metrics within the expression (passed via usingMetrics). Default: - Deployment region.

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.MathExpressionProps(
            expression=expression,
            using_metrics=using_metrics,
            color=color,
            label=label,
            period=period,
            search_account=search_account,
            search_region=search_region,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="createAlarm")
    def create_alarm(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        evaluation_periods: jsii.Number,
        threshold: jsii.Number,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description: typing.Optional[builtins.str] = None,
        alarm_name: typing.Optional[builtins.str] = None,
        comparison_operator: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.str] = None,
        treat_missing_data: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
    ) -> aws_cdk.aws_cloudwatch.Alarm:
        '''(experimental) Make a new Alarm for this metric.

        Combines both properties that may adjust the metric (aggregation) as well
        as alarm properties.

        :param scope: -
        :param id: -
        :param evaluation_periods: The number of periods over which data is compared to the specified threshold.
        :param threshold: The value against which the specified statistic is compared.
        :param actions_enabled: Whether the actions for this alarm are enabled. Default: true
        :param alarm_description: Description for the alarm. Default: No description
        :param alarm_name: Name of the alarm. Default: Automatically generated name
        :param comparison_operator: Comparison to use to check if metric is breaching. Default: GreaterThanOrEqualToThreshold
        :param datapoints_to_alarm: The number of datapoints that must be breaching to trigger the alarm. This is used only if you are setting an "M out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon CloudWatch User Guide. Default: ``evaluationPeriods``
        :param evaluate_low_sample_count_percentile: Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant. Used only for alarms that are based on percentiles. Default: - Not configured.
        :param treat_missing_data: Sets how this alarm is to handle missing data points. Default: TreatMissingData.Missing

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.CreateAlarmOptions(
            evaluation_periods=evaluation_periods,
            threshold=threshold,
            actions_enabled=actions_enabled,
            alarm_description=alarm_description,
            alarm_name=alarm_name,
            comparison_operator=comparison_operator,
            datapoints_to_alarm=datapoints_to_alarm,
            evaluate_low_sample_count_percentile=evaluate_low_sample_count_percentile,
            treat_missing_data=treat_missing_data,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.Alarm, jsii.invoke(self, "createAlarm", [scope, id, props]))

    @jsii.member(jsii_name="with")
    def with_(
        self,
        *,
        color: typing.Optional[builtins.str] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        search_account: typing.Optional[builtins.str] = None,
        search_region: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.MathExpression:
        '''(experimental) Return a copy of Metric with properties changed.

        All properties except namespace and metricName can be changed.

        :param color: Color for this metric when added to a Graph in a Dashboard. Default: - Automatic color
        :param label: Label for this metric when added to a Graph in a Dashboard. Default: - Expression value is used as label
        :param period: The period over which the expression's statistics are applied. This period overrides all periods in the metrics used in this math expression. Default: Duration.minutes(5)
        :param search_account: Account to evaluate search expressions within. Specifying a searchAccount has no effect to the account used for metrics within the expression (passed via usingMetrics). Default: - Deployment account.
        :param search_region: Region to evaluate search expressions within. Specifying a searchRegion has no effect to the region used for metrics within the expression (passed via usingMetrics). Default: - Deployment region.

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.MathExpressionOptions(
            color=color,
            label=label,
            period=period,
            search_account=search_account,
            search_region=search_region,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.MathExpression, jsii.invoke(self, "with", [props]))


class ApiGatewayMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.ApiGatewayMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        api: aws_cdk.aws_apigateway.RestApiBase,
        api_method: typing.Optional[builtins.str] = None,
        api_resource: typing.Optional[builtins.str] = None,
        api_stage: typing.Optional[builtins.str] = None,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param api: (experimental) API to monitor (cannot use IRestApi, since it does not provide API name).
        :param api_method: (experimental) On undefined value is not set in dimensions.
        :param api_resource: (experimental) On undefined value is not set in dimensions.
        :param api_stage: Default: prod
        :param fill_tps_with_zeroes: Default: true
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        props = ApiGatewayMetricFactoryProps(
            api=api,
            api_method=api_method,
            api_resource=api_resource,
            api_stage=api_stage,
            fill_tps_with_zeroes=fill_tps_with_zeroes,
            rate_computation_method=rate_computation_method,
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metric4XXErrorCount")
    def metric4_xx_error_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric4XXErrorCount", []))

    @jsii.member(jsii_name="metric4XXErrorRate")
    def metric4_xx_error_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric4XXErrorRate", []))

    @jsii.member(jsii_name="metric5XXFaultCount")
    def metric5_xx_fault_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric5XXFaultCount", []))

    @jsii.member(jsii_name="metric5XXFaultRate")
    def metric5_xx_fault_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric5XXFaultRate", []))

    @jsii.member(jsii_name="metricInvocationCount")
    def metric_invocation_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricInvocationCount", []))

    @jsii.member(jsii_name="metricInvocationRate")
    def metric_invocation_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricInvocationRate", []))

    @jsii.member(jsii_name="metricLatencyInMillis")
    def metric_latency_in_millis(
        self,
        latency_type: "LatencyType",
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :param latency_type: -

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyInMillis", [latency_type]))

    @jsii.member(jsii_name="metricLatencyP50InMillis")
    def metric_latency_p50_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP50InMillis", []))

    @jsii.member(jsii_name="metricLatencyP90InMillis")
    def metric_latency_p90_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP90InMillis", []))

    @jsii.member(jsii_name="metricLatencyP99InMillis")
    def metric_latency_p99_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP99InMillis", []))

    @jsii.member(jsii_name="metricTps")
    def metric_tps(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricInvocationRate

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTps", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fillTpsWithZeroes")
    def _fill_tps_with_zeroes(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "fillTpsWithZeroes"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rateComputationMethod")
    def _rate_computation_method(self) -> "RateComputationMethod":
        '''
        :stability: experimental
        '''
        return typing.cast("RateComputationMethod", jsii.get(self, "rateComputationMethod"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.ApiGatewayMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "api": "api",
        "api_method": "apiMethod",
        "api_resource": "apiResource",
        "api_stage": "apiStage",
        "fill_tps_with_zeroes": "fillTpsWithZeroes",
        "rate_computation_method": "rateComputationMethod",
    },
)
class ApiGatewayMetricFactoryProps:
    def __init__(
        self,
        *,
        api: aws_cdk.aws_apigateway.RestApiBase,
        api_method: typing.Optional[builtins.str] = None,
        api_resource: typing.Optional[builtins.str] = None,
        api_stage: typing.Optional[builtins.str] = None,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param api: (experimental) API to monitor (cannot use IRestApi, since it does not provide API name).
        :param api_method: (experimental) On undefined value is not set in dimensions.
        :param api_resource: (experimental) On undefined value is not set in dimensions.
        :param api_stage: Default: prod
        :param fill_tps_with_zeroes: Default: true
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "api": api,
        }
        if api_method is not None:
            self._values["api_method"] = api_method
        if api_resource is not None:
            self._values["api_resource"] = api_resource
        if api_stage is not None:
            self._values["api_stage"] = api_stage
        if fill_tps_with_zeroes is not None:
            self._values["fill_tps_with_zeroes"] = fill_tps_with_zeroes
        if rate_computation_method is not None:
            self._values["rate_computation_method"] = rate_computation_method

    @builtins.property
    def api(self) -> aws_cdk.aws_apigateway.RestApiBase:
        '''(experimental) API to monitor (cannot use IRestApi, since it does not provide API name).

        :stability: experimental
        '''
        result = self._values.get("api")
        assert result is not None, "Required property 'api' is missing"
        return typing.cast(aws_cdk.aws_apigateway.RestApiBase, result)

    @builtins.property
    def api_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) On undefined value is not set in dimensions.

        :stability: experimental
        '''
        result = self._values.get("api_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def api_resource(self) -> typing.Optional[builtins.str]:
        '''(experimental) On undefined value is not set in dimensions.

        :stability: experimental
        '''
        result = self._values.get("api_resource")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def api_stage(self) -> typing.Optional[builtins.str]:
        '''
        :default: prod

        :stability: experimental
        '''
        result = self._values.get("api_stage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def fill_tps_with_zeroes(self) -> typing.Optional[builtins.bool]:
        '''
        :default: true

        :stability: experimental
        '''
        result = self._values.get("fill_tps_with_zeroes")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def rate_computation_method(self) -> typing.Optional["RateComputationMethod"]:
        '''
        :default: average

        :stability: experimental
        '''
        result = self._values.get("rate_computation_method")
        return typing.cast(typing.Optional["RateComputationMethod"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayV2HttpApiMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        api: aws_cdk.aws_apigatewayv2_alpha.IHttpApi,
        api_method: typing.Optional[builtins.str] = None,
        api_resource: typing.Optional[builtins.str] = None,
        api_stage: typing.Optional[builtins.str] = None,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param api: 
        :param api_method: (experimental) On undefined value is not set in dimensions.
        :param api_resource: (experimental) On undefined value is not set in dimensions.
        :param api_stage: Default: $default
        :param fill_tps_with_zeroes: Default: true
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        props = ApiGatewayV2HttpApiMetricFactoryProps(
            api=api,
            api_method=api_method,
            api_resource=api_resource,
            api_stage=api_stage,
            fill_tps_with_zeroes=fill_tps_with_zeroes,
            rate_computation_method=rate_computation_method,
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metric4xxCount")
    def metric4xx_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric4xxCount", []))

    @jsii.member(jsii_name="metric4xxRate")
    def metric4xx_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric4xxRate", []))

    @jsii.member(jsii_name="metric5xxCount")
    def metric5xx_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric5xxCount", []))

    @jsii.member(jsii_name="metric5xxRate")
    def metric5xx_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric5xxRate", []))

    @jsii.member(jsii_name="metricIntegrationLatencyInMillis")
    def metric_integration_latency_in_millis(
        self,
        latency_type: "LatencyType",
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :param latency_type: -

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIntegrationLatencyInMillis", [latency_type]))

    @jsii.member(jsii_name="metricIntegrationLatencyP50InMillis")
    def metric_integration_latency_p50_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricIntegrationLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIntegrationLatencyP50InMillis", []))

    @jsii.member(jsii_name="metricIntegrationLatencyP90InMillis")
    def metric_integration_latency_p90_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricIntegrationLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIntegrationLatencyP90InMillis", []))

    @jsii.member(jsii_name="metricIntegrationLatencyP99InMillis")
    def metric_integration_latency_p99_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricIntegrationLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIntegrationLatencyP99InMillis", []))

    @jsii.member(jsii_name="metricInvocationCount")
    def metric_invocation_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricInvocationCount", []))

    @jsii.member(jsii_name="metricInvocationRate")
    def metric_invocation_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricInvocationRate", []))

    @jsii.member(jsii_name="metricLatencyInMillis")
    def metric_latency_in_millis(
        self,
        latency_type: "LatencyType",
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :param latency_type: -

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyInMillis", [latency_type]))

    @jsii.member(jsii_name="metricLatencyP50InMillis")
    def metric_latency_p50_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP50InMillis", []))

    @jsii.member(jsii_name="metricLatencyP90InMillis")
    def metric_latency_p90_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP90InMillis", []))

    @jsii.member(jsii_name="metricLatencyP99InMillis")
    def metric_latency_p99_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricLatencyInMillis instead

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP99InMillis", []))

    @jsii.member(jsii_name="metricTps")
    def metric_tps(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricInvocationRate

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTps", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fillTpsWithZeroes")
    def _fill_tps_with_zeroes(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "fillTpsWithZeroes"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rateComputationMethod")
    def _rate_computation_method(self) -> "RateComputationMethod":
        '''
        :stability: experimental
        '''
        return typing.cast("RateComputationMethod", jsii.get(self, "rateComputationMethod"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "api": "api",
        "api_method": "apiMethod",
        "api_resource": "apiResource",
        "api_stage": "apiStage",
        "fill_tps_with_zeroes": "fillTpsWithZeroes",
        "rate_computation_method": "rateComputationMethod",
    },
)
class ApiGatewayV2HttpApiMetricFactoryProps:
    def __init__(
        self,
        *,
        api: aws_cdk.aws_apigatewayv2_alpha.IHttpApi,
        api_method: typing.Optional[builtins.str] = None,
        api_resource: typing.Optional[builtins.str] = None,
        api_stage: typing.Optional[builtins.str] = None,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param api: 
        :param api_method: (experimental) On undefined value is not set in dimensions.
        :param api_resource: (experimental) On undefined value is not set in dimensions.
        :param api_stage: Default: $default
        :param fill_tps_with_zeroes: Default: true
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "api": api,
        }
        if api_method is not None:
            self._values["api_method"] = api_method
        if api_resource is not None:
            self._values["api_resource"] = api_resource
        if api_stage is not None:
            self._values["api_stage"] = api_stage
        if fill_tps_with_zeroes is not None:
            self._values["fill_tps_with_zeroes"] = fill_tps_with_zeroes
        if rate_computation_method is not None:
            self._values["rate_computation_method"] = rate_computation_method

    @builtins.property
    def api(self) -> aws_cdk.aws_apigatewayv2_alpha.IHttpApi:
        '''
        :stability: experimental
        '''
        result = self._values.get("api")
        assert result is not None, "Required property 'api' is missing"
        return typing.cast(aws_cdk.aws_apigatewayv2_alpha.IHttpApi, result)

    @builtins.property
    def api_method(self) -> typing.Optional[builtins.str]:
        '''(experimental) On undefined value is not set in dimensions.

        :stability: experimental
        '''
        result = self._values.get("api_method")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def api_resource(self) -> typing.Optional[builtins.str]:
        '''(experimental) On undefined value is not set in dimensions.

        :stability: experimental
        '''
        result = self._values.get("api_resource")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def api_stage(self) -> typing.Optional[builtins.str]:
        '''
        :default: $default

        :stability: experimental
        '''
        result = self._values.get("api_stage")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def fill_tps_with_zeroes(self) -> typing.Optional[builtins.bool]:
        '''
        :default: true

        :stability: experimental
        '''
        result = self._values.get("fill_tps_with_zeroes")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def rate_computation_method(self) -> typing.Optional["RateComputationMethod"]:
        '''
        :default: average

        :stability: experimental
        '''
        result = self._values.get("rate_computation_method")
        return typing.cast(typing.Optional["RateComputationMethod"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayV2HttpApiMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppSyncMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AppSyncMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        api: aws_cdk.aws_appsync_alpha.GraphqlApi,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param api: (experimental) the GraphQL API to monitor.
        :param fill_tps_with_zeroes: (experimental) whether the TPS should be filled with zeroes. Default: true
        :param rate_computation_method: (experimental) method to compute TPS. Default: average

        :stability: experimental
        '''
        props = AppSyncMetricFactoryProps(
            api=api,
            fill_tps_with_zeroes=fill_tps_with_zeroes,
            rate_computation_method=rate_computation_method,
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metric4XXErrorCount")
    def metric4_xx_error_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric4XXErrorCount", []))

    @jsii.member(jsii_name="metric4XXErrorRate")
    def metric4_xx_error_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric4XXErrorRate", []))

    @jsii.member(jsii_name="metric5XXFaultCount")
    def metric5_xx_fault_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric5XXFaultCount", []))

    @jsii.member(jsii_name="metric5XXFaultRate")
    def metric5_xx_fault_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric5XXFaultRate", []))

    @jsii.member(jsii_name="metricLatencyP50InMillis")
    def metric_latency_p50_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP50InMillis", []))

    @jsii.member(jsii_name="metricLatencyP90InMillis")
    def metric_latency_p90_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP90InMillis", []))

    @jsii.member(jsii_name="metricLatencyP99InMillis")
    def metric_latency_p99_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP99InMillis", []))

    @jsii.member(jsii_name="metricRequestCount")
    def metric_request_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricRequestCount", []))

    @jsii.member(jsii_name="metricRequestRate")
    def metric_request_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricRequestRate", []))

    @jsii.member(jsii_name="metricTps")
    def metric_tps(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricRequestRate

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTps", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fillTpsWithZeroes")
    def _fill_tps_with_zeroes(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "fillTpsWithZeroes"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rateComputationMethod")
    def _rate_computation_method(self) -> "RateComputationMethod":
        '''
        :stability: experimental
        '''
        return typing.cast("RateComputationMethod", jsii.get(self, "rateComputationMethod"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AppSyncMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "api": "api",
        "fill_tps_with_zeroes": "fillTpsWithZeroes",
        "rate_computation_method": "rateComputationMethod",
    },
)
class AppSyncMetricFactoryProps:
    def __init__(
        self,
        *,
        api: aws_cdk.aws_appsync_alpha.GraphqlApi,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param api: (experimental) the GraphQL API to monitor.
        :param fill_tps_with_zeroes: (experimental) whether the TPS should be filled with zeroes. Default: true
        :param rate_computation_method: (experimental) method to compute TPS. Default: average

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "api": api,
        }
        if fill_tps_with_zeroes is not None:
            self._values["fill_tps_with_zeroes"] = fill_tps_with_zeroes
        if rate_computation_method is not None:
            self._values["rate_computation_method"] = rate_computation_method

    @builtins.property
    def api(self) -> aws_cdk.aws_appsync_alpha.GraphqlApi:
        '''(experimental) the GraphQL API to monitor.

        :stability: experimental
        '''
        result = self._values.get("api")
        assert result is not None, "Required property 'api' is missing"
        return typing.cast(aws_cdk.aws_appsync_alpha.GraphqlApi, result)

    @builtins.property
    def fill_tps_with_zeroes(self) -> typing.Optional[builtins.bool]:
        '''(experimental) whether the TPS should be filled with zeroes.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("fill_tps_with_zeroes")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def rate_computation_method(self) -> typing.Optional["RateComputationMethod"]:
        '''(experimental) method to compute TPS.

        :default: average

        :stability: experimental
        '''
        result = self._values.get("rate_computation_method")
        return typing.cast(typing.Optional["RateComputationMethod"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppSyncMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "application_load_balancer": "applicationLoadBalancer",
        "application_target_group": "applicationTargetGroup",
    },
)
class ApplicationLoadBalancerMetricFactoryProps:
    def __init__(
        self,
        *,
        application_load_balancer: aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer,
        application_target_group: aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup,
    ) -> None:
        '''(experimental) Props to create ApplicationLoadBalancerMetricFactory.

        :param application_load_balancer: 
        :param application_target_group: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "application_load_balancer": application_load_balancer,
            "application_target_group": application_target_group,
        }

    @builtins.property
    def application_load_balancer(
        self,
    ) -> aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer:
        '''
        :stability: experimental
        '''
        result = self._values.get("application_load_balancer")
        assert result is not None, "Required property 'application_load_balancer' is missing"
        return typing.cast(aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer, result)

    @builtins.property
    def application_target_group(
        self,
    ) -> aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup:
        '''
        :stability: experimental
        '''
        result = self._values.get("application_target_group")
        assert result is not None, "Required property 'application_target_group' is missing"
        return typing.cast(aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApplicationLoadBalancerMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AutoScalingGroupMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AutoScalingGroupMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        auto_scaling_group: aws_cdk.aws_autoscaling.IAutoScalingGroup,
    ) -> None:
        '''
        :param metric_factory: -
        :param auto_scaling_group: 

        :stability: experimental
        '''
        props = AutoScalingGroupMetricFactoryProps(
            auto_scaling_group=auto_scaling_group
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricGroupDesiredCapacity")
    def metric_group_desired_capacity(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The number of instances that the Auto Scaling group attempts to maintain.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupDesiredCapacity", []))

    @jsii.member(jsii_name="metricGroupInServiceInstances")
    def metric_group_in_service_instances(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The number of instances that are running as part of the Auto Scaling group.

        This metric does not include instances that are pending or terminating.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupInServiceInstances", []))

    @jsii.member(jsii_name="metricGroupMaxSize")
    def metric_group_max_size(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The maximum size of the Auto Scaling group.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupMaxSize", []))

    @jsii.member(jsii_name="metricGroupMinSize")
    def metric_group_min_size(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The minimum size of the Auto Scaling group.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupMinSize", []))

    @jsii.member(jsii_name="metricGroupPendingInstances")
    def metric_group_pending_instances(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The number of instances that are pending.

        A pending instance is not yet in service.
        This metric does not include instances that are in service or terminating.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupPendingInstances", []))

    @jsii.member(jsii_name="metricGroupStandbyInstances")
    def metric_group_standby_instances(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The number of instances that are in a Standby state.

        Instances in this state are still running but are not actively in service.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupStandbyInstances", []))

    @jsii.member(jsii_name="metricGroupTerminatingInstances")
    def metric_group_terminating_instances(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The number of instances that are in the process of terminating.

        This metric does not include instances that are in service or pending.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupTerminatingInstances", []))

    @jsii.member(jsii_name="metricGroupTotalInstances")
    def metric_group_total_instances(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) The total number of instances in the Auto Scaling group.

        This metric identifies the number of instances that are in service, pending, and terminating.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGroupTotalInstances", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AutoScalingGroupMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"auto_scaling_group": "autoScalingGroup"},
)
class AutoScalingGroupMetricFactoryProps:
    def __init__(
        self,
        *,
        auto_scaling_group: aws_cdk.aws_autoscaling.IAutoScalingGroup,
    ) -> None:
        '''
        :param auto_scaling_group: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "auto_scaling_group": auto_scaling_group,
        }

    @builtins.property
    def auto_scaling_group(self) -> aws_cdk.aws_autoscaling.IAutoScalingGroup:
        '''
        :stability: experimental
        '''
        result = self._values.get("auto_scaling_group")
        assert result is not None, "Required property 'auto_scaling_group' is missing"
        return typing.cast(aws_cdk.aws_autoscaling.IAutoScalingGroup, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoScalingGroupMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AwsConsoleUrlFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.AwsConsoleUrlFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        *,
        aws_account_id: builtins.str,
        aws_account_region: builtins.str,
    ) -> None:
        '''
        :param aws_account_id: 
        :param aws_account_region: 

        :stability: experimental
        '''
        props = AwsConsoleUrlFactoryProps(
            aws_account_id=aws_account_id, aws_account_region=aws_account_region
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="getApiGatewayUrl")
    def get_api_gateway_url(
        self,
        rest_api_id: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param rest_api_id: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getApiGatewayUrl", [rest_api_id]))

    @jsii.member(jsii_name="getAwsConsoleUrl")
    def get_aws_console_url(
        self,
        destination_url: typing.Optional[builtins.str] = None,
    ) -> typing.Optional[builtins.str]:
        '''
        :param destination_url: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getAwsConsoleUrl", [destination_url]))

    @jsii.member(jsii_name="getCloudFrontDistributionUrl")
    def get_cloud_front_distribution_url(
        self,
        distribution_id: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param distribution_id: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getCloudFrontDistributionUrl", [distribution_id]))

    @jsii.member(jsii_name="getCloudWatchLogGroupUrl")
    def get_cloud_watch_log_group_url(
        self,
        log_group_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param log_group_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getCloudWatchLogGroupUrl", [log_group_name]))

    @jsii.member(jsii_name="getCodeBuildProjectUrl")
    def get_code_build_project_url(
        self,
        project_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param project_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getCodeBuildProjectUrl", [project_name]))

    @jsii.member(jsii_name="getDynamoTableUrl")
    def get_dynamo_table_url(
        self,
        table_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param table_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getDynamoTableUrl", [table_name]))

    @jsii.member(jsii_name="getElastiCacheClusterUrl")
    def get_elasti_cache_cluster_url(
        self,
        cluster_id: builtins.str,
        cluster_type: "ElastiCacheClusterType",
    ) -> typing.Optional[builtins.str]:
        '''
        :param cluster_id: -
        :param cluster_type: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getElastiCacheClusterUrl", [cluster_id, cluster_type]))

    @jsii.member(jsii_name="getKinesisAnalyticsUrl")
    def get_kinesis_analytics_url(
        self,
        application: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param application: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getKinesisAnalyticsUrl", [application]))

    @jsii.member(jsii_name="getKinesisDataStreamUrl")
    def get_kinesis_data_stream_url(
        self,
        stream_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param stream_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getKinesisDataStreamUrl", [stream_name]))

    @jsii.member(jsii_name="getKinesisFirehoseDeliveryStreamUrl")
    def get_kinesis_firehose_delivery_stream_url(
        self,
        stream_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param stream_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getKinesisFirehoseDeliveryStreamUrl", [stream_name]))

    @jsii.member(jsii_name="getLambdaFunctionUrl")
    def get_lambda_function_url(
        self,
        function_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param function_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getLambdaFunctionUrl", [function_name]))

    @jsii.member(jsii_name="getOpenSearchClusterUrl")
    def get_open_search_cluster_url(
        self,
        domain_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param domain_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getOpenSearchClusterUrl", [domain_name]))

    @jsii.member(jsii_name="getRdsClusterUrl")
    def get_rds_cluster_url(
        self,
        cluster_id: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param cluster_id: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getRdsClusterUrl", [cluster_id]))

    @jsii.member(jsii_name="getRedshiftClusterUrl")
    def get_redshift_cluster_url(
        self,
        cluster_id: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param cluster_id: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getRedshiftClusterUrl", [cluster_id]))

    @jsii.member(jsii_name="getResolvedDestinationUrl")
    def _get_resolved_destination_url(
        self,
        context: aws_cdk.IResolveContext,
        destination_url: builtins.str,
    ) -> builtins.str:
        '''(experimental) Resolves a destination URL within a resolution context.

        :param context: The resolution context.
        :param destination_url: The destination URL to resolve since it may contain CDK tokens.

        :see: https://docs.aws.amazon.com/cdk/latest/guide/tokens.html
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "getResolvedDestinationUrl", [context, destination_url]))

    @jsii.member(jsii_name="getS3BucketUrl")
    def get_s3_bucket_url(
        self,
        bucket_name: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param bucket_name: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getS3BucketUrl", [bucket_name]))

    @jsii.member(jsii_name="getSnsTopicUrl")
    def get_sns_topic_url(
        self,
        topic_arn: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param topic_arn: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getSnsTopicUrl", [topic_arn]))

    @jsii.member(jsii_name="getSqsQueueUrl")
    def get_sqs_queue_url(
        self,
        queue_url: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param queue_url: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getSqsQueueUrl", [queue_url]))

    @jsii.member(jsii_name="getStateMachineUrl")
    def get_state_machine_url(
        self,
        state_machine_arn: builtins.str,
    ) -> typing.Optional[builtins.str]:
        '''
        :param state_machine_arn: -

        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.invoke(self, "getStateMachineUrl", [state_machine_arn]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="awsAccountId")
    def _aws_account_id(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "awsAccountId"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="awsAccountRegion")
    def _aws_account_region(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "awsAccountRegion"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.AwsConsoleUrlFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "aws_account_id": "awsAccountId",
        "aws_account_region": "awsAccountRegion",
    },
)
class AwsConsoleUrlFactoryProps:
    def __init__(
        self,
        *,
        aws_account_id: builtins.str,
        aws_account_region: builtins.str,
    ) -> None:
        '''
        :param aws_account_id: 
        :param aws_account_region: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "aws_account_id": aws_account_id,
            "aws_account_region": aws_account_region,
        }

    @builtins.property
    def aws_account_id(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("aws_account_id")
        assert result is not None, "Required property 'aws_account_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def aws_account_region(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("aws_account_region")
        assert result is not None, "Required property 'aws_account_region' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsConsoleUrlFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.AxisPosition")
class AxisPosition(enum.Enum):
    '''
    :stability: experimental
    '''

    LEFT = "LEFT"
    '''
    :stability: experimental
    '''
    RIGHT = "RIGHT"
    '''
    :stability: experimental
    '''


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.BaseDlqAlarms",
    jsii_struct_bases=[],
    name_mapping={
        "add_dead_letter_queue_max_incoming_messages_alarm": "addDeadLetterQueueMaxIncomingMessagesAlarm",
        "add_dead_letter_queue_max_message_age_alarm": "addDeadLetterQueueMaxMessageAgeAlarm",
        "add_dead_letter_queue_max_size_alarm": "addDeadLetterQueueMaxSizeAlarm",
    },
)
class BaseDlqAlarms:
    def __init__(
        self,
        *,
        add_dead_letter_queue_max_incoming_messages_alarm: typing.Optional[typing.Mapping[builtins.str, "MaxIncomingMessagesCountThreshold"]] = None,
        add_dead_letter_queue_max_message_age_alarm: typing.Optional[typing.Mapping[builtins.str, "MaxMessageAgeThreshold"]] = None,
        add_dead_letter_queue_max_size_alarm: typing.Optional[typing.Mapping[builtins.str, "MaxMessageCountThreshold"]] = None,
    ) -> None:
        '''
        :param add_dead_letter_queue_max_incoming_messages_alarm: (experimental) Alarm on the number of messages added to a queue. Note that this corresponds with the NumberOfMessagesSent metric, which does not capture messages sent to the DLQ as a result of a failed processing attempt.
        :param add_dead_letter_queue_max_message_age_alarm: 
        :param add_dead_letter_queue_max_size_alarm: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if add_dead_letter_queue_max_incoming_messages_alarm is not None:
            self._values["add_dead_letter_queue_max_incoming_messages_alarm"] = add_dead_letter_queue_max_incoming_messages_alarm
        if add_dead_letter_queue_max_message_age_alarm is not None:
            self._values["add_dead_letter_queue_max_message_age_alarm"] = add_dead_letter_queue_max_message_age_alarm
        if add_dead_letter_queue_max_size_alarm is not None:
            self._values["add_dead_letter_queue_max_size_alarm"] = add_dead_letter_queue_max_size_alarm

    @builtins.property
    def add_dead_letter_queue_max_incoming_messages_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MaxIncomingMessagesCountThreshold"]]:
        '''(experimental) Alarm on the number of messages added to a queue.

        Note that this corresponds with the NumberOfMessagesSent metric, which does not capture messages sent to the DLQ
        as a result of a failed processing attempt.

        :see: https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html#sqs-dlq-number-of-messages
        :stability: experimental
        '''
        result = self._values.get("add_dead_letter_queue_max_incoming_messages_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MaxIncomingMessagesCountThreshold"]], result)

    @builtins.property
    def add_dead_letter_queue_max_message_age_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MaxMessageAgeThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_dead_letter_queue_max_message_age_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MaxMessageAgeThreshold"]], result)

    @builtins.property
    def add_dead_letter_queue_max_size_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MaxMessageCountThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_dead_letter_queue_max_size_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MaxMessageCountThreshold"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BaseDlqAlarms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.BaseEc2ServiceAlarms",
    jsii_struct_bases=[],
    name_mapping={
        "add_cpu_usage_alarm": "addCpuUsageAlarm",
        "add_memory_usage_alarm": "addMemoryUsageAlarm",
        "add_running_task_count_alarm": "addRunningTaskCountAlarm",
        "max_auto_scaling_task_count": "maxAutoScalingTaskCount",
        "min_auto_scaling_task_count": "minAutoScalingTaskCount",
    },
)
class BaseEc2ServiceAlarms:
    def __init__(
        self,
        *,
        add_cpu_usage_alarm: typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]] = None,
        add_memory_usage_alarm: typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]] = None,
        add_running_task_count_alarm: typing.Optional[typing.Mapping[builtins.str, "RunningTaskCountThreshold"]] = None,
        max_auto_scaling_task_count: typing.Optional[jsii.Number] = None,
        min_auto_scaling_task_count: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param add_cpu_usage_alarm: 
        :param add_memory_usage_alarm: 
        :param add_running_task_count_alarm: (experimental) Container Insights needs to be enabled for the cluster for this alarm.
        :param max_auto_scaling_task_count: (experimental) maximum number of tasks, as specified in your auto scaling config.
        :param min_auto_scaling_task_count: (experimental) minimum number of tasks, as specified in your auto scaling config.

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if add_cpu_usage_alarm is not None:
            self._values["add_cpu_usage_alarm"] = add_cpu_usage_alarm
        if add_memory_usage_alarm is not None:
            self._values["add_memory_usage_alarm"] = add_memory_usage_alarm
        if add_running_task_count_alarm is not None:
            self._values["add_running_task_count_alarm"] = add_running_task_count_alarm
        if max_auto_scaling_task_count is not None:
            self._values["max_auto_scaling_task_count"] = max_auto_scaling_task_count
        if min_auto_scaling_task_count is not None:
            self._values["min_auto_scaling_task_count"] = min_auto_scaling_task_count

    @builtins.property
    def add_cpu_usage_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_cpu_usage_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]], result)

    @builtins.property
    def add_memory_usage_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_memory_usage_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]], result)

    @builtins.property
    def add_running_task_count_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "RunningTaskCountThreshold"]]:
        '''(experimental) Container Insights needs to be enabled for the cluster for this alarm.

        :stability: experimental
        '''
        result = self._values.get("add_running_task_count_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "RunningTaskCountThreshold"]], result)

    @builtins.property
    def max_auto_scaling_task_count(self) -> typing.Optional[jsii.Number]:
        '''(experimental) maximum number of tasks, as specified in your auto scaling config.

        :stability: experimental
        '''
        result = self._values.get("max_auto_scaling_task_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_auto_scaling_task_count(self) -> typing.Optional[jsii.Number]:
        '''(experimental) minimum number of tasks, as specified in your auto scaling config.

        :stability: experimental
        '''
        result = self._values.get("min_auto_scaling_task_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BaseEc2ServiceAlarms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.BaseFargateServiceAlarms",
    jsii_struct_bases=[],
    name_mapping={
        "add_cpu_usage_alarm": "addCpuUsageAlarm",
        "add_memory_usage_alarm": "addMemoryUsageAlarm",
        "add_running_task_count_alarm": "addRunningTaskCountAlarm",
        "max_auto_scaling_task_count": "maxAutoScalingTaskCount",
        "min_auto_scaling_task_count": "minAutoScalingTaskCount",
    },
)
class BaseFargateServiceAlarms:
    def __init__(
        self,
        *,
        add_cpu_usage_alarm: typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]] = None,
        add_memory_usage_alarm: typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]] = None,
        add_running_task_count_alarm: typing.Optional[typing.Mapping[builtins.str, "RunningTaskCountThreshold"]] = None,
        max_auto_scaling_task_count: typing.Optional[jsii.Number] = None,
        min_auto_scaling_task_count: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param add_cpu_usage_alarm: 
        :param add_memory_usage_alarm: 
        :param add_running_task_count_alarm: (experimental) Container Insights needs to be enabled for the cluster for this alarm.
        :param max_auto_scaling_task_count: (experimental) maximum number of tasks, as specified in your auto scaling config.
        :param min_auto_scaling_task_count: (experimental) minimum number of tasks, as specified in your auto scaling config.

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if add_cpu_usage_alarm is not None:
            self._values["add_cpu_usage_alarm"] = add_cpu_usage_alarm
        if add_memory_usage_alarm is not None:
            self._values["add_memory_usage_alarm"] = add_memory_usage_alarm
        if add_running_task_count_alarm is not None:
            self._values["add_running_task_count_alarm"] = add_running_task_count_alarm
        if max_auto_scaling_task_count is not None:
            self._values["max_auto_scaling_task_count"] = max_auto_scaling_task_count
        if min_auto_scaling_task_count is not None:
            self._values["min_auto_scaling_task_count"] = min_auto_scaling_task_count

    @builtins.property
    def add_cpu_usage_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_cpu_usage_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]], result)

    @builtins.property
    def add_memory_usage_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_memory_usage_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "UsageThreshold"]], result)

    @builtins.property
    def add_running_task_count_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "RunningTaskCountThreshold"]]:
        '''(experimental) Container Insights needs to be enabled for the cluster for this alarm.

        :stability: experimental
        '''
        result = self._values.get("add_running_task_count_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "RunningTaskCountThreshold"]], result)

    @builtins.property
    def max_auto_scaling_task_count(self) -> typing.Optional[jsii.Number]:
        '''(experimental) maximum number of tasks, as specified in your auto scaling config.

        :stability: experimental
        '''
        result = self._values.get("max_auto_scaling_task_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def min_auto_scaling_task_count(self) -> typing.Optional[jsii.Number]:
        '''(experimental) minimum number of tasks, as specified in your auto scaling config.

        :stability: experimental
        '''
        result = self._values.get("min_auto_scaling_task_count")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BaseFargateServiceAlarms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class BaseServiceMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.BaseServiceMetricFactory",
):
    '''(experimental) Metric factory for a base service (parent class for e.g. Fargate and EC2 services).

    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        service: aws_cdk.aws_ecs.BaseService,
    ) -> None:
        '''
        :param metric_factory: -
        :param service: 

        :stability: experimental
        '''
        props = BaseServiceMetricFactoryProps(service=service)

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricClusterCpuUtilisationInPercent")
    def metric_cluster_cpu_utilisation_in_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricClusterCpuUtilisationInPercent", []))

    @jsii.member(jsii_name="metricClusterMemoryUtilisationInPercent")
    def metric_cluster_memory_utilisation_in_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricClusterMemoryUtilisationInPercent", []))

    @jsii.member(jsii_name="metricRunningTaskCount")
    def metric_running_task_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricRunningTaskCount", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="service")
    def _service(self) -> aws_cdk.aws_ecs.BaseService:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_ecs.BaseService, jsii.get(self, "service"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.BaseServiceMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"service": "service"},
)
class BaseServiceMetricFactoryProps:
    def __init__(self, *, service: aws_cdk.aws_ecs.BaseService) -> None:
        '''(experimental) Props to create BaseServiceMetricFactory.

        :param service: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "service": service,
        }

    @builtins.property
    def service(self) -> aws_cdk.aws_ecs.BaseService:
        '''
        :stability: experimental
        '''
        result = self._values.get("service")
        assert result is not None, "Required property 'service' is missing"
        return typing.cast(aws_cdk.aws_ecs.BaseService, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BaseServiceMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.BaseSqsQueueAlarms",
    jsii_struct_bases=[],
    name_mapping={
        "add_queue_max_incoming_messages_alarm": "addQueueMaxIncomingMessagesAlarm",
        "add_queue_max_message_age_alarm": "addQueueMaxMessageAgeAlarm",
        "add_queue_max_size_alarm": "addQueueMaxSizeAlarm",
        "add_queue_max_time_to_drain_messages_alarm": "addQueueMaxTimeToDrainMessagesAlarm",
        "add_queue_min_incoming_messages_alarm": "addQueueMinIncomingMessagesAlarm",
        "add_queue_min_size_alarm": "addQueueMinSizeAlarm",
    },
)
class BaseSqsQueueAlarms:
    def __init__(
        self,
        *,
        add_queue_max_incoming_messages_alarm: typing.Optional[typing.Mapping[builtins.str, "MaxIncomingMessagesCountThreshold"]] = None,
        add_queue_max_message_age_alarm: typing.Optional[typing.Mapping[builtins.str, "MaxMessageAgeThreshold"]] = None,
        add_queue_max_size_alarm: typing.Optional[typing.Mapping[builtins.str, "MaxMessageCountThreshold"]] = None,
        add_queue_max_time_to_drain_messages_alarm: typing.Optional[typing.Mapping[builtins.str, "MaxTimeToDrainThreshold"]] = None,
        add_queue_min_incoming_messages_alarm: typing.Optional[typing.Mapping[builtins.str, "MinIncomingMessagesCountThreshold"]] = None,
        add_queue_min_size_alarm: typing.Optional[typing.Mapping[builtins.str, "MinMessageCountThreshold"]] = None,
    ) -> None:
        '''
        :param add_queue_max_incoming_messages_alarm: 
        :param add_queue_max_message_age_alarm: 
        :param add_queue_max_size_alarm: 
        :param add_queue_max_time_to_drain_messages_alarm: 
        :param add_queue_min_incoming_messages_alarm: 
        :param add_queue_min_size_alarm: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if add_queue_max_incoming_messages_alarm is not None:
            self._values["add_queue_max_incoming_messages_alarm"] = add_queue_max_incoming_messages_alarm
        if add_queue_max_message_age_alarm is not None:
            self._values["add_queue_max_message_age_alarm"] = add_queue_max_message_age_alarm
        if add_queue_max_size_alarm is not None:
            self._values["add_queue_max_size_alarm"] = add_queue_max_size_alarm
        if add_queue_max_time_to_drain_messages_alarm is not None:
            self._values["add_queue_max_time_to_drain_messages_alarm"] = add_queue_max_time_to_drain_messages_alarm
        if add_queue_min_incoming_messages_alarm is not None:
            self._values["add_queue_min_incoming_messages_alarm"] = add_queue_min_incoming_messages_alarm
        if add_queue_min_size_alarm is not None:
            self._values["add_queue_min_size_alarm"] = add_queue_min_size_alarm

    @builtins.property
    def add_queue_max_incoming_messages_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MaxIncomingMessagesCountThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_queue_max_incoming_messages_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MaxIncomingMessagesCountThreshold"]], result)

    @builtins.property
    def add_queue_max_message_age_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MaxMessageAgeThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_queue_max_message_age_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MaxMessageAgeThreshold"]], result)

    @builtins.property
    def add_queue_max_size_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MaxMessageCountThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_queue_max_size_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MaxMessageCountThreshold"]], result)

    @builtins.property
    def add_queue_max_time_to_drain_messages_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MaxTimeToDrainThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_queue_max_time_to_drain_messages_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MaxTimeToDrainThreshold"]], result)

    @builtins.property
    def add_queue_min_incoming_messages_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MinIncomingMessagesCountThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_queue_min_incoming_messages_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MinIncomingMessagesCountThreshold"]], result)

    @builtins.property
    def add_queue_min_size_alarm(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "MinMessageCountThreshold"]]:
        '''
        :stability: experimental
        '''
        result = self._values.get("add_queue_min_size_alarm")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "MinMessageCountThreshold"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "BaseSqsQueueAlarms(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class BillingMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.BillingMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="metricSearchTopCostByServiceInUsd")
    def metric_search_top_cost_by_service_in_usd(
        self,
    ) -> aws_cdk.aws_cloudwatch.IMetric:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.IMetric, jsii.invoke(self, "metricSearchTopCostByServiceInUsd", []))

    @jsii.member(jsii_name="metricTotalCostInUsd")
    def metric_total_cost_in_usd(self) -> aws_cdk.aws_cloudwatch.IMetric:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.IMetric, jsii.invoke(self, "metricTotalCostInUsd", []))


class BitmapDashboard(
    aws_cdk.aws_cloudwatch.Dashboard,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.BitmapDashboard",
):
    '''(experimental) Specific subtype of dashboard that renders supported widgets as bitmaps, while preserving the overall layout.

    :stability: experimental
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        dashboard_name: typing.Optional[builtins.str] = None,
        end: typing.Optional[builtins.str] = None,
        period_override: typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride] = None,
        start: typing.Optional[builtins.str] = None,
        widgets: typing.Optional[typing.Sequence[typing.Sequence[aws_cdk.aws_cloudwatch.IWidget]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param dashboard_name: Name of the dashboard. If set, must only contain alphanumerics, dash (-) and underscore (_) Default: - automatically generated name
        :param end: The end of the time range to use for each widget on the dashboard when the dashboard loads. If you specify a value for end, you must also specify a value for start. Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z. Default: When the dashboard loads, the end date will be the current time.
        :param period_override: Use this field to specify the period for the graphs when the dashboard loads. Specifying ``Auto`` causes the period of all graphs on the dashboard to automatically adapt to the time range of the dashboard. Specifying ``Inherit`` ensures that the period set for each graph is always obeyed. Default: Auto
        :param start: The start of the time range to use for each widget on the dashboard. You can specify start without specifying end to specify a relative time range that ends with the current time. In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months. You can also use start along with an end field, to specify an absolute time range. When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z. Default: When the dashboard loads, the start time will be the default time range.
        :param widgets: Initial set of widgets on the dashboard. One array represents a row of widgets. Default: - No widgets

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.DashboardProps(
            dashboard_name=dashboard_name,
            end=end,
            period_override=period_override,
            start=start,
            widgets=widgets,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addWidgets")
    def add_widgets(self, *widgets: aws_cdk.aws_cloudwatch.IWidget) -> None:
        '''(experimental) Add a widget to the dashboard.

        Widgets given in multiple calls to add() will be laid out stacked on
        top of each other.

        Multiple widgets added in the same call to add() will be laid out next
        to each other.

        :param widgets: -

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "addWidgets", [*widgets]))

    @jsii.member(jsii_name="asBitmap")
    def _as_bitmap(
        self,
        widget: aws_cdk.aws_cloudwatch.IWidget,
    ) -> aws_cdk.aws_cloudwatch.IWidget:
        '''
        :param widget: -

        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.IWidget, jsii.invoke(self, "asBitmap", [widget]))

    @jsii.member(jsii_name="asBitmaps")
    def _as_bitmaps(
        self,
        *widgets: aws_cdk.aws_cloudwatch.IWidget,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''
        :param widgets: -

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "asBitmaps", [*widgets]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="bitmapRenderingSupport")
    def _bitmap_rendering_support(self) -> "BitmapWidgetRenderingSupport":
        '''
        :stability: experimental
        '''
        return typing.cast("BitmapWidgetRenderingSupport", jsii.get(self, "bitmapRenderingSupport"))


class BitmapWidgetRenderingSupport(
    constructs.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.BitmapWidgetRenderingSupport",
):
    '''(experimental) Support for rendering bitmap widgets on the server side.

    It is a custom widget lambda with some additional roles and helper methods.

    :stability: experimental
    '''

    def __init__(self, scope: constructs.Construct, id: builtins.str) -> None:
        '''
        :param scope: -
        :param id: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [scope, id])

    @jsii.member(jsii_name="asBitmap")
    def as_bitmap(self, widget: aws_cdk.aws_cloudwatch.IWidget) -> "CustomWidget":
        '''
        :param widget: -

        :stability: experimental
        '''
        return typing.cast("CustomWidget", jsii.invoke(self, "asBitmap", [widget]))

    @jsii.member(jsii_name="getWidgetProperties")
    def _get_widget_properties(
        self,
        widget: aws_cdk.aws_cloudwatch.IWidget,
    ) -> typing.Any:
        '''
        :param widget: -

        :stability: experimental
        '''
        return typing.cast(typing.Any, jsii.invoke(self, "getWidgetProperties", [widget]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="handler")
    def handler(self) -> aws_cdk.aws_lambda.IFunction:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_lambda.IFunction, jsii.get(self, "handler"))


@jsii.enum(jsii_type="cdk-monitoring-constructs.CapacityType")
class CapacityType(enum.Enum):
    '''
    :stability: experimental
    '''

    READ = "READ"
    '''
    :stability: experimental
    '''
    WRITE = "WRITE"
    '''
    :stability: experimental
    '''


class CertificateManagerMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.CertificateManagerMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        certificate: aws_cdk.aws_certificatemanager.ICertificate,
    ) -> None:
        '''
        :param metric_factory: -
        :param certificate: 

        :stability: experimental
        '''
        props = CertificateManagerMetricFactoryProps(certificate=certificate)

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricDaysToExpiry")
    def metric_days_to_expiry(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricDaysToExpiry", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CertificateManagerMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"certificate": "certificate"},
)
class CertificateManagerMetricFactoryProps:
    def __init__(
        self,
        *,
        certificate: aws_cdk.aws_certificatemanager.ICertificate,
    ) -> None:
        '''
        :param certificate: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "certificate": certificate,
        }

    @builtins.property
    def certificate(self) -> aws_cdk.aws_certificatemanager.ICertificate:
        '''
        :stability: experimental
        '''
        result = self._values.get("certificate")
        assert result is not None, "Required property 'certificate' is missing"
        return typing.cast(aws_cdk.aws_certificatemanager.ICertificate, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CertificateManagerMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class CloudFrontDistributionMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.CloudFrontDistributionMetricFactory",
):
    '''(experimental) To get the CloudFront metrics from the CloudWatch API, you must use the US East (N.

    Virginia) Region (us-east-1).
    https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/programming-cloudwatch-metrics.html

    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        distribution: aws_cdk.aws_cloudfront.IDistribution,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param distribution: 
        :param fill_tps_with_zeroes: Default: true
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        props = CloudFrontDistributionMetricFactoryProps(
            distribution=distribution,
            fill_tps_with_zeroes=fill_tps_with_zeroes,
            rate_computation_method=rate_computation_method,
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metric4xxErrorRateAverage")
    def metric4xx_error_rate_average(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric4xxErrorRateAverage", []))

    @jsii.member(jsii_name="metric5xxErrorRateAverage")
    def metric5xx_error_rate_average(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metric5xxErrorRateAverage", []))

    @jsii.member(jsii_name="metricCacheHitRateAverageInPercent")
    def metric_cache_hit_rate_average_in_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricCacheHitRateAverageInPercent", []))

    @jsii.member(jsii_name="metricRequestCount")
    def metric_request_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricRequestCount", []))

    @jsii.member(jsii_name="metricRequestRate")
    def metric_request_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricRequestRate", []))

    @jsii.member(jsii_name="metricRequestTps")
    def metric_request_tps(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricRequestRate

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricRequestTps", []))

    @jsii.member(jsii_name="metricTotalBytesDownloaded")
    def metric_total_bytes_downloaded(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTotalBytesDownloaded", []))

    @jsii.member(jsii_name="metricTotalBytesUploaded")
    def metric_total_bytes_uploaded(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTotalBytesUploaded", []))

    @jsii.member(jsii_name="metricTotalErrorRateAverage")
    def metric_total_error_rate_average(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTotalErrorRateAverage", []))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CloudFrontDistributionMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "distribution": "distribution",
        "fill_tps_with_zeroes": "fillTpsWithZeroes",
        "rate_computation_method": "rateComputationMethod",
    },
)
class CloudFrontDistributionMetricFactoryProps:
    def __init__(
        self,
        *,
        distribution: aws_cdk.aws_cloudfront.IDistribution,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param distribution: 
        :param fill_tps_with_zeroes: Default: true
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "distribution": distribution,
        }
        if fill_tps_with_zeroes is not None:
            self._values["fill_tps_with_zeroes"] = fill_tps_with_zeroes
        if rate_computation_method is not None:
            self._values["rate_computation_method"] = rate_computation_method

    @builtins.property
    def distribution(self) -> aws_cdk.aws_cloudfront.IDistribution:
        '''
        :stability: experimental
        '''
        result = self._values.get("distribution")
        assert result is not None, "Required property 'distribution' is missing"
        return typing.cast(aws_cdk.aws_cloudfront.IDistribution, result)

    @builtins.property
    def fill_tps_with_zeroes(self) -> typing.Optional[builtins.bool]:
        '''
        :default: true

        :stability: experimental
        '''
        result = self._values.get("fill_tps_with_zeroes")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def rate_computation_method(self) -> typing.Optional["RateComputationMethod"]:
        '''
        :default: average

        :stability: experimental
        '''
        result = self._values.get("rate_computation_method")
        return typing.cast(typing.Optional["RateComputationMethod"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CloudFrontDistributionMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class CodeBuildProjectMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.CodeBuildProjectMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        project: aws_cdk.aws_codebuild.IProject,
    ) -> None:
        '''
        :param metric_factory: -
        :param project: 

        :stability: experimental
        '''
        props = CodeBuildProjectMetricFactoryProps(project=project)

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricBuildCount")
    def metric_build_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricBuildCount", []))

    @jsii.member(jsii_name="metricDurationP50InSeconds")
    def metric_duration_p50_in_seconds(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricDurationP50InSeconds", []))

    @jsii.member(jsii_name="metricDurationP90InSeconds")
    def metric_duration_p90_in_seconds(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricDurationP90InSeconds", []))

    @jsii.member(jsii_name="metricDurationP99InSeconds")
    def metric_duration_p99_in_seconds(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricDurationP99InSeconds", []))

    @jsii.member(jsii_name="metricFailedBuildCount")
    def metric_failed_build_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFailedBuildCount", []))

    @jsii.member(jsii_name="metricFailedBuildRate")
    def metric_failed_build_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFailedBuildRate", []))

    @jsii.member(jsii_name="metricSucceededBuildCount")
    def metric_succeeded_build_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricSucceededBuildCount", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="project")
    def _project(self) -> aws_cdk.aws_codebuild.IProject:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_codebuild.IProject, jsii.get(self, "project"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CodeBuildProjectMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"project": "project"},
)
class CodeBuildProjectMetricFactoryProps:
    def __init__(self, *, project: aws_cdk.aws_codebuild.IProject) -> None:
        '''
        :param project: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "project": project,
        }

    @builtins.property
    def project(self) -> aws_cdk.aws_codebuild.IProject:
        '''
        :stability: experimental
        '''
        result = self._values.get("project")
        assert result is not None, "Required property 'project' is missing"
        return typing.cast(aws_cdk.aws_codebuild.IProject, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CodeBuildProjectMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.CompositeAlarmOperator")
class CompositeAlarmOperator(enum.Enum):
    '''
    :stability: experimental
    '''

    AND = "AND"
    '''(experimental) trigger only if all the alarms are triggered.

    :stability: experimental
    '''
    OR = "OR"
    '''(experimental) trigger if any of the alarms is triggered.

    :stability: experimental
    '''


class CustomAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.CustomAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addCustomAlarm")
    def add_custom_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        alarm_name_suffix: builtins.str,
        disambiguator: builtins.str,
        *,
        comparison_operator: aws_cdk.aws_cloudwatch.ComparisonOperator,
        threshold: jsii.Number,
        additional_description: typing.Optional[builtins.str] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param alarm_name_suffix: -
        :param disambiguator: -
        :param comparison_operator: 
        :param threshold: 
        :param additional_description: 
        :param dedupe_string: 
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default

        :stability: experimental
        '''
        props = CustomThreshold(
            comparison_operator=comparison_operator,
            threshold=threshold,
            additional_description=additional_description,
            dedupe_string=dedupe_string,
            action_override=action_override,
            actions_enabled=actions_enabled,
            alarm_description_override=alarm_description_override,
            alarm_name_override=alarm_name_override,
            comparison_operator_override=comparison_operator_override,
            custom_params=custom_params,
            custom_tags=custom_tags,
            datapoints_to_alarm=datapoints_to_alarm,
            dedupe_string_override=dedupe_string_override,
            documentation_link=documentation_link,
            evaluate_low_sample_count_percentile=evaluate_low_sample_count_percentile,
            evaluation_periods=evaluation_periods,
            fill_alarm_range=fill_alarm_range,
            period=period,
            runbook_link=runbook_link,
            treat_missing_data_override=treat_missing_data_override,
        )

        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addCustomAlarm", [metric, alarm_name_suffix, disambiguator, props]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomAlarmThreshold",
    jsii_struct_bases=[],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
    },
)
class CustomAlarmThreshold:
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
    ) -> None:
        '''(experimental) Common customization that can be attached to each alarm.

        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomAlarmThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomMetricGroup",
    jsii_struct_bases=[],
    name_mapping={
        "metrics": "metrics",
        "title": "title",
        "graph_widget_axis": "graphWidgetAxis",
        "graph_widget_right_axis": "graphWidgetRightAxis",
        "graph_widget_type": "graphWidgetType",
        "horizontal_annotations": "horizontalAnnotations",
        "horizontal_right_annotations": "horizontalRightAnnotations",
        "important": "important",
    },
)
class CustomMetricGroup:
    def __init__(
        self,
        *,
        metrics: typing.Sequence[typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression, "CustomMetricWithAlarm", "CustomMetricWithAnomalyDetection", "CustomMetricSearch"]],
        title: builtins.str,
        graph_widget_axis: typing.Optional[aws_cdk.aws_cloudwatch.YAxisProps] = None,
        graph_widget_right_axis: typing.Optional[aws_cdk.aws_cloudwatch.YAxisProps] = None,
        graph_widget_type: typing.Optional["GraphWidgetType"] = None,
        horizontal_annotations: typing.Optional[typing.Sequence[aws_cdk.aws_cloudwatch.HorizontalAnnotation]] = None,
        horizontal_right_annotations: typing.Optional[typing.Sequence[aws_cdk.aws_cloudwatch.HorizontalAnnotation]] = None,
        important: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''(experimental) Custom metric group represents a single widget.

        :param metrics: (experimental) list of metrics in the group (can be defined in different ways, see the type documentation).
        :param title: (experimental) title of the whole group.
        :param graph_widget_axis: (experimental) optional axis. Default: undefined
        :param graph_widget_right_axis: (experimental) optional right axis default: undefined.
        :param graph_widget_type: (experimental) type of the widget. Default: line
        :param horizontal_annotations: (experimental) optional custom horizontal annotations which will be displayed over the metrics on the left axis (if there are any alarms, any existing annotations will be merged together).
        :param horizontal_right_annotations: (experimental) optional custom horizontal annotations which will be displayed over the metrics on the right axis (if there are any alarms, any existing annotations will be merged together).
        :param important: (experimental) Flag indicating, whether this is an important metric group that should be included in the summary as well. Default: false

        :stability: experimental
        '''
        if isinstance(graph_widget_axis, dict):
            graph_widget_axis = aws_cdk.aws_cloudwatch.YAxisProps(**graph_widget_axis)
        if isinstance(graph_widget_right_axis, dict):
            graph_widget_right_axis = aws_cdk.aws_cloudwatch.YAxisProps(**graph_widget_right_axis)
        self._values: typing.Dict[str, typing.Any] = {
            "metrics": metrics,
            "title": title,
        }
        if graph_widget_axis is not None:
            self._values["graph_widget_axis"] = graph_widget_axis
        if graph_widget_right_axis is not None:
            self._values["graph_widget_right_axis"] = graph_widget_right_axis
        if graph_widget_type is not None:
            self._values["graph_widget_type"] = graph_widget_type
        if horizontal_annotations is not None:
            self._values["horizontal_annotations"] = horizontal_annotations
        if horizontal_right_annotations is not None:
            self._values["horizontal_right_annotations"] = horizontal_right_annotations
        if important is not None:
            self._values["important"] = important

    @builtins.property
    def metrics(
        self,
    ) -> typing.List[typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression, "CustomMetricWithAlarm", "CustomMetricWithAnomalyDetection", "CustomMetricSearch"]]:
        '''(experimental) list of metrics in the group (can be defined in different ways, see the type documentation).

        :stability: experimental
        '''
        result = self._values.get("metrics")
        assert result is not None, "Required property 'metrics' is missing"
        return typing.cast(typing.List[typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression, "CustomMetricWithAlarm", "CustomMetricWithAnomalyDetection", "CustomMetricSearch"]], result)

    @builtins.property
    def title(self) -> builtins.str:
        '''(experimental) title of the whole group.

        :stability: experimental
        '''
        result = self._values.get("title")
        assert result is not None, "Required property 'title' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def graph_widget_axis(self) -> typing.Optional[aws_cdk.aws_cloudwatch.YAxisProps]:
        '''(experimental) optional axis.

        :default: undefined

        :stability: experimental
        '''
        result = self._values.get("graph_widget_axis")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.YAxisProps], result)

    @builtins.property
    def graph_widget_right_axis(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.YAxisProps]:
        '''(experimental) optional right axis default: undefined.

        :stability: experimental
        '''
        result = self._values.get("graph_widget_right_axis")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.YAxisProps], result)

    @builtins.property
    def graph_widget_type(self) -> typing.Optional["GraphWidgetType"]:
        '''(experimental) type of the widget.

        :default: line

        :stability: experimental
        '''
        result = self._values.get("graph_widget_type")
        return typing.cast(typing.Optional["GraphWidgetType"], result)

    @builtins.property
    def horizontal_annotations(
        self,
    ) -> typing.Optional[typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]]:
        '''(experimental) optional custom horizontal annotations which will be displayed over the metrics on the left axis (if there are any alarms, any existing annotations will be merged together).

        :stability: experimental
        '''
        result = self._values.get("horizontal_annotations")
        return typing.cast(typing.Optional[typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]], result)

    @builtins.property
    def horizontal_right_annotations(
        self,
    ) -> typing.Optional[typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]]:
        '''(experimental) optional custom horizontal annotations which will be displayed over the metrics on the right axis (if there are any alarms, any existing annotations will be merged together).

        :stability: experimental
        '''
        result = self._values.get("horizontal_right_annotations")
        return typing.cast(typing.Optional[typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]], result)

    @builtins.property
    def important(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Flag indicating, whether this is an important metric group that should be included in the summary as well.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("important")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomMetricGroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomMetricGroupWithAnnotations",
    jsii_struct_bases=[],
    name_mapping={
        "annotations": "annotations",
        "metric_group": "metricGroup",
        "right_annotations": "rightAnnotations",
        "title_addons": "titleAddons",
    },
)
class CustomMetricGroupWithAnnotations:
    def __init__(
        self,
        *,
        annotations: typing.Sequence[aws_cdk.aws_cloudwatch.HorizontalAnnotation],
        metric_group: CustomMetricGroup,
        right_annotations: typing.Sequence[aws_cdk.aws_cloudwatch.HorizontalAnnotation],
        title_addons: typing.Sequence[builtins.str],
    ) -> None:
        '''
        :param annotations: 
        :param metric_group: 
        :param right_annotations: 
        :param title_addons: 

        :stability: experimental
        '''
        if isinstance(metric_group, dict):
            metric_group = CustomMetricGroup(**metric_group)
        self._values: typing.Dict[str, typing.Any] = {
            "annotations": annotations,
            "metric_group": metric_group,
            "right_annotations": right_annotations,
            "title_addons": title_addons,
        }

    @builtins.property
    def annotations(self) -> typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]:
        '''
        :stability: experimental
        '''
        result = self._values.get("annotations")
        assert result is not None, "Required property 'annotations' is missing"
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation], result)

    @builtins.property
    def metric_group(self) -> CustomMetricGroup:
        '''
        :stability: experimental
        '''
        result = self._values.get("metric_group")
        assert result is not None, "Required property 'metric_group' is missing"
        return typing.cast(CustomMetricGroup, result)

    @builtins.property
    def right_annotations(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]:
        '''
        :stability: experimental
        '''
        result = self._values.get("right_annotations")
        assert result is not None, "Required property 'right_annotations' is missing"
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation], result)

    @builtins.property
    def title_addons(self) -> typing.List[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("title_addons")
        assert result is not None, "Required property 'title_addons' is missing"
        return typing.cast(typing.List[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomMetricGroupWithAnnotations(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomMetricSearch",
    jsii_struct_bases=[],
    name_mapping={
        "dimensions_map": "dimensionsMap",
        "search_query": "searchQuery",
        "statistic": "statistic",
        "label": "label",
        "namespace": "namespace",
        "period": "period",
        "position": "position",
    },
)
class CustomMetricSearch:
    def __init__(
        self,
        *,
        dimensions_map: typing.Mapping[builtins.str, builtins.str],
        search_query: builtins.str,
        statistic: "MetricStatistic",
        label: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        position: typing.Optional[AxisPosition] = None,
    ) -> None:
        '''(experimental) Custom metric search.

        :param dimensions_map: (experimental) search dimensions (can be empty).
        :param search_query: (experimental) search query (can be empty).
        :param statistic: (experimental) metric statistic.
        :param label: (experimental) custom label for the metrics. Default: " "
        :param namespace: (experimental) metric namespace. Default: none
        :param period: (experimental) metric period. Default: global default
        :param position: (experimental) axis (right or left) on which to graph metric default: AxisPosition.LEFT.

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "dimensions_map": dimensions_map,
            "search_query": search_query,
            "statistic": statistic,
        }
        if label is not None:
            self._values["label"] = label
        if namespace is not None:
            self._values["namespace"] = namespace
        if period is not None:
            self._values["period"] = period
        if position is not None:
            self._values["position"] = position

    @builtins.property
    def dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''(experimental) search dimensions (can be empty).

        :stability: experimental
        '''
        result = self._values.get("dimensions_map")
        assert result is not None, "Required property 'dimensions_map' is missing"
        return typing.cast(typing.Mapping[builtins.str, builtins.str], result)

    @builtins.property
    def search_query(self) -> builtins.str:
        '''(experimental) search query (can be empty).

        :stability: experimental
        '''
        result = self._values.get("search_query")
        assert result is not None, "Required property 'search_query' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def statistic(self) -> "MetricStatistic":
        '''(experimental) metric statistic.

        :stability: experimental
        '''
        result = self._values.get("statistic")
        assert result is not None, "Required property 'statistic' is missing"
        return typing.cast("MetricStatistic", result)

    @builtins.property
    def label(self) -> typing.Optional[builtins.str]:
        '''(experimental) custom label for the metrics.

        :default: " "

        :stability: experimental
        '''
        result = self._values.get("label")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''(experimental) metric namespace.

        :default: none

        :stability: experimental
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) metric period.

        :default: global default

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def position(self) -> typing.Optional[AxisPosition]:
        '''(experimental) axis (right or left) on which to graph metric default: AxisPosition.LEFT.

        :stability: experimental
        '''
        result = self._values.get("position")
        return typing.cast(typing.Optional[AxisPosition], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomMetricSearch(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomMetricWithAlarm",
    jsii_struct_bases=[],
    name_mapping={
        "add_alarm": "addAlarm",
        "alarm_friendly_name": "alarmFriendlyName",
        "metric": "metric",
        "position": "position",
    },
)
class CustomMetricWithAlarm:
    def __init__(
        self,
        *,
        add_alarm: typing.Mapping[builtins.str, "CustomThreshold"],
        alarm_friendly_name: builtins.str,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        position: typing.Optional[AxisPosition] = None,
    ) -> None:
        '''(experimental) Custom metric with an alarm defined.

        :param add_alarm: (experimental) alarm definitions.
        :param alarm_friendly_name: (experimental) alarm friendly name.
        :param metric: (experimental) metric to alarm on.
        :param position: (experimental) axis (right or left) on which to graph metric default: AxisPosition.LEFT.

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "add_alarm": add_alarm,
            "alarm_friendly_name": alarm_friendly_name,
            "metric": metric,
        }
        if position is not None:
            self._values["position"] = position

    @builtins.property
    def add_alarm(self) -> typing.Mapping[builtins.str, "CustomThreshold"]:
        '''(experimental) alarm definitions.

        :stability: experimental
        '''
        result = self._values.get("add_alarm")
        assert result is not None, "Required property 'add_alarm' is missing"
        return typing.cast(typing.Mapping[builtins.str, "CustomThreshold"], result)

    @builtins.property
    def alarm_friendly_name(self) -> builtins.str:
        '''(experimental) alarm friendly name.

        :stability: experimental
        '''
        result = self._values.get("alarm_friendly_name")
        assert result is not None, "Required property 'alarm_friendly_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) metric to alarm on.

        :stability: experimental
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], result)

    @builtins.property
    def position(self) -> typing.Optional[AxisPosition]:
        '''(experimental) axis (right or left) on which to graph metric default: AxisPosition.LEFT.

        :stability: experimental
        '''
        result = self._values.get("position")
        return typing.cast(typing.Optional[AxisPosition], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomMetricWithAlarm(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomMetricWithAnomalyDetection",
    jsii_struct_bases=[],
    name_mapping={
        "alarm_friendly_name": "alarmFriendlyName",
        "anomaly_detection_standard_deviation_to_render": "anomalyDetectionStandardDeviationToRender",
        "metric": "metric",
        "add_alarm_on_anomaly": "addAlarmOnAnomaly",
        "period": "period",
    },
)
class CustomMetricWithAnomalyDetection:
    def __init__(
        self,
        *,
        alarm_friendly_name: builtins.str,
        anomaly_detection_standard_deviation_to_render: jsii.Number,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        add_alarm_on_anomaly: typing.Optional[typing.Mapping[builtins.str, "AnomalyDetectionThreshold"]] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
    ) -> None:
        '''(experimental) Custom metric with anomaly detection.

        :param alarm_friendly_name: (experimental) alarm friendly name.
        :param anomaly_detection_standard_deviation_to_render: (experimental) standard deviation for the anomaly detection to be rendered on the graph widget.
        :param metric: (experimental) metric to alarm on.
        :param add_alarm_on_anomaly: (experimental) adds alarm on a detected anomaly.
        :param period: (experimental) anomaly detection period. Default: metric period (if defined) or global default

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "alarm_friendly_name": alarm_friendly_name,
            "anomaly_detection_standard_deviation_to_render": anomaly_detection_standard_deviation_to_render,
            "metric": metric,
        }
        if add_alarm_on_anomaly is not None:
            self._values["add_alarm_on_anomaly"] = add_alarm_on_anomaly
        if period is not None:
            self._values["period"] = period

    @builtins.property
    def alarm_friendly_name(self) -> builtins.str:
        '''(experimental) alarm friendly name.

        :stability: experimental
        '''
        result = self._values.get("alarm_friendly_name")
        assert result is not None, "Required property 'alarm_friendly_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def anomaly_detection_standard_deviation_to_render(self) -> jsii.Number:
        '''(experimental) standard deviation for the anomaly detection to be rendered on the graph widget.

        :stability: experimental
        '''
        result = self._values.get("anomaly_detection_standard_deviation_to_render")
        assert result is not None, "Required property 'anomaly_detection_standard_deviation_to_render' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) metric to alarm on.

        :stability: experimental
        '''
        result = self._values.get("metric")
        assert result is not None, "Required property 'metric' is missing"
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], result)

    @builtins.property
    def add_alarm_on_anomaly(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, "AnomalyDetectionThreshold"]]:
        '''(experimental) adds alarm on a detected anomaly.

        :stability: experimental
        '''
        result = self._values.get("add_alarm_on_anomaly")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, "AnomalyDetectionThreshold"]], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) anomaly detection period.

        :default: metric period (if defined) or global default

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomMetricWithAnomalyDetection(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "comparison_operator": "comparisonOperator",
        "threshold": "threshold",
        "additional_description": "additionalDescription",
        "dedupe_string": "dedupeString",
    },
)
class CustomThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        comparison_operator: aws_cdk.aws_cloudwatch.ComparisonOperator,
        threshold: jsii.Number,
        additional_description: typing.Optional[builtins.str] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param comparison_operator: 
        :param threshold: 
        :param additional_description: 
        :param dedupe_string: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "comparison_operator": comparison_operator,
            "threshold": threshold,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override
        if additional_description is not None:
            self._values["additional_description"] = additional_description
        if dedupe_string is not None:
            self._values["dedupe_string"] = dedupe_string

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def comparison_operator(self) -> aws_cdk.aws_cloudwatch.ComparisonOperator:
        '''
        :stability: experimental
        '''
        result = self._values.get("comparison_operator")
        assert result is not None, "Required property 'comparison_operator' is missing"
        return typing.cast(aws_cdk.aws_cloudwatch.ComparisonOperator, result)

    @builtins.property
    def threshold(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("threshold")
        assert result is not None, "Required property 'threshold' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def additional_description(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("additional_description")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def dedupe_string(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("dedupe_string")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class CustomWidget(
    aws_cdk.aws_cloudwatch.ConcreteWidget,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.CustomWidget",
):
    '''(experimental) A dashboard widget that can be customized using a Lambda.

    :stability: experimental
    '''

    def __init__(
        self,
        *,
        handler: aws_cdk.aws_lambda.IFunction,
        handler_params: typing.Any = None,
        height: typing.Optional[jsii.Number] = None,
        title: typing.Optional[builtins.str] = None,
        update_on_refresh: typing.Optional[builtins.bool] = None,
        update_on_resize: typing.Optional[builtins.bool] = None,
        update_on_time_range_change: typing.Optional[builtins.bool] = None,
        width: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param handler: (experimental) Lambda providing the widget contents. The Lambda function should return HTML with widget code. The simplest Lambda example:: exports.handler = function (event, context, callback) { return callback(null, "<h1>Hello! This is a custom widget.</h1><pre>" + JSON.stringify(event, null, 2) + "</pre>"); };
        :param handler_params: (experimental) Arguments to pass to the Lambda. These arguments will be available in the Lambda context.
        :param height: (experimental) Height of the widget. Default: 6
        :param title: (experimental) Title for the graph.
        :param update_on_refresh: (experimental) Whether the widget should be updated (by calling the Lambda again) on refresh. Default: true
        :param update_on_resize: (experimental) Whether the widget should be updated (by calling the Lambda again) on resize. Default: true
        :param update_on_time_range_change: (experimental) Whether the widget should be updated (by calling the Lambda again) on time range change. Default: true
        :param width: (experimental) Width of the widget, in a grid of 24 units wide. Default: 6

        :stability: experimental
        '''
        props = CustomWidgetProps(
            handler=handler,
            handler_params=handler_params,
            height=height,
            title=title,
            update_on_refresh=update_on_refresh,
            update_on_resize=update_on_resize,
            update_on_time_range_change=update_on_time_range_change,
            width=width,
        )

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="toJson")
    def to_json(self) -> typing.List[typing.Any]:
        '''(experimental) Return the widget JSON for use in the dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[typing.Any], jsii.invoke(self, "toJson", []))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.CustomWidgetProps",
    jsii_struct_bases=[],
    name_mapping={
        "handler": "handler",
        "handler_params": "handlerParams",
        "height": "height",
        "title": "title",
        "update_on_refresh": "updateOnRefresh",
        "update_on_resize": "updateOnResize",
        "update_on_time_range_change": "updateOnTimeRangeChange",
        "width": "width",
    },
)
class CustomWidgetProps:
    def __init__(
        self,
        *,
        handler: aws_cdk.aws_lambda.IFunction,
        handler_params: typing.Any = None,
        height: typing.Optional[jsii.Number] = None,
        title: typing.Optional[builtins.str] = None,
        update_on_refresh: typing.Optional[builtins.bool] = None,
        update_on_resize: typing.Optional[builtins.bool] = None,
        update_on_time_range_change: typing.Optional[builtins.bool] = None,
        width: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''(experimental) Properties of a custom widget.

        :param handler: (experimental) Lambda providing the widget contents. The Lambda function should return HTML with widget code. The simplest Lambda example:: exports.handler = function (event, context, callback) { return callback(null, "<h1>Hello! This is a custom widget.</h1><pre>" + JSON.stringify(event, null, 2) + "</pre>"); };
        :param handler_params: (experimental) Arguments to pass to the Lambda. These arguments will be available in the Lambda context.
        :param height: (experimental) Height of the widget. Default: 6
        :param title: (experimental) Title for the graph.
        :param update_on_refresh: (experimental) Whether the widget should be updated (by calling the Lambda again) on refresh. Default: true
        :param update_on_resize: (experimental) Whether the widget should be updated (by calling the Lambda again) on resize. Default: true
        :param update_on_time_range_change: (experimental) Whether the widget should be updated (by calling the Lambda again) on time range change. Default: true
        :param width: (experimental) Width of the widget, in a grid of 24 units wide. Default: 6

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "handler": handler,
        }
        if handler_params is not None:
            self._values["handler_params"] = handler_params
        if height is not None:
            self._values["height"] = height
        if title is not None:
            self._values["title"] = title
        if update_on_refresh is not None:
            self._values["update_on_refresh"] = update_on_refresh
        if update_on_resize is not None:
            self._values["update_on_resize"] = update_on_resize
        if update_on_time_range_change is not None:
            self._values["update_on_time_range_change"] = update_on_time_range_change
        if width is not None:
            self._values["width"] = width

    @builtins.property
    def handler(self) -> aws_cdk.aws_lambda.IFunction:
        '''(experimental) Lambda providing the widget contents.

        The Lambda function should return HTML with widget code.
        The simplest Lambda example::

           exports.handler = function (event, context, callback) {
              return callback(null, "<h1>Hello! This is a custom widget.</h1><pre>" + JSON.stringify(event, null, 2) + "</pre>");
           };

        :stability: experimental
        '''
        result = self._values.get("handler")
        assert result is not None, "Required property 'handler' is missing"
        return typing.cast(aws_cdk.aws_lambda.IFunction, result)

    @builtins.property
    def handler_params(self) -> typing.Any:
        '''(experimental) Arguments to pass to the Lambda.

        These arguments will be available in the Lambda context.

        :stability: experimental
        '''
        result = self._values.get("handler_params")
        return typing.cast(typing.Any, result)

    @builtins.property
    def height(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Height of the widget.

        :default: 6

        :stability: experimental
        '''
        result = self._values.get("height")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def title(self) -> typing.Optional[builtins.str]:
        '''(experimental) Title for the graph.

        :stability: experimental
        '''
        result = self._values.get("title")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def update_on_refresh(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether the widget should be updated (by calling the Lambda again) on refresh.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("update_on_refresh")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def update_on_resize(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether the widget should be updated (by calling the Lambda again) on resize.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("update_on_resize")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def update_on_time_range_change(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Whether the widget should be updated (by calling the Lambda again) on time range change.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("update_on_time_range_change")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def width(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Width of the widget, in a grid of 24 units wide.

        :default: 6

        :stability: experimental
        '''
        result = self._values.get("width")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "CustomWidgetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.DashboardRenderingPreference")
class DashboardRenderingPreference(enum.Enum):
    '''(experimental) Preferred way of rendering the widgets.

    :stability: experimental
    '''

    INTERACTIVE_ONLY = "INTERACTIVE_ONLY"
    '''(experimental) create standard set of dashboards with interactive widgets only.

    :stability: experimental
    '''
    BITMAP_ONLY = "BITMAP_ONLY"
    '''(experimental) create standard set of dashboards with bitmap widgets only.

    :stability: experimental
    '''
    INTERACTIVE_AND_BITMAP = "INTERACTIVE_AND_BITMAP"
    '''(experimental) create a two sets of dashboards: standard set (interactive) and a copy (bitmap).

    :stability: experimental
    '''


class DashboardWithBitmapCopy(
    aws_cdk.aws_cloudwatch.Dashboard,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.DashboardWithBitmapCopy",
):
    '''(experimental) Composite dashboard which keeps a normal dashboard with its bitmap copy.

    The bitmap copy name will be derived from the primary dashboard name, if specified.

    :stability: experimental
    '''

    def __init__(
        self,
        scope: constructs.Construct,
        id: builtins.str,
        *,
        dashboard_name: typing.Optional[builtins.str] = None,
        end: typing.Optional[builtins.str] = None,
        period_override: typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride] = None,
        start: typing.Optional[builtins.str] = None,
        widgets: typing.Optional[typing.Sequence[typing.Sequence[aws_cdk.aws_cloudwatch.IWidget]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param dashboard_name: Name of the dashboard. If set, must only contain alphanumerics, dash (-) and underscore (_) Default: - automatically generated name
        :param end: The end of the time range to use for each widget on the dashboard when the dashboard loads. If you specify a value for end, you must also specify a value for start. Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z. Default: When the dashboard loads, the end date will be the current time.
        :param period_override: Use this field to specify the period for the graphs when the dashboard loads. Specifying ``Auto`` causes the period of all graphs on the dashboard to automatically adapt to the time range of the dashboard. Specifying ``Inherit`` ensures that the period set for each graph is always obeyed. Default: Auto
        :param start: The start of the time range to use for each widget on the dashboard. You can specify start without specifying end to specify a relative time range that ends with the current time. In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months. You can also use start along with an end field, to specify an absolute time range. When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z. Default: When the dashboard loads, the start time will be the default time range.
        :param widgets: Initial set of widgets on the dashboard. One array represents a row of widgets. Default: - No widgets

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.DashboardProps(
            dashboard_name=dashboard_name,
            end=end,
            period_override=period_override,
            start=start,
            widgets=widgets,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="addWidgets")
    def add_widgets(self, *widgets: aws_cdk.aws_cloudwatch.IWidget) -> None:
        '''(experimental) Add a widget to the dashboard.

        Widgets given in multiple calls to add() will be laid out stacked on
        top of each other.

        Multiple widgets added in the same call to add() will be laid out next
        to each other.

        :param widgets: -

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "addWidgets", [*widgets]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="bitmapCopy")
    def _bitmap_copy(self) -> BitmapDashboard:
        '''
        :stability: experimental
        '''
        return typing.cast(BitmapDashboard, jsii.get(self, "bitmapCopy"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.DaysSinceUpdateThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_days_since_update": "maxDaysSinceUpdate",
    },
)
class DaysSinceUpdateThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_days_since_update: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_days_since_update: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_days_since_update": max_days_since_update,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_days_since_update(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_days_since_update")
        assert result is not None, "Required property 'max_days_since_update' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaysSinceUpdateThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.DaysToExpiryThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_days_to_expiry": "minDaysToExpiry",
    },
)
class DaysToExpiryThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_days_to_expiry: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_days_to_expiry: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_days_to_expiry": min_days_to_expiry,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_days_to_expiry(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_days_to_expiry")
        assert result is not None, "Required property 'min_days_to_expiry' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DaysToExpiryThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.DurationThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_duration": "maxDuration",
    },
)
class DurationThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_duration: aws_cdk.Duration,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_duration: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_duration": max_duration,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_duration(self) -> aws_cdk.Duration:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_duration")
        assert result is not None, "Required property 'max_duration' is missing"
        return typing.cast(aws_cdk.Duration, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DurationThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DynamoAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.DynamoAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addConsumedCapacityAlarm")
    def add_consumed_capacity_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        capacity_type: CapacityType,
        props: "ConsumedCapacityThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param capacity_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addConsumedCapacityAlarm", [metric, capacity_type, props, disambiguator]))

    @jsii.member(jsii_name="addThrottledEventsAlarm")
    def add_throttled_events_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        capacity_type: CapacityType,
        props: "ThrottledEventsThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param capacity_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addThrottledEventsAlarm", [metric, capacity_type, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


class DynamoTableGlobalSecondaryIndexMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        global_secondary_index_name: builtins.str,
        table: aws_cdk.aws_dynamodb.ITable,
    ) -> None:
        '''
        :param metric_factory: -
        :param global_secondary_index_name: 
        :param table: 

        :stability: experimental
        '''
        props = DynamoTableGlobalSecondaryIndexMetricFactoryProps(
            global_secondary_index_name=global_secondary_index_name, table=table
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricConsumedReadCapacityUnits")
    def metric_consumed_read_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricConsumedReadCapacityUnits", []))

    @jsii.member(jsii_name="metricConsumedWriteCapacityUnits")
    def metric_consumed_write_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricConsumedWriteCapacityUnits", []))

    @jsii.member(jsii_name="metricIndexConsumedWriteUnitsMetric")
    def metric_index_consumed_write_units_metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIndexConsumedWriteUnitsMetric", []))

    @jsii.member(jsii_name="metricProvisionedReadCapacityUnits")
    def metric_provisioned_read_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricProvisionedReadCapacityUnits", []))

    @jsii.member(jsii_name="metricProvisionedWriteCapacityUnits")
    def metric_provisioned_write_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricProvisionedWriteCapacityUnits", []))

    @jsii.member(jsii_name="metricThrottledIndexRequestCount")
    def metric_throttled_index_request_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottledIndexRequestCount", []))

    @jsii.member(jsii_name="metricThrottledReadRequestCount")
    def metric_throttled_read_request_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottledReadRequestCount", []))

    @jsii.member(jsii_name="metricThrottledWriteRequestCount")
    def metric_throttled_write_request_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottledWriteRequestCount", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "global_secondary_index_name": "globalSecondaryIndexName",
        "table": "table",
    },
)
class DynamoTableGlobalSecondaryIndexMetricFactoryProps:
    def __init__(
        self,
        *,
        global_secondary_index_name: builtins.str,
        table: aws_cdk.aws_dynamodb.ITable,
    ) -> None:
        '''
        :param global_secondary_index_name: 
        :param table: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "global_secondary_index_name": global_secondary_index_name,
            "table": table,
        }

    @builtins.property
    def global_secondary_index_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("global_secondary_index_name")
        assert result is not None, "Required property 'global_secondary_index_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def table(self) -> aws_cdk.aws_dynamodb.ITable:
        '''
        :stability: experimental
        '''
        result = self._values.get("table")
        assert result is not None, "Required property 'table' is missing"
        return typing.cast(aws_cdk.aws_dynamodb.ITable, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DynamoTableGlobalSecondaryIndexMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class DynamoTableMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.DynamoTableMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        table: aws_cdk.aws_dynamodb.ITable,
    ) -> None:
        '''
        :param metric_factory: -
        :param table: 

        :stability: experimental
        '''
        props = DynamoTableMetricFactoryProps(table=table)

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricAverageSuccessfulRequestLatencyInMillis")
    def metric_average_successful_request_latency_in_millis(
        self,
        operation: aws_cdk.aws_dynamodb.Operation,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''
        :param operation: -

        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricAverageSuccessfulRequestLatencyInMillis", [operation]))

    @jsii.member(jsii_name="metricConsumedReadCapacityUnits")
    def metric_consumed_read_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricConsumedReadCapacityUnits", []))

    @jsii.member(jsii_name="metricConsumedWriteCapacityUnits")
    def metric_consumed_write_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricConsumedWriteCapacityUnits", []))

    @jsii.member(jsii_name="metricProvisionedReadCapacityUnits")
    def metric_provisioned_read_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricProvisionedReadCapacityUnits", []))

    @jsii.member(jsii_name="metricProvisionedWriteCapacityUnits")
    def metric_provisioned_write_capacity_units(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricProvisionedWriteCapacityUnits", []))

    @jsii.member(jsii_name="metricReadCapacityUtilizationPercentage")
    def metric_read_capacity_utilization_percentage(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricReadCapacityUtilizationPercentage", []))

    @jsii.member(jsii_name="metricSearchAverageSuccessfulRequestLatencyInMillis")
    def metric_search_average_successful_request_latency_in_millis(
        self,
    ) -> aws_cdk.aws_cloudwatch.IMetric:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.IMetric, jsii.invoke(self, "metricSearchAverageSuccessfulRequestLatencyInMillis", []))

    @jsii.member(jsii_name="metricSystemErrorsCount")
    def metric_system_errors_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) This represents the number of requests that resulted in a 500 (server error) error code.

        It summarizes across the basic CRUD operations:
        GetItem, BatchGetItem, Scan, Query, GetRecords, PutItem, DeleteItem, UpdateItem, BatchWriteItem

        It’s usually equal to zero.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricSystemErrorsCount", []))

    @jsii.member(jsii_name="metricThrottledReadRequestCount")
    def metric_throttled_read_request_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottledReadRequestCount", []))

    @jsii.member(jsii_name="metricThrottledWriteRequestCount")
    def metric_throttled_write_request_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottledWriteRequestCount", []))

    @jsii.member(jsii_name="metricWriteCapacityUtilizationPercentage")
    def metric_write_capacity_utilization_percentage(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricWriteCapacityUtilizationPercentage", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="table")
    def _table(self) -> aws_cdk.aws_dynamodb.ITable:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_dynamodb.ITable, jsii.get(self, "table"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.DynamoTableMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"table": "table"},
)
class DynamoTableMetricFactoryProps:
    def __init__(self, *, table: aws_cdk.aws_dynamodb.ITable) -> None:
        '''
        :param table: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "table": table,
        }

    @builtins.property
    def table(self) -> aws_cdk.aws_dynamodb.ITable:
        '''
        :stability: experimental
        '''
        result = self._values.get("table")
        assert result is not None, "Required property 'table' is missing"
        return typing.cast(aws_cdk.aws_dynamodb.ITable, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "DynamoTableMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class EC2MetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.EC2MetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        auto_scaling_group: typing.Optional[aws_cdk.aws_autoscaling.IAutoScalingGroup] = None,
        instance_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param auto_scaling_group: (experimental) Auto-Scaling Group to monitor. Default: no Auto-Scaling Group filter
        :param instance_ids: (experimental) Selected IDs of EC2 instances to monitor. Default: no instance filter

        :stability: experimental
        '''
        props = EC2MetricFactoryProps(
            auto_scaling_group=auto_scaling_group, instance_ids=instance_ids
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricAverageCpuUtilisationPercent")
    def metric_average_cpu_utilisation_percent(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''(experimental) The percentage of allocated EC2 compute units that are currently in use on the instance.

        This metric identifies the processing power required to run an application on a selected instance.
        Depending on the instance type, tools in your operating system can show a lower percentage than
        CloudWatch when the instance is not allocated a full processor core.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "metricAverageCpuUtilisationPercent", []))

    @jsii.member(jsii_name="metricAverageDiskReadBytes")
    def metric_average_disk_read_bytes(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''(experimental) Bytes read from all instance store volumes available to the instance.

        This metric is used to determine the volume of the data the application reads from the hard disk of the instance.
        This can be used to determine the speed of the application.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "metricAverageDiskReadBytes", []))

    @jsii.member(jsii_name="metricAverageDiskReadOps")
    def metric_average_disk_read_ops(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''(experimental) Completed read operations from all instance store volumes available to the instance in a specified period of time.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "metricAverageDiskReadOps", []))

    @jsii.member(jsii_name="metricAverageDiskWriteBytes")
    def metric_average_disk_write_bytes(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''(experimental) Bytes written to all instance store volumes available to the instance.

        This metric is used to determine the volume of the data the application writes onto the hard disk of the instance.
        This can be used to determine the speed of the application.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "metricAverageDiskWriteBytes", []))

    @jsii.member(jsii_name="metricAverageDiskWriteOps")
    def metric_average_disk_write_ops(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''(experimental) Completed write operations to all instance store volumes available to the instance in a specified period of time.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "metricAverageDiskWriteOps", []))

    @jsii.member(jsii_name="metricAverageNetworkInRateBytes")
    def metric_average_network_in_rate_bytes(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''(experimental) The number of bytes received on all network interfaces by the instance.

        This metric identifies the volume of incoming network traffic to a single instance.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "metricAverageNetworkInRateBytes", []))

    @jsii.member(jsii_name="metricAverageNetworkOutRateBytes")
    def metric_average_network_out_rate_bytes(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''(experimental) The number of bytes sent out on all network interfaces by the instance.

        This metric identifies the volume of outgoing network traffic from a single instance.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "metricAverageNetworkOutRateBytes", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="strategy")
    def _strategy(self) -> "IEC2MetricFactoryStrategy":
        '''
        :stability: experimental
        '''
        return typing.cast("IEC2MetricFactoryStrategy", jsii.get(self, "strategy"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.EC2MetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "auto_scaling_group": "autoScalingGroup",
        "instance_ids": "instanceIds",
    },
)
class EC2MetricFactoryProps:
    def __init__(
        self,
        *,
        auto_scaling_group: typing.Optional[aws_cdk.aws_autoscaling.IAutoScalingGroup] = None,
        instance_ids: typing.Optional[typing.Sequence[builtins.str]] = None,
    ) -> None:
        '''
        :param auto_scaling_group: (experimental) Auto-Scaling Group to monitor. Default: no Auto-Scaling Group filter
        :param instance_ids: (experimental) Selected IDs of EC2 instances to monitor. Default: no instance filter

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if auto_scaling_group is not None:
            self._values["auto_scaling_group"] = auto_scaling_group
        if instance_ids is not None:
            self._values["instance_ids"] = instance_ids

    @builtins.property
    def auto_scaling_group(
        self,
    ) -> typing.Optional[aws_cdk.aws_autoscaling.IAutoScalingGroup]:
        '''(experimental) Auto-Scaling Group to monitor.

        :default: no Auto-Scaling Group filter

        :stability: experimental
        '''
        result = self._values.get("auto_scaling_group")
        return typing.cast(typing.Optional[aws_cdk.aws_autoscaling.IAutoScalingGroup], result)

    @builtins.property
    def instance_ids(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) Selected IDs of EC2 instances to monitor.

        :default: no instance filter

        :stability: experimental
        '''
        result = self._values.get("instance_ids")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "EC2MetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ElastiCacheAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.ElastiCacheAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addMaxEvictedItemsCountAlarm")
    def add_max_evicted_items_count_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "MaxItemsCountThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addMaxEvictedItemsCountAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addMaxItemsCountAlarm")
    def add_max_items_count_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "MaxItemsCountThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addMaxItemsCountAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addMaxUsedSwapMemoryAlarm")
    def add_max_used_swap_memory_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "MaxUsedSwapMemoryThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addMaxUsedSwapMemoryAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addMinFreeableMemoryAlarm")
    def add_min_freeable_memory_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "MinFreeableMemoryThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addMinFreeableMemoryAlarm", [metric, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


class ElastiCacheClusterMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.ElastiCacheClusterMetricFactory",
):
    '''
    :see: https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheMetrics.html
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        cluster_id: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param cluster_id: (experimental) Cluster to monitor. Default: monitor all clusters

        :stability: experimental
        '''
        props = ElastiCacheClusterMetricFactoryProps(cluster_id=cluster_id)

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricAverageCachedItemsSizeInBytes")
    def metric_average_cached_items_size_in_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricAverageCachedItemsSizeInBytes", []))

    @jsii.member(jsii_name="metricAverageConnections")
    def metric_average_connections(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricAverageConnections", []))

    @jsii.member(jsii_name="metricAverageFreeableMemoryInBytes")
    def metric_average_freeable_memory_in_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricAverageFreeableMemoryInBytes", []))

    @jsii.member(jsii_name="metricAverageSwapUsageInBytes")
    def metric_average_swap_usage_in_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricAverageSwapUsageInBytes", []))

    @jsii.member(jsii_name="metricAverageUnusedMemoryInBytes")
    def metric_average_unused_memory_in_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricAverageUnusedMemoryInBytes", []))

    @jsii.member(jsii_name="metricEvictions")
    def metric_evictions(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricEvictions", []))

    @jsii.member(jsii_name="metricMaxCpuUtilizationInPercent")
    def metric_max_cpu_utilization_in_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricMaxCpuUtilizationInPercent", []))

    @jsii.member(jsii_name="metricMaxItemCount")
    def metric_max_item_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricMaxItemCount", []))

    @jsii.member(jsii_name="metricNetworkBytesIn")
    def metric_network_bytes_in(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricNetworkBytesIn", []))

    @jsii.member(jsii_name="metricNetworkBytesOut")
    def metric_network_bytes_out(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricNetworkBytesOut", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.ElastiCacheClusterMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"cluster_id": "clusterId"},
)
class ElastiCacheClusterMetricFactoryProps:
    def __init__(self, *, cluster_id: typing.Optional[builtins.str] = None) -> None:
        '''
        :param cluster_id: (experimental) Cluster to monitor. Default: monitor all clusters

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if cluster_id is not None:
            self._values["cluster_id"] = cluster_id

    @builtins.property
    def cluster_id(self) -> typing.Optional[builtins.str]:
        '''(experimental) Cluster to monitor.

        :default: monitor all clusters

        :stability: experimental
        '''
        result = self._values.get("cluster_id")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ElastiCacheClusterMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.ElastiCacheClusterType")
class ElastiCacheClusterType(enum.Enum):
    '''
    :stability: experimental
    '''

    MEMCACHED = "MEMCACHED"
    '''
    :stability: experimental
    '''
    REDIS = "REDIS"
    '''
    :stability: experimental
    '''


@jsii.enum(jsii_type="cdk-monitoring-constructs.ElasticsearchClusterStatus")
class ElasticsearchClusterStatus(enum.Enum):
    '''
    :stability: experimental
    '''

    RED = "RED"
    '''
    :stability: experimental
    '''
    YELLOW = "YELLOW"
    '''
    :stability: experimental
    '''


class ErrorAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.ErrorAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addErrorCountAlarm")
    def add_error_count_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        error_type: "ErrorType",
        props: "ErrorCountThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param error_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addErrorCountAlarm", [metric, error_type, props, disambiguator]))

    @jsii.member(jsii_name="addErrorRateAlarm")
    def add_error_rate_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        error_type: "ErrorType",
        props: "ErrorRateThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param error_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addErrorRateAlarm", [metric, error_type, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.ErrorCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_error_count": "maxErrorCount",
    },
)
class ErrorCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_error_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_error_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_error_count": max_error_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_error_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_error_count")
        assert result is not None, "Required property 'max_error_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ErrorCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.ErrorRateThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_error_rate": "maxErrorRate",
    },
)
class ErrorRateThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_error_rate: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_error_rate: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_error_rate": max_error_rate,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_error_rate(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_error_rate")
        assert result is not None, "Required property 'max_error_rate' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ErrorRateThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.ErrorType")
class ErrorType(enum.Enum):
    '''
    :stability: experimental
    '''

    FAULT = "FAULT"
    '''
    :stability: experimental
    '''
    ERROR = "ERROR"
    '''
    :stability: experimental
    '''
    SYSTEM_ERROR = "SYSTEM_ERROR"
    '''
    :stability: experimental
    '''
    USER_ERROR = "USER_ERROR"
    '''
    :stability: experimental
    '''
    FAILURE = "FAILURE"
    '''
    :stability: experimental
    '''
    ABORTED = "ABORTED"
    '''
    :stability: experimental
    '''
    THROTTLED = "THROTTLED"
    '''
    :stability: experimental
    '''
    TIMED_OUT = "TIMED_OUT"
    '''
    :stability: experimental
    '''
    READ_ERROR = "READ_ERROR"
    '''
    :stability: experimental
    '''
    WRITE_ERROR = "WRITE_ERROR"
    '''
    :stability: experimental
    '''
    EXPIRED = "EXPIRED"
    '''
    :stability: experimental
    '''
    KILLED = "KILLED"
    '''
    :stability: experimental
    '''


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.FullRestartCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_full_restart_count": "maxFullRestartCount",
    },
)
class FullRestartCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_full_restart_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_full_restart_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_full_restart_count": max_full_restart_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_full_restart_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_full_restart_count")
        assert result is not None, "Required property 'max_full_restart_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "FullRestartCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class GlueJobMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.GlueJobMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        job_name: builtins.str,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param job_name: 
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        props = GlueJobMetricFactoryProps(
            job_name=job_name, rate_computation_method=rate_computation_method
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricActiveExecutorsAverage")
    def metric_active_executors_average(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricActiveExecutorsAverage", []))

    @jsii.member(jsii_name="metricAverageExecutorCpuUsagePercentage")
    def metric_average_executor_cpu_usage_percentage(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricAverageExecutorCpuUsagePercentage", []))

    @jsii.member(jsii_name="metricAverageExecutorMemoryUsagePercentage")
    def metric_average_executor_memory_usage_percentage(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricAverageExecutorMemoryUsagePercentage", []))

    @jsii.member(jsii_name="metricCompletedStagesSum")
    def metric_completed_stages_sum(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricCompletedStagesSum", []))

    @jsii.member(jsii_name="metricCompletedTasksSum")
    def metric_completed_tasks_sum(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricCompletedTasksSum", []))

    @jsii.member(jsii_name="metricFailedTasksRate")
    def metric_failed_tasks_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFailedTasksRate", []))

    @jsii.member(jsii_name="metricFailedTasksSum")
    def metric_failed_tasks_sum(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFailedTasksSum", []))

    @jsii.member(jsii_name="metricKilledTasksRate")
    def metric_killed_tasks_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricKilledTasksRate", []))

    @jsii.member(jsii_name="metricKilledTasksSum")
    def metric_killed_tasks_sum(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricKilledTasksSum", []))

    @jsii.member(jsii_name="metricMaximumNeededExecutors")
    def metric_maximum_needed_executors(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricMaximumNeededExecutors", []))

    @jsii.member(jsii_name="metricTotalReadBytesFromS3")
    def metric_total_read_bytes_from_s3(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTotalReadBytesFromS3", []))

    @jsii.member(jsii_name="metricTotalWrittenBytesToS3")
    def metric_total_written_bytes_to_s3(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTotalWrittenBytesToS3", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rateComputationMethod")
    def _rate_computation_method(self) -> "RateComputationMethod":
        '''
        :stability: experimental
        '''
        return typing.cast("RateComputationMethod", jsii.get(self, "rateComputationMethod"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.GlueJobMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "job_name": "jobName",
        "rate_computation_method": "rateComputationMethod",
    },
)
class GlueJobMetricFactoryProps:
    def __init__(
        self,
        *,
        job_name: builtins.str,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param job_name: 
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "job_name": job_name,
        }
        if rate_computation_method is not None:
            self._values["rate_computation_method"] = rate_computation_method

    @builtins.property
    def job_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("job_name")
        assert result is not None, "Required property 'job_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def rate_computation_method(self) -> typing.Optional["RateComputationMethod"]:
        '''
        :default: average

        :stability: experimental
        '''
        result = self._values.get("rate_computation_method")
        return typing.cast(typing.Optional["RateComputationMethod"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "GlueJobMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.GraphWidgetType")
class GraphWidgetType(enum.Enum):
    '''
    :stability: experimental
    '''

    LINE = "LINE"
    '''
    :stability: experimental
    '''
    STACKED_AREA = "STACKED_AREA"
    '''
    :stability: experimental
    '''
    PIE = "PIE"
    '''
    :stability: experimental
    '''
    BAR = "BAR"
    '''
    :stability: experimental
    '''


@jsii.enum(jsii_type="cdk-monitoring-constructs.HeaderLevel")
class HeaderLevel(enum.Enum):
    '''
    :stability: experimental
    '''

    LARGE = "LARGE"
    '''
    :stability: experimental
    '''
    MEDIUM = "MEDIUM"
    '''
    :stability: experimental
    '''
    SMALL = "SMALL"
    '''
    :stability: experimental
    '''


class HeaderWidget(
    aws_cdk.aws_cloudwatch.TextWidget,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.HeaderWidget",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        text: builtins.str,
        level: typing.Optional[HeaderLevel] = None,
    ) -> None:
        '''
        :param text: -
        :param level: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [text, level])


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.HealthyTaskCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_healthy_tasks": "minHealthyTasks",
    },
)
class HealthyTaskCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_healthy_tasks: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_healthy_tasks: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_healthy_tasks": min_healthy_tasks,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_healthy_tasks(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_healthy_tasks")
        assert result is not None, "Required property 'min_healthy_tasks' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HealthyTaskCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.HealthyTaskPercentThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_healthy_task_percent": "minHealthyTaskPercent",
    },
)
class HealthyTaskPercentThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_healthy_task_percent: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_healthy_task_percent: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_healthy_task_percent": min_healthy_task_percent,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_healthy_task_percent(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_healthy_task_percent")
        assert result is not None, "Required property 'min_healthy_task_percent' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HealthyTaskPercentThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.HighMessagesPublishedThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_messages_published_count": "maxMessagesPublishedCount",
    },
)
class HighMessagesPublishedThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_messages_published_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_messages_published_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_messages_published_count": max_messages_published_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_messages_published_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_messages_published_count")
        assert result is not None, "Required property 'max_messages_published_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HighMessagesPublishedThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.HighTpsThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_tps": "maxTps",
    },
)
class HighTpsThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional["IAlarmActionStrategy"] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_tps: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_tps: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_tps": max_tps,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional["IAlarmActionStrategy"]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional["IAlarmActionStrategy"], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_tps(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_tps")
        assert result is not None, "Required property 'max_tps' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "HighTpsThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.interface(jsii_type="cdk-monitoring-constructs.IAlarmActionStrategy")
class IAlarmActionStrategy(typing_extensions.Protocol):
    '''(experimental) An object that appends actions to alarms.

    :stability: experimental
    '''

    @jsii.member(jsii_name="addAlarmActions")
    def add_alarm_actions(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.AlarmBase,
        action: "IAlarmActionStrategy",
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarm: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        ...


class _IAlarmActionStrategyProxy:
    '''(experimental) An object that appends actions to alarms.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IAlarmActionStrategy"

    @jsii.member(jsii_name="addAlarmActions")
    def add_alarm_actions(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.AlarmBase,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarm: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        props = AlarmActionStrategyProps(
            alarm=alarm,
            action=action,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string=dedupe_string,
            disambiguator=disambiguator,
        )

        return typing.cast(None, jsii.invoke(self, "addAlarmActions", [props]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IAlarmActionStrategy).__jsii_proxy_class__ = lambda : _IAlarmActionStrategyProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IAlarmAnnotationStrategy")
class IAlarmAnnotationStrategy(typing_extensions.Protocol):
    '''(experimental) Helper class for creating annotations for alarms.

    :stability: experimental
    '''

    @jsii.member(jsii_name="createAnnotation")
    def create_annotation(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.Alarm,
        comparison_operator: aws_cdk.aws_cloudwatch.ComparisonOperator,
        datapoints_to_alarm: jsii.Number,
        evaluation_periods: jsii.Number,
        fill_alarm_range: builtins.bool,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        threshold: jsii.Number,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.HorizontalAnnotation:
        '''(experimental) Creates annotation based on the metric and alarm properties.

        :param alarm: 
        :param comparison_operator: 
        :param datapoints_to_alarm: 
        :param evaluation_periods: 
        :param fill_alarm_range: 
        :param metric: 
        :param threshold: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        ...


class _IAlarmAnnotationStrategyProxy:
    '''(experimental) Helper class for creating annotations for alarms.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IAlarmAnnotationStrategy"

    @jsii.member(jsii_name="createAnnotation")
    def create_annotation(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.Alarm,
        comparison_operator: aws_cdk.aws_cloudwatch.ComparisonOperator,
        datapoints_to_alarm: jsii.Number,
        evaluation_periods: jsii.Number,
        fill_alarm_range: builtins.bool,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        threshold: jsii.Number,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.HorizontalAnnotation:
        '''(experimental) Creates annotation based on the metric and alarm properties.

        :param alarm: 
        :param comparison_operator: 
        :param datapoints_to_alarm: 
        :param evaluation_periods: 
        :param fill_alarm_range: 
        :param metric: 
        :param threshold: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        props = AlarmAnnotationStrategyProps(
            alarm=alarm,
            comparison_operator=comparison_operator,
            datapoints_to_alarm=datapoints_to_alarm,
            evaluation_periods=evaluation_periods,
            fill_alarm_range=fill_alarm_range,
            metric=metric,
            threshold=threshold,
            action=action,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string=dedupe_string,
            disambiguator=disambiguator,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.HorizontalAnnotation, jsii.invoke(self, "createAnnotation", [props]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IAlarmAnnotationStrategy).__jsii_proxy_class__ = lambda : _IAlarmAnnotationStrategyProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IAlarmConsumer")
class IAlarmConsumer(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @jsii.member(jsii_name="consume")
    def consume(self, alarms: typing.Sequence[AlarmWithAnnotation]) -> None:
        '''
        :param alarms: -

        :stability: experimental
        '''
        ...


class _IAlarmConsumerProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IAlarmConsumer"

    @jsii.member(jsii_name="consume")
    def consume(self, alarms: typing.Sequence[AlarmWithAnnotation]) -> None:
        '''
        :param alarms: -

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "consume", [alarms]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IAlarmConsumer).__jsii_proxy_class__ = lambda : _IAlarmConsumerProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IAlarmDedupeStringProcessor")
class IAlarmDedupeStringProcessor(typing_extensions.Protocol):
    '''(experimental) Strategy used to finalize dedupe string.

    :stability: experimental
    '''

    @jsii.member(jsii_name="processDedupeString")
    def process_dedupe_string(self, dedupe_string: builtins.str) -> builtins.str:
        '''(experimental) Process the dedupe string which was auto-generated.

        :param dedupe_string: -

        :return: final dedupe string

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="processDedupeStringOverride")
    def process_dedupe_string_override(
        self,
        dedupe_string: builtins.str,
    ) -> builtins.str:
        '''(experimental) Process the dedupe string which was specified by the user as an override.

        :param dedupe_string: -

        :return: final dedupe string

        :stability: experimental
        '''
        ...


class _IAlarmDedupeStringProcessorProxy:
    '''(experimental) Strategy used to finalize dedupe string.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IAlarmDedupeStringProcessor"

    @jsii.member(jsii_name="processDedupeString")
    def process_dedupe_string(self, dedupe_string: builtins.str) -> builtins.str:
        '''(experimental) Process the dedupe string which was auto-generated.

        :param dedupe_string: -

        :return: final dedupe string

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "processDedupeString", [dedupe_string]))

    @jsii.member(jsii_name="processDedupeStringOverride")
    def process_dedupe_string_override(
        self,
        dedupe_string: builtins.str,
    ) -> builtins.str:
        '''(experimental) Process the dedupe string which was specified by the user as an override.

        :param dedupe_string: -

        :return: final dedupe string

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "processDedupeStringOverride", [dedupe_string]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IAlarmDedupeStringProcessor).__jsii_proxy_class__ = lambda : _IAlarmDedupeStringProcessorProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IDashboardFactory")
class IDashboardFactory(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @jsii.member(jsii_name="addSegment")
    def add_segment(self, props: "IDashboardFactoryProps") -> None:
        '''
        :param props: -

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="createdAlarmDashboard")
    def created_alarm_dashboard(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.Dashboard]:
        '''
        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="createdDashboard")
    def created_dashboard(self) -> typing.Optional[aws_cdk.aws_cloudwatch.Dashboard]:
        '''
        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="createdSummaryDashboard")
    def created_summary_dashboard(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.Dashboard]:
        '''
        :stability: experimental
        '''
        ...


class _IDashboardFactoryProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IDashboardFactory"

    @jsii.member(jsii_name="addSegment")
    def add_segment(self, props: "IDashboardFactoryProps") -> None:
        '''
        :param props: -

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "addSegment", [props]))

    @jsii.member(jsii_name="createdAlarmDashboard")
    def created_alarm_dashboard(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.Dashboard]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.Dashboard], jsii.invoke(self, "createdAlarmDashboard", []))

    @jsii.member(jsii_name="createdDashboard")
    def created_dashboard(self) -> typing.Optional[aws_cdk.aws_cloudwatch.Dashboard]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.Dashboard], jsii.invoke(self, "createdDashboard", []))

    @jsii.member(jsii_name="createdSummaryDashboard")
    def created_summary_dashboard(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.Dashboard]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.Dashboard], jsii.invoke(self, "createdSummaryDashboard", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IDashboardFactory).__jsii_proxy_class__ = lambda : _IDashboardFactoryProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IDashboardFactoryProps")
class IDashboardFactoryProps(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="segment")
    def segment(self) -> "IDashboardSegment":
        '''(experimental) Segment to be placed on the dashboard.

        :stability: experimental
        '''
        ...

    @segment.setter
    def segment(self, value: "IDashboardSegment") -> None:
        ...

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="overrideProps")
    def override_props(self) -> typing.Optional["MonitoringDashboardsOverrideProps"]:
        '''(experimental) Dashboard placement override props.

        :default: all default

        :stability: experimental
        '''
        ...

    @override_props.setter
    def override_props(
        self,
        value: typing.Optional["MonitoringDashboardsOverrideProps"],
    ) -> None:
        ...


class _IDashboardFactoryPropsProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IDashboardFactoryProps"

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="segment")
    def segment(self) -> "IDashboardSegment":
        '''(experimental) Segment to be placed on the dashboard.

        :stability: experimental
        '''
        return typing.cast("IDashboardSegment", jsii.get(self, "segment"))

    @segment.setter
    def segment(self, value: "IDashboardSegment") -> None:
        jsii.set(self, "segment", value)

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="overrideProps")
    def override_props(self) -> typing.Optional["MonitoringDashboardsOverrideProps"]:
        '''(experimental) Dashboard placement override props.

        :default: all default

        :stability: experimental
        '''
        return typing.cast(typing.Optional["MonitoringDashboardsOverrideProps"], jsii.get(self, "overrideProps"))

    @override_props.setter
    def override_props(
        self,
        value: typing.Optional["MonitoringDashboardsOverrideProps"],
    ) -> None:
        jsii.set(self, "overrideProps", value)

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IDashboardFactoryProps).__jsii_proxy_class__ = lambda : _IDashboardFactoryPropsProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IDashboardSegment")
class IDashboardSegment(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @jsii.member(jsii_name="alarmWidgets")
    def alarm_widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets for all alarms.

        These should go to the runbook or service dashboard.

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="summaryWidgets")
    def summary_widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets for the summary.

        These should go to the team OPS dashboard.

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="widgets")
    def widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns all widgets.

        These should go to the detailed service dashboard.

        :stability: experimental
        '''
        ...


class _IDashboardSegmentProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IDashboardSegment"

    @jsii.member(jsii_name="alarmWidgets")
    def alarm_widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets for all alarms.

        These should go to the runbook or service dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "alarmWidgets", []))

    @jsii.member(jsii_name="summaryWidgets")
    def summary_widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets for the summary.

        These should go to the team OPS dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "summaryWidgets", []))

    @jsii.member(jsii_name="widgets")
    def widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns all widgets.

        These should go to the detailed service dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "widgets", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IDashboardSegment).__jsii_proxy_class__ = lambda : _IDashboardSegmentProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IEC2MetricFactoryStrategy")
class IEC2MetricFactoryStrategy(typing_extensions.Protocol):
    '''
    :stability: experimental
    '''

    @jsii.member(jsii_name="createMetrics")
    def create_metrics(
        self,
        metric_factory: "MetricFactory",
        metric_name: builtins.str,
        statistic: "MetricStatistic",
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''
        :param metric_factory: -
        :param metric_name: -
        :param statistic: -

        :stability: experimental
        '''
        ...


class _IEC2MetricFactoryStrategyProxy:
    '''
    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IEC2MetricFactoryStrategy"

    @jsii.member(jsii_name="createMetrics")
    def create_metrics(
        self,
        metric_factory: "MetricFactory",
        metric_name: builtins.str,
        statistic: "MetricStatistic",
    ) -> typing.List[aws_cdk.aws_cloudwatch.IMetric]:
        '''
        :param metric_factory: -
        :param metric_name: -
        :param statistic: -

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IMetric], jsii.invoke(self, "createMetrics", [metric_factory, metric_name, statistic]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IEC2MetricFactoryStrategy).__jsii_proxy_class__ = lambda : _IEC2MetricFactoryStrategyProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.ILoadBalancerMetricFactory")
class ILoadBalancerMetricFactory(typing_extensions.Protocol):
    '''(experimental) Common interface for load-balancer based service metric factories.

    :stability: experimental
    '''

    @jsii.member(jsii_name="metricActiveConnectionCount")
    def metric_active_connection_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="metricHealthyTaskCount")
    def metric_healthy_task_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="metricHealthyTaskInPercent")
    def metric_healthy_task_in_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="metricNewConnectionCount")
    def metric_new_connection_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="metricProcessedBytesMin")
    def metric_processed_bytes_min(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="metricUnhealthyTaskCount")
    def metric_unhealthy_task_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        ...


class _ILoadBalancerMetricFactoryProxy:
    '''(experimental) Common interface for load-balancer based service metric factories.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.ILoadBalancerMetricFactory"

    @jsii.member(jsii_name="metricActiveConnectionCount")
    def metric_active_connection_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricActiveConnectionCount", []))

    @jsii.member(jsii_name="metricHealthyTaskCount")
    def metric_healthy_task_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricHealthyTaskCount", []))

    @jsii.member(jsii_name="metricHealthyTaskInPercent")
    def metric_healthy_task_in_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricHealthyTaskInPercent", []))

    @jsii.member(jsii_name="metricNewConnectionCount")
    def metric_new_connection_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricNewConnectionCount", []))

    @jsii.member(jsii_name="metricProcessedBytesMin")
    def metric_processed_bytes_min(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricProcessedBytesMin", []))

    @jsii.member(jsii_name="metricUnhealthyTaskCount")
    def metric_unhealthy_task_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricUnhealthyTaskCount", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, ILoadBalancerMetricFactory).__jsii_proxy_class__ = lambda : _ILoadBalancerMetricFactoryProxy


@jsii.interface(jsii_type="cdk-monitoring-constructs.IWidgetFactory")
class IWidgetFactory(typing_extensions.Protocol):
    '''(experimental) Strategy for creating widgets.

    :stability: experimental
    '''

    @jsii.member(jsii_name="createAlarmDetailWidget")
    def create_alarm_detail_widget(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.Alarm,
        alarm_description: builtins.str,
        alarm_label: builtins.str,
        alarm_name: builtins.str,
        alarm_name_suffix: builtins.str,
        alarm_rule_when_alarming: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_insufficient_data: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_ok: aws_cdk.aws_cloudwatch.IAlarmRule,
        annotation: aws_cdk.aws_cloudwatch.HorizontalAnnotation,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.IWidget:
        '''(experimental) Create widget representing an alarm detail.

        :param alarm: 
        :param alarm_description: 
        :param alarm_label: 
        :param alarm_name: 
        :param alarm_name_suffix: 
        :param alarm_rule_when_alarming: 
        :param alarm_rule_when_insufficient_data: 
        :param alarm_rule_when_ok: 
        :param annotation: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        ...


class _IWidgetFactoryProxy:
    '''(experimental) Strategy for creating widgets.

    :stability: experimental
    '''

    __jsii_type__: typing.ClassVar[str] = "cdk-monitoring-constructs.IWidgetFactory"

    @jsii.member(jsii_name="createAlarmDetailWidget")
    def create_alarm_detail_widget(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.Alarm,
        alarm_description: builtins.str,
        alarm_label: builtins.str,
        alarm_name: builtins.str,
        alarm_name_suffix: builtins.str,
        alarm_rule_when_alarming: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_insufficient_data: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_ok: aws_cdk.aws_cloudwatch.IAlarmRule,
        annotation: aws_cdk.aws_cloudwatch.HorizontalAnnotation,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> aws_cdk.aws_cloudwatch.IWidget:
        '''(experimental) Create widget representing an alarm detail.

        :param alarm: 
        :param alarm_description: 
        :param alarm_label: 
        :param alarm_name: 
        :param alarm_name_suffix: 
        :param alarm_rule_when_alarming: 
        :param alarm_rule_when_insufficient_data: 
        :param alarm_rule_when_ok: 
        :param annotation: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        alarm_ = AlarmWithAnnotation(
            alarm=alarm,
            alarm_description=alarm_description,
            alarm_label=alarm_label,
            alarm_name=alarm_name,
            alarm_name_suffix=alarm_name_suffix,
            alarm_rule_when_alarming=alarm_rule_when_alarming,
            alarm_rule_when_insufficient_data=alarm_rule_when_insufficient_data,
            alarm_rule_when_ok=alarm_rule_when_ok,
            annotation=annotation,
            action=action,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string=dedupe_string,
            disambiguator=disambiguator,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.IWidget, jsii.invoke(self, "createAlarmDetailWidget", [alarm_]))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the interface
typing.cast(typing.Any, IWidgetFactory).__jsii_proxy_class__ = lambda : _IWidgetFactoryProxy


class KeyValueTableWidget(
    aws_cdk.aws_cloudwatch.TextWidget,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.KeyValueTableWidget",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        data: typing.Sequence[typing.Mapping[typing.Any, typing.Any]],
    ) -> None:
        '''
        :param data: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [data])


class KinesisAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.KinesisAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addIteratorMaxAgeAlarm")
    def add_iterator_max_age_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "MaxIteratorAgeThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addIteratorMaxAgeAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addProvisionedReadThroughputExceededAlarm")
    def add_provisioned_read_throughput_exceeded_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "RecordsThrottledThreshold",
        disambiguator: builtins.str,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addProvisionedReadThroughputExceededAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addProvisionedWriteThroughputExceededAlarm")
    def add_provisioned_write_throughput_exceeded_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "RecordsThrottledThreshold",
        disambiguator: builtins.str,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addProvisionedWriteThroughputExceededAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addPutRecordsFailedAlarm")
    def add_put_records_failed_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "RecordsFailedThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addPutRecordsFailedAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addPutRecordsThrottledAlarm")
    def add_put_records_throttled_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "RecordsThrottledThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addPutRecordsThrottledAlarm", [metric, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


class KinesisDataAnalyticsAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.KinesisDataAnalyticsAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addDowntimeAlarm")
    def add_downtime_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: "MaxDowntimeThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addDowntimeAlarm", [metric, props, disambiguator]))

    @jsii.member(jsii_name="addFullRestartAlarm")
    def add_full_restart_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        props: FullRestartCountThreshold,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addFullRestartAlarm", [metric, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


class KinesisDataAnalyticsMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.KinesisDataAnalyticsMetricFactory",
):
    '''
    :see: https://docs.aws.amazon.com/kinesisanalytics/latest/java/metrics-dimensions.html
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        application: builtins.str,
    ) -> None:
        '''
        :param metric_factory: -
        :param application: 

        :stability: experimental
        '''
        props = KinesisDataAnalyticsMetricFactoryProps(application=application)

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricCpuUtilizationPercent")
    def metric_cpu_utilization_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricCpuUtilizationPercent", []))

    @jsii.member(jsii_name="metricDowntimeMs")
    def metric_downtime_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricDowntimeMs", []))

    @jsii.member(jsii_name="metricFullRestartsCount")
    def metric_full_restarts_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFullRestartsCount", []))

    @jsii.member(jsii_name="metricHeapMemoryUtilizationPercent")
    def metric_heap_memory_utilization_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricHeapMemoryUtilizationPercent", []))

    @jsii.member(jsii_name="metricKPUsCount")
    def metric_kp_us_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricKPUsCount", []))

    @jsii.member(jsii_name="metricLastCheckpointDurationMs")
    def metric_last_checkpoint_duration_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLastCheckpointDurationMs", []))

    @jsii.member(jsii_name="metricLastCheckpointSizeBytes")
    def metric_last_checkpoint_size_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLastCheckpointSizeBytes", []))

    @jsii.member(jsii_name="metricNumberOfFailedCheckpointsCount")
    def metric_number_of_failed_checkpoints_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricNumberOfFailedCheckpointsCount", []))

    @jsii.member(jsii_name="metricOldGenerationGCCount")
    def metric_old_generation_gc_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricOldGenerationGCCount", []))

    @jsii.member(jsii_name="metricOldGenerationGCTimeMs")
    def metric_old_generation_gc_time_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricOldGenerationGCTimeMs", []))

    @jsii.member(jsii_name="metricUptimeMs")
    def metric_uptime_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricUptimeMs", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.KinesisDataAnalyticsMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"application": "application"},
)
class KinesisDataAnalyticsMetricFactoryProps:
    def __init__(self, *, application: builtins.str) -> None:
        '''
        :param application: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "application": application,
        }

    @builtins.property
    def application(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("application")
        assert result is not None, "Required property 'application' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KinesisDataAnalyticsMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KinesisDataStreamMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.KinesisDataStreamMetricFactory",
):
    '''
    :see: https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        stream_name: builtins.str,
    ) -> None:
        '''
        :param metric_factory: -
        :param stream_name: 

        :stability: experimental
        '''
        props = KinesisDataStreamMetricFactoryProps(stream_name=stream_name)

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricGetRecordsIteratorAgeMaxMs")
    def metric_get_records_iterator_age_max_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGetRecordsIteratorAgeMaxMs", []))

    @jsii.member(jsii_name="metricGetRecordsLatencyAverageMs")
    def metric_get_records_latency_average_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGetRecordsLatencyAverageMs", []))

    @jsii.member(jsii_name="metricGetRecordsSuccessCount")
    def metric_get_records_success_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGetRecordsSuccessCount", []))

    @jsii.member(jsii_name="metricGetRecordsSumBytes")
    def metric_get_records_sum_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGetRecordsSumBytes", []))

    @jsii.member(jsii_name="metricGetRecordsSumCount")
    def metric_get_records_sum_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricGetRecordsSumCount", []))

    @jsii.member(jsii_name="metricIncomingDataSumBytes")
    def metric_incoming_data_sum_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingDataSumBytes", []))

    @jsii.member(jsii_name="metricIncomingDataSumCount")
    def metric_incoming_data_sum_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingDataSumCount", []))

    @jsii.member(jsii_name="metricPutRecordLatencyAverageMs")
    def metric_put_record_latency_average_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordLatencyAverageMs", []))

    @jsii.member(jsii_name="metricPutRecordsFailedRecordsCount")
    def metric_put_records_failed_records_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordsFailedRecordsCount", []))

    @jsii.member(jsii_name="metricPutRecordsLatencyAverageMs")
    def metric_put_records_latency_average_ms(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordsLatencyAverageMs", []))

    @jsii.member(jsii_name="metricPutRecordsSuccessCount")
    def metric_put_records_success_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordsSuccessCount", []))

    @jsii.member(jsii_name="metricPutRecordsSuccessfulRecordsCount")
    def metric_put_records_successful_records_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordsSuccessfulRecordsCount", []))

    @jsii.member(jsii_name="metricPutRecordsSumBytes")
    def metric_put_records_sum_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordsSumBytes", []))

    @jsii.member(jsii_name="metricPutRecordsThrottledRecordsCount")
    def metric_put_records_throttled_records_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordsThrottledRecordsCount", []))

    @jsii.member(jsii_name="metricPutRecordsTotalRecordsCount")
    def metric_put_records_total_records_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordsTotalRecordsCount", []))

    @jsii.member(jsii_name="metricPutRecordSuccessCount")
    def metric_put_record_success_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordSuccessCount", []))

    @jsii.member(jsii_name="metricPutRecordSumBytes")
    def metric_put_record_sum_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordSumBytes", []))

    @jsii.member(jsii_name="metricReadProvisionedThroughputExceededPercent")
    def metric_read_provisioned_throughput_exceeded_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricReadProvisionedThroughputExceededPercent", []))

    @jsii.member(jsii_name="metricWriteProvisionedThroughputExceededPercent")
    def metric_write_provisioned_throughput_exceeded_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricWriteProvisionedThroughputExceededPercent", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.KinesisDataStreamMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"stream_name": "streamName"},
)
class KinesisDataStreamMetricFactoryProps:
    def __init__(self, *, stream_name: builtins.str) -> None:
        '''
        :param stream_name: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "stream_name": stream_name,
        }

    @builtins.property
    def stream_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("stream_name")
        assert result is not None, "Required property 'stream_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KinesisDataStreamMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class KinesisFirehoseMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.KinesisFirehoseMetricFactory",
):
    '''
    :see: https://docs.aws.amazon.com/firehose/latest/dev/monitoring-with-cloudwatch-metrics.html
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        delivery_stream_name: builtins.str,
    ) -> None:
        '''
        :param metric_factory: -
        :param delivery_stream_name: 

        :stability: experimental
        '''
        props = KinesisFirehoseMetricFactoryProps(
            delivery_stream_name=delivery_stream_name
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricBytesPerSecondLimit")
    def metric_bytes_per_second_limit(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricBytesPerSecondLimit", []))

    @jsii.member(jsii_name="metricFailedConversionCount")
    def metric_failed_conversion_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFailedConversionCount", []))

    @jsii.member(jsii_name="metricIncomingBytes")
    def metric_incoming_bytes(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingBytes", []))

    @jsii.member(jsii_name="metricIncomingBytesToLimitRate")
    def metric_incoming_bytes_to_limit_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingBytesToLimitRate", []))

    @jsii.member(jsii_name="metricIncomingPutRequests")
    def metric_incoming_put_requests(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingPutRequests", []))

    @jsii.member(jsii_name="metricIncomingPutRequestsToLimitRate")
    def metric_incoming_put_requests_to_limit_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingPutRequestsToLimitRate", []))

    @jsii.member(jsii_name="metricIncomingRecordCount")
    def metric_incoming_record_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingRecordCount", []))

    @jsii.member(jsii_name="metricIncomingRecordsToLimitRate")
    def metric_incoming_records_to_limit_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricIncomingRecordsToLimitRate", []))

    @jsii.member(jsii_name="metricPutRecordBatchLatencyP90InMillis")
    def metric_put_record_batch_latency_p90_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordBatchLatencyP90InMillis", []))

    @jsii.member(jsii_name="metricPutRecordLatencyP90InMillis")
    def metric_put_record_latency_p90_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRecordLatencyP90InMillis", []))

    @jsii.member(jsii_name="metricPutRequestsPerSecondLimit")
    def metric_put_requests_per_second_limit(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricPutRequestsPerSecondLimit", []))

    @jsii.member(jsii_name="metricRecordsPerSecondLimit")
    def metric_records_per_second_limit(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricRecordsPerSecondLimit", []))

    @jsii.member(jsii_name="metricSuccessfulConversionCount")
    def metric_successful_conversion_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricSuccessfulConversionCount", []))

    @jsii.member(jsii_name="metricThrottledRecordCount")
    def metric_throttled_record_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottledRecordCount", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="dimensionsMap")
    def _dimensions_map(self) -> typing.Mapping[builtins.str, builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Mapping[builtins.str, builtins.str], jsii.get(self, "dimensionsMap"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.KinesisFirehoseMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"delivery_stream_name": "deliveryStreamName"},
)
class KinesisFirehoseMetricFactoryProps:
    def __init__(self, *, delivery_stream_name: builtins.str) -> None:
        '''
        :param delivery_stream_name: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "delivery_stream_name": delivery_stream_name,
        }

    @builtins.property
    def delivery_stream_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("delivery_stream_name")
        assert result is not None, "Required property 'delivery_stream_name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "KinesisFirehoseMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LambdaFunctionEnhancedMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.LambdaFunctionEnhancedMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        lambda_function: aws_cdk.aws_lambda.IFunction,
    ) -> None:
        '''
        :param metric_factory: -
        :param lambda_function: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [metric_factory, lambda_function])

    @jsii.member(jsii_name="enhancedMetricAvgCpuTotalTime")
    def enhanced_metric_avg_cpu_total_time(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "enhancedMetricAvgCpuTotalTime", []))

    @jsii.member(jsii_name="enhancedMetricAvgMemoryUtilization")
    def enhanced_metric_avg_memory_utilization(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "enhancedMetricAvgMemoryUtilization", []))

    @jsii.member(jsii_name="enhancedMetricFunctionCost")
    def enhanced_metric_function_cost(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "enhancedMetricFunctionCost", []))

    @jsii.member(jsii_name="enhancedMetricMaxCpuTotalTime")
    def enhanced_metric_max_cpu_total_time(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "enhancedMetricMaxCpuTotalTime", []))

    @jsii.member(jsii_name="enhancedMetricMaxMemoryUtilization")
    def enhanced_metric_max_memory_utilization(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "enhancedMetricMaxMemoryUtilization", []))

    @jsii.member(jsii_name="enhancedMetricP90CpuTotalTime")
    def enhanced_metric_p90_cpu_total_time(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "enhancedMetricP90CpuTotalTime", []))

    @jsii.member(jsii_name="enhancedMetricP90MemoryUtilization")
    def enhanced_metric_p90_memory_utilization(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "enhancedMetricP90MemoryUtilization", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lambdaFunction")
    def _lambda_function(self) -> aws_cdk.aws_lambda.IFunction:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_lambda.IFunction, jsii.get(self, "lambdaFunction"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))


class LambdaFunctionMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.LambdaFunctionMetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: "MetricFactory",
        *,
        lambda_function: aws_cdk.aws_lambda.IFunction,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        lambda_insights_enabled: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param metric_factory: -
        :param lambda_function: 
        :param fill_tps_with_zeroes: Default: true
        :param lambda_insights_enabled: (experimental) Generate dashboard charts for Lambda Insights metrics. To enable Lambda Insights on your Lambda function, see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-clouddevelopmentkit.html Default: false
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        props = LambdaFunctionMetricFactoryProps(
            lambda_function=lambda_function,
            fill_tps_with_zeroes=fill_tps_with_zeroes,
            lambda_insights_enabled=lambda_insights_enabled,
            rate_computation_method=rate_computation_method,
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricConcurrentExecutions")
    def metric_concurrent_executions(self) -> aws_cdk.aws_cloudwatch.Metric:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricConcurrentExecutions", []))

    @jsii.member(jsii_name="metricFaultCount")
    def metric_fault_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFaultCount", []))

    @jsii.member(jsii_name="metricFaultRate")
    def metric_fault_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricFaultRate", []))

    @jsii.member(jsii_name="metricInvocationCount")
    def metric_invocation_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricInvocationCount", []))

    @jsii.member(jsii_name="metricInvocationRate")
    def metric_invocation_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricInvocationRate", []))

    @jsii.member(jsii_name="metricLatencyP50InMillis")
    def metric_latency_p50_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP50InMillis", []))

    @jsii.member(jsii_name="metricLatencyP90InMillis")
    def metric_latency_p90_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP90InMillis", []))

    @jsii.member(jsii_name="metricLatencyP99InMillis")
    def metric_latency_p99_in_millis(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricLatencyP99InMillis", []))

    @jsii.member(jsii_name="metricMaxIteratorAgeInMillis")
    def metric_max_iterator_age_in_millis(self) -> aws_cdk.aws_cloudwatch.Metric:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricMaxIteratorAgeInMillis", []))

    @jsii.member(jsii_name="metricProvisionedConcurrencySpilloverInvocations")
    def metric_provisioned_concurrency_spillover_invocations(
        self,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricProvisionedConcurrencySpilloverInvocations", []))

    @jsii.member(jsii_name="metricProvisionedConcurrencySpilloverRate")
    def metric_provisioned_concurrency_spillover_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricProvisionedConcurrencySpilloverRate", []))

    @jsii.member(jsii_name="metricThrottlesCount")
    def metric_throttles_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottlesCount", []))

    @jsii.member(jsii_name="metricThrottlesRate")
    def metric_throttles_rate(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricThrottlesRate", []))

    @jsii.member(jsii_name="metricTps")
    def metric_tps(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :deprecated: use metricInvocationRate

        :stability: deprecated
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricTps", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="fillTpsWithZeroes")
    def _fill_tps_with_zeroes(self) -> builtins.bool:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.bool, jsii.get(self, "fillTpsWithZeroes"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="lambdaFunction")
    def _lambda_function(self) -> aws_cdk.aws_lambda.IFunction:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_lambda.IFunction, jsii.get(self, "lambdaFunction"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> "MetricFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactory", jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="rateComputationMethod")
    def _rate_computation_method(self) -> "RateComputationMethod":
        '''
        :stability: experimental
        '''
        return typing.cast("RateComputationMethod", jsii.get(self, "rateComputationMethod"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.LambdaFunctionMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "lambda_function": "lambdaFunction",
        "fill_tps_with_zeroes": "fillTpsWithZeroes",
        "lambda_insights_enabled": "lambdaInsightsEnabled",
        "rate_computation_method": "rateComputationMethod",
    },
)
class LambdaFunctionMetricFactoryProps:
    def __init__(
        self,
        *,
        lambda_function: aws_cdk.aws_lambda.IFunction,
        fill_tps_with_zeroes: typing.Optional[builtins.bool] = None,
        lambda_insights_enabled: typing.Optional[builtins.bool] = None,
        rate_computation_method: typing.Optional["RateComputationMethod"] = None,
    ) -> None:
        '''
        :param lambda_function: 
        :param fill_tps_with_zeroes: Default: true
        :param lambda_insights_enabled: (experimental) Generate dashboard charts for Lambda Insights metrics. To enable Lambda Insights on your Lambda function, see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-clouddevelopmentkit.html Default: false
        :param rate_computation_method: Default: average

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "lambda_function": lambda_function,
        }
        if fill_tps_with_zeroes is not None:
            self._values["fill_tps_with_zeroes"] = fill_tps_with_zeroes
        if lambda_insights_enabled is not None:
            self._values["lambda_insights_enabled"] = lambda_insights_enabled
        if rate_computation_method is not None:
            self._values["rate_computation_method"] = rate_computation_method

    @builtins.property
    def lambda_function(self) -> aws_cdk.aws_lambda.IFunction:
        '''
        :stability: experimental
        '''
        result = self._values.get("lambda_function")
        assert result is not None, "Required property 'lambda_function' is missing"
        return typing.cast(aws_cdk.aws_lambda.IFunction, result)

    @builtins.property
    def fill_tps_with_zeroes(self) -> typing.Optional[builtins.bool]:
        '''
        :default: true

        :stability: experimental
        '''
        result = self._values.get("fill_tps_with_zeroes")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def lambda_insights_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Generate dashboard charts for Lambda Insights metrics.

        To enable Lambda Insights on your Lambda function, see
        https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-Getting-Started-clouddevelopmentkit.html

        :default: false

        :stability: experimental
        '''
        result = self._values.get("lambda_insights_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def rate_computation_method(self) -> typing.Optional["RateComputationMethod"]:
        '''
        :default: average

        :stability: experimental
        '''
        result = self._values.get("rate_computation_method")
        return typing.cast(typing.Optional["RateComputationMethod"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LambdaFunctionMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class LatencyAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.LatencyAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addDurationAlarm")
    def add_duration_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        latency_type: "LatencyType",
        props: DurationThreshold,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param latency_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addDurationAlarm", [metric, latency_type, props, disambiguator]))

    @jsii.member(jsii_name="addIntegrationLatencyAlarm")
    def add_integration_latency_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        latency_type: "LatencyType",
        props: "LatencyThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param latency_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addIntegrationLatencyAlarm", [metric, latency_type, props, disambiguator]))

    @jsii.member(jsii_name="addJvmGarbageCollectionDurationAlarm")
    def add_jvm_garbage_collection_duration_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        latency_type: "LatencyType",
        props: DurationThreshold,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param latency_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addJvmGarbageCollectionDurationAlarm", [metric, latency_type, props, disambiguator]))

    @jsii.member(jsii_name="addLatencyAlarm")
    def add_latency_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        latency_type: "LatencyType",
        props: "LatencyThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param latency_type: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addLatencyAlarm", [metric, latency_type, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.LatencyThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_latency": "maxLatency",
    },
)
class LatencyThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_latency: aws_cdk.Duration,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_latency: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_latency": max_latency,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_latency(self) -> aws_cdk.Duration:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_latency")
        assert result is not None, "Required property 'max_latency' is missing"
        return typing.cast(aws_cdk.Duration, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LatencyThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.LatencyType")
class LatencyType(enum.Enum):
    '''
    :stability: experimental
    '''

    P50 = "P50"
    '''
    :stability: experimental
    '''
    P70 = "P70"
    '''
    :stability: experimental
    '''
    P90 = "P90"
    '''
    :stability: experimental
    '''
    P95 = "P95"
    '''
    :stability: experimental
    '''
    P99 = "P99"
    '''
    :stability: experimental
    '''
    P999 = "P999"
    '''
    :stability: experimental
    '''
    P9999 = "P9999"
    '''
    :stability: experimental
    '''
    P100 = "P100"
    '''
    :stability: experimental
    '''
    TM50 = "TM50"
    '''
    :stability: experimental
    '''
    TM70 = "TM70"
    '''
    :stability: experimental
    '''
    TM90 = "TM90"
    '''
    :stability: experimental
    '''
    TM95 = "TM95"
    '''
    :stability: experimental
    '''
    TM99 = "TM99"
    '''
    :stability: experimental
    '''
    TM999 = "TM999"
    '''
    :stability: experimental
    '''
    TM9999 = "TM9999"
    '''
    :stability: experimental
    '''
    AVERAGE = "AVERAGE"
    '''
    :stability: experimental
    '''


@jsii.enum(jsii_type="cdk-monitoring-constructs.LogLevel")
class LogLevel(enum.Enum):
    '''(experimental) Level of a given log.

    :stability: experimental
    '''

    ERROR = "ERROR"
    '''
    :stability: experimental
    '''
    CRITICAL = "CRITICAL"
    '''
    :stability: experimental
    '''
    FATAL = "FATAL"
    '''
    :stability: experimental
    '''


class LogLevelAlarmFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.LogLevelAlarmFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(self, alarm_factory: AlarmFactory) -> None:
        '''
        :param alarm_factory: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [alarm_factory])

    @jsii.member(jsii_name="addLogCountAlarm")
    def add_log_count_alarm(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        log_level: LogLevel,
        props: "LogLevelCountThreshold",
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> AlarmWithAnnotation:
        '''
        :param metric: -
        :param log_level: -
        :param props: -
        :param disambiguator: -

        :stability: experimental
        '''
        return typing.cast(AlarmWithAnnotation, jsii.invoke(self, "addLogCountAlarm", [metric, log_level, props, disambiguator]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarmFactory")
    def _alarm_factory(self) -> AlarmFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.get(self, "alarmFactory"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.LogLevelCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_log_count": "maxLogCount",
    },
)
class LogLevelCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_log_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_log_count: (experimental) Threshold for the number of logs to alarm on.

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_log_count": max_log_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_log_count(self) -> jsii.Number:
        '''(experimental) Threshold for the number of logs to alarm on.

        :stability: experimental
        '''
        result = self._values.get("max_log_count")
        assert result is not None, "Required property 'max_log_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LogLevelCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.LowMessagesPublishedThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_messages_published_count": "minMessagesPublishedCount",
    },
)
class LowMessagesPublishedThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_messages_published_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_messages_published_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_messages_published_count": min_messages_published_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_messages_published_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_messages_published_count")
        assert result is not None, "Required property 'min_messages_published_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LowMessagesPublishedThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.LowTpsThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_tps": "minTps",
    },
)
class LowTpsThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_tps: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_tps: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_tps": min_tps,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_tps(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_tps")
        assert result is not None, "Required property 'min_tps' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "LowTpsThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxAgeThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_age_in_millis": "maxAgeInMillis",
    },
)
class MaxAgeThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_age_in_millis: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_age_in_millis: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_age_in_millis": max_age_in_millis,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_age_in_millis(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_age_in_millis")
        assert result is not None, "Required property 'max_age_in_millis' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxAgeThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxDowntimeThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_downtime_in_millis": "maxDowntimeInMillis",
    },
)
class MaxDowntimeThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_downtime_in_millis: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_downtime_in_millis: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_downtime_in_millis": max_downtime_in_millis,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_downtime_in_millis(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_downtime_in_millis")
        assert result is not None, "Required property 'max_downtime_in_millis' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxDowntimeThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxIncomingMessagesCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_incoming_messages_count": "maxIncomingMessagesCount",
    },
)
class MaxIncomingMessagesCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_incoming_messages_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_incoming_messages_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_incoming_messages_count": max_incoming_messages_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_incoming_messages_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_incoming_messages_count")
        assert result is not None, "Required property 'max_incoming_messages_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxIncomingMessagesCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxItemsCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_items_count": "maxItemsCount",
    },
)
class MaxItemsCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_items_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_items_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_items_count": max_items_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_items_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_items_count")
        assert result is not None, "Required property 'max_items_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxItemsCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxIteratorAgeThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_age_in_millis": "maxAgeInMillis",
    },
)
class MaxIteratorAgeThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_age_in_millis: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_age_in_millis: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_age_in_millis": max_age_in_millis,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_age_in_millis(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_age_in_millis")
        assert result is not None, "Required property 'max_age_in_millis' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxIteratorAgeThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxMessageAgeThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_age_in_seconds": "maxAgeInSeconds",
    },
)
class MaxMessageAgeThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_age_in_seconds: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_age_in_seconds: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_age_in_seconds": max_age_in_seconds,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_age_in_seconds(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_age_in_seconds")
        assert result is not None, "Required property 'max_age_in_seconds' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxMessageAgeThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxMessageCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_message_count": "maxMessageCount",
    },
)
class MaxMessageCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_message_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_message_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_message_count": max_message_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_message_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_message_count")
        assert result is not None, "Required property 'max_message_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxMessageCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxTimeToDrainThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_time_to_drain": "maxTimeToDrain",
    },
)
class MaxTimeToDrainThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_time_to_drain: aws_cdk.Duration,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_time_to_drain: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_time_to_drain": max_time_to_drain,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_time_to_drain(self) -> aws_cdk.Duration:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_time_to_drain")
        assert result is not None, "Required property 'max_time_to_drain' is missing"
        return typing.cast(aws_cdk.Duration, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxTimeToDrainThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MaxUsedSwapMemoryThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_used_swap_memory_in_bytes": "maxUsedSwapMemoryInBytes",
    },
)
class MaxUsedSwapMemoryThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_used_swap_memory_in_bytes: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_used_swap_memory_in_bytes: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_used_swap_memory_in_bytes": max_used_swap_memory_in_bytes,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_used_swap_memory_in_bytes(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_used_swap_memory_in_bytes")
        assert result is not None, "Required property 'max_used_swap_memory_in_bytes' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MaxUsedSwapMemoryThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.MetricFactory",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        *,
        global_defaults: typing.Optional["MetricFactoryDefaults"] = None,
    ) -> None:
        '''
        :param global_defaults: (experimental) Allows you to specify the global defaults, which can be overridden in the individual metrics or alarms.

        :stability: experimental
        '''
        props = MetricFactoryProps(global_defaults=global_defaults)

        jsii.create(self.__class__, self, [props])

    @jsii.member(jsii_name="adaptMetric")
    def adapt_metric(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Adapts properties of a foreign metric (metric created outside of this metric factory) to comply with the global defaults.

        Might modify namespace and metric period.

        :param metric: metric to be adapted.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "adaptMetric", [metric]))

    @jsii.member(jsii_name="adaptMetricPreservingPeriod")
    def adapt_metric_preserving_period(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Adapts properties of a foreign metric (metric created outside of this metric factory) to comply with the global defaults.

        Might modify namespace. Preserves metric period.

        :param metric: metric to be adapted.

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "adaptMetricPreservingPeriod", [metric]))

    @jsii.member(jsii_name="addAdditionalDimensions")
    def add_additional_dimensions(
        self,
        target: typing.Mapping[builtins.str, builtins.str],
        additional_dimensions: typing.Mapping[builtins.str, builtins.str],
    ) -> None:
        '''(experimental) Merges the given additional dimensions to the given target dimension hash.

        All existing dimensions with the same key are replaced.

        :param target: target dimension hash to update.
        :param additional_dimensions: additional dimensions.

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "addAdditionalDimensions", [target, additional_dimensions]))

    @jsii.member(jsii_name="createMetric")
    def create_metric(
        self,
        metric_name: builtins.str,
        statistic: "MetricStatistic",
        label: typing.Optional[builtins.str] = None,
        dimensions_map: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        color: typing.Optional[builtins.str] = None,
        namespace: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Factory method that creates a metric.

        The metric properties will already be updated to comply with the global defaults.

        :param metric_name: metric name.
        :param statistic: aggregation statistic to use.
        :param label: metric label; if undefined, metric name is used by CloudWatch
        :param dimensions_map: additional dimensions to be added.
        :param color: metric color; if undefined, uses a CloudWatch provided color (preferred)
        :param namespace: specify a custom namespace; if undefined, uses the global default
        :param period: specify a custom period; if undefined, uses the global default

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "createMetric", [metric_name, statistic, label, dimensions_map, color, namespace, period]))

    @jsii.member(jsii_name="createMetricAnomalyDetection")
    def create_metric_anomaly_detection(
        self,
        metric: aws_cdk.aws_cloudwatch.IMetric,
        stdev: jsii.Number,
        label: builtins.str,
        color: typing.Optional[builtins.str] = None,
        expression_id: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Factory method that creates anomaly detection on a metric.

        Anomaly occurs whenever a metric value falls outside of a precomputed range of predicted values.
        The detection does not need any setup. The model will start learning automatically and should be ready in a few minutes.
        Usually, the anomaly detection is paired with an alarm.

        :param metric: metric to detect anomaly detection of.
        :param stdev: standard deviation, basically the tolerance / band thickness.
        :param label: metric label (required, as there is no reasonable default).
        :param color: metric color; if undefined, uses a CloudWatch provided color (preferred)
        :param expression_id: expression ID of the metric; uses ``m1`` if undefined
        :param period: specify a custom period; if undefined, uses the global default

        :see: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Anomaly_Detection.html
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "createMetricAnomalyDetection", [metric, stdev, label, color, expression_id, period]))

    @jsii.member(jsii_name="createMetricMath")
    def create_metric_math(
        self,
        expression: builtins.str,
        using_metrics: typing.Mapping[builtins.str, aws_cdk.aws_cloudwatch.IMetric],
        label: builtins.str,
        color: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Factory method that creates a metric math expression.

        The metric properties will already be updated to comply with the global defaults.

        :param expression: CloudWatch metric math expression (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html).
        :param using_metrics: map of metrics, where keys are expression IDs (used in the expression) and values are metrics.
        :param label: metric label (required, as there is no reasonable default).
        :param color: metric color; if undefined, uses a CloudWatch provided color (preferred)
        :param period: specify a custom period; if undefined, uses the global default

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "createMetricMath", [expression, using_metrics, label, color, period]))

    @jsii.member(jsii_name="createMetricSearch")
    def create_metric_search(
        self,
        query: builtins.str,
        dimensions_map: typing.Mapping[builtins.str, builtins.str],
        statistic: "MetricStatistic",
        namespace: typing.Optional[builtins.str] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
    ) -> aws_cdk.aws_cloudwatch.IMetric:
        '''(experimental) Factory method that creates a metric search query.

        The metric properties will already be updated to comply with the global defaults.

        :param query: metric search query (the same as the search query prompt in CloudWatch AWS Console), it might also be empty.
        :param dimensions_map: dimensions, further narrowing the search results; values might be undefined if you want to represent "any value"
        :param statistic: aggregation statistic to use.
        :param namespace: specify a custom namespace; if undefined, uses the global default
        :param label: specify custom label for search metrics; default is " " as it cannot be empty string
        :param period: specify a custom period; if undefined, uses the global default

        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.IMetric, jsii.invoke(self, "createMetricSearch", [query, dimensions_map, statistic, namespace, label, period]))

    @jsii.member(jsii_name="divideMetric")
    def divide_metric(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        divisor: jsii.Number,
        label: builtins.str,
        expression_id: typing.Optional[builtins.str] = None,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Creates a metric math expression that divides the given metric by given coefficient.

        Does nothing if the divisor is one. Preserves the metric period.

        :param metric: metric to multiply.
        :param divisor: divisor (must be > 1).
        :param label: expression label.
        :param expression_id: expression ID of the metric; uses ``m1`` if undefined

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "divideMetric", [metric, divisor, label, expression_id]))

    @jsii.member(jsii_name="getNamespaceWithFallback")
    def get_namespace_with_fallback(
        self,
        value: typing.Optional[builtins.str] = None,
    ) -> builtins.str:
        '''(experimental) Returns the given namespace (if defined) or the global namespace as a fallback.

        If there is no namespace to fallback to (neither the custom or the default one), it will fail.

        :param value: custom namespace.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "getNamespaceWithFallback", [value]))

    @jsii.member(jsii_name="multiplyMetric")
    def multiply_metric(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        multiplier: jsii.Number,
        label: builtins.str,
        expression_id: typing.Optional[builtins.str] = None,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Creates a metric math expression that multiplies the given metric by given coefficient.

        Does nothing if the multiplier is one. Preserves the metric period.

        :param metric: metric to multiply.
        :param multiplier: multiplier (must be > 1).
        :param label: expression label.
        :param expression_id: expression ID of the metric; uses ``m1`` if undefined

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "multiplyMetric", [metric, multiplier, label, expression_id]))

    @jsii.member(jsii_name="sanitizeMetricExpressionIdSuffix")
    def sanitize_metric_expression_id_suffix(
        self,
        expression_id: builtins.str,
    ) -> builtins.str:
        '''(experimental) Helper method that helps to sanitize the given expression ID and removes all invalid characters.

        Valid expression ID regexp is the following: ^[a-z][a-zA-Z0-9_]*$
        As this is just to validate a suffix and not the whole ID, we do not have to verify the first lower case letter.

        :param expression_id: expression ID to sanitize.

        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "sanitizeMetricExpressionIdSuffix", [expression_id]))

    @jsii.member(jsii_name="toRate")
    def to_rate(
        self,
        metric: typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression],
        method: "RateComputationMethod",
        add_stats_to_label: typing.Optional[builtins.bool] = None,
        expression_id: typing.Optional[builtins.str] = None,
        fill_with_zeroes: typing.Optional[builtins.bool] = None,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''(experimental) Creates a metric math expression that computes a rate from a regular metric.

        For example, it allows you to compute rate per second (TPS), per minute, or just an average of your transactions.

        :param metric: metric to calculate the rate from.
        :param method: rate computation method.
        :param add_stats_to_label: add detailed statistics (min, max, average) to the label.
        :param expression_id: expression ID of the metric; uses ``m1`` if undefined
        :param fill_with_zeroes: if TRUE, the final metric will be zero-filled (0 on no data); false if undefined

        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "toRate", [metric, method, add_stats_to_label, expression_id, fill_with_zeroes]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="globalDefaults")
    def _global_defaults(self) -> "MetricFactoryDefaults":
        '''
        :stability: experimental
        '''
        return typing.cast("MetricFactoryDefaults", jsii.get(self, "globalDefaults"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MetricFactoryDefaults",
    jsii_struct_bases=[],
    name_mapping={"namespace": "namespace", "period": "period"},
)
class MetricFactoryDefaults:
    def __init__(
        self,
        *,
        namespace: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
    ) -> None:
        '''(experimental) These are the globals used for each metric, unless there is some kind of override.

        :param namespace: (experimental) Each metric exists in a namespace. AWS Services have their own namespace, but here you can specify your custom one.
        :param period: (experimental) Metric period. Default value is used if not defined. Default: DefaultMetricPeriod

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if namespace is not None:
            self._values["namespace"] = namespace
        if period is not None:
            self._values["period"] = period

    @builtins.property
    def namespace(self) -> typing.Optional[builtins.str]:
        '''(experimental) Each metric exists in a namespace.

        AWS Services have their own namespace, but here you can specify your custom one.

        :stability: experimental
        '''
        result = self._values.get("namespace")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Metric period.

        Default value is used if not defined.

        :default: DefaultMetricPeriod

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricFactoryDefaults(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={"global_defaults": "globalDefaults"},
)
class MetricFactoryProps:
    def __init__(
        self,
        *,
        global_defaults: typing.Optional[MetricFactoryDefaults] = None,
    ) -> None:
        '''
        :param global_defaults: (experimental) Allows you to specify the global defaults, which can be overridden in the individual metrics or alarms.

        :stability: experimental
        '''
        if isinstance(global_defaults, dict):
            global_defaults = MetricFactoryDefaults(**global_defaults)
        self._values: typing.Dict[str, typing.Any] = {}
        if global_defaults is not None:
            self._values["global_defaults"] = global_defaults

    @builtins.property
    def global_defaults(self) -> typing.Optional[MetricFactoryDefaults]:
        '''(experimental) Allows you to specify the global defaults, which can be overridden in the individual metrics or alarms.

        :stability: experimental
        '''
        result = self._values.get("global_defaults")
        return typing.cast(typing.Optional[MetricFactoryDefaults], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-monitoring-constructs.MetricStatistic")
class MetricStatistic(enum.Enum):
    '''(experimental) Metric aggregation statistic to be used with the IMetric objects.

    :see: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html
    :stability: experimental
    '''

    P50 = "P50"
    '''(experimental) 50th percentile of all datapoints.

    :stability: experimental
    '''
    P70 = "P70"
    '''(experimental) 70th percentile of all datapoints.

    :stability: experimental
    '''
    P90 = "P90"
    '''(experimental) 90th percentile of all datapoints.

    :stability: experimental
    '''
    P95 = "P95"
    '''(experimental) 95th percentile of all datapoints.

    :stability: experimental
    '''
    P99 = "P99"
    '''(experimental) 99th percentile of all datapoints.

    :stability: experimental
    '''
    P999 = "P999"
    '''(experimental) 99.9th percentile of all datapoints.

    :stability: experimental
    '''
    P9999 = "P9999"
    '''(experimental) 99.99th percentile of all datapoints.

    :stability: experimental
    '''
    P100 = "P100"
    '''(experimental) 100th percentile of all datapoints.

    :stability: experimental
    '''
    TM50 = "TM50"
    '''(experimental) trimmed mean;

    calculates the average after removing the 50% of data points with the highest values

    :stability: experimental
    '''
    TM70 = "TM70"
    '''(experimental) trimmed mean;

    calculates the average after removing the 30% of data points with the highest values

    :stability: experimental
    '''
    TM90 = "TM90"
    '''(experimental) trimmed mean;

    calculates the average after removing the 10% of data points with the highest values

    :stability: experimental
    '''
    TM95 = "TM95"
    '''(experimental) trimmed mean;

    calculates the average after removing the 5% of data points with the highest values

    :stability: experimental
    '''
    TM99 = "TM99"
    '''(experimental) trimmed mean;

    calculates the average after removing the 1% of data points with the highest values

    :stability: experimental
    '''
    TM999 = "TM999"
    '''(experimental) trimmed mean;

    calculates the average after removing the 0.1% of data points with the highest values

    :stability: experimental
    '''
    TM9999 = "TM9999"
    '''(experimental) trimmed mean;

    calculates the average after removing the 0.01% of data points with the highest values

    :stability: experimental
    '''
    TM99_BOTH = "TM99_BOTH"
    '''(experimental) trimmed mean;

    calculates the average after removing the 1% lowest data points and the 1% highest data points

    :stability: experimental
    '''
    TM95_BOTH = "TM95_BOTH"
    '''(experimental) trimmed mean;

    calculates the average after removing the 5% lowest data points and the 5% highest data points

    :stability: experimental
    '''
    TM90_BOTH = "TM90_BOTH"
    '''(experimental) trimmed mean;

    calculates the average after removing the 10% lowest data points and the 10% highest data points

    :stability: experimental
    '''
    TM85_BOTH = "TM85_BOTH"
    '''(experimental) trimmed mean;

    calculates the average after removing the 15% lowest data points and the 15% highest data points

    :stability: experimental
    '''
    TM80_BOTH = "TM80_BOTH"
    '''(experimental) trimmed mean;

    calculates the average after removing the 20% lowest data points and the 20% highest data points

    :stability: experimental
    '''
    TM75_BOTH = "TM75_BOTH"
    '''(experimental) trimmed mean;

    calculates the average after removing the 25% lowest data points and the 25% highest data points

    :stability: experimental
    '''
    TM70_BOTH = "TM70_BOTH"
    '''(experimental) trimmed mean;

    calculates the average after removing the 30% lowest data points and the 30% highest data points

    :stability: experimental
    '''
    WM50 = "WM50"
    '''(experimental) winsorized mean;

    calculates the average while treating the 50% of the highest values to be equal to the value at the 50th percentile

    :stability: experimental
    '''
    WM70 = "WM70"
    '''(experimental) winsorized mean;

    calculates the average while treating the 30% of the highest values to be equal to the value at the 70th percentile

    :stability: experimental
    '''
    WM90 = "WM90"
    '''(experimental) winsorized mean;

    calculates the average while treating the 10% of the highest values to be equal to the value at the 90th percentile

    :stability: experimental
    '''
    WM95 = "WM95"
    '''(experimental) winsorized mean;

    calculates the average while treating the 5% of the highest values to be equal to the value at the 95th percentile

    :stability: experimental
    '''
    WM99 = "WM99"
    '''(experimental) winsorized mean;

    calculates the average while treating the 1% of the highest values to be equal to the value at the 99th percentile

    :stability: experimental
    '''
    WM999 = "WM999"
    '''(experimental) winsorized mean;

    calculates the average while treating the 0.1% of the highest values to be equal to the value at the 99.9th percentile

    :stability: experimental
    '''
    WM9999 = "WM9999"
    '''(experimental) winsorized mean;

    calculates the average while treating the 0.01% of the highest values to be equal to the value at the 99.99th percentile

    :stability: experimental
    '''
    WM99_BOTH = "WM99_BOTH"
    '''(experimental) winsorized mean;

    calculates the average while treating the highest 1% of data points to be the value of the 99% boundary, and treating the lowest 1% of data points to be the value of the 1% boundary

    :stability: experimental
    '''
    WM95_BOTH = "WM95_BOTH"
    '''(experimental) winsorized mean;

    calculates the average while treating the highest 5% of data points to be the value of the 95% boundary, and treating the lowest 5% of data points to be the value of the 5% boundary

    :stability: experimental
    '''
    WM90_BOTH = "WM90_BOTH"
    '''(experimental) winsorized mean;

    calculates the average while treating the highest 10% of data points to be the value of the 90% boundary, and treating the lowest 10% of data points to be the value of the 10% boundary

    :stability: experimental
    '''
    WM85_BOTH = "WM85_BOTH"
    '''(experimental) winsorized mean;

    calculates the average while treating the highest 15% of data points to be the value of the 85% boundary, and treating the lowest 15% of data points to be the value of the 15% boundary

    :stability: experimental
    '''
    WM80_BOTH = "WM80_BOTH"
    '''(experimental) winsorized mean;

    calculates the average while treating the highest 20% of data points to be the value of the 80% boundary, and treating the lowest 20% of data points to be the value of the 20% boundary

    :stability: experimental
    '''
    WM75_BOTH = "WM75_BOTH"
    '''(experimental) winsorized mean;

    calculates the average while treating the highest 25% of data points to be the value of the 75% boundary, and treating the lowest 25% of data points to be the value of the 25% boundary

    :stability: experimental
    '''
    WM70_BOTH = "WM70_BOTH"
    '''(experimental) winsorized mean;

    calculates the average while treating the highest 30% of data points to be the value of the 70% boundary, and treating the lowest 30% of data points to be the value of the 30% boundary

    :stability: experimental
    '''
    MIN = "MIN"
    '''(experimental) minimum of all datapoints.

    :stability: experimental
    '''
    MAX = "MAX"
    '''(experimental) maximum of all datapoints.

    :stability: experimental
    '''
    SUM = "SUM"
    '''(experimental) sum of all datapoints.

    :stability: experimental
    '''
    AVERAGE = "AVERAGE"
    '''(experimental) average of all datapoints.

    :stability: experimental
    '''
    N = "N"
    '''(experimental) number of datapoints.

    :stability: experimental
    '''


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MinFreeableMemoryThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_freeable_memory_in_bytes": "minFreeableMemoryInBytes",
    },
)
class MinFreeableMemoryThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_freeable_memory_in_bytes: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_freeable_memory_in_bytes: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_freeable_memory_in_bytes": min_freeable_memory_in_bytes,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_freeable_memory_in_bytes(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_freeable_memory_in_bytes")
        assert result is not None, "Required property 'min_freeable_memory_in_bytes' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MinFreeableMemoryThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MinIncomingMessagesCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_incoming_messages_count": "minIncomingMessagesCount",
    },
)
class MinIncomingMessagesCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_incoming_messages_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_incoming_messages_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_incoming_messages_count": min_incoming_messages_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_incoming_messages_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_incoming_messages_count")
        assert result is not None, "Required property 'min_incoming_messages_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MinIncomingMessagesCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MinMessageCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_message_count": "minMessageCount",
    },
)
class MinMessageCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_message_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_message_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_message_count": min_message_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_message_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_message_count")
        assert result is not None, "Required property 'min_message_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MinMessageCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MinProcessedBytesThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_processed_bytes": "minProcessedBytes",
    },
)
class MinProcessedBytesThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_processed_bytes: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_processed_bytes: (experimental) Threshold for the least number of bytes processed.

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_processed_bytes": min_processed_bytes,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_processed_bytes(self) -> jsii.Number:
        '''(experimental) Threshold for the least number of bytes processed.

        :stability: experimental
        '''
        result = self._values.get("min_processed_bytes")
        assert result is not None, "Required property 'min_processed_bytes' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MinProcessedBytesThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MinRunningTaskCountThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "min_running_tasks": "minRunningTasks",
    },
)
class MinRunningTaskCountThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        min_running_tasks: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param min_running_tasks: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "min_running_tasks": min_running_tasks,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def min_running_tasks(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("min_running_tasks")
        assert result is not None, "Required property 'min_running_tasks' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MinRunningTaskCountThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.implements(IDashboardSegment)
class Monitoring(
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk-monitoring-constructs.Monitoring",
):
    '''(experimental) An independent unit of monitoring.

    This is the base for all monitoring classes with alarm support.

    :stability: experimental
    '''

    def __init__(
        self,
        scope: "MonitoringScope",
        *,
        use_created_alarms: typing.Optional[IAlarmConsumer] = None,
        alarm_friendly_name: typing.Optional[builtins.str] = None,
        human_readable_name: typing.Optional[builtins.str] = None,
        local_alarm_name_prefix_override: typing.Optional[builtins.str] = None,
        add_to_alarm_dashboard: typing.Optional[builtins.bool] = None,
        add_to_detail_dashboard: typing.Optional[builtins.bool] = None,
        add_to_summary_dashboard: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param use_created_alarms: (experimental) Calls provided function to process all alarms created.
        :param alarm_friendly_name: (experimental) Plain name, used in naming alarms. This unique among other resources, and respect the AWS CDK restriction posed on alarm names. The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens. Default: derives name from the construct itself
        :param human_readable_name: (experimental) Human-readable name is a freeform string, used as a caption or description. There are no limitations on what it can be. Default: use alarmFriendlyName
        :param local_alarm_name_prefix_override: (experimental) If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.
        :param add_to_alarm_dashboard: (experimental) Flag indicating if the widgets should be added to alarm dashboard. Default: true
        :param add_to_detail_dashboard: (experimental) Flag indicating if the widgets should be added to detailed dashboard. Default: true
        :param add_to_summary_dashboard: (experimental) Flag indicating if the widgets should be added to summary dashboard. Default: true

        :stability: experimental
        '''
        props = BaseMonitoringProps(
            use_created_alarms=use_created_alarms,
            alarm_friendly_name=alarm_friendly_name,
            human_readable_name=human_readable_name,
            local_alarm_name_prefix_override=local_alarm_name_prefix_override,
            add_to_alarm_dashboard=add_to_alarm_dashboard,
            add_to_detail_dashboard=add_to_detail_dashboard,
            add_to_summary_dashboard=add_to_summary_dashboard,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="addAlarm")
    def add_alarm(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.Alarm,
        alarm_description: builtins.str,
        alarm_label: builtins.str,
        alarm_name: builtins.str,
        alarm_name_suffix: builtins.str,
        alarm_rule_when_alarming: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_insufficient_data: aws_cdk.aws_cloudwatch.IAlarmRule,
        alarm_rule_when_ok: aws_cdk.aws_cloudwatch.IAlarmRule,
        annotation: aws_cdk.aws_cloudwatch.HorizontalAnnotation,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> None:
        '''(experimental) Adds an alarm.

        :param alarm: 
        :param alarm_description: 
        :param alarm_label: 
        :param alarm_name: 
        :param alarm_name_suffix: 
        :param alarm_rule_when_alarming: 
        :param alarm_rule_when_insufficient_data: 
        :param alarm_rule_when_ok: 
        :param annotation: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        alarm_ = AlarmWithAnnotation(
            alarm=alarm,
            alarm_description=alarm_description,
            alarm_label=alarm_label,
            alarm_name=alarm_name,
            alarm_name_suffix=alarm_name_suffix,
            alarm_rule_when_alarming=alarm_rule_when_alarming,
            alarm_rule_when_insufficient_data=alarm_rule_when_insufficient_data,
            alarm_rule_when_ok=alarm_rule_when_ok,
            annotation=annotation,
            action=action,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string=dedupe_string,
            disambiguator=disambiguator,
        )

        return typing.cast(None, jsii.invoke(self, "addAlarm", [alarm_]))

    @jsii.member(jsii_name="alarmWidgets")
    def alarm_widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets for all alarms.

        These can go to runbook or to service dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "alarmWidgets", []))

    @jsii.member(jsii_name="createAlarmFactory")
    def create_alarm_factory(self, alarm_name_prefix: builtins.str) -> AlarmFactory:
        '''(experimental) Creates a new alarm factory.

        Alarms created will be named with the given prefix, unless a local name override is present.

        :param alarm_name_prefix: alarm name prefix.

        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.invoke(self, "createAlarmFactory", [alarm_name_prefix]))

    @jsii.member(jsii_name="createdAlarms")
    def created_alarms(self) -> typing.List[AlarmWithAnnotation]:
        '''(experimental) Returns all the alarms created.

        :stability: experimental
        '''
        return typing.cast(typing.List[AlarmWithAnnotation], jsii.invoke(self, "createdAlarms", []))

    @jsii.member(jsii_name="createMetricFactory")
    def create_metric_factory(self) -> MetricFactory:
        '''(experimental) Creates a new metric factory.

        :stability: experimental
        '''
        return typing.cast(MetricFactory, jsii.invoke(self, "createMetricFactory", []))

    @jsii.member(jsii_name="createWidgetFactory")
    def create_widget_factory(self) -> IWidgetFactory:
        '''(experimental) Creates a new widget factory.

        :stability: experimental
        '''
        return typing.cast(IWidgetFactory, jsii.invoke(self, "createWidgetFactory", []))

    @jsii.member(jsii_name="summaryWidgets")
    def summary_widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets to be placed on the summary dashboard.

        :default: no widgets.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "summaryWidgets", []))

    @jsii.member(jsii_name="widgets") # type: ignore[misc]
    @abc.abstractmethod
    def widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets to be placed on the main dashboard.

        :stability: experimental
        '''
        ...

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="alarms")
    def _alarms(self) -> typing.List[AlarmWithAnnotation]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[AlarmWithAnnotation], jsii.get(self, "alarms"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="scope")
    def _scope(self) -> "MonitoringScope":
        '''
        :stability: experimental
        '''
        return typing.cast("MonitoringScope", jsii.get(self, "scope"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="localAlarmNamePrefixOverride")
    def _local_alarm_name_prefix_override(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Optional[builtins.str], jsii.get(self, "localAlarmNamePrefixOverride"))


class _MonitoringProxy(Monitoring):
    @jsii.member(jsii_name="widgets")
    def widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets to be placed on the main dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "widgets", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, Monitoring).__jsii_proxy_class__ = lambda : _MonitoringProxy


@jsii.implements(aws_cdk.IAspect)
class MonitoringAspect(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.MonitoringAspect",
):
    '''(experimental) A CDK aspect that adds support for monitoring all resources within scope.

    :stability: experimental
    '''

    def __init__(
        self,
        monitoring_facade: "MonitoringFacade",
        *,
        acm: typing.Optional["MonitoringAspectType"] = None,
        api_gateway: typing.Optional["MonitoringAspectType"] = None,
        api_gateway_v2: typing.Optional["MonitoringAspectType"] = None,
        app_sync: typing.Optional["MonitoringAspectType"] = None,
        auto_scaling_group: typing.Optional["MonitoringAspectType"] = None,
        billing: typing.Optional["MonitoringAspectType"] = None,
        cloud_front: typing.Optional["MonitoringAspectType"] = None,
        code_build: typing.Optional["MonitoringAspectType"] = None,
        dynamo_db: typing.Optional["MonitoringAspectType"] = None,
        ec2: typing.Optional["MonitoringAspectType"] = None,
        elastic_cache: typing.Optional["MonitoringAspectType"] = None,
        glue: typing.Optional["MonitoringAspectType"] = None,
        kinesis_data_analytics: typing.Optional["MonitoringAspectType"] = None,
        kinesis_data_stream: typing.Optional["MonitoringAspectType"] = None,
        kinesis_firehose: typing.Optional["MonitoringAspectType"] = None,
        lambda_: typing.Optional["MonitoringAspectType"] = None,
        open_search: typing.Optional["MonitoringAspectType"] = None,
        rds: typing.Optional["MonitoringAspectType"] = None,
        redshift: typing.Optional["MonitoringAspectType"] = None,
        s3: typing.Optional["MonitoringAspectType"] = None,
        secrets_manager: typing.Optional["MonitoringAspectType"] = None,
        sns: typing.Optional["MonitoringAspectType"] = None,
        sqs: typing.Optional["MonitoringAspectType"] = None,
        step_functions: typing.Optional["MonitoringAspectType"] = None,
        synthetics_canaries: typing.Optional["MonitoringAspectType"] = None,
        web_application_firewall_acl_v2: typing.Optional["MonitoringAspectType"] = None,
    ) -> None:
        '''
        :param monitoring_facade: -
        :param acm: 
        :param api_gateway: 
        :param api_gateway_v2: 
        :param app_sync: 
        :param auto_scaling_group: 
        :param billing: 
        :param cloud_front: 
        :param code_build: 
        :param dynamo_db: 
        :param ec2: 
        :param elastic_cache: 
        :param glue: 
        :param kinesis_data_analytics: 
        :param kinesis_data_stream: 
        :param kinesis_firehose: 
        :param lambda_: 
        :param open_search: 
        :param rds: 
        :param redshift: 
        :param s3: 
        :param secrets_manager: 
        :param sns: 
        :param sqs: 
        :param step_functions: 
        :param synthetics_canaries: 
        :param web_application_firewall_acl_v2: 

        :stability: experimental
        '''
        props = MonitoringAspectProps(
            acm=acm,
            api_gateway=api_gateway,
            api_gateway_v2=api_gateway_v2,
            app_sync=app_sync,
            auto_scaling_group=auto_scaling_group,
            billing=billing,
            cloud_front=cloud_front,
            code_build=code_build,
            dynamo_db=dynamo_db,
            ec2=ec2,
            elastic_cache=elastic_cache,
            glue=glue,
            kinesis_data_analytics=kinesis_data_analytics,
            kinesis_data_stream=kinesis_data_stream,
            kinesis_firehose=kinesis_firehose,
            lambda_=lambda_,
            open_search=open_search,
            rds=rds,
            redshift=redshift,
            s3=s3,
            secrets_manager=secrets_manager,
            sns=sns,
            sqs=sqs,
            step_functions=step_functions,
            synthetics_canaries=synthetics_canaries,
            web_application_firewall_acl_v2=web_application_firewall_acl_v2,
        )

        jsii.create(self.__class__, self, [monitoring_facade, props])

    @jsii.member(jsii_name="visit")
    def visit(self, node: constructs.IConstruct) -> None:
        '''(experimental) All aspects can visit an IConstruct.

        :param node: -

        :stability: experimental
        '''
        return typing.cast(None, jsii.invoke(self, "visit", [node]))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MonitoringAspectProps",
    jsii_struct_bases=[],
    name_mapping={
        "acm": "acm",
        "api_gateway": "apiGateway",
        "api_gateway_v2": "apiGatewayV2",
        "app_sync": "appSync",
        "auto_scaling_group": "autoScalingGroup",
        "billing": "billing",
        "cloud_front": "cloudFront",
        "code_build": "codeBuild",
        "dynamo_db": "dynamoDB",
        "ec2": "ec2",
        "elastic_cache": "elasticCache",
        "glue": "glue",
        "kinesis_data_analytics": "kinesisDataAnalytics",
        "kinesis_data_stream": "kinesisDataStream",
        "kinesis_firehose": "kinesisFirehose",
        "lambda_": "lambda",
        "open_search": "openSearch",
        "rds": "rds",
        "redshift": "redshift",
        "s3": "s3",
        "secrets_manager": "secretsManager",
        "sns": "sns",
        "sqs": "sqs",
        "step_functions": "stepFunctions",
        "synthetics_canaries": "syntheticsCanaries",
        "web_application_firewall_acl_v2": "webApplicationFirewallAclV2",
    },
)
class MonitoringAspectProps:
    def __init__(
        self,
        *,
        acm: typing.Optional["MonitoringAspectType"] = None,
        api_gateway: typing.Optional["MonitoringAspectType"] = None,
        api_gateway_v2: typing.Optional["MonitoringAspectType"] = None,
        app_sync: typing.Optional["MonitoringAspectType"] = None,
        auto_scaling_group: typing.Optional["MonitoringAspectType"] = None,
        billing: typing.Optional["MonitoringAspectType"] = None,
        cloud_front: typing.Optional["MonitoringAspectType"] = None,
        code_build: typing.Optional["MonitoringAspectType"] = None,
        dynamo_db: typing.Optional["MonitoringAspectType"] = None,
        ec2: typing.Optional["MonitoringAspectType"] = None,
        elastic_cache: typing.Optional["MonitoringAspectType"] = None,
        glue: typing.Optional["MonitoringAspectType"] = None,
        kinesis_data_analytics: typing.Optional["MonitoringAspectType"] = None,
        kinesis_data_stream: typing.Optional["MonitoringAspectType"] = None,
        kinesis_firehose: typing.Optional["MonitoringAspectType"] = None,
        lambda_: typing.Optional["MonitoringAspectType"] = None,
        open_search: typing.Optional["MonitoringAspectType"] = None,
        rds: typing.Optional["MonitoringAspectType"] = None,
        redshift: typing.Optional["MonitoringAspectType"] = None,
        s3: typing.Optional["MonitoringAspectType"] = None,
        secrets_manager: typing.Optional["MonitoringAspectType"] = None,
        sns: typing.Optional["MonitoringAspectType"] = None,
        sqs: typing.Optional["MonitoringAspectType"] = None,
        step_functions: typing.Optional["MonitoringAspectType"] = None,
        synthetics_canaries: typing.Optional["MonitoringAspectType"] = None,
        web_application_firewall_acl_v2: typing.Optional["MonitoringAspectType"] = None,
    ) -> None:
        '''
        :param acm: 
        :param api_gateway: 
        :param api_gateway_v2: 
        :param app_sync: 
        :param auto_scaling_group: 
        :param billing: 
        :param cloud_front: 
        :param code_build: 
        :param dynamo_db: 
        :param ec2: 
        :param elastic_cache: 
        :param glue: 
        :param kinesis_data_analytics: 
        :param kinesis_data_stream: 
        :param kinesis_firehose: 
        :param lambda_: 
        :param open_search: 
        :param rds: 
        :param redshift: 
        :param s3: 
        :param secrets_manager: 
        :param sns: 
        :param sqs: 
        :param step_functions: 
        :param synthetics_canaries: 
        :param web_application_firewall_acl_v2: 

        :stability: experimental
        '''
        if isinstance(acm, dict):
            acm = MonitoringAspectType(**acm)
        if isinstance(api_gateway, dict):
            api_gateway = MonitoringAspectType(**api_gateway)
        if isinstance(api_gateway_v2, dict):
            api_gateway_v2 = MonitoringAspectType(**api_gateway_v2)
        if isinstance(app_sync, dict):
            app_sync = MonitoringAspectType(**app_sync)
        if isinstance(auto_scaling_group, dict):
            auto_scaling_group = MonitoringAspectType(**auto_scaling_group)
        if isinstance(billing, dict):
            billing = MonitoringAspectType(**billing)
        if isinstance(cloud_front, dict):
            cloud_front = MonitoringAspectType(**cloud_front)
        if isinstance(code_build, dict):
            code_build = MonitoringAspectType(**code_build)
        if isinstance(dynamo_db, dict):
            dynamo_db = MonitoringAspectType(**dynamo_db)
        if isinstance(ec2, dict):
            ec2 = MonitoringAspectType(**ec2)
        if isinstance(elastic_cache, dict):
            elastic_cache = MonitoringAspectType(**elastic_cache)
        if isinstance(glue, dict):
            glue = MonitoringAspectType(**glue)
        if isinstance(kinesis_data_analytics, dict):
            kinesis_data_analytics = MonitoringAspectType(**kinesis_data_analytics)
        if isinstance(kinesis_data_stream, dict):
            kinesis_data_stream = MonitoringAspectType(**kinesis_data_stream)
        if isinstance(kinesis_firehose, dict):
            kinesis_firehose = MonitoringAspectType(**kinesis_firehose)
        if isinstance(lambda_, dict):
            lambda_ = MonitoringAspectType(**lambda_)
        if isinstance(open_search, dict):
            open_search = MonitoringAspectType(**open_search)
        if isinstance(rds, dict):
            rds = MonitoringAspectType(**rds)
        if isinstance(redshift, dict):
            redshift = MonitoringAspectType(**redshift)
        if isinstance(s3, dict):
            s3 = MonitoringAspectType(**s3)
        if isinstance(secrets_manager, dict):
            secrets_manager = MonitoringAspectType(**secrets_manager)
        if isinstance(sns, dict):
            sns = MonitoringAspectType(**sns)
        if isinstance(sqs, dict):
            sqs = MonitoringAspectType(**sqs)
        if isinstance(step_functions, dict):
            step_functions = MonitoringAspectType(**step_functions)
        if isinstance(synthetics_canaries, dict):
            synthetics_canaries = MonitoringAspectType(**synthetics_canaries)
        if isinstance(web_application_firewall_acl_v2, dict):
            web_application_firewall_acl_v2 = MonitoringAspectType(**web_application_firewall_acl_v2)
        self._values: typing.Dict[str, typing.Any] = {}
        if acm is not None:
            self._values["acm"] = acm
        if api_gateway is not None:
            self._values["api_gateway"] = api_gateway
        if api_gateway_v2 is not None:
            self._values["api_gateway_v2"] = api_gateway_v2
        if app_sync is not None:
            self._values["app_sync"] = app_sync
        if auto_scaling_group is not None:
            self._values["auto_scaling_group"] = auto_scaling_group
        if billing is not None:
            self._values["billing"] = billing
        if cloud_front is not None:
            self._values["cloud_front"] = cloud_front
        if code_build is not None:
            self._values["code_build"] = code_build
        if dynamo_db is not None:
            self._values["dynamo_db"] = dynamo_db
        if ec2 is not None:
            self._values["ec2"] = ec2
        if elastic_cache is not None:
            self._values["elastic_cache"] = elastic_cache
        if glue is not None:
            self._values["glue"] = glue
        if kinesis_data_analytics is not None:
            self._values["kinesis_data_analytics"] = kinesis_data_analytics
        if kinesis_data_stream is not None:
            self._values["kinesis_data_stream"] = kinesis_data_stream
        if kinesis_firehose is not None:
            self._values["kinesis_firehose"] = kinesis_firehose
        if lambda_ is not None:
            self._values["lambda_"] = lambda_
        if open_search is not None:
            self._values["open_search"] = open_search
        if rds is not None:
            self._values["rds"] = rds
        if redshift is not None:
            self._values["redshift"] = redshift
        if s3 is not None:
            self._values["s3"] = s3
        if secrets_manager is not None:
            self._values["secrets_manager"] = secrets_manager
        if sns is not None:
            self._values["sns"] = sns
        if sqs is not None:
            self._values["sqs"] = sqs
        if step_functions is not None:
            self._values["step_functions"] = step_functions
        if synthetics_canaries is not None:
            self._values["synthetics_canaries"] = synthetics_canaries
        if web_application_firewall_acl_v2 is not None:
            self._values["web_application_firewall_acl_v2"] = web_application_firewall_acl_v2

    @builtins.property
    def acm(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("acm")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def api_gateway(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("api_gateway")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def api_gateway_v2(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("api_gateway_v2")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def app_sync(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("app_sync")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def auto_scaling_group(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("auto_scaling_group")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def billing(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("billing")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def cloud_front(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("cloud_front")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def code_build(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("code_build")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def dynamo_db(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("dynamo_db")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def ec2(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("ec2")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def elastic_cache(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("elastic_cache")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def glue(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("glue")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def kinesis_data_analytics(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("kinesis_data_analytics")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def kinesis_data_stream(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("kinesis_data_stream")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def kinesis_firehose(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("kinesis_firehose")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def lambda_(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("lambda_")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def open_search(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("open_search")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def rds(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("rds")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def redshift(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("redshift")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def s3(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("s3")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def secrets_manager(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("secrets_manager")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def sns(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("sns")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def sqs(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("sqs")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def step_functions(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("step_functions")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def synthetics_canaries(self) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("synthetics_canaries")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    @builtins.property
    def web_application_firewall_acl_v2(
        self,
    ) -> typing.Optional["MonitoringAspectType"]:
        '''
        :stability: experimental
        '''
        result = self._values.get("web_application_firewall_acl_v2")
        return typing.cast(typing.Optional["MonitoringAspectType"], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitoringAspectProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MonitoringAspectType",
    jsii_struct_bases=[],
    name_mapping={"enabled": "enabled", "props": "props"},
)
class MonitoringAspectType:
    def __init__(
        self,
        *,
        enabled: typing.Optional[builtins.bool] = None,
        props: typing.Any = None,
    ) -> None:
        '''
        :param enabled: (experimental) If the monitoring aspect is enabled for this resource. Default: true
        :param props: (experimental) The monitoring props for this resource. Default: - none

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if enabled is not None:
            self._values["enabled"] = enabled
        if props is not None:
            self._values["props"] = props

    @builtins.property
    def enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) If the monitoring aspect is enabled for this resource.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def props(self) -> typing.Any:
        '''(experimental) The monitoring props for this resource.

        :default: - none

        :stability: experimental
        '''
        result = self._values.get("props")
        return typing.cast(typing.Any, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitoringAspectType(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MonitoringDashboardsOverrideProps",
    jsii_struct_bases=[],
    name_mapping={
        "add_to_alarm_dashboard": "addToAlarmDashboard",
        "add_to_detail_dashboard": "addToDetailDashboard",
        "add_to_summary_dashboard": "addToSummaryDashboard",
    },
)
class MonitoringDashboardsOverrideProps:
    def __init__(
        self,
        *,
        add_to_alarm_dashboard: typing.Optional[builtins.bool] = None,
        add_to_detail_dashboard: typing.Optional[builtins.bool] = None,
        add_to_summary_dashboard: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param add_to_alarm_dashboard: (experimental) Flag indicating if the widgets should be added to alarm dashboard. Default: true
        :param add_to_detail_dashboard: (experimental) Flag indicating if the widgets should be added to detailed dashboard. Default: true
        :param add_to_summary_dashboard: (experimental) Flag indicating if the widgets should be added to summary dashboard. Default: true

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {}
        if add_to_alarm_dashboard is not None:
            self._values["add_to_alarm_dashboard"] = add_to_alarm_dashboard
        if add_to_detail_dashboard is not None:
            self._values["add_to_detail_dashboard"] = add_to_detail_dashboard
        if add_to_summary_dashboard is not None:
            self._values["add_to_summary_dashboard"] = add_to_summary_dashboard

    @builtins.property
    def add_to_alarm_dashboard(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Flag indicating if the widgets should be added to alarm dashboard.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("add_to_alarm_dashboard")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def add_to_detail_dashboard(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Flag indicating if the widgets should be added to detailed dashboard.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("add_to_detail_dashboard")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def add_to_summary_dashboard(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Flag indicating if the widgets should be added to summary dashboard.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("add_to_summary_dashboard")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitoringDashboardsOverrideProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MonitoringDashboardsProps",
    jsii_struct_bases=[],
    name_mapping={
        "create_alarm_dashboard": "createAlarmDashboard",
        "create_dashboard": "createDashboard",
        "create_summary_dashboard": "createSummaryDashboard",
        "dashboard_name_prefix": "dashboardNamePrefix",
        "rendering_preference": "renderingPreference",
        "detail_dashboard_period_override": "detailDashboardPeriodOverride",
        "detail_dashboard_range": "detailDashboardRange",
        "summary_dashboard_period_override": "summaryDashboardPeriodOverride",
        "summary_dashboard_range": "summaryDashboardRange",
    },
)
class MonitoringDashboardsProps:
    def __init__(
        self,
        *,
        create_alarm_dashboard: builtins.bool,
        create_dashboard: builtins.bool,
        create_summary_dashboard: builtins.bool,
        dashboard_name_prefix: builtins.str,
        rendering_preference: DashboardRenderingPreference,
        detail_dashboard_period_override: typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride] = None,
        detail_dashboard_range: typing.Optional[aws_cdk.Duration] = None,
        summary_dashboard_period_override: typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride] = None,
        summary_dashboard_range: typing.Optional[aws_cdk.Duration] = None,
    ) -> None:
        '''
        :param create_alarm_dashboard: (experimental) Flag indicating whether the alarm dashboard should be created. This is independent on other create dashboard flags.
        :param create_dashboard: (experimental) Flag indicating whether the default dashboard should be created. This is independent on other create dashboard flags.
        :param create_summary_dashboard: (experimental) Flag indicating whether the summary dashboard should be created. This is independent on other create dashboard flags.
        :param dashboard_name_prefix: (experimental) Prefix added to each dashboard name. This allows to have all dashboards sorted close to each other and also separate multiple monitoring facades.
        :param rendering_preference: (experimental) Dashboard rendering preference.
        :param detail_dashboard_period_override: (experimental) Period override for the detail dashboard (and other auxiliary dashboards). Default: respect individual graphs (PeriodOverride.INHERIT)
        :param detail_dashboard_range: (experimental) Range of the detail dashboard (and other auxiliary dashboards). Default: 8 hours
        :param summary_dashboard_period_override: (experimental) Period override for the summary dashboard. Default: respect individual graphs (PeriodOverride.INHERIT)
        :param summary_dashboard_range: (experimental) Range of the summary dashboard. Default: 14 days

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "create_alarm_dashboard": create_alarm_dashboard,
            "create_dashboard": create_dashboard,
            "create_summary_dashboard": create_summary_dashboard,
            "dashboard_name_prefix": dashboard_name_prefix,
            "rendering_preference": rendering_preference,
        }
        if detail_dashboard_period_override is not None:
            self._values["detail_dashboard_period_override"] = detail_dashboard_period_override
        if detail_dashboard_range is not None:
            self._values["detail_dashboard_range"] = detail_dashboard_range
        if summary_dashboard_period_override is not None:
            self._values["summary_dashboard_period_override"] = summary_dashboard_period_override
        if summary_dashboard_range is not None:
            self._values["summary_dashboard_range"] = summary_dashboard_range

    @builtins.property
    def create_alarm_dashboard(self) -> builtins.bool:
        '''(experimental) Flag indicating whether the alarm dashboard should be created.

        This is independent on other create dashboard flags.

        :stability: experimental
        '''
        result = self._values.get("create_alarm_dashboard")
        assert result is not None, "Required property 'create_alarm_dashboard' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def create_dashboard(self) -> builtins.bool:
        '''(experimental) Flag indicating whether the default dashboard should be created.

        This is independent on other create dashboard flags.

        :stability: experimental
        '''
        result = self._values.get("create_dashboard")
        assert result is not None, "Required property 'create_dashboard' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def create_summary_dashboard(self) -> builtins.bool:
        '''(experimental) Flag indicating whether the summary dashboard should be created.

        This is independent on other create dashboard flags.

        :stability: experimental
        '''
        result = self._values.get("create_summary_dashboard")
        assert result is not None, "Required property 'create_summary_dashboard' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def dashboard_name_prefix(self) -> builtins.str:
        '''(experimental) Prefix added to each dashboard name.

        This allows to have all dashboards sorted close to each other and also separate multiple monitoring facades.

        :stability: experimental
        '''
        result = self._values.get("dashboard_name_prefix")
        assert result is not None, "Required property 'dashboard_name_prefix' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def rendering_preference(self) -> DashboardRenderingPreference:
        '''(experimental) Dashboard rendering preference.

        :stability: experimental
        '''
        result = self._values.get("rendering_preference")
        assert result is not None, "Required property 'rendering_preference' is missing"
        return typing.cast(DashboardRenderingPreference, result)

    @builtins.property
    def detail_dashboard_period_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride]:
        '''(experimental) Period override for the detail dashboard (and other auxiliary dashboards).

        :default: respect individual graphs (PeriodOverride.INHERIT)

        :stability: experimental
        '''
        result = self._values.get("detail_dashboard_period_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride], result)

    @builtins.property
    def detail_dashboard_range(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Range of the detail dashboard (and other auxiliary dashboards).

        :default: 8 hours

        :see: DefaultDetailDashboardRange
        :stability: experimental
        '''
        result = self._values.get("detail_dashboard_range")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def summary_dashboard_period_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride]:
        '''(experimental) Period override for the summary dashboard.

        :default: respect individual graphs (PeriodOverride.INHERIT)

        :stability: experimental
        '''
        result = self._values.get("summary_dashboard_period_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.PeriodOverride], result)

    @builtins.property
    def summary_dashboard_range(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Range of the summary dashboard.

        :default: 14 days

        :stability: experimental
        '''
        result = self._values.get("summary_dashboard_range")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitoringDashboardsProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MonitoringFacadeProps",
    jsii_struct_bases=[],
    name_mapping={
        "alarm_factory_defaults": "alarmFactoryDefaults",
        "metric_factory_defaults": "metricFactoryDefaults",
        "dashboard_factory": "dashboardFactory",
    },
)
class MonitoringFacadeProps:
    def __init__(
        self,
        *,
        alarm_factory_defaults: AlarmFactoryDefaults,
        metric_factory_defaults: MetricFactoryDefaults,
        dashboard_factory: typing.Optional[IDashboardFactory] = None,
    ) -> None:
        '''
        :param alarm_factory_defaults: 
        :param metric_factory_defaults: 
        :param dashboard_factory: 

        :stability: experimental
        '''
        if isinstance(alarm_factory_defaults, dict):
            alarm_factory_defaults = AlarmFactoryDefaults(**alarm_factory_defaults)
        if isinstance(metric_factory_defaults, dict):
            metric_factory_defaults = MetricFactoryDefaults(**metric_factory_defaults)
        self._values: typing.Dict[str, typing.Any] = {
            "alarm_factory_defaults": alarm_factory_defaults,
            "metric_factory_defaults": metric_factory_defaults,
        }
        if dashboard_factory is not None:
            self._values["dashboard_factory"] = dashboard_factory

    @builtins.property
    def alarm_factory_defaults(self) -> AlarmFactoryDefaults:
        '''
        :stability: experimental
        '''
        result = self._values.get("alarm_factory_defaults")
        assert result is not None, "Required property 'alarm_factory_defaults' is missing"
        return typing.cast(AlarmFactoryDefaults, result)

    @builtins.property
    def metric_factory_defaults(self) -> MetricFactoryDefaults:
        '''
        :stability: experimental
        '''
        result = self._values.get("metric_factory_defaults")
        assert result is not None, "Required property 'metric_factory_defaults' is missing"
        return typing.cast(MetricFactoryDefaults, result)

    @builtins.property
    def dashboard_factory(self) -> typing.Optional[IDashboardFactory]:
        '''
        :stability: experimental
        '''
        result = self._values.get("dashboard_factory")
        return typing.cast(typing.Optional[IDashboardFactory], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitoringFacadeProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MonitoringHeaderWidget(
    HeaderWidget,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.MonitoringHeaderWidget",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        *,
        title: builtins.str,
        family: typing.Optional[builtins.str] = None,
        go_to_link_url: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param title: 
        :param family: 
        :param go_to_link_url: 

        :stability: experimental
        '''
        props = MonitoringHeaderWidgetProps(
            title=title, family=family, go_to_link_url=go_to_link_url
        )

        jsii.create(self.__class__, self, [props])


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.MonitoringHeaderWidgetProps",
    jsii_struct_bases=[],
    name_mapping={
        "title": "title",
        "family": "family",
        "go_to_link_url": "goToLinkUrl",
    },
)
class MonitoringHeaderWidgetProps:
    def __init__(
        self,
        *,
        title: builtins.str,
        family: typing.Optional[builtins.str] = None,
        go_to_link_url: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param title: 
        :param family: 
        :param go_to_link_url: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "title": title,
        }
        if family is not None:
            self._values["family"] = family
        if go_to_link_url is not None:
            self._values["go_to_link_url"] = go_to_link_url

    @builtins.property
    def title(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        result = self._values.get("title")
        assert result is not None, "Required property 'title' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def family(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("family")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def go_to_link_url(self) -> typing.Optional[builtins.str]:
        '''
        :stability: experimental
        '''
        result = self._values.get("go_to_link_url")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MonitoringHeaderWidgetProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MonitoringNamingStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.MonitoringNamingStrategy",
):
    '''(experimental) Utility class to unify approach to naming monitoring sections.

    :see: https://docs.aws.amazon.com/cdk/latest/guide/tokens.html#tokens_lazy
    :stability: experimental
    '''

    def __init__(
        self,
        *,
        fallback_construct_name: typing.Optional[builtins.str] = None,
        named_construct: typing.Optional[constructs.IConstruct] = None,
        alarm_friendly_name: typing.Optional[builtins.str] = None,
        human_readable_name: typing.Optional[builtins.str] = None,
        local_alarm_name_prefix_override: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param fallback_construct_name: (experimental) Fallback name before we fallback to extracting name from the construct itself. This might be some construct reference, such is cluster ID, stream name, and so on. Default: use namedConstruct to extract the name
        :param named_construct: (experimental) Construct that this naming strategy is naming. It is used as a last resort for naming.
        :param alarm_friendly_name: (experimental) Plain name, used in naming alarms. This unique among other resources, and respect the AWS CDK restriction posed on alarm names. The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens. Default: derives name from the construct itself
        :param human_readable_name: (experimental) Human-readable name is a freeform string, used as a caption or description. There are no limitations on what it can be. Default: use alarmFriendlyName
        :param local_alarm_name_prefix_override: (experimental) If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.

        :stability: experimental
        '''
        input = NameResolutionInput(
            fallback_construct_name=fallback_construct_name,
            named_construct=named_construct,
            alarm_friendly_name=alarm_friendly_name,
            human_readable_name=human_readable_name,
            local_alarm_name_prefix_override=local_alarm_name_prefix_override,
        )

        jsii.create(self.__class__, self, [input])

    @jsii.member(jsii_name="isAlarmFriendly") # type: ignore[misc]
    @builtins.classmethod
    def is_alarm_friendly(
        cls,
        str: builtins.str,
    ) -> typing.Union[builtins.bool, builtins.str]:
        '''
        :param str: -

        :stability: experimental
        '''
        return typing.cast(typing.Union[builtins.bool, builtins.str], jsii.sinvoke(cls, "isAlarmFriendly", [str]))

    @jsii.member(jsii_name="resolveAlarmFriendlyName")
    def resolve_alarm_friendly_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "resolveAlarmFriendlyName", []))

    @jsii.member(jsii_name="resolveHumanReadableName")
    def resolve_human_readable_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.invoke(self, "resolveHumanReadableName", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="input")
    def _input(self) -> "NameResolutionInput":
        '''
        :stability: experimental
        '''
        return typing.cast("NameResolutionInput", jsii.get(self, "input"))


class MonitoringScope(
    constructs.Construct,
    metaclass=jsii.JSIIAbstractClass,
    jsii_type="cdk-monitoring-constructs.MonitoringScope",
):
    '''(experimental) A scope (construct) where all monitoring constructs are living in.

    :stability: experimental
    '''

    def __init__(self, scope: constructs.Construct, id: builtins.str) -> None:
        '''Creates a new construct node.

        :param scope: The scope in which to define this construct.
        :param id: The scoped construct ID. Must be unique amongst siblings. If the ID includes a path separator (``/``), then it will be replaced by double dash ``--``.
        '''
        jsii.create(self.__class__, self, [scope, id])

    @jsii.member(jsii_name="createAlarmFactory") # type: ignore[misc]
    @abc.abstractmethod
    def create_alarm_factory(self, alarm_name_prefix: builtins.str) -> AlarmFactory:
        '''(experimental) Creates a new alarm factory.

        Alarms created will be named with the given prefix, unless a local name override is present.

        :param alarm_name_prefix: alarm name prefix.

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="createAwsConsoleUrlFactory") # type: ignore[misc]
    @abc.abstractmethod
    def create_aws_console_url_factory(self) -> AwsConsoleUrlFactory:
        '''(experimental) Creates a new factory that creates AWS Console URLs.

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="createMetricFactory") # type: ignore[misc]
    @abc.abstractmethod
    def create_metric_factory(self) -> MetricFactory:
        '''(experimental) Creates a new metric factory.

        :stability: experimental
        '''
        ...

    @jsii.member(jsii_name="createWidgetFactory") # type: ignore[misc]
    @abc.abstractmethod
    def create_widget_factory(self) -> IWidgetFactory:
        '''(experimental) Creates a new widget factory.

        :stability: experimental
        '''
        ...


class _MonitoringScopeProxy(MonitoringScope):
    @jsii.member(jsii_name="createAlarmFactory")
    def create_alarm_factory(self, alarm_name_prefix: builtins.str) -> AlarmFactory:
        '''(experimental) Creates a new alarm factory.

        Alarms created will be named with the given prefix, unless a local name override is present.

        :param alarm_name_prefix: alarm name prefix.

        :stability: experimental
        '''
        return typing.cast(AlarmFactory, jsii.invoke(self, "createAlarmFactory", [alarm_name_prefix]))

    @jsii.member(jsii_name="createAwsConsoleUrlFactory")
    def create_aws_console_url_factory(self) -> AwsConsoleUrlFactory:
        '''(experimental) Creates a new factory that creates AWS Console URLs.

        :stability: experimental
        '''
        return typing.cast(AwsConsoleUrlFactory, jsii.invoke(self, "createAwsConsoleUrlFactory", []))

    @jsii.member(jsii_name="createMetricFactory")
    def create_metric_factory(self) -> MetricFactory:
        '''(experimental) Creates a new metric factory.

        :stability: experimental
        '''
        return typing.cast(MetricFactory, jsii.invoke(self, "createMetricFactory", []))

    @jsii.member(jsii_name="createWidgetFactory")
    def create_widget_factory(self) -> IWidgetFactory:
        '''(experimental) Creates a new widget factory.

        :stability: experimental
        '''
        return typing.cast(IWidgetFactory, jsii.invoke(self, "createWidgetFactory", []))

# Adding a "__jsii_proxy_class__(): typing.Type" function to the abstract class
typing.cast(typing.Any, MonitoringScope).__jsii_proxy_class__ = lambda : _MonitoringScopeProxy


@jsii.implements(IAlarmActionStrategy)
class MultipleAlarmActionStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.MultipleAlarmActionStrategy",
):
    '''(experimental) Alarm action strategy that combines multiple actions in the same order as they were given.

    :stability: experimental
    '''

    def __init__(self, actions: typing.Sequence[IAlarmActionStrategy]) -> None:
        '''
        :param actions: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [actions])

    @jsii.member(jsii_name="addAlarmActions")
    def add_alarm_actions(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.AlarmBase,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarm: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        props = AlarmActionStrategyProps(
            alarm=alarm,
            action=action,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string=dedupe_string,
            disambiguator=disambiguator,
        )

        return typing.cast(None, jsii.invoke(self, "addAlarmActions", [props]))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="actions")
    def _actions(self) -> typing.List[IAlarmActionStrategy]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[IAlarmActionStrategy], jsii.get(self, "actions"))


@jsii.implements(ILoadBalancerMetricFactory)
class NetworkLoadBalancerMetricFactory(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.NetworkLoadBalancerMetricFactory",
):
    '''(experimental) Metric factory to create metrics for network load-balanced service.

    :stability: experimental
    '''

    def __init__(
        self,
        metric_factory: MetricFactory,
        *,
        network_load_balancer: aws_cdk.aws_elasticloadbalancingv2.NetworkLoadBalancer,
        network_target_group: aws_cdk.aws_elasticloadbalancingv2.NetworkTargetGroup,
    ) -> None:
        '''
        :param metric_factory: -
        :param network_load_balancer: 
        :param network_target_group: 

        :stability: experimental
        '''
        props = NetworkLoadBalancerMetricFactoryProps(
            network_load_balancer=network_load_balancer,
            network_target_group=network_target_group,
        )

        jsii.create(self.__class__, self, [metric_factory, props])

    @jsii.member(jsii_name="metricActiveConnectionCount")
    def metric_active_connection_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricActiveConnectionCount", []))

    @jsii.member(jsii_name="metricHealthyTaskCount")
    def metric_healthy_task_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricHealthyTaskCount", []))

    @jsii.member(jsii_name="metricHealthyTaskInPercent")
    def metric_healthy_task_in_percent(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricHealthyTaskInPercent", []))

    @jsii.member(jsii_name="metricNewConnectionCount")
    def metric_new_connection_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricNewConnectionCount", []))

    @jsii.member(jsii_name="metricProcessedBytesMin")
    def metric_processed_bytes_min(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricProcessedBytesMin", []))

    @jsii.member(jsii_name="metricUnhealthyTaskCount")
    def metric_unhealthy_task_count(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.invoke(self, "metricUnhealthyTaskCount", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> MetricFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(MetricFactory, jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkLoadBalancer")
    def _network_load_balancer(
        self,
    ) -> aws_cdk.aws_elasticloadbalancingv2.NetworkLoadBalancer:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_elasticloadbalancingv2.NetworkLoadBalancer, jsii.get(self, "networkLoadBalancer"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="networkTargetGroup")
    def _network_target_group(
        self,
    ) -> aws_cdk.aws_elasticloadbalancingv2.NetworkTargetGroup:
        '''
        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_elasticloadbalancingv2.NetworkTargetGroup, jsii.get(self, "networkTargetGroup"))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.NetworkLoadBalancerMetricFactoryProps",
    jsii_struct_bases=[],
    name_mapping={
        "network_load_balancer": "networkLoadBalancer",
        "network_target_group": "networkTargetGroup",
    },
)
class NetworkLoadBalancerMetricFactoryProps:
    def __init__(
        self,
        *,
        network_load_balancer: aws_cdk.aws_elasticloadbalancingv2.NetworkLoadBalancer,
        network_target_group: aws_cdk.aws_elasticloadbalancingv2.NetworkTargetGroup,
    ) -> None:
        '''(experimental) Props to create NetworkLoadBalancerMetricFactory.

        :param network_load_balancer: 
        :param network_target_group: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "network_load_balancer": network_load_balancer,
            "network_target_group": network_target_group,
        }

    @builtins.property
    def network_load_balancer(
        self,
    ) -> aws_cdk.aws_elasticloadbalancingv2.NetworkLoadBalancer:
        '''
        :stability: experimental
        '''
        result = self._values.get("network_load_balancer")
        assert result is not None, "Required property 'network_load_balancer' is missing"
        return typing.cast(aws_cdk.aws_elasticloadbalancingv2.NetworkLoadBalancer, result)

    @builtins.property
    def network_target_group(
        self,
    ) -> aws_cdk.aws_elasticloadbalancingv2.NetworkTargetGroup:
        '''
        :stability: experimental
        '''
        result = self._values.get("network_target_group")
        assert result is not None, "Required property 'network_target_group' is missing"
        return typing.cast(aws_cdk.aws_elasticloadbalancingv2.NetworkTargetGroup, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NetworkLoadBalancerMetricFactoryProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class NetworkLoadBalancerMonitoring(
    Monitoring,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.NetworkLoadBalancerMonitoring",
):
    '''
    :stability: experimental
    '''

    def __init__(
        self,
        scope: MonitoringScope,
        *,
        add_healthy_task_count_alarm: typing.Optional[typing.Mapping[builtins.str, HealthyTaskCountThreshold]] = None,
        add_healthy_task_percent_alarm: typing.Optional[typing.Mapping[builtins.str, HealthyTaskPercentThreshold]] = None,
        add_min_processed_bytes_alarm: typing.Optional[typing.Mapping[builtins.str, MinProcessedBytesThreshold]] = None,
        add_unhealthy_task_count_alarm: typing.Optional[typing.Mapping[builtins.str, "UnhealthyTaskCountThreshold"]] = None,
        network_load_balancer: aws_cdk.aws_elasticloadbalancingv2.NetworkLoadBalancer,
        network_target_group: aws_cdk.aws_elasticloadbalancingv2.NetworkTargetGroup,
        use_created_alarms: typing.Optional[IAlarmConsumer] = None,
        alarm_friendly_name: typing.Optional[builtins.str] = None,
        human_readable_name: typing.Optional[builtins.str] = None,
        local_alarm_name_prefix_override: typing.Optional[builtins.str] = None,
        add_to_alarm_dashboard: typing.Optional[builtins.bool] = None,
        add_to_detail_dashboard: typing.Optional[builtins.bool] = None,
        add_to_summary_dashboard: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param scope: -
        :param add_healthy_task_count_alarm: 
        :param add_healthy_task_percent_alarm: 
        :param add_min_processed_bytes_alarm: 
        :param add_unhealthy_task_count_alarm: 
        :param network_load_balancer: 
        :param network_target_group: 
        :param use_created_alarms: (experimental) Calls provided function to process all alarms created.
        :param alarm_friendly_name: (experimental) Plain name, used in naming alarms. This unique among other resources, and respect the AWS CDK restriction posed on alarm names. The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens. Default: derives name from the construct itself
        :param human_readable_name: (experimental) Human-readable name is a freeform string, used as a caption or description. There are no limitations on what it can be. Default: use alarmFriendlyName
        :param local_alarm_name_prefix_override: (experimental) If this is defined, the local alarm name prefix used in naming alarms for the construct will be set to this value. The length must be 1 - 255 characters and although the validation rules are undocumented, we recommend using ASCII and hyphens.
        :param add_to_alarm_dashboard: (experimental) Flag indicating if the widgets should be added to alarm dashboard. Default: true
        :param add_to_detail_dashboard: (experimental) Flag indicating if the widgets should be added to detailed dashboard. Default: true
        :param add_to_summary_dashboard: (experimental) Flag indicating if the widgets should be added to summary dashboard. Default: true

        :stability: experimental
        '''
        props = NetworkLoadBalancerMonitoringProps(
            add_healthy_task_count_alarm=add_healthy_task_count_alarm,
            add_healthy_task_percent_alarm=add_healthy_task_percent_alarm,
            add_min_processed_bytes_alarm=add_min_processed_bytes_alarm,
            add_unhealthy_task_count_alarm=add_unhealthy_task_count_alarm,
            network_load_balancer=network_load_balancer,
            network_target_group=network_target_group,
            use_created_alarms=use_created_alarms,
            alarm_friendly_name=alarm_friendly_name,
            human_readable_name=human_readable_name,
            local_alarm_name_prefix_override=local_alarm_name_prefix_override,
            add_to_alarm_dashboard=add_to_alarm_dashboard,
            add_to_detail_dashboard=add_to_detail_dashboard,
            add_to_summary_dashboard=add_to_summary_dashboard,
        )

        jsii.create(self.__class__, self, [scope, props])

    @jsii.member(jsii_name="createTaskHealthWidget")
    def _create_task_health_widget(
        self,
        width: jsii.Number,
        height: jsii.Number,
    ) -> aws_cdk.aws_cloudwatch.GraphWidget:
        '''
        :param width: -
        :param height: -

        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.GraphWidget, jsii.invoke(self, "createTaskHealthWidget", [width, height]))

    @jsii.member(jsii_name="createTcpFlowsWidget")
    def _create_tcp_flows_widget(
        self,
        width: jsii.Number,
        height: jsii.Number,
    ) -> aws_cdk.aws_cloudwatch.GraphWidget:
        '''
        :param width: -
        :param height: -

        :stability: experimental
        '''
        return typing.cast(aws_cdk.aws_cloudwatch.GraphWidget, jsii.invoke(self, "createTcpFlowsWidget", [width, height]))

    @jsii.member(jsii_name="createTitleWidget")
    def _create_title_widget(self) -> MonitoringHeaderWidget:
        '''
        :stability: experimental
        '''
        return typing.cast(MonitoringHeaderWidget, jsii.invoke(self, "createTitleWidget", []))

    @jsii.member(jsii_name="summaryWidgets")
    def summary_widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets to be placed on the summary dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "summaryWidgets", []))

    @jsii.member(jsii_name="widgets")
    def widgets(self) -> typing.List[aws_cdk.aws_cloudwatch.IWidget]:
        '''(experimental) Returns widgets to be placed on the main dashboard.

        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.IWidget], jsii.invoke(self, "widgets", []))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="activeTcpFlowCountMetric")
    def _active_tcp_flow_count_metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.get(self, "activeTcpFlowCountMetric"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthyTaskCountMetric")
    def _healthy_task_count_metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.get(self, "healthyTaskCountMetric"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="healthyTaskPercentMetric")
    def _healthy_task_percent_metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.get(self, "healthyTaskPercentMetric"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="humanReadableName")
    def _human_readable_name(self) -> builtins.str:
        '''
        :stability: experimental
        '''
        return typing.cast(builtins.str, jsii.get(self, "humanReadableName"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="metricFactory")
    def _metric_factory(self) -> NetworkLoadBalancerMetricFactory:
        '''
        :stability: experimental
        '''
        return typing.cast(NetworkLoadBalancerMetricFactory, jsii.get(self, "metricFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="newTcpFlowCountMetric")
    def _new_tcp_flow_count_metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.get(self, "newTcpFlowCountMetric"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="processedBytesAnnotations")
    def _processed_bytes_annotations(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation], jsii.get(self, "processedBytesAnnotations"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="processedBytesMetric")
    def _processed_bytes_metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.get(self, "processedBytesMetric"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="taskHealthAlarmFactory")
    def _task_health_alarm_factory(self) -> "TaskHealthAlarmFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("TaskHealthAlarmFactory", jsii.get(self, "taskHealthAlarmFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="taskHealthAnnotations")
    def _task_health_annotations(
        self,
    ) -> typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.List[aws_cdk.aws_cloudwatch.HorizontalAnnotation], jsii.get(self, "taskHealthAnnotations"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="throughputAlarmFactory")
    def _throughput_alarm_factory(self) -> "ThroughputAlarmFactory":
        '''
        :stability: experimental
        '''
        return typing.cast("ThroughputAlarmFactory", jsii.get(self, "throughputAlarmFactory"))

    @builtins.property # type: ignore[misc]
    @jsii.member(jsii_name="unhealthyTaskCountMetric")
    def _unhealthy_task_count_metric(
        self,
    ) -> typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression]:
        '''
        :stability: experimental
        '''
        return typing.cast(typing.Union[aws_cdk.aws_cloudwatch.Metric, aws_cdk.aws_cloudwatch.MathExpression], jsii.get(self, "unhealthyTaskCountMetric"))


@jsii.implements(IAlarmActionStrategy)
class NoopAlarmActionStrategy(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.NoopAlarmActionStrategy",
):
    '''(experimental) Alarm action strategy that does not add any actions.

    :stability: experimental
    '''

    def __init__(self) -> None:
        '''
        :stability: experimental
        '''
        jsii.create(self.__class__, self, [])

    @jsii.member(jsii_name="addAlarmActions")
    def add_alarm_actions(
        self,
        *,
        alarm: aws_cdk.aws_cloudwatch.AlarmBase,
        action: IAlarmActionStrategy,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        dedupe_string: typing.Optional[builtins.str] = None,
        disambiguator: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param alarm: 
        :param action: 
        :param custom_params: 
        :param custom_tags: 
        :param dedupe_string: 
        :param disambiguator: 

        :stability: experimental
        '''
        _props = AlarmActionStrategyProps(
            alarm=alarm,
            action=action,
            custom_params=custom_params,
            custom_tags=custom_tags,
            dedupe_string=dedupe_string,
            disambiguator=disambiguator,
        )

        return typing.cast(None, jsii.invoke(self, "addAlarmActions", [_props]))


@jsii.data_type(
    jsii_type="cdk-monitoring-constructs.NotificationsFailedThreshold",
    jsii_struct_bases=[CustomAlarmThreshold],
    name_mapping={
        "action_override": "actionOverride",
        "actions_enabled": "actionsEnabled",
        "alarm_description_override": "alarmDescriptionOverride",
        "alarm_name_override": "alarmNameOverride",
        "comparison_operator_override": "comparisonOperatorOverride",
        "custom_params": "customParams",
        "custom_tags": "customTags",
        "datapoints_to_alarm": "datapointsToAlarm",
        "dedupe_string_override": "dedupeStringOverride",
        "documentation_link": "documentationLink",
        "evaluate_low_sample_count_percentile": "evaluateLowSampleCountPercentile",
        "evaluation_periods": "evaluationPeriods",
        "fill_alarm_range": "fillAlarmRange",
        "period": "period",
        "runbook_link": "runbookLink",
        "treat_missing_data_override": "treatMissingDataOverride",
        "max_notifications_failed_count": "maxNotificationsFailedCount",
    },
)
class NotificationsFailedThreshold(CustomAlarmThreshold):
    def __init__(
        self,
        *,
        action_override: typing.Optional[IAlarmActionStrategy] = None,
        actions_enabled: typing.Optional[builtins.bool] = None,
        alarm_description_override: typing.Optional[builtins.str] = None,
        alarm_name_override: typing.Optional[builtins.str] = None,
        comparison_operator_override: typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator] = None,
        custom_params: typing.Optional[typing.Mapping[builtins.str, typing.Any]] = None,
        custom_tags: typing.Optional[typing.Sequence[builtins.str]] = None,
        datapoints_to_alarm: typing.Optional[jsii.Number] = None,
        dedupe_string_override: typing.Optional[builtins.str] = None,
        documentation_link: typing.Optional[builtins.str] = None,
        evaluate_low_sample_count_percentile: typing.Optional[builtins.bool] = None,
        evaluation_periods: typing.Optional[jsii.Number] = None,
        fill_alarm_range: typing.Optional[builtins.bool] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        runbook_link: typing.Optional[builtins.str] = None,
        treat_missing_data_override: typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData] = None,
        max_notifications_failed_count: jsii.Number,
    ) -> None:
        '''
        :param action_override: (experimental) Allows to override the default alarm action. Default: undefined (default action will be used, if any)
        :param actions_enabled: (experimental) Enables the configured CloudWatch alarm ticketing actions. Default: the same as monitoring facade default
        :param alarm_description_override: (experimental) A text included in the generated ticket description body, which fully replaces the generated text. Default: default auto-generated content only
        :param alarm_name_override: (experimental) If this is defined, the alarm name is set to this exact value. Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        :param comparison_operator_override: (experimental) Comparison operator used to compare actual value against the threshold. Default: alarm-specific default
        :param custom_params: (experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no parameters
        :param custom_tags: (experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method. Default: no tags
        :param datapoints_to_alarm: (experimental) Number of breaches required to transition into an ALARM state. Default: the same as monitoring facade default
        :param dedupe_string_override: (experimental) If this is defined, the alarm dedupe string is set to this exact value. Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually. Dedupe strings are global and not unique per CTI. Default: undefined (no override)
        :param documentation_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param evaluate_low_sample_count_percentile: (experimental) Used only for alarms based on percentiles. If you specify false, the alarm state does not change during periods with too few data points to be statistically significant. If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available. Default: true
        :param evaluation_periods: (experimental) Number of periods to consider when checking the number of breaching datapoints. Default: the same as monitoring facade default
        :param fill_alarm_range: (experimental) Indicates whether the alarming range of values should be highlighted in the widget. Default: false
        :param period: (experimental) Period override for the metric to alarm on. Default: the default specified in MetricFactory
        :param runbook_link: (experimental) An optional link included in the generated ticket description body. Default: no additional link will be added
        :param treat_missing_data_override: (experimental) Behaviour in case the metric data is missing. Default: alarm-specific default
        :param max_notifications_failed_count: 

        :stability: experimental
        '''
        self._values: typing.Dict[str, typing.Any] = {
            "max_notifications_failed_count": max_notifications_failed_count,
        }
        if action_override is not None:
            self._values["action_override"] = action_override
        if actions_enabled is not None:
            self._values["actions_enabled"] = actions_enabled
        if alarm_description_override is not None:
            self._values["alarm_description_override"] = alarm_description_override
        if alarm_name_override is not None:
            self._values["alarm_name_override"] = alarm_name_override
        if comparison_operator_override is not None:
            self._values["comparison_operator_override"] = comparison_operator_override
        if custom_params is not None:
            self._values["custom_params"] = custom_params
        if custom_tags is not None:
            self._values["custom_tags"] = custom_tags
        if datapoints_to_alarm is not None:
            self._values["datapoints_to_alarm"] = datapoints_to_alarm
        if dedupe_string_override is not None:
            self._values["dedupe_string_override"] = dedupe_string_override
        if documentation_link is not None:
            self._values["documentation_link"] = documentation_link
        if evaluate_low_sample_count_percentile is not None:
            self._values["evaluate_low_sample_count_percentile"] = evaluate_low_sample_count_percentile
        if evaluation_periods is not None:
            self._values["evaluation_periods"] = evaluation_periods
        if fill_alarm_range is not None:
            self._values["fill_alarm_range"] = fill_alarm_range
        if period is not None:
            self._values["period"] = period
        if runbook_link is not None:
            self._values["runbook_link"] = runbook_link
        if treat_missing_data_override is not None:
            self._values["treat_missing_data_override"] = treat_missing_data_override

    @builtins.property
    def action_override(self) -> typing.Optional[IAlarmActionStrategy]:
        '''(experimental) Allows to override the default alarm action.

        :default: undefined (default action will be used, if any)

        :stability: experimental
        '''
        result = self._values.get("action_override")
        return typing.cast(typing.Optional[IAlarmActionStrategy], result)

    @builtins.property
    def actions_enabled(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Enables the configured CloudWatch alarm ticketing actions.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("actions_enabled")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def alarm_description_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) A text included in the generated ticket description body, which fully replaces the generated text.

        :default: default auto-generated content only

        :stability: experimental
        '''
        result = self._values.get("alarm_description_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def alarm_name_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm name is set to this exact value.

        Please be aware that you need to specify prefix for different stages (Beta, Prod...) and realms (EU, NA...) manually.

        :stability: experimental
        '''
        result = self._values.get("alarm_name_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def comparison_operator_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator]:
        '''(experimental) Comparison operator used to compare actual value against the threshold.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("comparison_operator_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.ComparisonOperator], result)

    @builtins.property
    def custom_params(
        self,
    ) -> typing.Optional[typing.Mapping[builtins.str, typing.Any]]:
        '''(experimental) This allows user to attach custom parameters to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no parameters

        :stability: experimental
        '''
        result = self._values.get("custom_params")
        return typing.cast(typing.Optional[typing.Mapping[builtins.str, typing.Any]], result)

    @builtins.property
    def custom_tags(self) -> typing.Optional[typing.List[builtins.str]]:
        '''(experimental) This allows user to attach custom values to this alarm, which can later be accessed from the "useCreatedAlarms" method.

        :default: no tags

        :stability: experimental
        '''
        result = self._values.get("custom_tags")
        return typing.cast(typing.Optional[typing.List[builtins.str]], result)

    @builtins.property
    def datapoints_to_alarm(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of breaches required to transition into an ALARM state.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("datapoints_to_alarm")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def dedupe_string_override(self) -> typing.Optional[builtins.str]:
        '''(experimental) If this is defined, the alarm dedupe string is set to this exact value.

        Please be aware that you need to handle deduping for different stages (Beta, Prod...) and realms (EU, NA...) manually.
        Dedupe strings are global and not unique per CTI.

        :default: undefined (no override)

        :stability: experimental
        '''
        result = self._values.get("dedupe_string_override")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def documentation_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("documentation_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def evaluate_low_sample_count_percentile(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Used only for alarms based on percentiles.

        If you specify false, the alarm state does not change during periods with too few data points to be statistically significant.
        If you specify true, the alarm is always evaluated and possibly changes state no matter how many data points are available.

        :default: true

        :stability: experimental
        '''
        result = self._values.get("evaluate_low_sample_count_percentile")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def evaluation_periods(self) -> typing.Optional[jsii.Number]:
        '''(experimental) Number of periods to consider when checking the number of breaching datapoints.

        :default: the same as monitoring facade default

        :stability: experimental
        '''
        result = self._values.get("evaluation_periods")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def fill_alarm_range(self) -> typing.Optional[builtins.bool]:
        '''(experimental) Indicates whether the alarming range of values should be highlighted in the widget.

        :default: false

        :stability: experimental
        '''
        result = self._values.get("fill_alarm_range")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def period(self) -> typing.Optional[aws_cdk.Duration]:
        '''(experimental) Period override for the metric to alarm on.

        :default: the default specified in MetricFactory

        :stability: experimental
        '''
        result = self._values.get("period")
        return typing.cast(typing.Optional[aws_cdk.Duration], result)

    @builtins.property
    def runbook_link(self) -> typing.Optional[builtins.str]:
        '''(experimental) An optional link included in the generated ticket description body.

        :default: no additional link will be added

        :stability: experimental
        '''
        result = self._values.get("runbook_link")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def treat_missing_data_override(
        self,
    ) -> typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData]:
        '''(experimental) Behaviour in case the metric data is missing.

        :default: alarm-specific default

        :stability: experimental
        '''
        result = self._values.get("treat_missing_data_override")
        return typing.cast(typing.Optional[aws_cdk.aws_cloudwatch.TreatMissingData], result)

    @builtins.property
    def max_notifications_failed_count(self) -> jsii.Number:
        '''
        :stability: experimental
        '''
        result = self._values.get("max_notifications_failed_count")
        assert result is not None, "Required property 'max_notifications_failed_count' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "NotificationsFailedThreshold(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class OpenSearchBackportedMetrics(
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-monitoring-constructs.OpenSearchBackportedMetrics",
):
    '''(experimental) Backported set of metric functions added in @aws-cdk/aws-elasticsearch@1.65.0.

    :see: https://github.com/aws/aws-cdk/releases/tag/v1.73.0
    :stability: experimental
    '''

    def __init__(
        self,
        domain: typing.Union[aws_cdk.aws_elasticsearch.IDomain, aws_cdk.aws_elasticsearch.CfnDomain, aws_cdk.aws_opensearchservice.IDomain, aws_cdk.aws_opensearchservice.CfnDomain],
    ) -> None:
        '''
        :param domain: -

        :stability: experimental
        '''
        jsii.create(self.__class__, self, [domain])

    @jsii.member(jsii_name="metric")
    def metric(
        self,
        metric_name: builtins.str,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions_map: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[aws_cdk.aws_cloudwatch.Unit] = None,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''(experimental) Return the given named metric for this Domain.

        :param metric_name: -
        :param account: Account which this metric comes from. Default: - Deployment account.
        :param color: The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions_map: Dimensions of the metric. Default: - No dimensions.
        :param label: Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: Region which this metric comes from. Default: - Deployment region.
        :param statistic: What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.MetricOptions(
            account=account,
            color=color,
            dimensions_map=dimensions_map,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metric", [metric_name, props]))

    @jsii.member(jsii_name="metricAutomatedSnapshotFailure")
    def metric_automated_snapshot_failure(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions_map: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[aws_cdk.aws_cloudwatch.Unit] = None,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''(experimental) Metric for automated snapshot failures.

        :param account: Account which this metric comes from. Default: - Deployment account.
        :param color: The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions_map: Dimensions of the metric. Default: - No dimensions.
        :param label: Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: Region which this metric comes from. Default: - Deployment region.
        :param statistic: What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: maximum over 5 minutes

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.MetricOptions(
            account=account,
            color=color,
            dimensions_map=dimensions_map,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricAutomatedSnapshotFailure", [props]))

    @jsii.member(jsii_name="metricClusterIndexWriteBlocked")
    def metric_cluster_index_write_blocked(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions_map: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[aws_cdk.aws_cloudwatch.Unit] = None,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''(experimental) Metric for the cluster blocking index writes.

        :param account: Account which this metric comes from. Default: - Deployment account.
        :param color: The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions_map: Dimensions of the metric. Default: - No dimensions.
        :param label: Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: Region which this metric comes from. Default: - Deployment region.
        :param statistic: What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: maximum over 1 minute

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.MetricOptions(
            account=account,
            color=color,
            dimensions_map=dimensions_map,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricClusterIndexWriteBlocked", [props]))

    @jsii.member(jsii_name="metricClusterStatusRed")
    def metric_cluster_status_red(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions_map: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[aws_cdk.aws_cloudwatch.Unit] = None,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''(experimental) Metric for the time the cluster status is red.

        :param account: Account which this metric comes from. Default: - Deployment account.
        :param color: The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions_map: Dimensions of the metric. Default: - No dimensions.
        :param label: Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: Region which this metric comes from. Default: - Deployment region.
        :param statistic: What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: maximum over 5 minutes

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.MetricOptions(
            account=account,
            color=color,
            dimensions_map=dimensions_map,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricClusterStatusRed", [props]))

    @jsii.member(jsii_name="metricClusterStatusYellow")
    def metric_cluster_status_yellow(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions_map: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[aws_cdk.aws_cloudwatch.Unit] = None,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''(experimental) Metric for the time the cluster status is yellow.

        :param account: Account which this metric comes from. Default: - Deployment account.
        :param color: The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :param dimensions_map: Dimensions of the metric. Default: - No dimensions.
        :param label: Label for this metric when added to a Graph in a Dashboard. Default: - No label
        :param period: The period over which the specified statistic is applied. Default: Duration.minutes(5)
        :param region: Region which this metric comes from. Default: - Deployment region.
        :param statistic: What function to use for aggregating. Can be one of the following: - "Minimum" | "min" - "Maximum" | "max" - "Average" | "avg" - "Sum" | "sum" - "SampleCount | "n" - "pNN.NN" Default: Average
        :param unit: Unit used to filter the metric stream. Only refer to datums emitted to the metric stream with the given unit and ignore all others. Only useful when datums are being emitted to the same metric stream under different units. The default is to use all matric datums in the stream, regardless of unit, which is recommended in nearly all cases. CloudWatch does not honor this property for graphs. Default: - All metric datums in the given metric stream

        :default: maximum over 5 minutes

        :stability: experimental
        '''
        props = aws_cdk.aws_cloudwatch.MetricOptions(
            account=account,
            color=color,
            dimensions_map=dimensions_map,
            label=label,
            period=period,
            region=region,
            statistic=statistic,
            unit=unit,
        )

        return typing.cast(aws_cdk.aws_cloudwatch.Metric, jsii.invoke(self, "metricClusterStatusYellow", [props]))

    @jsii.member(jsii_name="metricCPUUtilization")
    def metric_cpu_utilization(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        color: typing.Optional[builtins.str] = None,
        dimensions_map: typing.Optional[typing.Mapping[builtins.str, builtins.str]] = None,
        label: typing.Optional[builtins.str] = None,
        period: typing.Optional[aws_cdk.Duration] = None,
        region: typing.Optional[builtins.str] = None,
        statistic: typing.Optional[builtins.str] = None,
        unit: typing.Optional[aws_cdk.aws_cloudwatch.Unit] = None,
    ) -> aws_cdk.aws_cloudwatch.Metric:
        '''(experimental) Metric for CPU utilization.

        :param account: Account which this metric comes from. Default: - Deployment account.
        :param color: The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The ``Color`` class has a set of standard colors that can be used here. Default: - Automatic color
        :