# mypy-boto3-cloudfront

[![PyPI - mypy-boto3-cloudfront](https://img.shields.io/pypi/v/mypy-boto3-cloudfront.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudfront)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudfront.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudfront)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudFront 1.14.18](https://boto3.amazonaws.com/v1/documentation/api/1.14.18/reference/services/cloudfront.html#CloudFront) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudFront` service.

```bash
python -m pip install boto3-stubs[cloudfront]
```

## How to use

### Client annotations

`CloudFrontClient` provides annotations for `boto3.client("cloudfront")`.

```python
import boto3

from mypy_boto3_cloudfront import CloudFrontClient
from mypy_boto3_cloudfront.paginator import (
    ListCloudFrontOriginAccessIdentitiesPaginator,
    ListDistributionsPaginator,
    ListInvalidationsPaginator,
    ListStreamingDistributionsPaginator,
)
from mypy_boto3_cloudfront.type_defs import ActiveTrustedSignersTypeDef, ...
from mypy_boto3_cloudfront.waiter import (
    DistributionDeployedWaiter,
    InvalidationCompletedWaiter,
    StreamingDistributionDeployedWaiter,
)

client: CloudFrontClient = boto3.client("cloudfront")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudFrontClient = session.client("cloudfront")
```

### Paginators annotations

`mypy_boto3_cloudfront.paginator` module contains type annotations for all paginators.

```python

client: CloudFrontClient = boto3.client("cloudfront")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_cloud_front_origin_access_identities_paginator: ListCloudFrontOriginAccessIdentitiesPaginator = client.get_paginator("list_cloud_front_origin_access_identities")
list_distributions_paginator: ListDistributionsPaginator = client.get_paginator("list_distributions")
list_invalidations_paginator: ListInvalidationsPaginator = client.get_paginator("list_invalidations")
list_streaming_distributions_paginator: ListStreamingDistributionsPaginator = client.get_paginator("list_streaming_distributions")
```


### Waiters annotations

`mypy_boto3_cloudfront.waiter` module contains type annotations for all waiters.

```python

client: CloudFrontClient = boto3.client("cloudfront")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
distribution_deployed_waiter: DistributionDeployedWaiter = client.get_waiter("distribution_deployed")
invalidation_completed_waiter: InvalidationCompletedWaiter = client.get_waiter("invalidation_completed")
streaming_distribution_deployed_waiter: StreamingDistributionDeployedWaiter = client.get_waiter("streaming_distribution_deployed")
```





### Typed dictionations

`mypy_boto3_cloudfront.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> ActiveTrustedSignersTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_cloudfront` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("cloudfront")

session_client = boto3.Session().client("cloudfront")
```
