# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../pts/api/llm/04_internal_utils.pct.py.

# %% auto 0
__all__ = []

# %% ../../../pts/api/llm/04_internal_utils.pct.py 3
try:
    import litellm
    import inspect
    import time
    import asyncio
    import warnings
    from typing import Callable, Optional, Union
    from pathlib import Path
    from adulib.caching import get_default_cache_path
    from adulib.llm.caching import _cache_execute, _async_cache_execute, get_cache_key, is_in_cache
    from adulib.llm.call_logging import _log_call, get_cached_call_log, _add_log_to_tracker, CallLog
    from adulib.llm.rate_limits import _get_limiter, default_retry_on_exception, default_max_retries, default_retry_delay, default_timeout
except ImportError as e:
    raise ImportError(f"Install adulib[llm] to use this API.") from e

# %% ../../../pts/api/llm/04_internal_utils.pct.py 6
class MaximumRetriesException(Exception):
    def __init__(self, retry_exceptions: list[Exception]):
        self.retry_exceptions = retry_exceptions
        self.retry_exceptions_str = "\n".join([f"{i}: ({type(e).__name__}) {e}" for i, e in enumerate(retry_exceptions)])
        super().__init__(f"Maximum retries ({len(retry_exceptions)}) reached. Exceptions:\n{self.retry_exceptions_str}")

# %% ../../../pts/api/llm/04_internal_utils.pct.py 7
def _llm_func_factory(
    func: Callable,
    func_name: str,
    func_cache_name: str,
    module_name: str,
    cache_key_content_args: list[str],
    retrieve_log_data: Optional[Callable] = None,
    default_return_info: bool = True,
):
    func_sig = inspect.signature(func)
    def llm_func(
        *args,
        # Cache settings
        cache_enabled: bool=True,
        cache_path: Optional[Union[str, Path]]=None,
        cache_key_prefix: Optional[str]=None,
        include_model_in_cache_key: bool=True,
        return_cache_key: bool=False,
        return_info: bool=default_return_info,
        # Retry settings
        enable_retries: bool=True,
        retry_on_exceptions: Optional[list[Exception]]=None,
        retry_on_all_exceptions: bool=False,
        max_retries: Optional[int]=None,
        retry_delay: Optional[int]=None,
        **kwargs,
    ):
        if retry_on_exceptions is None: retry_on_exceptions = default_retry_on_exception
        if max_retries is None: max_retries = default_max_retries
        if retry_delay is None: retry_delay = default_retry_delay
        
        # Check that all args in cache_key_content are valid
        if not all(arg in func_sig.parameters for arg in cache_key_content_args):
            raise ValueError(f"Invalid cache_key_content_args: {cache_key_content_args}.")
        
        # Generate cache key
        bound = func_sig.bind(*args, **kwargs)
        func_args_and_kwargs = dict(bound.arguments)
        cache_key_content = {k: func_args_and_kwargs[k] for k in cache_key_content_args if k in func_args_and_kwargs}
        model = func_args_and_kwargs['model']
        cache_key = get_cache_key(model, func_cache_name, func_args_and_kwargs, cache_key_prefix, include_model_in_cache_key)
        if return_cache_key: return cache_key
        
        if cache_path is None:
            cache_path = get_default_cache_path()
        
        # Execute with caching and retries
        success = False
        exceptions = []
        for _ in range(max_retries):
            try:
                cache_hit, result = _cache_execute(
                    cache_key=cache_key,
                    execute_func=lambda: func(*args, **kwargs),
                    cache_enabled=cache_enabled,
                    cache_path=cache_path,
                )
                success = True
                break
            except BaseException as e:
                if not enable_retries: raise e
                if not (retry_on_all_exceptions or any([isinstance(e, exc) for exc in retry_on_exceptions])): raise e
                exceptions.append(e)
                time.sleep(retry_delay)
                    
        if not success:
            raise MaximumRetriesException(exceptions)
        
        # Call logging
        if retrieve_log_data is not None:
            if not cache_hit:
                cache_args = {
                    "cache_path": cache_path,
                    "cache_key_prefix": cache_key_prefix,
                    "include_model_in_cache_key": include_model_in_cache_key,
                }
                log_data = retrieve_log_data(model, func_args_and_kwargs, result, cache_args)
                _log_call(cache_key, cache_path, model=model, **log_data)

            call_info = get_cached_call_log(cache_key, cache_path)
            if call_info is None:
                warnings.warn(f"Call log for cache key '{cache_key}' not found in cache at '{cache_path}'. This may indicate a caching issue.")
                
            _add_log_to_tracker(call_info, cache_hit) # Track the call log if a tracker is set up
        
        if return_info:
            if retrieve_log_data is not None:
                return result, cache_hit, call_info
            else:
                return result, cache_hit
        else:
            return result
    
    llm_func.__name__ = func_name
    llm_func.__module__ = module_name
    llm_func.__qualname__ = func_name
    return llm_func

# %% ../../../pts/api/llm/04_internal_utils.pct.py 10
def _llm_async_func_factory(
    func: Callable,
    func_name: str,
    func_cache_name: str,
    module_name: str,
    cache_key_content_args: list[str],
    retrieve_log_data: Optional[Callable] = None,
    default_return_info: bool = True,
):
    func_sig = inspect.signature(func)
    async def llm_func(
        *args,
        # Cache settings
        cache_enabled: bool=True,
        cache_path: Optional[Union[str, Path]]=None,
        cache_key_prefix: Optional[str]=None,
        include_model_in_cache_key: bool=True,
        return_cache_key: bool=False,
        return_info: bool=default_return_info,
        # Retry settings
        enable_retries: bool=True,
        retry_on_exceptions: Optional[list[Exception]]=None,
        retry_on_all_exceptions: bool=False,
        max_retries: Optional[int]=None,
        retry_delay: Optional[int]=None,
        timeout: Optional[int]=None,
        **kwargs,
    ):
        if retry_on_exceptions is None: retry_on_exceptions = default_retry_on_exception
        if max_retries is None: max_retries = default_max_retries
        if retry_delay is None: retry_delay = default_retry_delay
        if timeout is None: timeout = default_timeout
        
        # Check that all args in cache_key_content are valid
        if not all(arg in func_sig.parameters for arg in cache_key_content_args):
            raise ValueError(f"Invalid cache_key_content_args: {cache_key_content_args}.")
        
        # Generate cache key
        bound = func_sig.bind(*args, **kwargs)
        func_args_and_kwargs = dict(bound.arguments)
        cache_key_content = {k: func_args_and_kwargs[k] for k in cache_key_content_args if k in func_args_and_kwargs}
        model = func_args_and_kwargs['model']
        cache_key = get_cache_key(model, func_cache_name, cache_key_content, cache_key_prefix, include_model_in_cache_key)
        if return_cache_key: return cache_key
        
        if cache_path is None:
            cache_path = get_default_cache_path()
        
        # Rate limiting
        key_in_cache = is_in_cache(cache_key, cache=cache_path)
        if not key_in_cache:
            api_key = kwargs.get("api_key", None)
            await _get_limiter(model, api_key).wait()
        
        # Execute with caching and retries
        success = False
        exceptions = []
        async def run_with_timeout():
            return await asyncio.wait_for(func(*args, **kwargs), timeout)
        for _ in range(max_retries):
            try:                
                cache_hit, result = await _async_cache_execute(
                    cache_key=cache_key,
                    execute_func=run_with_timeout if timeout is not None else lambda: func(*args, **kwargs),
                    cache_enabled=cache_enabled,
                    cache_path=cache_path,
                )
                success = True
                break
            except BaseException as e:
                if not enable_retries: raise e
                if not (retry_on_all_exceptions or any([isinstance(e, exc) for exc in retry_on_exceptions])): raise e
                exceptions.append(e)
                await asyncio.sleep(retry_delay)
                    
        if not success:
            raise MaximumRetriesException(exceptions)
        
        # Call logging
        if retrieve_log_data is not None:
            if not cache_hit:
                cache_args = {
                    "cache_path": cache_path,
                    "cache_key_prefix": cache_key_prefix,
                    "include_model_in_cache_key": include_model_in_cache_key,
                }
                log_data = retrieve_log_data(model, func_args_and_kwargs, result, cache_args)
                _log_call(cache_key, cache_path, model=model, **log_data)

            call_info = get_cached_call_log(cache_key, cache_path)
            if call_info is None:
                warnings.warn(f"Call log for cache key '{cache_key}' not found in cache at '{cache_path}'. This may indicate a caching issue.")
                
            _add_log_to_tracker(CallLog(**call_info), cache_hit) # Track the call log if a tracker is set up
        
        if return_info:
            if retrieve_log_data is not None:
                return result, cache_hit, call_info
            else:
                return result, cache_hit
        else:
            return result
    
    llm_func.__name__ = func_name
    llm_func.__module__ = module_name
    llm_func.__qualname__ = func_name
    return llm_func
