"""Otherwise known as *chat completions*. See the [`litellm` documention](https://docs.litellm.ai/docs/completion)."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../pts/api/llm/06_completions.pct.py.

# %% auto 0
__all__ = ['completion', 'sig', 'async_completion', 'single', 'async_single']

# %% ../../../pts/api/llm/06_completions.pct.py 3
try:
    import litellm
    import inspect
    from inspect import Parameter
    import functools
    from typing import List, Dict
    from adulib.llm._utils import _llm_func_factory, _llm_async_func_factory
    from adulib.llm.tokens import token_counter
except ImportError as e:
    raise ImportError(f"Install adulib[llm] to use this API.") from e

# %% ../../../pts/api/llm/06_completions.pct.py 8
completion = _llm_func_factory(
    func=litellm.completion,
    func_name="completion",
    func_cache_name="completion",
    module_name=__name__,
    cache_key_content_args=['messages', 'response_format'],
    retrieve_log_data=lambda model, func_kwargs, response, cache_args: {
        "method": "completion",
        "input_tokens": token_counter(model=model, messages=func_kwargs['messages'], **cache_args),
        "output_tokens": sum([token_counter(model=model, messages=[{'role': c.message.role, 'content': c.message.content}], **cache_args) for c in response.choices]),
        "cost": response._hidden_params['response_cost'],
    }
)

completion.__doc__ = """
This function is a wrapper around a corresponding function in the `litellm` library, see [this](https://docs.litellm.ai/docs/completion/input) for a full list of the available arguments.
""".strip()

sig = inspect.signature(completion)
sig = sig.replace(parameters=[
    Parameter("model", Parameter.POSITIONAL_OR_KEYWORD, annotation=str),
    Parameter("messages", Parameter.POSITIONAL_OR_KEYWORD, annotation=List[Dict[str, str]]),
    *sig.parameters.values()
])
completion.__signature__ = sig

# %% ../../../pts/api/llm/06_completions.pct.py 16
async_completion = _llm_async_func_factory(
    func=litellm.acompletion,
    func_name="async_completion",
    func_cache_name="completion",
    module_name=__name__,
    cache_key_content_args=['messages', 'response_format'],
    retrieve_log_data=lambda model, func_kwargs, response, cache_args: {
        "method": "completion",
        "input_tokens": token_counter(model=model, messages=func_kwargs['messages'], **cache_args),
        "output_tokens": sum([token_counter(model=model, messages=[{'role': c.message.role, 'content': c.message.content}], **cache_args) for c in response.choices]),
        "cost": response._hidden_params['response_cost'],
    }
)

completion.__doc__ = """
This function is a wrapper around a corresponding function in the `litellm` library, see [this](https://docs.litellm.ai/docs/completion/input) for a full list of the available arguments.
""".strip()

sig = inspect.signature(async_completion)
sig = sig.replace(parameters=[
    Parameter("model", Parameter.POSITIONAL_OR_KEYWORD, annotation=str),
    Parameter("messages", Parameter.POSITIONAL_OR_KEYWORD, annotation=List[Dict[str, str]]),
    *sig.parameters.values()
])
async_completion.__signature__ = sig

# %% ../../../pts/api/llm/06_completions.pct.py 19
def _get_msgs(orig_msgs, response):
    if len(response.choices) == 0: return orig_msgs
    msgs = orig_msgs.copy()
    # msgs.append(response.choices[0].message.model_dump())
    msgs.append({ 'role': response.choices[0].message.role, 'content': response.choices[0].message.content })
    return msgs

# %% ../../../pts/api/llm/06_completions.pct.py 20
def single(
    prompt: str,
    model: str|None = None,
    system: str|None = None,
    *args,
    multi: bool|Dict|None = None,
    return_full_response: bool=False,
    return_info: bool=True,
    **kwargs,
):
    if system is None and multi is None: system = "You are a helpful assistant."
    if system is not None and type(multi) == dict: raise ValueError("Cannot provide `system` if already in multi-turn completion mode.")
    if multi: model = model or multi['model']
    
    if type(multi) == dict:
        messages = multi['messages'].copy() + [ {"role": "user", "content": prompt} ]
    else:
        messages = [
            {"role": "system", "content": system},
            {"role": "user", "content": prompt}
        ]
    
    if model is None: raise ValueError("`model` must be provided.")
    
    response, cache_hit, call_log = completion(model, messages, *args, **kwargs)
    
    res = response.choices[0].message.content if not return_full_response else response
    if multi is not None:
        res = res, {'model' : model, 'messages' : _get_msgs(messages, response)}
    
    return res, cache_hit, call_log if return_info else res
    
single.__name__ = "single"
single.__doc__ = """
Simplified chat completions designed for single-turn tasks like classification, summarization, or extraction. For a full list of the available arguments see the [documentation](https://docs.litellm.ai/docs/completion/input) for the `completion` function in `litellm`.

If 'return_info' is set to True, the function returns a tuple of the response, cache hit status, and call log. If set to False, it returns only the response.
If 'multi' is provided, it should be a dictionary containing the model and messages from previous turns, allowing for multi-turn interactions. The function will append the new prompt to the existing messages.
""".strip()

# %% ../../../pts/api/llm/06_completions.pct.py 26
async def async_single(
    prompt: str,
    model: str|None = None,
    system: str|None = None,
    *args,
    multi: bool|Dict|None = None,
    return_full_response: bool=False,
    return_info: bool=True,
    **kwargs,
):
    if system is None and multi is None: system = "You are a helpful assistant."
    if system is not None and type(multi) == dict: raise ValueError("Cannot provide `system` if already in multi-turn completion mode.")
    if multi: model = model or multi['model']
    
    if type(multi) == dict:
        messages = multi['messages'].copy() + [ {"role": "user", "content": prompt} ]
    else:
        messages = [
            {"role": "system", "content": system},
            {"role": "user", "content": prompt}
        ]
    
    if model is None: raise ValueError("`model` must be provided.")
    
    response, cache_hit, call_log = await async_completion(model, messages, *args, **kwargs)
    
    res = response.choices[0].message.content if not return_full_response else response
    if multi is not None:
        res = res, {'model' : model, 'messages' : _get_msgs(messages, response)}
    
    return res, cache_hit, call_log if return_info else res
    
async_single.__name__ = "async_single"
async_single.__doc__ = """
Simplified chat completions designed for single-turn tasks like classification, summarization, or extraction. For a full list of the available arguments see the [documentation](https://docs.litellm.ai/docs/completion/input) for the `completion` function in `litellm`.

If 'return_info' is set to True, the function returns a tuple of the response, cache hit status, and call log. If set to False, it returns only the response.
If 'multi' is provided, it should be a dictionary containing the model and messages from previous turns, allowing for multi-turn interactions. The function will append the new prompt to the existing messages.
""".strip()
