# NodCast

NodCast is a keyboard-driven, text-based reading platform designed for focused, distraction-free engagement with articles and scientific papers. It introduces a novel method for reading and writing by allowing readers to interact with text through short written signals called **nods**, track comprehension, and flag ambiguous or challenging sections.

Articles can be annotated dynamically, and your interactions provide feedback for understanding and coherence, helping both readers and writers improve the reading experience.

For more details, visit [NodCast Website](http://puraminy.github.io/nodcast/).

## Key Features

- **Interactive Reading**: Engage with each sentence via affirming or reflective nods.
- **Custom Feedback**: Add your own nods and questions to capture points of confusion or reasoning gaps.
- **Read Aloud**: Supports Google Text-to-Speech for listening to articles while reading.
- **Article Scoring and Feedback**: Create and read articles that receive scores and feedback from community, helping writers improve clarity and coherence.
- **Context-Aware Summaries**: Quickly focus on core ideas without losing track of the narrative.
- **Dynamic Article Analysis**: Tracks reading behavior to highlight confusing sections or important points.
- **Keyboard-Centric Navigation**: Designed for smooth terminal interaction with minimal distractions.

## Installation

Installation on linux:
```
pip install nodcast
```
### Installation on Windows
For Windows you need to instll `windows-curses` package too, so use the following command:
```
pip install windows-curses nodcast
```

 

