# Contributing to portndock

Thank you for your interest in contributing to portndock! We welcome contributions from the community.

## How to Contribute

### Reporting Issues
- Use GitHub Issues to report bugs or request features
- Include your operating system and Python version
- Provide steps to reproduce any bugs

### Contributing Code
1. Fork the repository
2. Create a feature branch: `git checkout -b feature-name`
3. Make your changes
4. Test your changes thoroughly
5. Submit a pull request

### Development Setup
```bash
git clone https://github.com/decentaro/portndock.git
cd portndock
python -m pip install -e .
```

### Code Style
- Follow existing code patterns
- Keep functions focused and well-documented
- Test on multiple platforms when possible

### Areas We'd Love Help With
- Cross-platform compatibility improvements
- Performance optimizations
- Additional Docker features
- UI/UX enhancements
- Documentation improvements

## Questions?
Open a GitHub Discussion or Issue - we're happy to help!

---
**Let's build the best port management tool for developers together!**