# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import List, Optional

import httpx

from ..types import app_build_list_params, app_build_create_params
from .._types import Body, Omit, Query, Headers, NotGiven, omit, not_given
from .._utils import maybe_transform, async_maybe_transform
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..pagination import SyncCursorPage, AsyncCursorPage
from .._base_client import AsyncPaginator, make_request_options
from ..types.shared.app_build import AppBuild
from ..types.shared.app_view_type import AppViewType
from ..types.app_build_list_response import AppBuildListResponse
from ..types.shared.app_build_statuses import AppBuildStatuses
from ..types.shared.app_build_platforms import AppBuildPlatforms

__all__ = ["AppBuildsResource", "AsyncAppBuildsResource"]


class AppBuildsResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AppBuildsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/whopio/whopsdk-python#accessing-raw-response-data-eg-headers
        """
        return AppBuildsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AppBuildsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/whopio/whopsdk-python#with_streaming_response
        """
        return AppBuildsResourceWithStreamingResponse(self)

    def create(
        self,
        *,
        attachment: app_build_create_params.Attachment,
        checksum: str,
        platform: AppBuildPlatforms,
        app_id: Optional[str] | Omit = omit,
        supported_app_view_types: Optional[List[AppViewType]] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AppBuild:
        """
        Creates a new app build

        Required permissions:

        - `developer:manage_builds`

        Args:
          attachment: Attachment input for the app build file. This should be an upload in .zip
              format. The zip should contain at least one main_js_bundle.hbc file and
              optionally an assets folder next to it.

          checksum: Checksum of the app build file. This is generated by the client and used to
              verify the integrity of the file that is submitted when un-packaged later on a
              device.

          platform: The platform of the app build (ios, android, web)

          app_id: The ID of the app to create a build for. By default the current app from the api
              key is used.

          supported_app_view_types: Supported app view types for the app build. A build can specify multiple view
              types, but should only specify ones that its code supports.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._post(
            "/app_builds",
            body=maybe_transform(
                {
                    "attachment": attachment,
                    "checksum": checksum,
                    "platform": platform,
                    "app_id": app_id,
                    "supported_app_view_types": supported_app_view_types,
                },
                app_build_create_params.AppBuildCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AppBuild,
        )

    def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AppBuild:
        """
        Retrieves an app build by ID

        Required permissions:

        - `developer:manage_builds`

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._get(
            f"/app_builds/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AppBuild,
        )

    def list(
        self,
        *,
        app_id: str,
        after: Optional[str] | Omit = omit,
        before: Optional[str] | Omit = omit,
        first: Optional[int] | Omit = omit,
        last: Optional[int] | Omit = omit,
        platform: Optional[AppBuildPlatforms] | Omit = omit,
        status: Optional[AppBuildStatuses] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> SyncCursorPage[AppBuildListResponse]:
        """
        Lists app builds for an app

        Required permissions:

        - `developer:manage_builds`

        Args:
          app_id: The ID of the app to filter app builds by

          after: Returns the elements in the list that come after the specified cursor.

          before: Returns the elements in the list that come before the specified cursor.

          first: Returns the first _n_ elements from the list.

          last: Returns the last _n_ elements from the list.

          platform: The different platforms an app build can target.

          status: The different statuses an AppBuild can be in.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/app_builds",
            page=SyncCursorPage[AppBuildListResponse],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "app_id": app_id,
                        "after": after,
                        "before": before,
                        "first": first,
                        "last": last,
                        "platform": platform,
                        "status": status,
                    },
                    app_build_list_params.AppBuildListParams,
                ),
            ),
            model=AppBuildListResponse,
        )

    def promote(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AppBuild:
        """
        Promotes an app build to production

        Required permissions:

        - `developer:manage_builds`

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return self._post(
            f"/app_builds/{id}/promote",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AppBuild,
        )


class AsyncAppBuildsResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncAppBuildsResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/whopio/whopsdk-python#accessing-raw-response-data-eg-headers
        """
        return AsyncAppBuildsResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncAppBuildsResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/whopio/whopsdk-python#with_streaming_response
        """
        return AsyncAppBuildsResourceWithStreamingResponse(self)

    async def create(
        self,
        *,
        attachment: app_build_create_params.Attachment,
        checksum: str,
        platform: AppBuildPlatforms,
        app_id: Optional[str] | Omit = omit,
        supported_app_view_types: Optional[List[AppViewType]] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AppBuild:
        """
        Creates a new app build

        Required permissions:

        - `developer:manage_builds`

        Args:
          attachment: Attachment input for the app build file. This should be an upload in .zip
              format. The zip should contain at least one main_js_bundle.hbc file and
              optionally an assets folder next to it.

          checksum: Checksum of the app build file. This is generated by the client and used to
              verify the integrity of the file that is submitted when un-packaged later on a
              device.

          platform: The platform of the app build (ios, android, web)

          app_id: The ID of the app to create a build for. By default the current app from the api
              key is used.

          supported_app_view_types: Supported app view types for the app build. A build can specify multiple view
              types, but should only specify ones that its code supports.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return await self._post(
            "/app_builds",
            body=await async_maybe_transform(
                {
                    "attachment": attachment,
                    "checksum": checksum,
                    "platform": platform,
                    "app_id": app_id,
                    "supported_app_view_types": supported_app_view_types,
                },
                app_build_create_params.AppBuildCreateParams,
            ),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AppBuild,
        )

    async def retrieve(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AppBuild:
        """
        Retrieves an app build by ID

        Required permissions:

        - `developer:manage_builds`

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._get(
            f"/app_builds/{id}",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AppBuild,
        )

    def list(
        self,
        *,
        app_id: str,
        after: Optional[str] | Omit = omit,
        before: Optional[str] | Omit = omit,
        first: Optional[int] | Omit = omit,
        last: Optional[int] | Omit = omit,
        platform: Optional[AppBuildPlatforms] | Omit = omit,
        status: Optional[AppBuildStatuses] | Omit = omit,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AsyncPaginator[AppBuildListResponse, AsyncCursorPage[AppBuildListResponse]]:
        """
        Lists app builds for an app

        Required permissions:

        - `developer:manage_builds`

        Args:
          app_id: The ID of the app to filter app builds by

          after: Returns the elements in the list that come after the specified cursor.

          before: Returns the elements in the list that come before the specified cursor.

          first: Returns the first _n_ elements from the list.

          last: Returns the last _n_ elements from the list.

          platform: The different platforms an app build can target.

          status: The different statuses an AppBuild can be in.

          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/app_builds",
            page=AsyncCursorPage[AppBuildListResponse],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "app_id": app_id,
                        "after": after,
                        "before": before,
                        "first": first,
                        "last": last,
                        "platform": platform,
                        "status": status,
                    },
                    app_build_list_params.AppBuildListParams,
                ),
            ),
            model=AppBuildListResponse,
        )

    async def promote(
        self,
        id: str,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = not_given,
    ) -> AppBuild:
        """
        Promotes an app build to production

        Required permissions:

        - `developer:manage_builds`

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        if not id:
            raise ValueError(f"Expected a non-empty value for `id` but received {id!r}")
        return await self._post(
            f"/app_builds/{id}/promote",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AppBuild,
        )


class AppBuildsResourceWithRawResponse:
    def __init__(self, app_builds: AppBuildsResource) -> None:
        self._app_builds = app_builds

        self.create = to_raw_response_wrapper(
            app_builds.create,
        )
        self.retrieve = to_raw_response_wrapper(
            app_builds.retrieve,
        )
        self.list = to_raw_response_wrapper(
            app_builds.list,
        )
        self.promote = to_raw_response_wrapper(
            app_builds.promote,
        )


class AsyncAppBuildsResourceWithRawResponse:
    def __init__(self, app_builds: AsyncAppBuildsResource) -> None:
        self._app_builds = app_builds

        self.create = async_to_raw_response_wrapper(
            app_builds.create,
        )
        self.retrieve = async_to_raw_response_wrapper(
            app_builds.retrieve,
        )
        self.list = async_to_raw_response_wrapper(
            app_builds.list,
        )
        self.promote = async_to_raw_response_wrapper(
            app_builds.promote,
        )


class AppBuildsResourceWithStreamingResponse:
    def __init__(self, app_builds: AppBuildsResource) -> None:
        self._app_builds = app_builds

        self.create = to_streamed_response_wrapper(
            app_builds.create,
        )
        self.retrieve = to_streamed_response_wrapper(
            app_builds.retrieve,
        )
        self.list = to_streamed_response_wrapper(
            app_builds.list,
        )
        self.promote = to_streamed_response_wrapper(
            app_builds.promote,
        )


class AsyncAppBuildsResourceWithStreamingResponse:
    def __init__(self, app_builds: AsyncAppBuildsResource) -> None:
        self._app_builds = app_builds

        self.create = async_to_streamed_response_wrapper(
            app_builds.create,
        )
        self.retrieve = async_to_streamed_response_wrapper(
            app_builds.retrieve,
        )
        self.list = async_to_streamed_response_wrapper(
            app_builds.list,
        )
        self.promote = async_to_streamed_response_wrapper(
            app_builds.promote,
        )
