# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import List, Union, Optional
from typing_extensions import Required, TypeAlias, TypedDict

from .shared.app_view_type import AppViewType
from .shared.app_build_platforms import AppBuildPlatforms

__all__ = [
    "AppBuildCreateParams",
    "Attachment",
    "AttachmentAttachmentInputWithDirectUploadID",
    "AttachmentAttachmentInputWithID",
]


class AppBuildCreateParams(TypedDict, total=False):
    attachment: Required[Attachment]
    """Attachment input for the app build file.

    This should be an upload in .zip format. The zip should contain at least one
    main_js_bundle.hbc file and optionally an assets folder next to it.
    """

    checksum: Required[str]
    """Checksum of the app build file.

    This is generated by the client and used to verify the integrity of the file
    that is submitted when un-packaged later on a device.
    """

    platform: Required[AppBuildPlatforms]
    """The platform of the app build (ios, android, web)"""

    app_id: Optional[str]
    """The ID of the app to create a build for.

    By default the current app from the api key is used.
    """

    supported_app_view_types: Optional[List[AppViewType]]
    """Supported app view types for the app build.

    A build can specify multiple view types, but should only specify ones that its
    code supports.
    """


class AttachmentAttachmentInputWithDirectUploadID(TypedDict, total=False):
    direct_upload_id: Required[str]
    """This ID should be used the first time you upload an attachment.

    It is the ID of the direct upload that was created when uploading the file to S3
    via the mediaDirectUpload mutation.
    """


class AttachmentAttachmentInputWithID(TypedDict, total=False):
    id: Required[str]
    """The ID of an existing attachment object.

    Use this when updating a resource and keeping a subset of the attachments. Don't
    use this unless you know what you're doing.
    """


Attachment: TypeAlias = Union[AttachmentAttachmentInputWithDirectUploadID, AttachmentAttachmentInputWithID]
