# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from datetime import datetime

from .._models import BaseModel
from .shared.app_view_type import AppViewType
from .shared.app_build_statuses import AppBuildStatuses
from .shared.app_build_platforms import AppBuildPlatforms

__all__ = ["AppBuildListResponse"]


class AppBuildListResponse(BaseModel):
    id: str
    """The ID of the app build. It will look like apbu_xxxxx."""

    checksum: str
    """
    This is generated by the client and used to verify the integrity of the file
    that is submitted. It is a SHA256 hash of the app build file.
    """

    created_at: datetime
    """When this app build was created."""

    file_url: str
    """The URL to download the app build .zip file."""

    is_production: bool
    """Whether this app build is currently being used in production."""

    platform: AppBuildPlatforms
    """The platform of the app build (ios, android, web)"""

    review_message: Optional[str] = None
    """The review message for the app build, if any.

    This is populated when the build is rejected and there is a reason specified by
    the reviewer.
    """

    status: AppBuildStatuses
    """The status of the app build (draft, approved, rejected, pending, etc)"""

    supported_app_view_types: List[AppViewType]
    """The supported app view types for the app build.

    These are the views that the developer has specified that this build supports.
    """
