# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Iterable, Optional
from typing_extensions import Literal, Required, TypedDict

from .._types import SequenceNotStr
from .shared.currency import Currency
from .shared.plan_type import PlanType
from .shared.custom_cta import CustomCta
from .shared.visibility import Visibility
from .shared.business_types import BusinessTypes
from .shared.industry_types import IndustryTypes
from .shared.release_method import ReleaseMethod
from .shared.global_affiliate_status import GlobalAffiliateStatus

__all__ = ["ProductCreateParams", "PlanOptions", "PlanOptionsCustomField", "ProductHighlight"]


class ProductCreateParams(TypedDict, total=False):
    company_id: Required[str]
    """The ID of the company to create the product for."""

    title: Required[str]
    """The title of the product."""

    business_type: Optional[BusinessTypes]
    """The different business types a company can be."""

    collect_shipping_address: Optional[bool]
    """Whether or not to collect shipping information at checkout from the customer."""

    custom_cta: Optional[CustomCta]
    """The different types of custom CTAs that can be selected."""

    custom_cta_url: Optional[str]
    """The custom call to action URL for the product."""

    custom_statement_descriptor: Optional[str]
    """The custom statement descriptor for the product i.e.

    WHOP\\**SPORTS, must be between 5 and 22 characters, contain at least one letter,
    and not contain any of the following characters: <, >, \\,, ', "
    """

    description: Optional[str]
    """A written description of the product."""

    experience_ids: Optional[SequenceNotStr[str]]
    """An array of experience IDs that this pass has"""

    global_affiliate_percentage: Optional[float]
    """The percentage of the revenue that goes to the global affiliate program."""

    global_affiliate_status: Optional[GlobalAffiliateStatus]
    """The different statuses of the global affiliate program for a product."""

    headline: Optional[str]
    """The headline of the product."""

    industry_type: Optional[IndustryTypes]
    """The different industry types a company can be in."""

    member_affiliate_percentage: Optional[float]
    """The percentage of the revenue that goes to the member affiliate program."""

    member_affiliate_status: Optional[GlobalAffiliateStatus]
    """The different statuses of the global affiliate program for a product."""

    plan_options: Optional[PlanOptions]
    """The details to assign an autogenerated plan."""

    product_highlights: Optional[Iterable[ProductHighlight]]
    """The product highlights for the product."""

    product_tax_code_id: Optional[str]
    """The ID of the product tax code to apply to this product."""

    redirect_purchase_url: Optional[str]
    """The URL to redirect the customer to after a purchase."""

    route: Optional[str]
    """The route of the product."""

    visibility: Optional[Visibility]
    """Visibility of a resource"""


class PlanOptionsCustomField(TypedDict, total=False):
    field_type: Required[Literal["text"]]
    """The type of the custom field."""

    name: Required[str]
    """The name of the custom field."""

    id: Optional[str]
    """The ID of the custom field (if being updated)"""

    order: Optional[int]
    """The order of the field."""

    placeholder: Optional[str]
    """The placeholder value of the field."""

    required: Optional[bool]
    """Whether or not the field is required."""


class PlanOptions(TypedDict, total=False):
    base_currency: Optional[Currency]
    """The available currencies on the platform"""

    billing_period: Optional[int]
    """The interval at which the plan charges (renewal plans)."""

    custom_fields: Optional[Iterable[PlanOptionsCustomField]]
    """An array of custom field objects."""

    initial_price: Optional[float]
    """An additional amount charged upon first purchase."""

    plan_type: Optional[PlanType]
    """The type of plan that can be attached to a product"""

    release_method: Optional[ReleaseMethod]
    """The methods of how a plan can be released."""

    renewal_price: Optional[float]
    """The amount the customer is charged every billing period."""

    visibility: Optional[Visibility]
    """Visibility of a resource"""


class ProductHighlight(TypedDict, total=False):
    content: Required[str]
    """
    Text to display to describe the product highlight (max length 250 for
    qualification or benefits, 170 for who this is for, 140 for pricing features).
    """

    highlight_type: Required[Literal["qualification", "benefit", "who_this_is_for", "pricing_feature"]]
    """The type of this highlight."""

    title: Optional[str]
    """The title of the product highlight, if applicable."""
