# # SCI Results

# ## Imports

import hbsir

# ## Parameters

YEAR = 1401
URABN_RURAL = "urban"

# ## Table 101: Households by size and expenditure
#
# Percentage of households by household size in each annual expenditure group

hbsir.load_knowledge("sci_results.T101", years=YEAR, urban_rural=URABN_RURAL)

# ## Table 102: Households by literacy and expenditure
#
# Percentage of households by number of literate individuals in each annual expenditure group

hbsir.load_knowledge("sci_results.T102", years=YEAR, urban_rural=URABN_RURAL)

# ## Table 103: Households by employment and expenditure
#
# Percentage of households by number of employed individuals in each annual expenditure group

hbsir.load_knowledge("sci_results.T103", years=YEAR, urban_rural=URABN_RURAL)

# ## Table 104: Households by head's employment status and expenditure
#
# Percentage of households by employment status of household head in each annual expenditure group

hbsir.load_knowledge("sci_results.T104", years=YEAR, urban_rural=URABN_RURAL)

# ## Table 105: Households by head's occupation and expenditure
#
# Percentage of households by occupational group of household head in each annual expenditure group

hbsir.load_knowledge("sci_results.T105", years=YEAR, urban_rural=URABN_RURAL)

# ## Table 106: Households by head's workplace and expenditure
#
# Percentage of households by main activity of household head's workplace in each annual
# expenditure group

# ## Table 107: Households by head's job situation and expenditure
#
# Percentage of households by employment situation of household head in each annual expenditure
# group

# ## Table 108: Households by head's education and expenditure
#
# Percentage of households by education level of household head in each annual expenditure group

# ## Table 109: Households by housing facilities and expenditure
#
# Percentage of households using major housing facilities in each annual expenditure group

# ## Table 110: Households by housing tenure and expenditure
#
# Percentage of households by housing tenure status in each annual expenditure group

# ## Table 111: Households by rooms and expenditure
#
# Percentage of households by number of rooms available to the household in each annual
# expenditure group

# ## Table 112: Households by appliances and expenditure
#
# Percentage of households using major home appliances in each annual expenditure group

# ## Table 113: Households by cooking fuel and expenditure
#
# Percentage of households by main fuel used for cooking in each annual expenditure group

# ## Table 114: Households by heating fuel and expenditure
#
# Percentage of households by main fuel used for heating in each annual expenditure group

# ## Table 115: Households by residence building and expenditure
#
# Percentage of households by main structure and materials of residence building in each annual
# expenditure group

# ## Table 116: Households by size and expenditure decile
#
# Percentage of households by household size in each annual expenditure decile

hbsir.load_knowledge("sci_results.T116", years=YEAR, urban_rural=URABN_RURAL)

# ## Table 117: Households by literacy and expenditure decile
#
# Percentage of households by number of literate individuals in each annual expenditure decile

# ## Table 118: Households by employment and expenditure decile
#
# Percentage of households by number of employed individuals in each annual expenditure decile

# ## Table 119: Households by head's employment status and expenditure decile
#
# Percentage of households by employment status of household head in each annual expenditure decile

# ## Table 120: Households by head's occupation and expenditure decile
#
# Percentage of households by occupational group of household head in each annual expenditure decile

# ## Table 121: Households by head's workplace and expenditure decile
#
# Percentage of households by main activity of household head's workplace in each annual
# expenditure decile

# ## Table 122: Households by head's job situation and expenditure decile
#
# Percentage of households by employment situation of household head in each annual expenditure
# decile

# ## Table 123: Households by head's education and expenditure decile
#
# Percentage of households by education level of household head in each annual expenditure decile

# ## Table 124: Households by housing facilities and expenditure decile
#
# Percentage of households using major housing facilities in each annual expenditure decile

# ## Table 125: Households by housing tenure and expenditure decile
#
# Percentage of households by housing tenure status in each annual expenditure decile

# ## Table 126: Households by rooms and expenditure decile
#
# Percentage of households by number of rooms available to the household in each annual
# expenditure decile

# ## Table 127: Households by appliances and expenditure decile
#
# Percentage of households using major home appliances in each annual expenditure decile

# ## Table 128: Households by residence size and expenditure decile
#
# Percentage of households by size of residence area in each annual expenditure decile

# ## Table 129: Households by water heating fuel and expenditure group
#
# Percentage of households by main fuel used for heating water in each annual expenditure group
