from .merge import merge_policies as merge_policies
from .models import PermissionLookup as PermissionLookup
from .types import PolicyType as PolicyType
from collections.abc import Callable
from typing import Any

POLICY_SCHEMA: Any

class AbstractPermissions:
    _cached_entity_func: Union[Callable[[str, str], bool], None]
    def _entity_func(self) -> Callable[[str, str], bool]: ...
    def access_all_entities(self, key: str) -> bool: ...
    def check_entity(self, entity_id: str, key: str) -> bool: ...

class PolicyPermissions(AbstractPermissions):
    _policy: Any
    _perm_lookup: Any
    def __init__(self, policy: PolicyType, perm_lookup: PermissionLookup) -> None: ...
    def access_all_entities(self, key: str) -> bool: ...
    def _entity_func(self) -> Callable[[str, str], bool]: ...
    def __eq__(self, other: Any) -> bool: ...

class _OwnerPermissions(AbstractPermissions):
    def access_all_entities(self, key: str) -> bool: ...
    def _entity_func(self) -> Callable[[str, str], bool]: ...

OwnerPermissions: Any
