import asyncio
from .const import CONF_CALLBACK_URL_OVERRIDE as CONF_CALLBACK_URL_OVERRIDE, CONF_LISTEN_PORT as CONF_LISTEN_PORT, CONF_POLL_AVAILABILITY as CONF_POLL_AVAILABILITY, DOMAIN as DOMAIN, MEDIA_METADATA_DIDL as MEDIA_METADATA_DIDL, MEDIA_TYPE_MAP as MEDIA_TYPE_MAP, MEDIA_UPNP_CLASS_MAP as MEDIA_UPNP_CLASS_MAP, REPEAT_PLAY_MODES as REPEAT_PLAY_MODES, SHUFFLE_PLAY_MODES as SHUFFLE_PLAY_MODES, STREAMABLE_PROTOCOLS as STREAMABLE_PROTOCOLS
from .data import EventListenAddr as EventListenAddr, get_domain_data as get_domain_data
from async_upnp_client import UpnpService as UpnpService, UpnpStateVariable as UpnpStateVariable
from async_upnp_client.profiles.dlna import DmrDevice
from collections.abc import Awaitable as Awaitable, Callable, Coroutine, Sequence
from datetime import datetime
from homeassistant import config_entries as config_entries
from homeassistant.components import media_source as media_source, ssdp as ssdp
from homeassistant.components.media_player import BrowseMedia as BrowseMedia, MediaPlayerEntity as MediaPlayerEntity, async_process_play_media_url as async_process_play_media_url
from homeassistant.components.media_player.const import ATTR_MEDIA_EXTRA as ATTR_MEDIA_EXTRA, REPEAT_MODE_ALL as REPEAT_MODE_ALL, REPEAT_MODE_OFF as REPEAT_MODE_OFF, REPEAT_MODE_ONE as REPEAT_MODE_ONE, SUPPORT_BROWSE_MEDIA as SUPPORT_BROWSE_MEDIA, SUPPORT_NEXT_TRACK as SUPPORT_NEXT_TRACK, SUPPORT_PAUSE as SUPPORT_PAUSE, SUPPORT_PLAY as SUPPORT_PLAY, SUPPORT_PLAY_MEDIA as SUPPORT_PLAY_MEDIA, SUPPORT_PREVIOUS_TRACK as SUPPORT_PREVIOUS_TRACK, SUPPORT_REPEAT_SET as SUPPORT_REPEAT_SET, SUPPORT_SEEK as SUPPORT_SEEK, SUPPORT_SELECT_SOUND_MODE as SUPPORT_SELECT_SOUND_MODE, SUPPORT_SHUFFLE_SET as SUPPORT_SHUFFLE_SET, SUPPORT_STOP as SUPPORT_STOP, SUPPORT_VOLUME_MUTE as SUPPORT_VOLUME_MUTE, SUPPORT_VOLUME_SET as SUPPORT_VOLUME_SET
from homeassistant.const import CONF_DEVICE_ID as CONF_DEVICE_ID, CONF_TYPE as CONF_TYPE, CONF_URL as CONF_URL, STATE_IDLE as STATE_IDLE, STATE_OFF as STATE_OFF, STATE_ON as STATE_ON, STATE_PAUSED as STATE_PAUSED, STATE_PLAYING as STATE_PLAYING
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers import device_registry as device_registry, entity_registry as entity_registry
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from typing import Any, TypeVar
from typing_extensions import Concatenate as Concatenate

PARALLEL_UPDATES: int
_T = TypeVar('_T', bound='DlnaDmrEntity')
_R = TypeVar('_R')
_P: Any
Func = TypeVar('Func', bound=Callable[..., Any])

def catch_request_errors(func: Callable[Concatenate[_T, _P], Awaitable[_R]]) -> Callable[Concatenate[_T, _P], Coroutine[Any, Any, Union[_R, None]]]: ...
async def async_setup_entry(hass: HomeAssistant, entry: config_entries.ConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class DlnaDmrEntity(MediaPlayerEntity):
    udn: str
    device_type: str
    _event_addr: EventListenAddr
    poll_availability: bool
    location: str
    _device_lock: asyncio.Lock
    _device: Union[DmrDevice, None]
    check_available: bool
    _ssdp_connect_failed: bool
    _bootid: Union[int, None]
    _attr_should_poll: bool
    _attr_name: Any
    def __init__(self, udn: str, device_type: str, name: str, event_port: int, event_callback_url: Union[str, None], poll_availability: bool, location: str) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_ssdp_callback(self, info: ssdp.SsdpServiceInfo, change: ssdp.SsdpChange) -> None: ...
    async def async_config_update_listener(self, hass: HomeAssistant, entry: config_entries.ConfigEntry) -> None: ...
    async def _device_connect(self, location: str) -> None: ...
    async def _device_disconnect(self) -> None: ...
    async def async_update(self) -> None: ...
    def _on_event(self, service: UpnpService, state_variables: Sequence[UpnpStateVariable]) -> None: ...
    @property
    def available(self) -> bool: ...
    @property
    def unique_id(self) -> str: ...
    @property
    def usn(self) -> str: ...
    @property
    def state(self) -> Union[str, None]: ...
    @property
    def supported_features(self) -> int: ...
    @property
    def volume_level(self) -> Union[float, None]: ...
    async def async_set_volume_level(self, volume: float) -> None: ...
    @property
    def is_volume_muted(self) -> Union[bool, None]: ...
    async def async_mute_volume(self, mute: bool) -> None: ...
    async def async_media_pause(self) -> None: ...
    async def async_media_play(self) -> None: ...
    async def async_media_stop(self) -> None: ...
    async def async_media_seek(self, position: Union[int, float]) -> None: ...
    async def async_play_media(self, media_type: str, media_id: str, **kwargs: Any) -> None: ...
    async def async_media_previous_track(self) -> None: ...
    async def async_media_next_track(self) -> None: ...
    @property
    def shuffle(self) -> Union[bool, None]: ...
    async def async_set_shuffle(self, shuffle: bool) -> None: ...
    @property
    def repeat(self) -> Union[str, None]: ...
    async def async_set_repeat(self, repeat: str) -> None: ...
    @property
    def sound_mode(self) -> Union[str, None]: ...
    @property
    def sound_mode_list(self) -> Union[list[str], None]: ...
    async def async_select_sound_mode(self, sound_mode: str) -> None: ...
    async def async_browse_media(self, media_content_type: Union[str, None] = ..., media_content_id: Union[str, None] = ...) -> BrowseMedia: ...
    def _get_content_filter(self) -> Callable[[BrowseMedia], bool]: ...
    @property
    def media_title(self) -> Union[str, None]: ...
    @property
    def media_image_url(self) -> Union[str, None]: ...
    @property
    def media_content_id(self) -> Union[str, None]: ...
    @property
    def media_content_type(self) -> Union[str, None]: ...
    @property
    def media_duration(self) -> Union[int, None]: ...
    @property
    def media_position(self) -> Union[int, None]: ...
    @property
    def media_position_updated_at(self) -> Union[datetime, None]: ...
    @property
    def media_artist(self) -> Union[str, None]: ...
    @property
    def media_album_name(self) -> Union[str, None]: ...
    @property
    def media_album_artist(self) -> Union[str, None]: ...
    @property
    def media_track(self) -> Union[int, None]: ...
    @property
    def media_series_title(self) -> Union[str, None]: ...
    @property
    def media_season(self) -> Union[str, None]: ...
    @property
    def media_episode(self) -> Union[str, None]: ...
    @property
    def media_channel(self) -> Union[str, None]: ...
    @property
    def media_playlist(self) -> Union[str, None]: ...
