from .common import AvmWrapper as AvmWrapper, FritzBoxBaseEntity as FritzBoxBaseEntity
from .const import DOMAIN as DOMAIN, DSL_CONNECTION as DSL_CONNECTION, MeshRoles as MeshRoles, UPTIME_DEVIATION as UPTIME_DEVIATION
from collections.abc import Callable as Callable
from datetime import datetime
from fritzconnection.lib.fritzstatus import FritzStatus as FritzStatus
from homeassistant.components.sensor import SensorDeviceClass as SensorDeviceClass, SensorEntity as SensorEntity, SensorEntityDescription as SensorEntityDescription, SensorStateClass as SensorStateClass
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import DATA_GIGABYTES as DATA_GIGABYTES, DATA_RATE_KILOBITS_PER_SECOND as DATA_RATE_KILOBITS_PER_SECOND, DATA_RATE_KILOBYTES_PER_SECOND as DATA_RATE_KILOBYTES_PER_SECOND, SIGNAL_STRENGTH_DECIBELS as SIGNAL_STRENGTH_DECIBELS
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity import EntityCategory as EntityCategory
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from homeassistant.util.dt import utcnow as utcnow
from typing import Any

_LOGGER: Any

def _uptime_calculation(seconds_uptime: float, last_value: Union[datetime, None]) -> datetime: ...
def _retrieve_device_uptime_state(status: FritzStatus, last_value: datetime) -> datetime: ...
def _retrieve_connection_uptime_state(status: FritzStatus, last_value: Union[datetime, None]) -> datetime: ...
def _retrieve_external_ip_state(status: FritzStatus, last_value: str) -> str: ...
def _retrieve_kb_s_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_kb_s_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_max_kb_s_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_max_kb_s_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_gb_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_gb_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_kb_s_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_kb_s_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_noise_margin_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_noise_margin_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_attenuation_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_attenuation_received_state(status: FritzStatus, last_value: str) -> float: ...

class ConnectionInfo:
    connection: str
    mesh_role: MeshRoles
    wan_enabled: bool
    def __init__(self, connection, mesh_role, wan_enabled) -> None: ...

class FritzRequireKeysMixin:
    value_fn: Callable[[FritzStatus, Any], Any]
    def __init__(self, value_fn) -> None: ...

class FritzSensorEntityDescription(SensorEntityDescription, FritzRequireKeysMixin):
    is_suitable: Callable[[ConnectionInfo], bool]
    def __init__(self, value_fn, key, device_class, entity_category, entity_registry_enabled_default, force_update, icon, name, unit_of_measurement, last_reset, native_unit_of_measurement, state_class, is_suitable) -> None: ...

SENSOR_TYPES: tuple[FritzSensorEntityDescription, ...]

async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class FritzBoxSensor(FritzBoxBaseEntity, SensorEntity):
    entity_description: FritzSensorEntityDescription
    _last_device_value: Any
    _attr_available: bool
    _attr_name: Any
    _attr_unique_id: Any
    def __init__(self, avm_wrapper: AvmWrapper, device_friendly_name: str, description: FritzSensorEntityDescription) -> None: ...
    _attr_native_value: Any
    def update(self) -> None: ...
