import abc
from abc import abstractmethod
from collections.abc import Iterable
from contextvars import ContextVar
from homeassistant.const import ATTR_ASSUMED_STATE as ATTR_ASSUMED_STATE, ATTR_ENTITY_ID as ATTR_ENTITY_ID, ATTR_ICON as ATTR_ICON, ATTR_NAME as ATTR_NAME, CONF_ENTITIES as CONF_ENTITIES, CONF_ICON as CONF_ICON, CONF_NAME as CONF_NAME, ENTITY_MATCH_ALL as ENTITY_MATCH_ALL, ENTITY_MATCH_NONE as ENTITY_MATCH_NONE, Platform as Platform, SERVICE_RELOAD as SERVICE_RELOAD, STATE_OFF as STATE_OFF, STATE_ON as STATE_ON
from homeassistant.core import HomeAssistant as HomeAssistant, ServiceCall as ServiceCall, callback as callback, split_entity_id as split_entity_id
from homeassistant.helpers import start as start
from homeassistant.helpers.entity import Entity as Entity, async_generate_entity_id as async_generate_entity_id
from homeassistant.helpers.entity_component import EntityComponent as EntityComponent
from homeassistant.helpers.event import async_track_state_change_event as async_track_state_change_event
from homeassistant.helpers.integration_platform import async_process_integration_platforms as async_process_integration_platforms
from homeassistant.helpers.reload import async_reload_integration_platforms as async_reload_integration_platforms
from homeassistant.helpers.typing import ConfigType as ConfigType
from homeassistant.loader import bind_hass as bind_hass
from typing import Any

DOMAIN: str
GROUP_ORDER: str
ENTITY_ID_FORMAT: Any
CONF_ALL: str
ATTR_ADD_ENTITIES: str
ATTR_AUTO: str
ATTR_ENTITIES: str
ATTR_OBJECT_ID: str
ATTR_ORDER: str
ATTR_ALL: str
SERVICE_SET: str
SERVICE_REMOVE: str
PLATFORMS: Any
REG_KEY: Any
_LOGGER: Any
current_domain: ContextVar[str]

def _conf_preprocess(value): ...

GROUP_SCHEMA: Any
CONFIG_SCHEMA: Any

class GroupIntegrationRegistry:
    on_off_mapping: dict[str, str]
    off_on_mapping: dict[str, str]
    on_states_by_domain: dict[str, set]
    exclude_domains: set
    def exclude_domain(self) -> None: ...
    def on_off_states(self, on_states: set, off_state: str) -> None: ...

def is_on(hass, entity_id): ...
def expand_entity_ids(hass: HomeAssistant, entity_ids: Iterable[Any]) -> list[str]: ...
def get_entity_ids(hass: HomeAssistant, entity_id: str, domain_filter: Union[str, None] = ...) -> list[str]: ...
def groups_with_entity(hass: HomeAssistant, entity_id: str) -> list[str]: ...
async def async_setup(hass: HomeAssistant, config: ConfigType) -> bool: ...
async def _process_group_platform(hass, domain, platform) -> None: ...
async def _async_process_config(hass, config, component) -> None: ...

class GroupEntity(Entity, metaclass=abc.ABCMeta):
    @property
    def should_poll(self) -> bool: ...
    async def async_added_to_hass(self) -> None: ...
    def async_defer_or_update_ha_state(self) -> None: ...
    @abstractmethod
    def async_update_group_state(self) -> None: ...

class Group(Entity):
    hass: Any
    _name: Any
    _state: Any
    _icon: Any
    _on_off: Any
    _assumed: Any
    _on_states: Any
    user_defined: Any
    mode: Any
    _order: Any
    _assumed_state: bool
    _async_unsub_state_changed: Any
    def __init__(self, hass, name, order: Any | None = ..., icon: Any | None = ..., user_defined: bool = ..., entity_ids: Any | None = ..., mode: Any | None = ...) -> None: ...
    @staticmethod
    def create_group(hass, name, entity_ids: Any | None = ..., user_defined: bool = ..., icon: Any | None = ..., object_id: Any | None = ..., mode: Any | None = ..., order: Any | None = ...): ...
    @staticmethod
    async def async_create_group(hass, name, entity_ids: Any | None = ..., user_defined: bool = ..., icon: Any | None = ..., object_id: Any | None = ..., mode: Any | None = ..., order: Any | None = ...): ...
    @property
    def should_poll(self): ...
    @property
    def name(self): ...
    @name.setter
    def name(self, value) -> None: ...
    @property
    def state(self): ...
    @property
    def icon(self): ...
    @icon.setter
    def icon(self, value) -> None: ...
    @property
    def extra_state_attributes(self): ...
    @property
    def assumed_state(self): ...
    def update_tracked_entity_ids(self, entity_ids) -> None: ...
    async def async_update_tracked_entity_ids(self, entity_ids) -> None: ...
    tracking: Any
    trackable: Any
    def _set_tracked(self, entity_ids) -> None: ...
    def _async_start(self, *_) -> None: ...
    def _async_start_tracking(self) -> None: ...
    def _async_stop(self) -> None: ...
    def async_update_group_state(self) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def _async_state_changed_listener(self, event) -> None: ...
    def _reset_tracked_state(self) -> None: ...
    def _see_state(self, new_state) -> None: ...
    def _async_update_group_state(self, tr_state: Any | None = ...) -> None: ...
