from .config_flow import normalize_hkid as normalize_hkid
from .connection import HKDevice as HKDevice, valid_serial_number as valid_serial_number
from .const import ENTITY_MAP as ENTITY_MAP, KNOWN_DEVICES as KNOWN_DEVICES, TRIGGERS as TRIGGERS
from .storage import EntityMapStorage as EntityMapStorage
from .utils import async_get_controller as async_get_controller
from aiohomekit.model import Accessory as Accessory
from aiohomekit.model.characteristics import Characteristic as Characteristic
from aiohomekit.model.services import Service as Service
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP
from homeassistant.core import Event as Event, HomeAssistant as HomeAssistant
from homeassistant.exceptions import ConfigEntryNotReady as ConfigEntryNotReady
from homeassistant.helpers.entity import DeviceInfo as DeviceInfo, Entity as Entity
from homeassistant.helpers.typing import ConfigType as ConfigType
from typing import Any

_LOGGER: Any

class HomeKitEntity(Entity):
    _attr_should_poll: bool
    _accessory: Any
    _aid: Any
    _iid: Any
    _features: int
    def __init__(self, accessory: HKDevice, devinfo: ConfigType) -> None: ...
    @property
    def accessory(self) -> Accessory: ...
    @property
    def accessory_info(self) -> Service: ...
    @property
    def service(self) -> Service: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_will_remove_from_hass(self) -> None: ...
    async def async_put_characteristics(self, characteristics: dict[str, Any]) -> None: ...
    pollable_characteristics: Any
    watchable_characteristics: Any
    def setup(self) -> None: ...
    def _setup_characteristic(self, char: Characteristic) -> None: ...
    @property
    def unique_id(self) -> str: ...
    @property
    def name(self) -> Union[str, None]: ...
    @property
    def available(self) -> bool: ...
    @property
    def device_info(self) -> DeviceInfo: ...
    def get_characteristic_types(self) -> list[str]: ...

class AccessoryEntity(HomeKitEntity):
    @property
    def unique_id(self) -> str: ...

class CharacteristicEntity(HomeKitEntity):
    _char: Any
    def __init__(self, accessory: HKDevice, devinfo: ConfigType, char: Characteristic) -> None: ...
    @property
    def unique_id(self) -> str: ...

async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
async def async_setup(hass: HomeAssistant, config: ConfigType) -> bool: ...
async def async_unload_entry(hass: HomeAssistant, entry: ConfigEntry) -> bool: ...
async def async_remove_entry(hass: HomeAssistant, entry: ConfigEntry) -> None: ...
