from .coordinator import OverkizDataUpdateCoordinator as OverkizDataUpdateCoordinator
from pyoverkiz.enums import OverkizCommand
from pyoverkiz.models import Device as Device
from pyoverkiz.types import StateType as OverkizStateType
from typing import Any

COMMANDS_WITHOUT_DELAY: Any

class OverkizExecutor:
    device_url: Any
    coordinator: Any
    base_device_url: Any
    def __init__(self, device_url: str, coordinator: OverkizDataUpdateCoordinator) -> None: ...
    @property
    def device(self) -> Device: ...
    def select_command(self, *commands: str) -> Union[str, None]: ...
    def has_command(self, *commands: str) -> bool: ...
    def select_state(self, *states: str) -> OverkizStateType: ...
    def has_state(self, *states: str) -> bool: ...
    def select_attribute(self, *attributes: str) -> OverkizStateType: ...
    async def async_execute_command(self, command_name: str, *args: Any) -> None: ...
    async def async_cancel_command(self, commands_to_cancel: list[OverkizCommand]) -> bool: ...
    async def async_cancel_execution(self, exec_id: str) -> None: ...
    def get_gateway_id(self) -> str: ...
