from .const import ATTR_ENDPOINTS as ATTR_ENDPOINTS, ATTR_SETTINGS as ATTR_SETTINGS, ATTR_STREAMS as ATTR_STREAMS, CONF_LL_HLS as CONF_LL_HLS, CONF_PART_DURATION as CONF_PART_DURATION, CONF_SEGMENT_DURATION as CONF_SEGMENT_DURATION, DOMAIN as DOMAIN, HLS_PROVIDER as HLS_PROVIDER, MAX_SEGMENTS as MAX_SEGMENTS, OUTPUT_IDLE_TIMEOUT as OUTPUT_IDLE_TIMEOUT, RECORDER_PROVIDER as RECORDER_PROVIDER, SEGMENT_DURATION_ADJUSTER as SEGMENT_DURATION_ADJUSTER, STREAM_RESTART_INCREMENT as STREAM_RESTART_INCREMENT, STREAM_RESTART_RESET_TIME as STREAM_RESTART_RESET_TIME, TARGET_SEGMENT_DURATION_NON_LL_HLS as TARGET_SEGMENT_DURATION_NON_LL_HLS
from .core import IdleTimer as IdleTimer, KeyFrameConverter as KeyFrameConverter, PROVIDERS as PROVIDERS, StreamOutput as StreamOutput, StreamSettings as StreamSettings
from .hls import HlsStreamOutput as HlsStreamOutput, async_setup_hls as async_setup_hls
from collections.abc import Callable as Callable, Mapping
from homeassistant.const import EVENT_HOMEASSISTANT_STOP as EVENT_HOMEASSISTANT_STOP
from homeassistant.core import Event as Event, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.typing import ConfigType as ConfigType
from typing import Any

_LOGGER: Any
STREAM_SOURCE_REDACT_PATTERN: Any

def redact_credentials(data: str) -> str: ...
def create_stream(hass: HomeAssistant, stream_source: str, options: dict[str, str], stream_label: Union[str, None] = ...) -> Stream: ...

DOMAIN_SCHEMA: Any
CONFIG_SCHEMA: Any

def filter_libav_logging() -> None: ...
async def async_setup(hass: HomeAssistant, config: ConfigType) -> bool: ...

class Stream:
    hass: Any
    source: Any
    options: Any
    _stream_label: Any
    keepalive: bool
    access_token: Any
    _thread: Any
    _thread_quit: Any
    _outputs: Any
    _fast_restart_once: bool
    _keyframe_converter: Any
    _available: bool
    _update_callback: Any
    _logger: Any
    def __init__(self, hass: HomeAssistant, source: str, options: dict[str, str], stream_label: Union[str, None] = ...) -> None: ...
    def endpoint_url(self, fmt: str) -> str: ...
    def outputs(self) -> Mapping[str, StreamOutput]: ...
    def add_provider(self, fmt: str, timeout: int = ...) -> StreamOutput: ...
    def remove_provider(self, provider: StreamOutput) -> None: ...
    def check_idle(self) -> None: ...
    @property
    def available(self) -> bool: ...
    def set_update_callback(self, update_callback: Callable[[], None]) -> None: ...
    def _async_update_state(self, available: bool) -> None: ...
    def start(self) -> None: ...
    def update_source(self, new_source: str) -> None: ...
    def _run_worker(self) -> None: ...
    def _worker_finished(self) -> None: ...
    def stop(self) -> None: ...
    def _stop(self) -> None: ...
    async def async_record(self, video_path: str, duration: int = ..., lookback: int = ...) -> None: ...
    async def async_get_image(self, width: Union[int, None] = ..., height: Union[int, None] = ...) -> Union[bytes, None]: ...

def _should_retry() -> bool: ...
