import datetime
from . import Stream as Stream
from .const import ATTR_STREAMS as ATTR_STREAMS, DOMAIN as DOMAIN
from aiohttp import web
from av import CodecContext, Packet as Packet
from collections import deque
from collections.abc import Iterable
from homeassistant.components.http.view import HomeAssistantView as HomeAssistantView
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.event import async_call_later as async_call_later
from homeassistant.util.decorator import Registry as Registry
from typing import Any

PROVIDERS: Registry[str, type[StreamOutput]]

class StreamSettings:
    ll_hls: bool
    min_segment_duration: float
    part_target_duration: float
    hls_advance_part_limit: int
    hls_part_timeout: float
    def __init__(self, ll_hls, min_segment_duration, part_target_duration, hls_advance_part_limit, hls_part_timeout) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class Part:
    duration: float
    has_keyframe: bool
    data: bytes
    def __init__(self, duration, has_keyframe, data) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class Segment:
    sequence: int
    init: bytes
    stream_id: int
    start_time: datetime.datetime
    _stream_outputs: Iterable[StreamOutput]
    duration: float
    parts: list[Part]
    hls_playlist_template: list[str]
    hls_playlist_parts: list[str]
    hls_num_parts_rendered: int
    hls_playlist_complete: bool
    def __attrs_post_init__(self) -> None: ...
    @property
    def complete(self) -> bool: ...
    @property
    def data_size_with_init(self) -> int: ...
    @property
    def data_size(self) -> int: ...
    def async_add_part(self, part: Part, duration: float) -> None: ...
    def get_data(self) -> bytes: ...
    def _render_hls_template(self, last_stream_id: int, render_parts: bool) -> str: ...
    def render_hls(self, last_stream_id: int, render_parts: bool, add_hint: bool) -> str: ...
    def __init__(self, sequence, init, stream_id, start_time, stream_outputs, duration, parts, hls_playlist_template, hls_playlist_parts, hls_num_parts_rendered, hls_playlist_complete) -> None: ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...

class IdleTimer:
    _hass: Any
    _timeout: Any
    _callback: Any
    _unsub: Any
    idle: bool
    def __init__(self, hass: HomeAssistant, timeout: int, idle_callback: CALLBACK_TYPE) -> None: ...
    def start(self) -> None: ...
    def awake(self) -> None: ...
    def clear(self) -> None: ...
    def fire(self, _now: datetime.datetime) -> None: ...

class StreamOutput:
    _hass: Any
    idle_timer: Any
    _event: Any
    _part_event: Any
    _segments: Any
    def __init__(self, hass: HomeAssistant, idle_timer: IdleTimer, deque_maxlen: Union[int, None] = ...) -> None: ...
    @property
    def name(self) -> Union[str, None]: ...
    @property
    def idle(self) -> bool: ...
    @property
    def last_sequence(self) -> int: ...
    @property
    def sequences(self) -> list[int]: ...
    @property
    def last_segment(self) -> Union[Segment, None]: ...
    def get_segment(self, sequence: int) -> Union[Segment, None]: ...
    def get_segments(self) -> deque[Segment]: ...
    async def part_recv(self, timeout: Union[float, None] = ...) -> bool: ...
    def part_put(self) -> None: ...
    async def recv(self) -> bool: ...
    def put(self, segment: Segment) -> None: ...
    def _async_put(self, segment: Segment) -> None: ...
    def cleanup(self) -> None: ...

class StreamView(HomeAssistantView):
    requires_auth: bool
    platform: Any
    async def get(self, request: web.Request, token: str, sequence: str = ..., part_num: str = ...) -> web.StreamResponse: ...
    async def handle(self, request: web.Request, stream: Stream, sequence: str, part_num: str) -> web.StreamResponse: ...

class KeyFrameConverter:
    packet: Any
    _hass: Any
    _image: Any
    _turbojpeg: Any
    _lock: Any
    _codec_context: Any
    def __init__(self, hass: HomeAssistant) -> None: ...
    def create_codec_context(self, codec_context: CodecContext) -> None: ...
    def _generate_image(self, width: Union[int, None], height: Union[int, None]) -> None: ...
    async def async_get_image(self, width: Union[int, None] = ..., height: Union[int, None] = ...) -> Union[bytes, None]: ...
