from .const import DATA_CLIENT as DATA_CLIENT, DOMAIN as DOMAIN
from .discovery import ZwaveDiscoveryInfo as ZwaveDiscoveryInfo
from .discovery_data_template import FanSpeedDataTemplate as FanSpeedDataTemplate
from .entity import ZWaveBaseEntity as ZWaveBaseEntity
from homeassistant.components.fan import FanEntity as FanEntity, SUPPORT_SET_SPEED as SUPPORT_SET_SPEED
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.dispatcher import async_dispatcher_connect as async_dispatcher_connect
from homeassistant.helpers.entity_platform import AddEntitiesCallback as AddEntitiesCallback
from homeassistant.util.percentage import int_states_in_range as int_states_in_range, percentage_to_ranged_value as percentage_to_ranged_value, ranged_value_to_percentage as ranged_value_to_percentage
from typing import Any
from zwave_js_server.client import Client as ZwaveClient

SUPPORTED_FEATURES = SUPPORT_SET_SPEED
DEFAULT_SPEED_RANGE: Any

async def async_setup_entry(hass: HomeAssistant, config_entry: ConfigEntry, async_add_entities: AddEntitiesCallback) -> None: ...

class ZwaveFan(ZWaveBaseEntity, FanEntity):
    _target_value: Any
    def __init__(self, config_entry: ConfigEntry, client: ZwaveClient, info: ZwaveDiscoveryInfo) -> None: ...
    async def async_set_percentage(self, percentage: int) -> None: ...
    async def async_turn_on(self, speed: Union[str, None] = ..., percentage: Union[int, None] = ..., preset_mode: Union[str, None] = ..., **kwargs: Any) -> None: ...
    async def async_turn_off(self, **kwargs: Any) -> None: ...
    @property
    def is_on(self) -> Union[bool, None]: ...
    @property
    def percentage(self) -> Union[int, None]: ...
    @property
    def percentage_step(self) -> float: ...
    @property
    def speed_count(self) -> int: ...
    @property
    def supported_features(self) -> int: ...

class ConfiguredSpeedRangeZwaveFan(ZwaveFan):
    data_template: Any
    def __init__(self, config_entry: ConfigEntry, client: ZwaveClient, info: ZwaveDiscoveryInfo) -> None: ...
    async def async_set_percentage(self, percentage: int) -> None: ...
    @property
    def available(self) -> bool: ...
    @property
    def percentage(self) -> Union[int, None]: ...
    @property
    def percentage_step(self) -> float: ...
    @property
    def has_speed_configuration(self) -> bool: ...
    @property
    def speed_configuration(self) -> list[int]: ...
    @property
    def speed_count(self) -> int: ...
    def percentage_to_zwave_speed(self, percentage: int) -> int: ...
    def zwave_speed_to_percentage(self, zwave_speed: int) -> int: ...
