# Copyright 2018 Mathias Burger <mathias.burger@gmail.com>
#
# SPDX-License-Identifier: MIT

"""
A colormap from opencv could be created like this:
::
    values = np.array([i for i in range(0, 256)], dtype=np.uint8)
    cmap = cv2.applyColorMap(values, cv2.COLORMAP_JET)
    cmap_bytes = cmap.tobytes()
"""

import numpy as np


COLORMAP_JET = np.frombuffer(b'\x80\x00\x00\x84\x00\x00\x88\x00\x00\x8c\x00\x00\x90\x00\x00\x94\x00\x00\x98\x00\x00\x9c\x00\x00\xa0\x00\x00\xa4\x00\x00\xa8\x00\x00\xac\x00\x00\xb0\x00\x00\xb4\x00\x00\xb8\x00\x00\xbc\x00\x00\xc0\x00\x00\xc4\x00\x00\xc8\x00\x00\xcc\x00\x00\xd0\x00\x00\xd4\x00\x00\xd8\x00\x00\xdc\x00\x00\xe0\x00\x00\xe4\x00\x00\xe8\x00\x00\xec\x00\x00\xf0\x00\x00\xf4\x00\x00\xf8\x00\x00\xfc\x00\x00\xff\x00\x00\xff\x04\x00\xff\x08\x00\xff\x0c\x00\xff\x10\x00\xff\x14\x00\xff\x18\x00\xff\x1c\x00\xff \x00\xff$\x00\xff(\x00\xff,\x00\xff0\x00\xff4\x00\xff8\x00\xff<\x00\xff@\x00\xffD\x00\xffH\x00\xffL\x00\xffP\x00\xffT\x00\xffX\x00\xff\\\x00\xff`\x00\xffd\x00\xffh\x00\xffl\x00\xffp\x00\xfft\x00\xffx\x00\xff|\x00\xff\x80\x00\xff\x84\x00\xff\x88\x00\xff\x8c\x00\xff\x90\x00\xff\x94\x00\xff\x98\x00\xff\x9c\x00\xff\xa0\x00\xff\xa4\x00\xff\xa8\x00\xff\xac\x00\xff\xb0\x00\xff\xb4\x00\xff\xb8\x00\xff\xbc\x00\xff\xc0\x00\xff\xc4\x00\xff\xc8\x00\xff\xcc\x00\xff\xd0\x00\xff\xd4\x00\xff\xd8\x00\xff\xdc\x00\xff\xe0\x00\xff\xe4\x00\xff\xe8\x00\xff\xec\x00\xff\xf0\x00\xff\xf4\x00\xff\xf8\x00\xff\xfc\x00\xfe\xff\x02\xfa\xff\x06\xf6\xff\n\xf2\xff\x0e\xee\xff\x12\xea\xff\x16\xe6\xff\x1a\xe2\xff\x1e\xde\xff"\xda\xff&\xd6\xff*\xd2\xff.\xce\xff2\xca\xff6\xc6\xff:\xc2\xff>\xbe\xffB\xba\xffF\xb6\xffJ\xb2\xffN\xae\xffR\xaa\xffV\xa6\xffZ\xa2\xff^\x9e\xffb\x9a\xfff\x96\xffj\x92\xffn\x8e\xffr\x8a\xffv\x86\xffz\x82\xff~~\xff\x82z\xff\x86v\xff\x8ar\xff\x8en\xff\x92j\xff\x96f\xff\x9ab\xff\x9e^\xff\xa2Z\xff\xa6V\xff\xaaR\xff\xaeN\xff\xb2J\xff\xb6F\xff\xbaB\xff\xbe>\xff\xc2:\xff\xc66\xff\xca2\xff\xce.\xff\xd2*\xff\xd6&\xff\xda"\xff\xde\x1e\xff\xe2\x1a\xff\xe6\x16\xff\xea\x12\xff\xee\x0e\xff\xf2\n\xff\xf6\x06\xff\xfa\x01\xff\xfe\x00\xfc\xff\x00\xf8\xff\x00\xf4\xff\x00\xf0\xff\x00\xec\xff\x00\xe8\xff\x00\xe4\xff\x00\xe0\xff\x00\xdc\xff\x00\xd8\xff\x00\xd4\xff\x00\xd0\xff\x00\xcc\xff\x00\xc8\xff\x00\xc4\xff\x00\xc0\xff\x00\xbc\xff\x00\xb8\xff\x00\xb4\xff\x00\xb0\xff\x00\xac\xff\x00\xa8\xff\x00\xa4\xff\x00\xa0\xff\x00\x9c\xff\x00\x98\xff\x00\x94\xff\x00\x90\xff\x00\x8c\xff\x00\x88\xff\x00\x84\xff\x00\x80\xff\x00|\xff\x00x\xff\x00t\xff\x00p\xff\x00l\xff\x00h\xff\x00d\xff\x00`\xff\x00\\\xff\x00X\xff\x00T\xff\x00P\xff\x00L\xff\x00H\xff\x00D\xff\x00@\xff\x00<\xff\x008\xff\x004\xff\x000\xff\x00,\xff\x00(\xff\x00$\xff\x00 \xff\x00\x1c\xff\x00\x18\xff\x00\x14\xff\x00\x10\xff\x00\x0c\xff\x00\x08\xff\x00\x04\xff\x00\x00\xff\x00\x00\xfc\x00\x00\xf8\x00\x00\xf4\x00\x00\xf0\x00\x00\xec\x00\x00\xe8\x00\x00\xe4\x00\x00\xe0\x00\x00\xdc\x00\x00\xd8\x00\x00\xd4\x00\x00\xd0\x00\x00\xcc\x00\x00\xc8\x00\x00\xc4\x00\x00\xc0\x00\x00\xbc\x00\x00\xb8\x00\x00\xb4\x00\x00\xb0\x00\x00\xac\x00\x00\xa8\x00\x00\xa4\x00\x00\xa0\x00\x00\x9c\x00\x00\x98\x00\x00\x94\x00\x00\x90\x00\x00\x8c\x00\x00\x88\x00\x00\x84\x00\x00\x80', dtype=np.uint8).reshape((256, 3))
