"""V1 API routers."""

from fastapi import APIRouter

from api.routers.v1 import auth, alerts, architecture, audit_logs, billing, budget, code_examples, compliance, compliance_custom, cost_search, csrf, document_updates, health, infrastructure, indexing, knowledge, metrics, oauth, pricing, reports, search, troubleshoot, usage, users, versioning
from api.routers.v1.admin import (
    users as admin_users,
    activity as admin_activity,
    analytics as admin_analytics,
    security as admin_security,
    system as admin_system,
    invitations as admin_invitations,
    admins as admin_admins,
    pipelines as admin_pipelines,
)

router = APIRouter()

router.include_router(health.router)
router.include_router(csrf.router)
router.include_router(auth.router, prefix="/auth", tags=["auth"])
router.include_router(billing.router)
router.include_router(budget.router)
router.include_router(alerts.router)
router.include_router(usage.router)
router.include_router(compliance.router)
router.include_router(compliance_custom.router)
router.include_router(cost_search.router)
router.include_router(pricing.router)
router.include_router(code_examples.router)
router.include_router(knowledge.router)
router.include_router(indexing.router)
router.include_router(document_updates.router)
router.include_router(reports.router)
router.include_router(metrics.router)
router.include_router(search.router)
router.include_router(troubleshoot.router)
router.include_router(architecture.router)
router.include_router(infrastructure.router)
router.include_router(versioning.router)
router.include_router(audit_logs.router)
router.include_router(oauth.router, prefix="/oauth", tags=["oauth"])
router.include_router(users.router, prefix="/users", tags=["users"])
router.include_router(admin_users.router, prefix="/admin", tags=["admin"])
router.include_router(admin_activity.router, prefix="/admin", tags=["admin"])
router.include_router(admin_analytics.router, prefix="/admin", tags=["admin"])
router.include_router(admin_security.router, prefix="/admin", tags=["admin"])
router.include_router(admin_system.router, prefix="/admin", tags=["admin"])
router.include_router(admin_invitations.router, prefix="/admin", tags=["admin"])
router.include_router(admin_admins.router, prefix="/admin", tags=["admin"])
router.include_router(admin_pipelines.router, prefix="/admin", tags=["admin"])

