#!/usr/bin/env python3
"""Test script to identify problematic imports."""

import sys
import traceback

print(f"Python version: {sys.version}")
print(f"Python executable: {sys.executable}")
print()

modules_to_test = [
    "wistx_mcp.config",
    "wistx_mcp.tools.lib.auth_context",
    "wistx_mcp.tools.lib.concurrent_limiter",
    "wistx_mcp.tools.lib.mcp_errors",
    "wistx_mcp.tools.lib.request_context",
    "wistx_mcp.tools.lib.rate_limiter",
    "wistx_mcp.tools.lib.request_deduplicator",
    "wistx_mcp.tools.lib.resource_manager",
    "wistx_mcp.tools.lib.constants",
    "wistx_mcp.tools.lib.protocol_handler",
    "wistx_mcp.tools.lib.lazy_tool_loader",
    "wistx_mcp.tools.lib.rate_limit_headers",
    "wistx_mcp.tools.lib.tool_analytics",
    "wistx_mcp.tools.lib.distributed_tool_cache",
    "wistx_mcp.tools.lib.comprehensive_audit_logger",
    "wistx_mcp.tools.mcp_tools",
    "mcp.server",
    "mcp.server.stdio",
]

failed_imports = []
successful_imports = []

for module_name in modules_to_test:
    try:
        print(f"Testing import: {module_name}...", end=" ", flush=True)
        __import__(module_name)
        print("✓ OK")
        successful_imports.append(module_name)
    except SystemExit as e:
        print(f"✗ SystemExit: {e}")
        failed_imports.append((module_name, f"SystemExit: {e}"))
    except Exception as e:
        print(f"✗ Error: {e}")
        failed_imports.append((module_name, str(e)))
        traceback.print_exc()

print()
print("=" * 60)
print(f"Successful imports: {len(successful_imports)}")
print(f"Failed imports: {len(failed_imports)}")
print()

if failed_imports:
    print("Failed imports:")
    for module_name, error in failed_imports:
        print(f"  - {module_name}: {error}")
else:
    print("All imports successful!")

