#!/usr/bin/env python3
"""Minimal test to isolate MCP server crash."""

import sys
import asyncio
import logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

print("=" * 60)
print("Testing MCP Server Startup")
print("=" * 60)
print()

try:
    print("Step 1: Importing server module...")
    from wistx_mcp.server import main, cli
    print("✓ Server module imported")
except Exception as e:
    print(f"✗ Failed to import server module: {e}")
    import traceback
    traceback.print_exc()
    sys.exit(1)

try:
    print("\nStep 2: Testing async main() function...")
    print("   (This will fail if stdio is not available, which is expected)")
    asyncio.run(main())
except RuntimeError as e:
    if "stdio" in str(e).lower() or "stream" in str(e).lower():
        print(f"✓ Expected error (no stdio): {e}")
    else:
        print(f"✗ Unexpected RuntimeError: {e}")
        import traceback
        traceback.print_exc()
        sys.exit(1)
except Exception as e:
    print(f"✗ Unexpected error: {e}")
    import traceback
    traceback.print_exc()
    sys.exit(1)

print("\n✓ All tests passed - server module loads successfully")
print("\nThe crash likely happens when Cursor tries to communicate with the server.")
print("This might be a communication protocol issue or a problem with how")
print("the MCP SDK handles the stdio streams.")

