guiLocalSettings.setIfNotExists('guiApi.real_query_timeout',100);class StatusError extends Error{constructor(status,data){super();this.status=status;this.message=undefined;if(typeof data=="string"){this.message=data;}
if(typeof data=="object"&&data.detail){this.message=data.detail;}}}
class ApiConnector{constructor(config,openapi,cache){this.config=config;this.openapi=openapi;this.cache=cache;this.api=axios.create(config);this.bulk_collector={timeout_id:undefined,bulk_parts:[],};}
query(method,url="",data={}){let with_data_methods=["post","put","patch"];let without_data_methods=["get","delete"];if(with_data_methods.includes(method)){return this.api[method](url,data);}else if(without_data_methods.includes(method)){return this.api[method](url);}}
bulkQuery(data){if(this.bulk_collector.timeout_id){clearTimeout(this.bulk_collector.timeout_id);}
let callbacks={resolve:undefined,reject:undefined,};let promise=new Promise((resolve,reject)=>{callbacks.resolve=resolve;callbacks.reject=reject;});this.bulk_collector.bulk_parts.push({data:data,promise:promise,callbacks:callbacks,});let bulk_timeout=guiLocalSettings.get('guiApi.real_query_timeout')||100;this.bulk_collector.timeout_id=setTimeout(()=>this.sendBulk(),bulk_timeout);return promise;}
sendBulk(){let url="/"+this.openapi.info.version+"/_bulk/";let collector=$.extend(true,{},this.bulk_collector);this.bulk_collector.bulk_parts=[];let bulk_data=[];for(let index=0;index<collector.bulk_parts.length;index++){bulk_data.push(collector.bulk_parts[index].data);}
return this.query("put",url,bulk_data).then(response=>{let result=response.data;for(let index=0;index<result.length;index++){let item=result[index];let method="resolve";if(!(item.status>=200&&item.status<400)){debugger;method="reject";}
collector.bulk_parts[index].callbacks[method](result[index]);}}).catch(error=>{debugger;throw new StatusError(error.status,error.data);});}
getHostUrl(){return this.openapi.schemes[0]+"://"+this.openapi.host;}
getTimeZone(){return this.openapi.info['x-settings'].time_zone;}
getStaticPath(){return this.openapi.info['x-settings'].static_path;}
getUserId(){return this.openapi.info["x-user-id"];}
loadUser(){return this.bulkQuery({data_type:['user',this.getUserId()],method:'get'}).then(response=>{return response.data;});}
loadLanguages(){return this.bulkQuery({data_type:['_lang'],method:'get'}).then(response=>{return response.data.results;});}
getLanguagesFromCache(){return this.cache.getFile('languages').then(response=>{return JSON.parse(response.data);}).catch(error=>{return this.loadLanguages().then(languages=>{this.cache.setFile('languages',JSON.stringify(languages));return languages;});});}
getLanguages(){if(this.cache){return this.getLanguagesFromCache();}
return this.loadLanguages();}
loadTranslations(lang){return this.bulkQuery({data_type:['_lang',lang],method:'get'}).then(response=>{return response.data.translations;});}
getTranslationsFromCache(lang){return this.cache.getFile('translations.'+lang).then(response=>{return JSON.parse(response.data);}).catch(error=>{return this.loadTranslations(lang).then(translations=>{this.cache.setFile('translations.'+lang,JSON.stringify(translations));return translations;});});}
getTranslations(lang){if(this.cache){return this.getTranslationsFromCache(lang);}
return this.loadTranslations(lang);}}
let api_connector_config={headers:{'content-type':'application/json','X-CSRFToken':getCookie('csrftoken'),},baseURL:openapi_path.replace("/openapi/","")+"/api",};let openapi_dictionary={models:{name:"definitions",fields:{name:"properties",},required_fields:{name:"required",},ref_names:["$ref","definition_ref"],filters_to_delete:["limit","offset"],},paths:{name:"paths",operation_id:{name:"operationId",},operations:{base:{remove:{name:'remove',title:'remove',icon_classes:['fa','fa-trash'],title_classes:['d-none','d-lg-inline-block'],classes:['btn-danger','danger-right'],},},list:{new:{name:'new',title:'create',icon_classes:['fa','fa-plus'],title_classes:['d-none','d-lg-inline-block','title-for-btn'],},add:{name:'add',title:'add',component:'gui_add_child_modal',},},page:{edit:{name:'edit',title:'edit',icon_classes:['fa','fa-pencil-square-o'],title_classes:['d-none','d-lg-inline-block','title-for-btn'],},},page_new:{save_new:{name:'save',title:'save',icon_classes:['fa','fa-floppy-o'],title_classes:['d-none','d-lg-inline-block','title-for-btn'],},},page_edit:{save:{name:'save',title:'save',icon_classes:['fa','fa-floppy-o'],title_classes:['d-none','d-lg-inline-block','title-for-btn'],},reload:{name:'reload',title:'reload',icon_classes:['fa',' fa-refresh'],title_classes:['d-none','d-lg-inline-block','title-for-btn'],},},action:{execute:{name:'execute',title:'send',icon_classes:['fa','fa-upload'],title_classes:['d-none','d-lg-inline-block','title-for-btn'],}},},multi_actions:['remove'],types_operations_always_to_add:['page_new','page_edit','action'],},schema_types:{"_add":{query_type:"post",url_postfix:"new/",type:"page_new",},"_list":{query_type:"get",url_postfix:"",filters:{name:"parameters"},type:"list",autoupdate:true,},"_get":{query_type:"get",url_postfix:"",type:"page",autoupdate:true,},"_edit":{query_type:"patch",url_postfix:"edit/",type:"page_edit",},"_update":{query_type:"put",url_postfix:"edit/",type:"page_edit",},"_remove":{query_type:"delete",url_postfix:"remove/",type:"page_remove",hidden:true,},}};