class App{constructor(api_config,openapi,cache){this.api=new ApiConnector(api_config,openapi,cache);this.error_handler=new ErrorHandler();this.models=null;this.views=null;this.languages=null;this.translations=null;this.user=null;this.application=null;}
start(){let LANG=guiLocalSettings.get('lang')||'en';let promises=[this.api.getLanguages(),this.api.getTranslations(LANG),this.api.loadUser(),];return Promise.all(promises).then(response=>{this.languages=response[0];this.translations={[LANG]:response[1],};this.user=response[2];fieldsRegistrator.registerAllFieldsComponents();this.initModels();this.initViews();this.mountApplication();}).catch(error=>{debugger;throw new Error(error);});}
initModels(){this.models=this.generateModels();}
generateModels(){let models_constructor=new ModelConstructor(openapi_dictionary,guiModels);return models_constructor.generateModels(this.api.openapi);}
initViews(){this.views=this.generateViews();this.prepareViewsModelsFields();}
generateViews(){let views_constructor=new ViewConstructor(openapi_dictionary,this.models);return views_constructor.generateViews(View,this.api.openapi);}
prepareViewsModelsFields(){for(let path in this.views){if(this.views.hasOwnProperty(path)){let view=this.views[path];for(let key in view.objects.model.fields){if(view.objects.model.fields.hasOwnProperty(key)){let field=view.objects.model.fields[key];if(field.constructor.prepareField){let prepared=field.constructor.prepareField(field,path);view.objects.model.fields[key]=prepared;}}}}}}
setLanguage(lang){return this._prefetchTranslation(lang).then(lang=>{this.application.$i18n.locale=lang;guiLocalSettings.set('lang',lang);tabSignal.emit('app.language.changed',{lang:lang});return lang;});}
_prefetchTranslation(lang){if(!Object.values(this.languages).map(item=>item.code).includes(lang)){return Promise.reject(false);}
if(this.translations[lang]){return Promise.resolve(lang);}
return this.api.getTranslations(lang).then(transitions=>{this.translations={...this.translations,[lang]:transitions,};this.application.$i18n.setLocaleMessage(lang,transitions);return lang;}).catch(error=>{debugger;throw error;});}
mountApplication(){tabSignal.emit('app.beforeInit',{app:this});let store_constructor=new StoreConstructor(this.views);let routerConstructor=new RouterConstructor(this.views,routesComponentsTemplates,customRoutesComponentsTemplates,);let i18n=new VueI18n({locale:guiLocalSettings.get('lang')||'en',messages:this.translations,});this.application=new Vue({data:{info:this.api.openapi.info,x_menu:this.api.openapi.info['x-menu'],x_docs:this.api.openapi.info['x-docs'],a_links:false,},computed:{realBodyClasses(){let cls="";['is_superuser','is_staff'].forEach(item=>{cls+=window[item]?(item+" "):"";});return cls;}},router:routerConstructor.getRouter(),store:store_constructor.getStore(),i18n:i18n,}).$mount('#RealBody');tabSignal.emit('app.afterInit',{app:this});}}