from __future__ import annotations

from cognite.client.data_classes.hosted_extractors.destinations import (
    Destination,
    DestinationList,
    DestinationUpdate,
    DestinationWrite,
    DestinationWriteList,
    SessionWrite,
)
from cognite.client.data_classes.hosted_extractors.jobs import (
    BodyLoad,
    CogniteFormat,
    CustomFormat,
    HeaderValueLoad,
    IncrementalLoad,
    Job,
    JobConfig,
    JobFormat,
    JobList,
    JobLogs,
    JobLogsList,
    JobMetrics,
    JobMetricsList,
    JobStatus,
    JobUpdate,
    JobWrite,
    JobWriteList,
    KafkaConfig,
    MQTTConfig,
    NextUrlLoad,
    Prefix,
    QueryParamLoad,
    RestConfig,
    RockwellFormat,
    TargetStatus,
    ValueFormat,
)
from cognite.client.data_classes.hosted_extractors.mappings import (
    CSVInput,
    CustomMapping,
    InputMapping,
    JSONInput,
    Mapping,
    MappingList,
    MappingUpdate,
    MappingWrite,
    MappingWriteList,
    ProtoBufInput,
    XMLInput,
)
from cognite.client.data_classes.hosted_extractors.sources import (
    EventHubSource,
    EventHubSourceUpdate,
    EventHubSourceWrite,
    KafkaSource,
    KafkaSourceUpdate,
    KafkaSourceWrite,
    MQTT3Source,
    MQTT3SourceUpdate,
    MQTT3SourceWrite,
    MQTT5Source,
    MQTT5SourceUpdate,
    MQTT5SourceWrite,
    RestSource,
    RestSourceUpdate,
    RestSourceWrite,
    Source,
    SourceList,
    SourceUpdate,
    SourceWrite,
    SourceWriteList,
)

__all__ = [
    "BodyLoad",
    "CSVInput",
    "CogniteFormat",
    "CustomFormat",
    "CustomMapping",
    "Destination",
    "DestinationList",
    "DestinationUpdate",
    "DestinationWrite",
    "DestinationWriteList",
    "EventHubSource",
    "EventHubSourceUpdate",
    "EventHubSourceWrite",
    "HeaderValueLoad",
    "IncrementalLoad",
    "InputMapping",
    "JSONInput",
    "Job",
    "JobConfig",
    "JobFormat",
    "JobList",
    "JobLogs",
    "JobLogsList",
    "JobMetrics",
    "JobMetricsList",
    "JobStatus",
    "JobUpdate",
    "JobWrite",
    "JobWriteList",
    "KafkaConfig",
    "KafkaSource",
    "KafkaSourceUpdate",
    "KafkaSourceWrite",
    "MQTT3Source",
    "MQTT3SourceUpdate",
    "MQTT3SourceWrite",
    "MQTT5Source",
    "MQTT5SourceUpdate",
    "MQTT5SourceWrite",
    "MQTTConfig",
    "Mapping",
    "MappingList",
    "MappingUpdate",
    "MappingWrite",
    "MappingWriteList",
    "NextUrlLoad",
    "Prefix",
    "ProtoBufInput",
    "QueryParamLoad",
    "RestConfig",
    "RestSource",
    "RestSourceUpdate",
    "RestSourceWrite",
    "RockwellFormat",
    "SessionWrite",
    "Source",
    "SourceList",
    "SourceUpdate",
    "SourceWrite",
    "SourceWriteList",
    "TargetStatus",
    "ValueFormat",
    "XMLInput",
]
