# MeerK40t
Laser software for the Stock-LIHUIYU laserboard. This is the stock board for most K40 Laser Cutters, M2 Nano, et al.

MeerK40t (pronounced MeerKat) is a built-from-the-ground-up MIT licensed open-source laser cutting software. It's a replacement for LaserDrw, Corel Laser, and K40 Whisperer. 

With the dual driver support it can run aside any of these programs, without breaking anything. It's written in python and has precompiled versions for Windows, Mac OSX, and Raspberry Pi. Available: https://github.com/meerk40t/meerk40t/releases


# Installing

Windows, OSX, Raspberry Pi, and Linux (sometimes) Versions.
Everything is prebundled. You can just run the file.
https://github.com/meerk40t/meerk40t/releases

Download the version you need and run it

---

If you need/want something more complex or need to run from Python directly: https://github.com/meerk40t/meerk40t/wiki/Alternative-Installs

# GUI

![meerk40t69](https://user-images.githubusercontent.com/3302478/97104931-babe8e80-1674-11eb-841b-5c8f4674a629.png)

The wxMeerK40t is the GUI and is written in wxPython.

# CLI

MeerK40t has a highly robust command line interface. It should be able to execute many projects without needing or having a gui

https://github.com/meerk40t/meerk40t/wiki/Command-Line-Interface

# Features

* Built in Raster Preprocessing, RasterWizard.
* Dual drivers, use either the Whisperer method or LaserDrw method. 
* Grid/Guides, Zoom and Pan scene Navigation (use middle mouse button, mouse wheel).
* Easy Object Manipulation.
* PPI Power modulation (Yes, power modulation for the M2 Nano)
* Keybinds and advanced console execution.
* Drag-and-Drop support for SVGs/Images.
* On-the-fly job Processing
* Multi-language support.
* Multi-K40 support.
* Pixel perfect curve cutting.
* Command Line Interface


# Support

If you have a bug, feature request, or other issue raise it here. These are likely to be resolved. Squeaky wheels get the grease.
https://github.com/meerk40t/meerk40t/issues

## Wiki
See/edit the Wiki here.
https://github.com/meerk40t/meerk40t/wiki

## Facebook
Most Official MeerK40t facebook group: https://www.facebook.com/groups/716000085655097/

## Maker Forum
Maker Forum MeerK40t category: https://forum.makerforums.info/t/about-the-meerk40t-category/79660

## Youtube
* David Olsen's channel: https://www.youtube.com/channel/UCsAUV23O2FyKxC0HN7nkAQQ
* Milan Karakas' channel https://www.youtube.com/channel/UCXhlGsmGJZ3m5GgTE8xuc_Q

## IRC
* There is an IRC channel #MeerK40t on irc.freenode.net irc://irc.freenode.net:6666


# Assisting the Project

Open source projects live and die with their support. There are a lots of ways to help the project.
* Code
* Research ( https://github.com/meerk40t/meerk40t/wiki/Needed-Research )
* Design ( Good design instincts, smooth out the rough edges)
* Compile/Testers
* Provide feedback, criticism is preferable to praise but both are welcome.
* Edit the Wiki
* Make helpful support content
* Make guides ("How to setup cameras?", etc)
* Provide Translations in other languages.
* Bounce ideas around
