"""Terraform workspace and resource scanning functionality."""

from .resources import count_resources_recursive, format_resource_summary
from .state import parse_state_data, extract_state_from_response
from .workspace import process_single_workspace

__all__ = [
    # Resources
    'count_resources_recursive',
    'format_resource_summary',
    # State
    'parse_state_data', 
    'extract_state_from_response',
    # Workspace
    'process_single_workspace'
]